/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.model.AGInstance;
import oracle.bpel.activityguide.ui.beans.model.AGUtil;
import oracle.bpel.activityguide.ui.beans.model.TaskInstance;
import oracle.bpel.services.workflow.activityguide.query.model.MilestoneDisplayInfoType;
import oracle.bpel.services.workflow.activityguide.query.model.TaskDisplayInfoType;
import oracle.bpel.services.workflow.task.model.Task;

class MilestoneInstance {
    private static AGLog agLog = AGLogFactory.getLog(MilestoneInstance.class);
    private Map<String, TaskInstance> taskInstanceMap = new HashMap<String, TaskInstance>();
    private Map<String, TaskDisplayInfoType> taskDisplayInfoMap = new HashMap<String, TaskDisplayInfoType>();
    private MilestoneDisplayInfoType msDisplayInfo = null;
    private Object parent = null;
    private List<String> taskDisplaySequence = null;
    private String processMode = null;
    private Map<String, MilestoneInstance> subMilestoneMap = new HashMap<String, MilestoneInstance>();

    MilestoneInstance(MilestoneDisplayInfoType displayInfo, Object parent) {
        this.msDisplayInfo = displayInfo;
        this.parent = parent;
        this.taskDisplaySequence = new ArrayList<String>();
        this.processMode = ((AGInstance)parent).getProcessMode();
        if (agLog.isDebug()) {
            agLog.debug("Caching milestone: " + this.msDisplayInfo.getMilestoneInstance().getName());
        }
        for (Task taskInfo : this.msDisplayInfo.getTask()) {
            this.taskDisplaySequence.add(taskInfo.getSystemAttributes().getTaskId());
            this.taskInstanceMap.put(taskInfo.getSystemAttributes().getTaskId(), new TaskInstance(taskInfo, this, null));
        }
        List taskDisplayInfoList = this.msDisplayInfo.getTaskDisplayInfo();
        if (this.processMode.equalsIgnoreCase("AGBPM")) {
            for (TaskDisplayInfoType taskDispInfo : taskDisplayInfoList) {
                if (!this.taskDisplaySequence.contains(taskDispInfo.getTask().getSystemAttributes().getTaskId())) {
                    this.taskDisplaySequence.add(taskDispInfo.getTask().getSystemAttributes().getTaskId());
                }
                Task newTask = AGUtil.createTask(taskDispInfo);
                this.taskInstanceMap.put(newTask.getSystemAttributes().getTaskId(), new TaskInstance(newTask, this, taskDispInfo));
            }
        }
    }

    MilestoneInstance(Object parent) {
        this.parent = parent;
    }

    Object getParent() {
        return this.parent;
    }

    List<String> getChildTasks() {
        return this.taskDisplaySequence;
    }

    List<String> getChildMilestones() {
        return new ArrayList<String>(this.subMilestoneMap.keySet());
    }

    TaskInstance getTaskInstanceById(String taskId) {
        return this.taskInstanceMap.get(taskId);
    }

    MilestoneInstance getSubMilestoneByName(String name) {
        return this.subMilestoneMap.get(name);
    }

    String getDisplayTitle() {
        return this.msDisplayInfo.getTitle();
    }

    String getIconLocation() {
        return this.msDisplayInfo.getIconLocation();
    }

    String getDescription() {
        return this.msDisplayInfo.getDescription();
    }

    String getStatus() {
        if (this.getProcessMode().equalsIgnoreCase("AGBPEL")) {
            return this.msDisplayInfo.getMilestoneInstance().getStatus();
        }
        return this.msDisplayInfo.getStatus();
    }

    String getErrorMessage() {
        if (this.processMode.equalsIgnoreCase("AGBPEL")) {
            return this.msDisplayInfo.getMilestoneInstance().getErrorMessage();
        }
        return "Error";
    }

    void release() {
        Collection<MilestoneInstance> cMilestone = this.subMilestoneMap.values();
        Iterator<Object> i = cMilestone.iterator();
        while (i.hasNext()) {
            MilestoneInstance msInstance = i.next();
            msInstance.release();
            i.remove();
        }
        Collection<TaskInstance> cTask = this.taskInstanceMap.values();
        i = cTask.iterator();
        while (i.hasNext()) {
            TaskInstance taskInstance = (TaskInstance)i.next();
            taskInstance.release();
            i.remove();
        }
    }

    public String getProcessMode() {
        return this.processMode;
    }

    public boolean isFutureMilestone() {
        return this.getStatus() != null && this.getStatus().equalsIgnoreCase("Not Started");
    }

    public boolean isMilestoneBranch() {
        return this.getDisplayTitle().startsWith("switch");
    }
}

