/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import oracle.adf.share.logging.ADFLogger;
import org.apache.myfaces.trinidad.model.CollectionModel;

public class ListCollectionModel
extends CollectionModel {
    private int _index = -1;
    private List _listOfKeys;
    private Map _mapOfItems;
    private AtomicInteger _counter = new AtomicInteger();
    private static final ADFLogger _LOG = ADFLogger.createADFLogger(ListCollectionModel.class);

    public ListCollectionModel() {
        this(null);
    }

    public ListCollectionModel(List list) {
        this.setWrappedData(list);
    }

    public Object getRowKey() {
        if (!this.isRowAvailable()) {
            return null;
        }
        return this._listOfKeys.get(this.getRowIndex());
    }

    public void setRowKey(Object newKey) {
        if (newKey == null) {
            this.setRowIndex(-1);
        }
        this.setRowIndex(this._listOfKeys.indexOf(newKey));
    }

    public boolean isRowAvailable() {
        if (this._listOfKeys == null) {
            return false;
        }
        return this._index >= 0 && this._index < this._listOfKeys.size();
    }

    public int getRowCount() {
        if (this._listOfKeys == null) {
            return -1;
        }
        return this._listOfKeys.size();
    }

    public Object getRowData() {
        if (this._listOfKeys == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException();
        }
        Object key = this._listOfKeys.get(this._index);
        return this._mapOfItems.get(key);
    }

    public int getRowIndex() {
        return this._index;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException();
        }
        int old = this._index;
        this._index = rowIndex;
        if (this._listOfKeys == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (old != this._index && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, this._index, rowData);
            int n = listeners.length;
            for (int i = 0; i < n; ++i) {
                if (null == listeners[i]) continue;
                listeners[i].rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        ArrayList returnList = new ArrayList();
        for (Object key : this._listOfKeys) {
            Object item = this._mapOfItems.get(key);
            returnList.add(item);
        }
        return returnList;
    }

    public void setWrappedData(Object data) {
        assert (data instanceof List);
        if (data == null) {
            this._listOfKeys = null;
            this._mapOfItems = null;
            this.setRowIndex(-1);
        } else {
            List listData = (List)data;
            this._listOfKeys = new ArrayList(listData.size());
            this._mapOfItems = new HashMap(listData.size());
            for (Object item : listData) {
                Integer keyObject = this._counter.getAndIncrement();
                this._mapOfItems.put(keyObject, item);
                this._listOfKeys.add(keyObject);
            }
            this._index = -1;
            this.setRowIndex(0);
        }
    }

    public void add(int addRowIndex, Object newItem) {
        if (addRowIndex < 0 || addRowIndex > this._listOfKeys.size()) {
            _LOG.warning("Trying to add row at invalid spot, index " + addRowIndex);
            return;
        }
        Integer newKey = this._counter.getAndIncrement();
        this._mapOfItems.put(newKey, newItem);
        this._listOfKeys.add(addRowIndex, newKey);
    }

    public void remove(int removeRowIndex) {
        if (!this.isRowAvailable(removeRowIndex)) {
            _LOG.warning("Trying to delete invalid row " + removeRowIndex);
            return;
        }
        Object key = this._listOfKeys.get(removeRowIndex);
        this._mapOfItems.remove(key);
        this._listOfKeys.remove(removeRowIndex);
    }
}

