/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import org.apache.myfaces.trinidad.context.RequestContext;

public class ComponentEditorHandler {
    private UIComponent _editedComponent;
    private boolean _javascriptShown = true;
    private List _list;

    public String update() {
        boolean rendered = this._editedComponent.isRendered();
        List list = this._list;
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ((PropertyOfComponent)iter.next()).flushToComponent();
            }
        }
        RequestContext rc = RequestContext.getCurrentInstance();
        if (rendered != this._editedComponent.isRendered()) {
            rc.addPartialTarget(this._editedComponent.getParent());
        } else {
            rc.addPartialTarget(this._editedComponent);
        }
        return null;
    }

    public void setComponent(UIComponent component) {
        this._editedComponent = component;
    }

    public UIComponent getComponent() {
        return this._editedComponent;
    }

    public boolean isJavascriptShown() {
        return this._javascriptShown;
    }

    public void setJavascriptShown(boolean javascriptShown) {
        this._javascriptShown = javascriptShown;
    }

    public List getAttributes() {
        if (this._list != null) {
            return this._list;
        }
        UIComponent comp = this.getComponent();
        if (comp == null) {
            return null;
        }
        ArrayList<StringProperty> list = new ArrayList<StringProperty>();
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(comp.getClass());
            PropertyDescriptor[] descriptors = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < descriptors.length; ++i) {
                String name;
                boolean readOnly;
                PropertyDescriptor descriptor = descriptors[i];
                if (descriptor.getReadMethod() == null) continue;
                PropertyOfComponent poc = null;
                boolean bl = readOnly = descriptor.getWriteMethod() == null;
                if (readOnly || this.skipAttributeForValueBinding(comp, name = descriptor.getName())) continue;
                Class<?> type = descriptor.getPropertyType();
                if (type == String.class || type == Object.class) {
                    if (!this.isJavascriptShown() && name.startsWith("on")) continue;
                    poc = new StringProperty(comp, descriptor);
                } else if (type == Integer.class || type == Integer.TYPE) {
                    poc = new IntegerProperty(comp, descriptor);
                } else if (type == Number.class) {
                    poc = new NumberProperty(comp, descriptor);
                } else if (type == Boolean.class || type == Boolean.TYPE) {
                    poc = new BooleanProperty(comp, descriptor);
                } else if (type == Date.class) {
                    poc = new DateProperty(comp, descriptor);
                } else if (type == Color.class) {
                    poc = new ColorProperty(comp, descriptor);
                } else if (type == List.class) {
                    poc = new ListProperty(comp, descriptor);
                } else if (type == Set.class) {
                    poc = new SetProperty(comp, descriptor);
                } else if (type == Character.class || type == Character.TYPE) {
                    poc = new CharacterProperty(comp, descriptor);
                }
                if (poc == null) continue;
                list.add((StringProperty)poc);
            }
            Collections.sort(list);
            this._list = list;
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected boolean skipAttributeForValueBinding(UIComponent comp, String name) {
        return comp.getValueExpression(name) != null;
    }

    public static class BooleanProperty
    extends PropertyOfComponent {
        public BooleanProperty(UIComponent component, PropertyDescriptor descriptor) {
            super(component, descriptor);
        }

        public Boolean getValue() {
            return (Boolean)this.getBeanProperty();
        }

        public void setValue(Boolean b) {
            this.setProperty(b);
        }

        @Override
        public String getType() {
            return "boolean";
        }
    }

    public static class StringProperty
    extends PropertyOfComponent {
        public StringProperty(UIComponent component, PropertyDescriptor descriptor) {
            super(component, descriptor);
        }

        public String getValue() {
            Object o = this.getProperty();
            if (o == null) {
                return null;
            }
            return o.toString();
        }

        public void setValue(String s) {
            this.setProperty(s);
        }

        @Override
        public String getType() {
            return "string";
        }
    }

    public static class SetProperty
    extends PropertyOfComponent {
        public SetProperty(UIComponent component, PropertyDescriptor descriptor) {
            super(component, descriptor);
        }

        public Set getValue() {
            return (Set)this.getProperty();
        }

        public void setValue(Set i) {
            this.setProperty(i);
        }

        @Override
        public String getType() {
            return "set";
        }
    }

    public static class ListProperty
    extends PropertyOfComponent {
        public ListProperty(UIComponent component, PropertyDescriptor descriptor) {
            super(component, descriptor);
        }

        public List getValue() {
            return (List)this.getProperty();
        }

        public void setValue(List i) {
            this.setProperty(i);
        }

        @Override
        public String getType() {
            return "list";
        }
    }

    public static class ColorProperty
    extends PropertyOfComponent {
        public ColorProperty(UIComponent component, PropertyDescriptor descriptor) {
            super(component, descriptor);
        }

        public Color getValue() {
            return (Color)this.getProperty();
        }

        public void setValue(Color i) {
            this.setProperty(i);
        }

        @Override
        public String getType() {
            return "color";
        }
    }

    public static class DateProperty
    extends PropertyOfComponent {
        public DateProperty(UIComponent component, PropertyDescriptor descriptor) {
            super(component, descriptor);
        }

        public Date getValue() {
            return (Date)this.getProperty();
        }

        public void setValue(Date i) {
            this.setProperty(i);
        }

        @Override
        public String getType() {
            return "date";
        }
    }

    public static class CharacterProperty
    extends PropertyOfComponent {
        public CharacterProperty(UIComponent component, PropertyDescriptor descriptor) {
            super(component, descriptor);
        }

        public Character getValue() {
            return (Character)this.getProperty();
        }

        public void setValue(Character i) {
            this.setProperty(i);
        }

        @Override
        public String getType() {
            return "character";
        }
    }

    public static class NumberProperty
    extends PropertyOfComponent {
        public NumberProperty(UIComponent component, PropertyDescriptor descriptor) {
            super(component, descriptor);
        }

        public Number getValue() {
            return (Number)this.getProperty();
        }

        public void setValue(Number n) {
            this.setProperty(n);
        }

        @Override
        public String getType() {
            return "number";
        }
    }

    public static class IntegerProperty
    extends PropertyOfComponent {
        public IntegerProperty(UIComponent component, PropertyDescriptor descriptor) {
            super(component, descriptor);
        }

        public Integer getValue() {
            return (Integer)this.getProperty();
        }

        public void setValue(Integer i) {
            this.setProperty(i);
        }

        @Override
        public String getType() {
            return "integer";
        }
    }

    public static class PropertyOfComponent
    implements Comparable {
        private boolean _valueSet = false;
        private Object _value = null;
        private final PropertyDescriptor _descriptor;
        private final UIComponent _component;

        public PropertyOfComponent(UIComponent component, PropertyDescriptor descriptor) {
            this._component = component;
            this._descriptor = descriptor;
        }

        public int compareTo(Object o) {
            PropertyOfComponent poc = (PropertyOfComponent)o;
            return this.getName().compareTo(poc.getName());
        }

        public String getName() {
            return this._descriptor.getName();
        }

        public String getType() {
            return null;
        }

        public void flushToComponent() {
            if (this._valueSet) {
                this._component.getAttributes().put(this.getName(), this._value);
            }
        }

        protected Object getBeanProperty() {
            Method method = this._descriptor.getReadMethod();
            try {
                return method.invoke((Object)this._component, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.getProperty();
            }
        }

        protected Object getProperty() {
            return this._component.getAttributes().get(this.getName());
        }

        protected void setProperty(Object value) {
            if ("".equals(value)) {
                value = null;
            }
            this._valueSet = true;
            this._value = value;
        }
    }
}

