/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.model.AGException;
import oracle.bpel.activityguide.ui.beans.model.AGInstance;
import oracle.bpel.activityguide.ui.beans.model.AGProperties;
import oracle.bpel.activityguide.ui.beans.model.AGServiceInterfaceImpl;
import oracle.bpel.activityguide.ui.beans.model.IAGServiceInterface;
import oracle.bpel.activityguide.ui.beans.model.MilestoneInstance;
import oracle.bpel.activityguide.ui.beans.model.TaskInstance;
import oracle.bpel.activityguide.ui.beans.resources.AGUIErrorMsg;
import oracle.bpel.activityguide.ui.beans.resources.AGUIInfoMsg;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.activityguide.query.model.TaskDisplayInfoType;
import oracle.bpel.services.workflow.query.impl.QueryUtil;
import oracle.bpel.services.workflow.repos.Column;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.repos.TableConstants;
import oracle.bpel.services.workflow.task.model.ObjectFactory;
import oracle.bpel.services.workflow.task.model.Task;

public class AGUtil {
    private static AGLog agLog = AGLogFactory.getLog(AGUtil.class);
    private static TimeZone timezone = TimeZone.getDefault();
    private static String queryMode = "AGBPM";
    static AGProperties agProps = null;

    public static IAGServiceInterface createIAGServiceInterface() {
        return new AGServiceInterfaceImpl();
    }

    public static AGServiceInterfaceImpl getAGServiceInterfaceImpl(Object obj) {
        String method = "getAGServiceInterfaceImpl";
        Object root = obj;
        while (root != null) {
            if (root.getClass().getName().equals("oracle.bpel.activityguide.ui.beans.model.AGServiceInterfaceImpl")) {
                return (AGServiceInterfaceImpl)root;
            }
            if (root.getClass().getName().equals("oracle.bpel.activityguide.ui.beans.model.TaskInstance")) {
                root = ((TaskInstance)root).getParent();
                continue;
            }
            if (root.getClass().getName().equals("oracle.bpel.activityguide.ui.beans.model.MilestoneInstance")) {
                root = ((MilestoneInstance)root).getParent();
                continue;
            }
            if (!root.getClass().getName().equals("oracle.bpel.activityguide.ui.beans.model.AGInstance")) continue;
            root = ((AGInstance)root).getParent();
        }
        if (root == null && agLog.isDebug()) {
            agLog.debug("Parent link broken when getting AG root");
        }
        return (AGServiceInterfaceImpl)root;
    }

    public static Predicate processDefinitionFilter(String defn) throws WorkflowException {
        Predicate predicate = null;
        if (queryMode.equals("AGBPEL")) {
            predicate = new Predicate(TableConstants.AGINSTANCE_DEFINITIONID_COLUMN, 12, (Object)defn);
        } else if (queryMode.equals("AGBPM")) {
            predicate = new Predicate(TableConstants.WFTASK_COMPOSITEDN_COLUMN, 12, (Object)defn);
        }
        if (agLog.isTrace()) {
            String predicateString = predicate == null ? "" : predicate.toString();
            agLog.trace(AGUIInfoMsg.MSG_AG_UTIL_AG_DEFINITION_ID.instance(predicateString));
        }
        return predicate;
    }

    public static Predicate processPredicateProp(String predicate1, String predicate2) throws WorkflowException, AGException {
        int dayOfYear;
        String[] tokens;
        String mthd = "processPredicateProp";
        String table_col1 = null;
        String table_col2 = null;
        String op1 = null;
        String op2 = null;
        String value1 = null;
        String value2 = null;
        Column columnObj1 = null;
        Column columnObj2 = null;
        Object valueObj1 = null;
        Object valueObj2 = null;
        if (predicate1 == null) {
            return null;
        }
        if (agLog.isTrace()) {
            agLog.trace(AGUIInfoMsg.MSG_AG_UTIL_AG_CUSTOM_PRED1.instance(predicate1.toString()));
        }
        String tableName = "";
        if (queryMode.equals("AGBPEL")) {
            tableName = "AG_INSTANCE";
        } else if (queryMode.equals("AGBPM")) {
            tableName = "WFTask";
        } else {
            return null;
        }
        Calendar calendarObj = null;
        if (predicate1 != null) {
            tokens = predicate1.split(",");
            table_col1 = tokens[0];
            op1 = tokens.length > 1 ? tokens[1] : null;
            value1 = tokens.length > 2 ? tokens[2].trim() : null;
            columnObj1 = Column.getColumn((String)tableName, (String)table_col1);
            if (columnObj1 == null) {
                Object[] params = new Object[]{tableName, table_col1};
                if (agLog.isError()) {
                    agLog.error(mthd, AGUIErrorMsg.ERR_AG_UTIL_INVALID_PREDICATE_VALUE.instance(mthd, params));
                }
                throw new AGException(38015, params);
            }
            if (columnObj1.getType() == 5) {
                calendarObj = AGUtil.getCalendarObject(value1);
                if (Predicate.getOperationNumber((String)op1) == 5) {
                    dayOfYear = calendarObj.get(6);
                    calendarObj.set(6, dayOfYear + 1);
                }
            }
            valueObj1 = QueryUtil.createValueObject((Column)columnObj1, (int)Predicate.getOperationNumber((String)op1), (String)value1, (Calendar)calendarObj);
        }
        if (predicate2 != null) {
            if (agLog.isTrace()) {
                agLog.trace(AGUIInfoMsg.MSG_AG_UTIL_AG_CUSTOM_PRED2.instance(predicate2.toString()));
            }
            tokens = predicate2.split(",");
            table_col2 = tokens[0];
            op2 = tokens.length > 1 ? tokens[1] : null;
            value2 = tokens.length > 2 ? tokens[2].trim() : null;
            columnObj2 = Column.getColumn((String)tableName, (String)table_col2);
            if (columnObj2.getType() == 5) {
                calendarObj = AGUtil.getCalendarObject(value2);
                if (Predicate.getOperationNumber((String)op2) == 5) {
                    dayOfYear = calendarObj.get(6);
                    calendarObj.set(6, dayOfYear + 1);
                }
            }
            valueObj2 = QueryUtil.createValueObject((Column)columnObj2, (int)Predicate.getOperationNumber((String)op2), (String)value2, (Calendar)calendarObj);
        }
        Predicate agPredicate = new Predicate(columnObj1, Predicate.getOperationNumber(op1), valueObj1);
        if (predicate2 != null) {
            agPredicate.addClause(7, columnObj2, Predicate.getOperationNumber(op2), valueObj2);
        }
        return agPredicate;
    }

    protected static Calendar getCalendarObject(String dateValue) {
        Date dateObj;
        String method = "getCalendarObject";
        SimpleDateFormat formatObj = new SimpleDateFormat();
        formatObj.applyPattern("dd-MMM-yy");
        formatObj.setTimeZone(timezone);
        if (dateValue == null) {
            return null;
        }
        try {
            dateObj = formatObj.parse(dateValue);
            System.out.println(dateObj);
        }
        catch (ParseException e) {
            if (agLog.isError()) {
                agLog.error(method, AGUIErrorMsg.ERR_AG_UTIL_DATE_INVALID.instance(dateValue, e.getMessage()));
            }
            return null;
        }
        Calendar calendarObj = Calendar.getInstance();
        calendarObj.setTime(dateObj);
        return calendarObj;
    }

    public static Ordering processOrderingProp(String prop) throws AGException, WorkflowException {
        String mthd = "processOrderingProp";
        if (agLog.isTrace()) {
            agLog.trace(AGUIInfoMsg.MSG_AG_UTIL_AG_ORDERING_PROP.instance(prop));
        }
        String columnName = null;
        String sortOrder = null;
        if (prop == null) {
            return null;
        }
        String[] tokens = prop.split(":");
        columnName = tokens[0];
        sortOrder = tokens.length > 1 ? tokens[1].trim() : null;
        if (columnName == null || sortOrder == null) {
            if (agLog.isError()) {
                agLog.error(mthd, AGUIErrorMsg.ERR_AG_UTIL_INVALID_AGINSTANCEOREDERING.instance(mthd));
            }
            throw new AGException(38013);
        }
        Object newOrdering = null;
        boolean isAscending = true;
        if ("ASC".equalsIgnoreCase(sortOrder)) {
            isAscending = true;
        } else if ("DESC".equalsIgnoreCase(sortOrder)) {
            isAscending = false;
        } else {
            if (agLog.isError()) {
                agLog.error(mthd, AGUIErrorMsg.ERR_AG_UTIL_INVALID_AGINSTANCEOREDERING.instance(mthd));
            }
            throw new AGException(38013);
        }
        String tableName = "";
        if (queryMode.equals("AGBPEL")) {
            tableName = "AG_INSTANCE";
        } else if (queryMode.equals("AGBPM")) {
            tableName = "WFTask";
        } else {
            return null;
        }
        Column columnObj = Column.getColumn((String)tableName, (String)columnName);
        return new Ordering(columnObj, isAscending, false);
    }

    public static Object evaluateELExpression(String elExp, Class pClass) {
        FacesContext context = FacesContext.getCurrentInstance();
        Object obj = context.getApplication().evaluateExpressionGet(context, elExp, pClass);
        return obj;
    }

    private static void createAgProps() {
        agProps = (AGProperties)AGUtil.evaluateELExpression("#{agProps}", AGProperties.class);
        if (agProps == null) {
            agProps = new AGProperties();
            String absAgPropsFileName = System.getProperty("agui.property.file");
            agProps.setAbsAgPropsFileName(absAgPropsFileName);
        }
    }

    public static AGProperties getAgProps() {
        if (agProps == null) {
            AGUtil.createAgProps();
        }
        return agProps;
    }

    public static void setTimezone(TimeZone timezone) {
        AGUtil.timezone = timezone;
    }

    public static void setQueryMode(String queryMode) {
        AGUtil.queryMode = queryMode;
    }

    public static String getqueryMode() {
        return queryMode;
    }

    public static Task createTask(TaskDisplayInfoType taskDispInfo) {
        ObjectFactory objf = new ObjectFactory();
        Task newTask = objf.createTask();
        newTask.getSystemAttributes().setTaskId(taskDispInfo.getTask().getSystemAttributes().getTaskId());
        newTask.setSystemAttributes(taskDispInfo.getTask().getSystemAttributes());
        newTask.setTitle(taskDispInfo.getTask().getTitle());
        newTask.setTaskDefinitionId(taskDispInfo.getTask().getTaskDefinitionId());
        newTask.setTaskDisplayUrl(taskDispInfo.getTask().getTaskDisplayUrl());
        newTask.setOwnerUser(taskDispInfo.getTask().getOwnerUser());
        newTask.setDueDate(taskDispInfo.getTask().getDueDate());
        newTask.setOwnerGroup(taskDispInfo.getTask().getOwnerGroup());
        newTask.setPercentageComplete(taskDispInfo.getTask().getPercentageComplete());
        newTask.setStartDate(taskDispInfo.getTask().getStartDate());
        return newTask;
    }
}

