/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.beans.IntrospectionException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.ValueChangeEvent;
import javax.imageio.ImageIO;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.view.faces.bi.component.gauge.CoreGauge;
import oracle.adf.view.faces.bi.component.gauge.MetricLabel;
import oracle.adf.view.faces.bi.component.gauge.UIGauge;
import oracle.adf.view.rich.component.rich.data.RichTree;
import oracle.adf.view.rich.component.rich.layout.RichPanelGroupLayout;
import oracle.adf.view.rich.component.rich.layout.RichPanelStretchLayout;
import oracle.adf.view.rich.component.rich.nav.RichCommandLink;
import oracle.binding.OperationBinding;
import oracle.bpel.activityguide.ui.beans.events.AGContextualEventRegionalHandler;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.logger.ResourceRef;
import oracle.bpel.activityguide.ui.beans.model.AGAppearanceParams;
import oracle.bpel.activityguide.ui.beans.model.AGDetailsCache;
import oracle.bpel.activityguide.ui.beans.model.AGException;
import oracle.bpel.activityguide.ui.beans.model.AGInstance;
import oracle.bpel.activityguide.ui.beans.model.AGInstanceListBean;
import oracle.bpel.activityguide.ui.beans.model.AGProperties;
import oracle.bpel.activityguide.ui.beans.model.AGServiceInterfaceImpl;
import oracle.bpel.activityguide.ui.beans.model.AGTasksPopup;
import oracle.bpel.activityguide.ui.beans.model.AGUtil;
import oracle.bpel.activityguide.ui.beans.model.FilterBean;
import oracle.bpel.activityguide.ui.beans.model.IAGServiceInterface;
import oracle.bpel.activityguide.ui.beans.model.IAGUIConstants;
import oracle.bpel.activityguide.ui.beans.model.RowKeyPropertyModel;
import oracle.bpel.activityguide.ui.beans.model.RowKeyPropertyTreeModel;
import oracle.bpel.activityguide.ui.beans.resources.AGUIErrorMsg;
import oracle.bpel.activityguide.ui.beans.resources.AGUIInfoMsg;
import oracle.bpel.services.workflow.WorkflowException;
import org.apache.myfaces.trinidad.component.UIXGroup;
import org.apache.myfaces.trinidad.component.UIXSwitcher;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.event.RowDisclosureEvent;
import org.apache.myfaces.trinidad.event.SelectionEvent;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySet;
import org.apache.myfaces.trinidad.model.RowKeySetTreeImpl;
import org.apache.myfaces.trinidad.model.TreeModel;

public class AGTreeModelBean {
    private static AGLog agLog = AGLogFactory.getLog(AGTreeModelBean.class);
    IAGServiceInterface svcIfc;
    private AGProperties agProps = null;
    private static String _aGInstanceID;
    private static Map<String, TreeModel> _agTreeModelList;
    private static List _agInstanceIdList;
    private static String _agName;
    private static String _agInstanceId;
    private static String _agPercentCompletion;
    private static String _agDescription;
    private static Date _agCreated;
    private static String _agStatus;
    private static String _msName;
    private static String _msDescription;
    private static String _msStatus;
    private static String _taskName;
    private static String _taskState;
    private static Date _taskDueDate;
    private static String _taskURL;
    private static String _inlineStyleActive;
    private static String _inlineStyleInactive;
    private static Boolean bMilestoneErrors;
    private static Boolean bTaskErrors;
    private static Boolean bComponentIdInitialized;
    private boolean bEmptyTreeModel = true;
    private static Map statusToIconMap;
    private String recentSelectedPath = null;
    private String agNodePanelFormLayoutId = "panelFormLayout1";
    private String milestoneNodeFormLayoutId = "panelFormLayout2";
    private String taskNodeTopFormLayoutId = "panelFormLayout3";
    private UIGauge agProgressGauge = new UIGauge();
    private String agProgressGaugeValue = new String("0");
    private static String treeNodeType;
    private UIXSwitcher agNodeSwitcherBind;
    private RichTree agTreeBinding;
    private UIXSwitcher mainAreaNodeSwitcher;
    private RowKeySet disclosedRowKeys = new RowKeySetTreeImpl();
    private RowKeySet selectedRowKeys = new RowKeySetTreeImpl();
    private RowKeySet disclosedAgTreeNode = new RowKeySetTreeImpl();
    private RowKeySet selectedAgTreeNode = new RowKeySetTreeImpl();
    private Boolean isMilestoneRequired = false;
    private Boolean isTaskRequired = false;
    private Boolean isMilestoneActive = true;
    private Boolean isTaskActive = true;
    private String singleAGInstanceId = null;
    private Boolean singleInstance = false;
    private Boolean areAGDetailsRendered = false;
    private RichPanelStretchLayout agDetailsLayout = null;
    private String showRefreshButton = "false";
    private String showGaugeTickMarks = "false";
    private String showGaugePercentLabel = "false";
    private boolean bShowGaugeTickMarks = false;
    private boolean bShowGaugePercentLabel = false;
    private RichPanelGroupLayout agTreePanelGroup = null;
    private String useCustomBlockedIcon = null;
    private String currentTaskId = null;
    private String previousTaskId = null;
    private boolean isCurrentTaskFuture = false;
    boolean previousTaskTraversed = false;
    String humanTaskURLType = null;
    private AGDetailsCache agDetailsCache = new AGDetailsCache();

    public AGTreeModelBean() {
        this.svcIfc = AGUtil.createIAGServiceInterface();
        this.agProps = AGUtil.getAgProps();
        this.initialize();
    }

    public void initialize() {
        _aGInstanceID = null;
        _agName = null;
        _agInstanceId = null;
        _agPercentCompletion = null;
        _agDescription = null;
        _agCreated = null;
        _agStatus = null;
        _msName = null;
        _msDescription = null;
        _msStatus = null;
        _taskState = null;
        _taskDueDate = null;
        _taskURL = null;
        _agTreeModelList = null;
        bMilestoneErrors = false;
        bTaskErrors = false;
        bComponentIdInitialized = false;
        this.recentSelectedPath = null;
        treeNodeType = null;
        this.currentTaskId = null;
        this.previousTaskId = null;
        this.isCurrentTaskFuture = false;
        this.previousTaskTraversed = false;
        this.humanTaskURLType = null;
        this.readParams();
        this.setGaugeCustomAttributes();
        this.setServerInterfaceAttributes();
        this.initializeAGTreeModelList();
        if (this.singleInstance.booleanValue() && this.singleAGInstanceId != null) {
            this.updateAGPercentCompletion(this.singleAGInstanceId);
        }
    }

    private void updateAGPercentCompletion(String agId) {
        String mthd = "updateAGPercentCompletion";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        try {
            if (agId != null) {
                int agPercentCompletion = this.svcIfc.getAGPercentCompletion(agId);
                _agPercentCompletion = Integer.toString(agPercentCompletion);
            } else {
                _agPercentCompletion = "0";
            }
        }
        catch (AGException e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
        catch (WorkflowException e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
        if (_agPercentCompletion != null) {
            this.agProgressGaugeValue = _agPercentCompletion;
        }
    }

    protected void refreshAGPercentCompletion(String agId) {
        String mthd = "refreshAGPercentCompletion";
        this.updateAGPercentCompletion(agId);
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        if (agLog.isInfo()) {
            agLog.info(mthd, AGUIInfoMsg.MSG_PERCENT_COMPLETE.instance(this.agProgressGaugeValue));
        }
        RequestContext reqContext = RequestContext.getCurrentInstance();
        reqContext.addPartialTarget((UIComponent)this.agProgressGauge);
    }

    public String getAGInstanceID() {
        return _aGInstanceID;
    }

    public void setAGInstanceID(String aGInstanceID) {
        if (aGInstanceID != null) {
            _aGInstanceID = aGInstanceID;
        }
    }

    public AGInstance getAGInstance() {
        try {
            if (_aGInstanceID != null) {
                return this.svcIfc.getAGInstanceById(_aGInstanceID);
            }
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance("getAGInstance", e.getMessage());
            agLog.error("getAGInstance", lMsgRef, e);
        }
        return null;
    }

    public String getAgName() {
        return _agName;
    }

    public String getAgInstanceId() {
        return _agInstanceId;
    }

    public String getAgPercentCompletion() {
        return _agPercentCompletion;
    }

    public String getAgDescription() {
        return _agDescription;
    }

    public Date getAgCreated() {
        return _agCreated;
    }

    public String getAgStatus() {
        return _agStatus;
    }

    public String getMsName() {
        return _msName;
    }

    public String getMsDescription() {
        return _msDescription;
    }

    public String getMsStatus() {
        return _msStatus;
    }

    public String getTaskName() {
        return _taskName;
    }

    public Date getTaskDueDate() {
        return _taskDueDate;
    }

    public String getTaskURL() {
        return _taskURL;
    }

    public String getTreeFacetName() {
        if (this.bEmptyTreeModel) {
            return "blankTreeFacet";
        }
        return "treeFacet";
    }

    public List getAgInstanceIdList() {
        return _agInstanceIdList;
    }

    public String getInlineStyleInactive() {
        return _inlineStyleInactive;
    }

    public TreeModel getTreeModel() {
        String currentInstanceId = null;
        if (this.singleInstance.booleanValue()) {
            currentInstanceId = this.singleAGInstanceId;
            if (!this.areAGDetailsRendered.booleanValue()) {
                this.refreshAGDetailsRegion();
                if (this.agDetailsLayout != null && this.agDetailsLayout.isRendered()) {
                    RequestContext.getCurrentInstance().addPartialTarget((UIComponent)this.agDetailsLayout);
                    this.areAGDetailsRendered = true;
                }
            }
        } else {
            AGInstanceListBean agInstBean = (AGInstanceListBean)AGUtil.evaluateELExpression("#{agInstanceListBean}", AGInstanceListBean.class);
            currentInstanceId = agInstBean.getAGInstanceID();
        }
        return this.getAgTreeModel(currentInstanceId);
    }

    public TreeModel getAgTreeModel(String agInstanceId) {
        TreeModel agTreeModel = null;
        String mthd = "agAgTreeModel";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        if (agInstanceId == null) {
            return null;
        }
        try {
            agTreeModel = this._createTreeModel(agInstanceId);
            if (agTreeModel == null) {
                if (agLog.isDebug()) {
                    agLog.debug("Tree model is null for instance " + agInstanceId);
                }
                this.bEmptyTreeModel = true;
            } else {
                this.bEmptyTreeModel = false;
            }
        }
        catch (IntrospectionException e) {
            this.bEmptyTreeModel = true;
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
        return agTreeModel;
    }

    private TreeModel _createTreeModel(String agInstanceId) throws IntrospectionException {
        String mthd = "_createTreeModel";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        String nodeIcon = null;
        String statusIcon = null;
        ArrayList rootList = new ArrayList(1);
        if (this.agDetailsCache.getAGDetails(agInstanceId) != null) {
            rootList = this.agDetailsCache.getAGDetails(agInstanceId);
        } else {
            HashMap<Object, Object> agEntry = new HashMap<Object, Object>(19);
            try {
                List milestoneList = this.getMilestoneList(agInstanceId);
                agEntry.put(IAGUIConstants.NODETYPE_PROPERTY, "ag");
                agEntry.put(IAGUIConstants.INSTANCEID_AG_PROPERTY, agInstanceId);
                _agName = this.svcIfc.getAGDisplayTitle(agInstanceId);
                if (_agName == null || _agName.length() == 0) {
                    _agName = this.svcIfc.getAGName(agInstanceId);
                }
                agEntry.put(IAGUIConstants.NAME_AG_PROPERTY, _agName);
                agEntry.put(IAGUIConstants.ROW_KEY_PROPERTY, agInstanceId);
                _agDescription = this.svcIfc.getAGDescription(agInstanceId);
                agEntry.put(IAGUIConstants.NAME_TOOLTIP_AG_PROPERTY, _agDescription);
                agEntry.put(IAGUIConstants.DESCRIPTION_AG_PROPERTY, _agDescription);
                String agStatus = this.svcIfc.getAGStatus(agInstanceId);
                _agStatus = agStatus;
                agEntry.put("status", agStatus);
                Calendar agCreated = this.svcIfc.getAGCreated(agInstanceId);
                agEntry.put("agCreationDate", agCreated);
                String agStatusIconTooltip = null;
                nodeIcon = this.svcIfc.getAGIconLocation(agInstanceId);
                nodeIcon = this.verifyImageURL(nodeIcon);
                if (bMilestoneErrors.booleanValue()) {
                    statusIcon = "/ag_images/taskerrored_qualifier.png";
                    bMilestoneErrors = false;
                    agStatusIconTooltip = "One of the milestones in this activity guide is in an error state";
                    agEntry.put(IAGUIConstants.ICON_TOOLTIP_AG_PROPERTY, agStatusIconTooltip);
                } else if (agStatus.compareTo("Completed With Warning") == 0 || agStatus.compareTo("Errored") == 0 || agStatus.compareTo("Terminated") == 0) {
                    statusIcon = "/ag_images/taskalerted_qualifier.png";
                    agStatusIconTooltip = "The underlying BPEL process for this AG is in an error state";
                    agEntry.put(IAGUIConstants.ICON_TOOLTIP_AG_PROPERTY, agStatusIconTooltip);
                } else if (agStatus.equals("Completed") || agStatus.equals("Terminated")) {
                    // empty if block
                }
                if (nodeIcon != null) {
                    agEntry.put(IAGUIConstants.ICON_PROPERTY, nodeIcon);
                }
                if (statusIcon != null) {
                    agEntry.put(IAGUIConstants.STATUS_ICON_AG_PROPERTY, statusIcon);
                }
                if (milestoneList != null) {
                    agEntry.put("agList", milestoneList);
                }
            }
            catch (Exception e) {
                ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
                agLog.error(mthd, lMsgRef, e);
                FilterBean filterBean = (FilterBean)AGUtil.evaluateELExpression("#{filterBean}", FilterBean.class);
                AGAppearanceParams agAppearanceParams = (AGAppearanceParams)AGUtil.evaluateELExpression("#{appearanceParams}", AGAppearanceParams.class);
                agAppearanceParams.setAgFilterDropDownVisible(false);
                agAppearanceParams.setAgTreeRendered(false);
                treeNodeType = "blank";
                RequestContext reqContext = RequestContext.getCurrentInstance();
                reqContext.addPartialTarget(this.agTreeBinding.getParent());
                reqContext.addPartialTarget((UIComponent)filterBean.getTaskFilterDropDown());
                reqContext.addPartialTarget((UIComponent)this.agDetailsLayout);
                _aGInstanceID = null;
                AGTasksPopup agTasksPopup = (AGTasksPopup)AGUtil.evaluateELExpression("#{agTasksPopup}", AGTasksPopup.class);
                try {
                    agTasksPopup.setAGInstance(this.svcIfc.getAGInstanceById(_aGInstanceID));
                    agTasksPopup.refreshCompletedTasks();
                }
                catch (Exception ex) {
                    ResourceRef lMsgRefEx = AGUIErrorMsg.ERR_IN_METHOD.instance("_createTreeModel", e.getMessage());
                    agLog.error("_createTreeModel", lMsgRef, e);
                }
                this.refreshAGPercentCompletion(null);
                reqContext.addPartialTarget((UIComponent)this.agProgressGauge);
            }
            rootList.add(agEntry);
            this.agDetailsCache.addAGDetailsToCache(rootList, agInstanceId);
            if (agLog.isDebug()) {
                agLog.debug("Adding ag details of instance id " + agInstanceId + " to cache");
            }
        }
        RowKeyPropertyModel rowKeyPropModel = new RowKeyPropertyModel(rootList, (String)IAGUIConstants.ROW_KEY_PROPERTY);
        return new RowKeyPropertyTreeModel((Object)rowKeyPropModel, "agList", (String)IAGUIConstants.ROW_KEY_PROPERTY);
    }

    public List getMilestoneList(String agInstanceId) {
        String mthd = "getMilestoneList";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        ArrayList milestoneList = null;
        try {
            List<String> milestones = this.svcIfc.getAGMilestones(agInstanceId);
            if (milestones == null || milestones.size() == 0) {
                return IAGUIConstants.EMPTY_MILESTONE_LIST;
            }
            milestoneList = new ArrayList(milestones.size());
            for (int i = 0; i < milestones.size(); ++i) {
                boolean b;
                String nodeIcon = null;
                String statusIcon = null;
                this.isMilestoneRequired = false;
                this.isMilestoneActive = true;
                HashMap<Object, Object> milestoneEntry = new HashMap<Object, Object>(19);
                milestoneEntry.put(IAGUIConstants.NODETYPE_PROPERTY, "milestone");
                String milestoneName = milestones.get(i);
                milestoneEntry.put(IAGUIConstants.ROW_KEY_PROPERTY, milestoneName);
                String milestoneStatus = this.svcIfc.getMSStatus(agInstanceId, milestoneName);
                milestoneEntry.put("status", milestoneStatus);
                String milestoneDisplayTitle = this.svcIfc.getMSDisplayTitle(agInstanceId, milestoneName);
                Boolean msErrorStatus = false;
                if (milestoneStatus.compareToIgnoreCase("Errored") == 0) {
                    msErrorStatus = true;
                }
                milestoneEntry.put(IAGUIConstants.INSTANCEID_AG_PROPERTY, agInstanceId);
                if (!milestoneDisplayTitle.startsWith("switch_")) {
                    milestoneEntry.put(IAGUIConstants.NAME_MILESTONE_PROPERTY, this.svcIfc.getMSDisplayTitle(agInstanceId, milestoneName));
                } else {
                    milestoneEntry.put(IAGUIConstants.NAME_MILESTONE_PROPERTY, " ");
                    milestoneEntry.put(IAGUIConstants.INLINESTYLE_MILESTONE_PROPERTY, _inlineStyleInactive);
                    this.isMilestoneActive = false;
                    milestoneEntry.put("isMilestoneBranch", true);
                }
                milestoneEntry.put(IAGUIConstants.ID_MILESTONE_PROPERTY, milestoneName);
                milestoneEntry.put(IAGUIConstants.NAME_TOOLTIP_MILESTONE_PROPERTY, this.svcIfc.getMSDescription(agInstanceId, milestoneName));
                _msDescription = this.svcIfc.getMSDescription(agInstanceId, milestoneName);
                milestoneEntry.put(IAGUIConstants.DESCRIPTION_MILESTONE_PROPERTY, this.svcIfc.getMSDescription(agInstanceId, milestoneName));
                if (!milestoneDisplayTitle.startsWith("switch_")) {
                    nodeIcon = this.svcIfc.getMSIconLocation(agInstanceId, milestoneName);
                    nodeIcon = this.verifyImageURL(nodeIcon);
                } else {
                    nodeIcon = "/ag_images/indicatemoreside.png";
                }
                List taskList = this.getMSChildren(agInstanceId, milestoneName);
                if (bTaskErrors.booleanValue() || msErrorStatus.booleanValue()) {
                    statusIcon = "/ag_images/taskerrored_qualifier.png";
                    bMilestoneErrors = true;
                    bTaskErrors = false;
                    milestoneEntry.put(IAGUIConstants.ICON_TOOLTIP_MILESTONE_PROPERTY, "One of the tasks that belong to the milestone might be in an error state");
                } else if (milestoneStatus.compareToIgnoreCase("Completed") == 0) {
                    statusIcon = "/ag_images/checkmark_status.png";
                } else if (milestoneStatus.compareToIgnoreCase("Expired") == 0) {
                    statusIcon = "/ag_images/taskexpired_qualifier.png";
                    milestoneEntry.put(IAGUIConstants.ICON_TOOLTIP_MILESTONE_PROPERTY, "The milestone is in expired state");
                }
                if ("Expired".equals(milestoneStatus) || milestoneDisplayTitle.startsWith("switch_")) {
                    milestoneEntry.put(IAGUIConstants.INLINESTYLE_MILESTONE_PROPERTY, _inlineStyleInactive);
                    b = false;
                    milestoneEntry.put(IAGUIConstants.NODE_LINK_ACTIVE, b);
                    this.isMilestoneActive = false;
                } else {
                    if (_inlineStyleActive != null) {
                        milestoneEntry.put(IAGUIConstants.INLINESTYLE_MILESTONE_PROPERTY, _inlineStyleActive);
                    }
                    milestoneEntry.put("agList", taskList);
                    b = true;
                    milestoneEntry.put(IAGUIConstants.NODE_LINK_ACTIVE, b);
                }
                milestoneEntry.put("isNodeRequired", this.isMilestoneRequired);
                if (this.isMilestoneRequired.booleanValue()) {
                    if (this.isMilestoneActive.booleanValue()) {
                        milestoneEntry.put("nodeRequiredAltText", "AG_MILESTONE_NODE_REQUIRED");
                    } else {
                        milestoneEntry.put("nodeRequiredAltText", "AG_MILESTONE_NODE_DISABLED_REQUIRED");
                    }
                }
                if (nodeIcon != null) {
                    milestoneEntry.put(IAGUIConstants.ICON_PROPERTY, nodeIcon);
                }
                if (statusIcon != null) {
                    milestoneEntry.put(IAGUIConstants.STATUS_ICON_MILESTONE_PROPERTY, statusIcon);
                }
                milestoneList.add(milestoneEntry);
            }
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
        return milestoneList;
    }

    public List getMSChildren(String agInstanceId, String milestoneName) {
        ArrayList msChildrenList = null;
        String mthd = "getMSChildren";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        try {
            List<String> msChildren = this.svcIfc.getMSChildren(agInstanceId, milestoneName);
            String queryMode = this.svcIfc.getProcessMode(agInstanceId);
            msChildrenList = new ArrayList(msChildren.size());
            for (int i = 0; i < msChildren.size(); ++i) {
                boolean b;
                Object nodeIcon = null;
                String statusIcon = null;
                String msChild = msChildren.get(i);
                String taskTypePrefix = "Task:";
                this.isTaskActive = true;
                if (msChild.indexOf(taskTypePrefix) <= -1) continue;
                HashMap<Object, Object> taskEntry = new HashMap<Object, Object>(19);
                taskEntry.put(IAGUIConstants.NODETYPE_PROPERTY, "task");
                int startIndex = msChild.indexOf("Task:") + taskTypePrefix.length();
                String taskInstanceId = msChild.substring(startIndex);
                String taskDispName = this.svcIfc.getTaskTitle(agInstanceId, milestoneName, taskInstanceId);
                taskEntry.put(IAGUIConstants.INSTANCEID_AG_PROPERTY, agInstanceId);
                taskEntry.put(IAGUIConstants.MILESTONE_NAME_TASK_PROPERTY, milestoneName);
                taskEntry.put(IAGUIConstants.INSTANCEID_TASK_PROPERTY, taskInstanceId);
                taskEntry.put(IAGUIConstants.ICON_TOOLTIP_TASK_PROPERTY, taskDispName);
                if (!taskDispName.startsWith("switch")) {
                    taskEntry.put(IAGUIConstants.NAME_TASK_PROPERTY, this.svcIfc.getTaskTitle(agInstanceId, milestoneName, taskInstanceId));
                    taskEntry.put(IAGUIConstants.ROW_KEY_PROPERTY, taskInstanceId);
                } else {
                    taskEntry.put(IAGUIConstants.NAME_TASK_PROPERTY, " ");
                    taskEntry.put(IAGUIConstants.ROW_KEY_PROPERTY, taskInstanceId);
                }
                taskEntry.put(IAGUIConstants.DESCRIPTION_TASK_PROPERTY, this.svcIfc.getMSDescription(agInstanceId, milestoneName));
                String taskStatus = this.svcIfc.getTaskStatus(agInstanceId, milestoneName, taskInstanceId);
                taskEntry.put("status", taskStatus);
                Calendar taskDueDate = this.svcIfc.getTaskDueDate(agInstanceId, milestoneName, taskInstanceId);
                taskEntry.put("taskDueDate", taskDueDate);
                String taskURL = null;
                if (!taskDispName.startsWith("switch")) {
                    statusIcon = (String)statusToIconMap.get(taskStatus);
                    if (!taskInstanceId.startsWith("AGDM") && !taskStatus.equalsIgnoreCase("COMPLETED")) {
                        taskURL = this.svcIfc.getTaskURL(agInstanceId, milestoneName, taskInstanceId);
                    }
                } else {
                    statusIcon = "/ag_images/indicatemoreside.png";
                    b = false;
                    taskEntry.put(IAGUIConstants.NODE_LINK_ACTIVE, b);
                    taskEntry.put(IAGUIConstants.INLINESTYLE_TASK_PROPERTY, _inlineStyleInactive);
                    this.isTaskActive = false;
                    taskURL = null;
                }
                taskEntry.put("taskURL", taskURL);
                if (taskInstanceId.startsWith("AGDM") || taskStatus.equalsIgnoreCase("Not Started")) {
                    taskEntry.put(IAGUIConstants.INLINESTYLE_TASK_PROPERTY, _inlineStyleInactive);
                    b = false;
                    taskEntry.put(IAGUIConstants.NODE_LINK_ACTIVE, b);
                    this.isTaskActive = false;
                } else if (_inlineStyleActive != null) {
                    taskEntry.put(IAGUIConstants.INLINESTYLE_TASK_PROPERTY, _inlineStyleActive);
                }
                if (taskStatus != null && taskStatus.equals("COMPLETED")) {
                    if (queryMode.equalsIgnoreCase("AGBPM")) {
                        String taskState = this.svcIfc.getGlobalTaskAccessMode(agInstanceId);
                        if (taskState != null && taskState.equalsIgnoreCase("activeOnly")) {
                            taskEntry.put(IAGUIConstants.INLINESTYLE_TASK_PROPERTY, _inlineStyleInactive);
                        } else {
                            taskEntry.put(IAGUIConstants.INLINESTYLE_TASK_PROPERTY, _inlineStyleActive);
                        }
                    } else {
                        taskEntry.put(IAGUIConstants.INLINESTYLE_TASK_PROPERTY, _inlineStyleInactive);
                    }
                }
                this.isTaskRequired = this.svcIfc.isTaskRequired(agInstanceId, milestoneName, taskInstanceId);
                taskEntry.put("isNodeRequired", this.isTaskRequired);
                Boolean bl = this.isMilestoneRequired = this.isTaskRequired != false ? this.isTaskRequired : this.isMilestoneRequired;
                if (this.isTaskRequired.booleanValue()) {
                    if (this.isTaskActive.booleanValue()) {
                        taskEntry.put("nodeRequiredAltText", "AG_TASK_NODE_REQUIRED");
                    } else {
                        taskEntry.put("nodeRequiredAltText", "AG_TASK_NODE_DISABLED_REQUIRED");
                    }
                }
                if (nodeIcon != null) {
                    taskEntry.put(IAGUIConstants.ICON_PROPERTY, nodeIcon);
                }
                if (statusIcon != null) {
                    taskEntry.put(IAGUIConstants.STATUS_ICON_TASK_PROPERTY, statusIcon);
                }
                if (!taskDispName.startsWith("switch") && queryMode.equalsIgnoreCase("AGBPM")) {
                    Boolean isTaskBlocked = this.svcIfc.isDisplayBlockedIcon(agInstanceId, milestoneName, taskInstanceId);
                    boolean useCustomIcon = this.svcIfc.getUseCustomBlockedIcon();
                    if (isTaskBlocked.booleanValue()) {
                        String taskBlockedDesc;
                        String taskBlockIcon;
                        if (useCustomIcon) {
                            taskBlockIcon = this.svcIfc.getTaskBlockedIconLocation(agInstanceId);
                            taskBlockedDesc = this.svcIfc.getTaskBlockedIconDescription(agInstanceId, milestoneName, taskInstanceId);
                            taskEntry.put("isTaskBlocked", true);
                            taskEntry.put(IAGUIConstants.TASK_BLOCKED_ICON_PROPERTY, taskBlockIcon);
                            taskEntry.put(IAGUIConstants.TASK_BLOCKED_ICON_DESC, taskBlockedDesc);
                            taskEntry.remove(IAGUIConstants.STATUS_ICON_TASK_PROPERTY);
                        } else {
                            taskBlockIcon = "/ag_images/taskblocked_qualifier.png";
                            taskEntry.put("isTaskBlocked", true);
                            taskEntry.put(IAGUIConstants.TASK_BLOCKED_ICON_PROPERTY, taskBlockIcon);
                            taskBlockedDesc = this.svcIfc.getTaskBlockedIconDescription(agInstanceId, milestoneName, taskInstanceId);
                            taskEntry.put(IAGUIConstants.TASK_BLOCKED_ICON_DESC, taskBlockedDesc);
                        }
                    }
                }
                if (taskStatus != null && taskStatus.compareToIgnoreCase("TASK_STATE_ERRORED") == 0) {
                    bTaskErrors = true;
                }
                FilterBean filterBean = (FilterBean)AGUtil.evaluateELExpression("#{filterBean}", FilterBean.class);
                filterBean.filterTasks(msChildrenList, taskEntry, taskStatus, this.isTaskRequired);
            }
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
        if (this.svcIfc.getQueryMode().equals("QUERY_BPM")) {
            this.setTaskBlockedIcon(msChildrenList);
        }
        return msChildrenList;
    }

    private void setServerInterfaceAttributes() {
        String mthd = " setServerInterfaceAttributes";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        String value = null;
        value = this.agProps.getProperty("ServerAuthenticationMethod");
        this.svcIfc.setAuthenticationMethod(value);
        value = this.agProps.getProperty("ServerConnectionMode");
        this.svcIfc.setConnectionMode(value);
        value = this.agProps.getProperty("Realm");
        this.svcIfc.setRealm(value);
        String jsCode = "{        \n         var refreshButton = event.getSource().findComponent(\"refreshButton\");\n         \n         if (refreshButton) {\n               AdfActionEvent.queue(refreshButton, refreshButton.getPartialSubmit());\n           }\n       }";
        this.svcIfc.setJSRefreshCallback(jsCode, "generateRowDisclosedEvent(event)");
        SecurityContext sctx = ADFContext.getCurrent().getSecurityContext();
        if (sctx.isAuthorizationEnabled() && sctx.isAuthenticated()) {
            if (agLog.isInfo()) {
                agLog.info(mthd, AGUIInfoMsg.MSG_SEC_AUTH_VALID.instance(mthd));
            }
            String loginUserId = sctx.getUserName();
            this.svcIfc.setLoginUserId(loginUserId);
            if (agLog.isInfo()) {
                agLog.info(mthd, AGUIInfoMsg.MSG_LOGIN_USERINFO.instance(loginUserId));
            }
        } else if (agLog.isError()) {
            agLog.error(mthd, AGUIErrorMsg.ERR_AG_SERVER_AUTHMODE_INVALID.instance(mthd));
        }
        value = this.agProps.getProperty("WorklistHttpURL");
        this.svcIfc.setWorklistURL(value);
        value = this.agProps.getProperty("AG_QUERY_MODE");
        this.svcIfc.setQueryMode(value);
        value = this.agProps.getProperty("ShowCustomBlockedIcon");
        this.svcIfc.setUseCustomBlockedIcon(value);
    }

    public Map<String, TreeModel> getAgTreeModelList() {
        String mthd = "getAgTreeModelList";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        if (_agTreeModelList == null) {
            this.setServerInterfaceAttributes();
            HashMap<String, String> queryPropMap = new HashMap<String, String>();
            String value = null;
            value = this.agProps.getProperty("SelectionFilter");
            queryPropMap.put("SelectionFilter", value);
            value = this.agProps.getProperty("AGDefinitionFilter");
            queryPropMap.put("AGDefinitionFilter", value);
            queryPropMap.put("AGInstanceID", this.getAGInstanceID());
            value = this.agProps.getProperty("AGInstanceOrdering");
            queryPropMap.put("AGInstanceOrdering", value);
            value = this.agProps.getProperty("CustomPredicate1");
            queryPropMap.put("CustomPredicate1", value);
            value = this.agProps.getProperty("CustomPredicate2");
            queryPropMap.put("CustomPredicate2", value);
            try {
                _agInstanceIdList = this.svcIfc.getAGInstances(queryPropMap);
                _agTreeModelList = new HashMap<String, TreeModel>();
                for (int i = 0; i < this.getAgInstanceIdList().size(); ++i) {
                    AGServiceInterfaceImpl.AGInstanceDetails agInstanceInfo = (AGServiceInterfaceImpl.AGInstanceDetails)_agInstanceIdList.get(i);
                    String agInstanceId = agInstanceInfo.getCiKey();
                    TreeModel agTreeModel = null;
                    this.agDetailsCache.clearAGDetailsCache();
                    agTreeModel = this.getAgTreeModel(agInstanceId);
                    _agTreeModelList.put(agInstanceId, agTreeModel);
                }
            }
            catch (Exception e) {
                ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
                agLog.error(mthd, lMsgRef, e);
            }
        }
        return _agTreeModelList;
    }

    public void setAgTreeModelList(Map<String, TreeModel> agTreeModelList) {
        _agTreeModelList = agTreeModelList;
    }

    public void treeRowSelected(SelectionEvent e) {
        RichTree _agTree = (RichTree)e.getSource();
        RowKeySet addedSet = e.getAddedSet();
        this.populateAllAGTreeNodesAttributes(_agTree, addedSet);
        this.refreshAGDetailsRegion();
    }

    private void populateAllAGTreeNodesAttributes(RichTree agTree, RowKeySet set) {
        String mthd = "populateAllAGTreeeNodesAttributes";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        if (agTree != null) {
            Object bkupRow = agTree.getRowKey();
            if (set == null || set.isEmpty()) {
                treeNodeType = "blank";
                return;
            }
            Object nodeInlineStyle = null;
            for (Object rowKey : set) {
                TreeModel agTreeModel = (TreeModel)agTree.getValue();
                agTreeModel.setRowKey(rowKey);
                Map currentRow = null;
                if (!agTreeModel.isRowAvailable()) {
                    treeNodeType = "blank";
                    return;
                }
                currentRow = (Map)agTreeModel.getRowData();
                treeNodeType = (String)currentRow.get(IAGUIConstants.NODETYPE_PROPERTY);
                _agInstanceId = (String)currentRow.get(IAGUIConstants.INSTANCEID_AG_PROPERTY);
                if (((String)currentRow.get(IAGUIConstants.NODETYPE_PROPERTY)).compareTo("ag") == 0) {
                    if (agLog.isFinest()) {
                        agLog.finest("Swting the right hand side to \"agNode\"");
                    }
                    this.populateAGNodeAttributes(_agInstanceId);
                    this.recentSelectedPath = _agInstanceId;
                    break;
                }
                if (((String)currentRow.get(IAGUIConstants.NODETYPE_PROPERTY)).compareTo("milestone") == 0) {
                    if (agLog.isFinest()) {
                        agLog.finest("Switching the right hand side to \"milestoneNode\"");
                    }
                    String milestoneName = (String)currentRow.get(IAGUIConstants.ID_MILESTONE_PROPERTY);
                    this.populateMilestoneNodeAttributes(_agInstanceId, milestoneName);
                    this.recentSelectedPath = _agInstanceId + ":" + milestoneName;
                    break;
                }
                if (((String)currentRow.get(IAGUIConstants.NODETYPE_PROPERTY)).compareTo("task") == 0) {
                    String milestoneName = (String)currentRow.get(IAGUIConstants.MILESTONE_NAME_TASK_PROPERTY);
                    String taskInstanceId = (String)currentRow.get(IAGUIConstants.INSTANCEID_TASK_PROPERTY);
                    String taskStatus = null;
                    String tasklinkState = null;
                    try {
                        taskStatus = this.svcIfc.getTaskStatus(_agInstanceId, milestoneName, taskInstanceId);
                        if (this.svcIfc.getProcessMode(_agInstanceId).equalsIgnoreCase("AGBPM")) {
                            tasklinkState = this.svcIfc.getGlobalTaskAccessMode(_agInstanceId);
                        }
                    }
                    catch (AGException e) {
                        ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
                        agLog.error(mthd, lMsgRef, e);
                    }
                    catch (WorkflowException e) {
                        ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
                        agLog.error(mthd, lMsgRef, e);
                    }
                    if (taskStatus != null && taskStatus.equals("COMPLETED")) {
                        if (tasklinkState != null) {
                            if (tasklinkState.equalsIgnoreCase("activeOnly")) {
                                treeNodeType = "blank";
                                break;
                            }
                        } else {
                            treeNodeType = "blank";
                            break;
                        }
                    }
                    if (agLog.isFinest()) {
                        agLog.finest("Switching to the right hand side to \"taskNode\"");
                    }
                    this.populateTaskNodeAttributes(_agInstanceId, milestoneName, taskInstanceId);
                    this.recentSelectedPath = _agInstanceId + ":" + milestoneName + ":" + taskInstanceId;
                    break;
                }
                treeNodeType = "blank";
            }
            this.agTreeBinding.setRowKey(bkupRow);
        }
    }

    private void populateAllAGTreeNodesAttributes(TreeModel treeModel) {
        if (!treeModel.isRowAvailable()) {
            return;
        }
        Map rowData = (Map)treeModel.getRowData();
        treeNodeType = (String)rowData.get(IAGUIConstants.NODETYPE_PROPERTY);
        if ("ag".equals(treeNodeType)) {
            _agDescription = (String)rowData.get(IAGUIConstants.DESCRIPTION_AG_PROPERTY);
            _agStatus = (String)rowData.get("status");
            Calendar calData = (Calendar)rowData.get("agCreationDate");
            _agCreated = this.getDate(calData);
        } else if ("milestone".equals(treeNodeType)) {
            _msName = (String)rowData.get(IAGUIConstants.NAME_MILESTONE_PROPERTY);
            _msDescription = (String)rowData.get(IAGUIConstants.DESCRIPTION_MILESTONE_PROPERTY);
            _msStatus = (String)rowData.get("status");
        } else if ("task".equals(treeNodeType)) {
            _taskName = (String)rowData.get(IAGUIConstants.NAME_TASK_PROPERTY);
            _taskState = (String)rowData.get("status");
            Calendar calData = (Calendar)rowData.get("taskDueDate");
            _taskDueDate = this.getDate(calData);
            _taskURL = (String)rowData.get("taskURL");
            this.currentTaskId = (String)rowData.get(IAGUIConstants.INSTANCEID_TASK_PROPERTY);
            this.isCurrentTaskFuture = _taskState == null;
        } else {
            treeNodeType = "blank";
        }
    }

    private Date getDate(Calendar calData) {
        if (calData == null) {
            return null;
        }
        return calData.getTime();
    }

    private void populateAGNodeAttributes(String agInstanceId) {
        String mthd = "populateAGNodeAttributes";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        try {
            _agDescription = this.svcIfc.getAGDescription(agInstanceId);
            Calendar agCreated = this.svcIfc.getAGCreated(agInstanceId);
            _agCreated = this.getDate(agCreated);
            _agStatus = this.svcIfc.getAGStatus(agInstanceId);
            this.postAGErrorMessages(agInstanceId);
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
    }

    private void postAGErrorMessages(String agInstanceId) {
        String mthd = "postAGErrorMessages";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        try {
            String errorMessage = this.svcIfc.getAGErrorMessage(agInstanceId);
            if (errorMessage != null && errorMessage.compareTo("") != 0) {
                FacesContext context = FacesContext.getCurrentInstance();
                FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, "", errorMessage);
                context.addMessage(this.agNodePanelFormLayoutId, msg);
            }
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
    }

    private void populateMilestoneNodeAttributes(String agInstanceId, String milestoneName) {
        String mthd = "populateMilestoneNodeAttributes";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        try {
            _msName = this.svcIfc.getMSDisplayTitle(agInstanceId, milestoneName);
            _msDescription = this.svcIfc.getMSDescription(agInstanceId, milestoneName);
            _msStatus = this.svcIfc.getMSStatus(agInstanceId, milestoneName);
            this.postMSErrorMessages(agInstanceId, milestoneName);
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
    }

    private void postMSErrorMessages(String agInstanceId, String milestoneName) {
        String mthd = "postMSErrorMessages";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        try {
            String errorMessage = this.svcIfc.getMSErrorMessage(agInstanceId, milestoneName);
            FacesContext context = FacesContext.getCurrentInstance();
            if (errorMessage != null && errorMessage.compareTo("") != 0) {
                FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, "", errorMessage);
                context.addMessage(this.milestoneNodeFormLayoutId, msg);
            }
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
    }

    private void populateTaskNodeAttributes(String agInstanceId, String milestoneName, String taskInstanceId) {
        String mthd = "populateTaskNodeAttributes";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        try {
            Calendar taskDueDate;
            this.currentTaskId = taskInstanceId;
            _taskName = this.svcIfc.getTaskTitle(agInstanceId, milestoneName, taskInstanceId);
            if (_taskName.startsWith("switch")) {
                _taskName = " ";
            }
            boolean bl = this.isCurrentTaskFuture = (_taskState = this.svcIfc.getTaskStatus(agInstanceId, milestoneName, taskInstanceId)) == null;
            if (!taskInstanceId.startsWith("AGDM")) {
                _taskURL = this.svcIfc.getTaskURL(agInstanceId, milestoneName, taskInstanceId);
            }
            if ((taskDueDate = this.svcIfc.getTaskDueDate(agInstanceId, milestoneName, taskInstanceId)) != null) {
                _taskDueDate = this.getDate(taskDueDate);
            }
            this.postTaskErrorMessages(agInstanceId, milestoneName, taskInstanceId);
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
    }

    private void postTaskErrorMessages(String agInstanceId, String milestoneName, String taskInstanceId) {
        String mthd = "postTaskErrorMessages";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        try {
            FacesContext context = FacesContext.getCurrentInstance();
            List<String> taskErrors = this.svcIfc.getTaskErrors(agInstanceId, milestoneName, taskInstanceId);
            for (int i = 0; i < taskErrors.size(); ++i) {
                FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, "", taskErrors.get(i));
                context.addMessage(this.taskNodeTopFormLayoutId, msg);
            }
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
    }

    public String getHumanTaskURLType() {
        this.humanTaskURLType = _taskURL != null ? "valid" : "invalid";
        return this.humanTaskURLType;
    }

    public void handleExplicitRefresh(ActionEvent actionEvent) {
        Object switcher = null;
        if (_agTreeModelList != null) {
            _agTreeModelList.clear();
        }
        this.agDetailsCache.clearAGDetailsCache();
        this.setAgTreeModelList(null);
        this.getAgTreeModelList();
        if (!this.isCurrentTaskFuture) {
            this.previousTaskId = this.currentTaskId;
        }
        String agId = null;
        if (this.singleInstance.booleanValue()) {
            agId = this.singleAGInstanceId;
        } else {
            AGInstanceListBean agInstBean = (AGInstanceListBean)AGUtil.evaluateELExpression("#{agInstanceListBean}", AGInstanceListBean.class);
            agId = agInstBean.getAGInstanceID();
        }
        this.refreshAGPercentCompletion(agId);
        AGTasksPopup agTasksPopup = (AGTasksPopup)AGUtil.evaluateELExpression("#{agTasksPopup}", AGTasksPopup.class);
        try {
            agTasksPopup.setAGInstance(this.svcIfc.getAGInstanceById(agId));
            agTasksPopup.refreshCompletedTasks();
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance("handleExplicitRefresh", e.getMessage());
            agLog.error("handleExplicitRefresh", lMsgRef, e);
        }
        this.handleTreeRowSelection();
        AGContextualEventRegionalHandler.handleAGRefreshTaskTreeEvent(null);
        this.refreshAGDetailsRegion();
    }

    public void handleRowDisclosure(RowDisclosureEvent rowDisclosureEvent) {
    }

    public void setAgNodeSwitcherBind(UIXSwitcher agNodeSwitcherBind) {
        this.agNodeSwitcherBind = agNodeSwitcherBind;
    }

    public UIXSwitcher getAgNodeSwitcherBind() {
        return this.agNodeSwitcherBind;
    }

    public void setAgProgressGaugeValue(String progressGaugeValue) {
        if (progressGaugeValue != null) {
            this.agProgressGaugeValue = progressGaugeValue;
        }
    }

    public String getAgProgressGaugeValue() {
        return this.agProgressGaugeValue;
    }

    public void setAgProgressGauge(UIGauge agProgressGauge) {
        if (agProgressGauge != null) {
            this.agProgressGauge = agProgressGauge;
            this.setGaugeCustomAttributes();
        }
    }

    public UIGauge getAgProgressGauge() {
        return this.agProgressGauge;
    }

    private void setGaugeCustomAttributes() {
        String mthd = "setGaugeCustomAttributes";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        try {
            if (agLog.isDebug()) {
                agLog.debug("setGaugeMetricLabelValue  b= " + this.bShowGaugePercentLabel);
            }
            CoreGauge gauge = new CoreGauge();
            MetricLabel mLabel = gauge.getMetricLabel();
            mLabel.setPosition(this.bShowGaugePercentLabel ? 4 : 0);
            if (this.bShowGaugePercentLabel) {
                mLabel.setNumberType(1);
            }
            this.agProgressGauge.setMetricLabel(mLabel);
            if (agLog.isDebug()) {
                agLog.debug(" setGaugeTickMarks  b= " + this.bShowGaugeTickMarks);
            }
            if (!this.bShowGaugeTickMarks) {
                this.agProgressGauge.getTickLabel().setContent(0);
                this.agProgressGauge.getTickMark().setContent(0);
            } else {
                this.agProgressGauge.getTickLabel().setContent(4);
                this.agProgressGauge.getTickMark().setContent(4);
            }
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
    }

    public void setAgTreeBinding(RichTree agTreebinding) {
        this.agTreeBinding = agTreebinding;
    }

    public RichTree getAgTreeBinding() {
        return this.agTreeBinding;
    }

    public String getTreeNodeType() {
        return treeNodeType;
    }

    public RowKeySet getDisclosedRowKeys() {
        if (this.disclosedRowKeys == null || this.disclosedRowKeys.isEmpty()) {
            this.disclosedRowKeys = this.computeTreeRowSelection(true);
        }
        return this.disclosedRowKeys;
    }

    public RowKeySet getSelectedRowKeys() {
        if (this.selectedRowKeys == null || this.selectedRowKeys.isEmpty()) {
            this.selectedRowKeys = this.computeTreeRowSelection(false);
        }
        return this.selectedRowKeys;
    }

    public void handleTreeRowSelection() {
        this.disclosedRowKeys = null;
        this.selectedRowKeys = null;
        this.getSelectedRowKeys();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RowKeySet computeTreeRowSelection(boolean isDisclose) {
        String mthd = "computeRowSelection";
        if (agLog.isTrace()) {
            agLog.trace(mthd);
        }
        this.selectedAgTreeNode = new RowKeySetTreeImpl();
        this.disclosedAgTreeNode = new RowKeySetTreeImpl();
        String selectedAGInstanceId = null;
        selectedAGInstanceId = this.singleInstance != false ? this.singleAGInstanceId : _aGInstanceID;
        if (selectedAGInstanceId == null) {
            return new RowKeySetTreeImpl();
        }
        try {
            this.previousTaskTraversed = false;
            TreeModel treeModel = this._createTreeModel(selectedAGInstanceId);
            this.disclosedAgTreeNode.setCollectionModel((CollectionModel)treeModel);
            this.selectedAgTreeNode.setCollectionModel((CollectionModel)treeModel);
            Object oldRowKey = treeModel.getRowKey();
            try {
                treeModel.setRowKey(null);
                treeModel.setRowIndex(0);
                Map agData = null;
                if (treeModel.isRowAvailable()) {
                    agData = (Map)treeModel.getRowData();
                } else {
                    new RowKeySetTreeImpl();
                }
                String agStatus = (String)agData.get("status");
                if (agStatus == null) {
                    RowKeySetTreeImpl rowKeySetTreeImpl = new RowKeySetTreeImpl();
                    return rowKeySetTreeImpl;
                }
                if (agStatus.equals("Completed") || agStatus.equals("Terminated") || agStatus.equals("Completed With Warning")) {
                    this.disclosedAgTreeNode.removeAll();
                    this.selectedAgTreeNode.removeAll();
                    this.selectedAgTreeNode.add(treeModel.getRowKey());
                    RequestContext.getCurrentInstance().addPartialTarget((UIComponent)this.agTreeBinding);
                } else {
                    List nodeList = (List)agData.get("agList");
                    if (nodeList == null || nodeList.isEmpty()) {
                        this.selectedAgTreeNode.removeAll();
                        this.selectedAgTreeNode.add(treeModel.getRowKey());
                    } else {
                        this.disclosedAgTreeNode.setContained(true);
                        treeModel.enterContainer();
                        treeModel.setRowIndex(0);
                        this.traverseMilestoneNodes(treeModel);
                        this.selectedAgTreeNode.removeAll();
                        this.selectedAgTreeNode.add(treeModel.getRowKey());
                        this.selectedAgTreeNode.setContained(true);
                    }
                }
                this.populateAllAGTreeNodesAttributes(treeModel);
            }
            finally {
                treeModel.setRowKey(oldRowKey);
            }
        }
        catch (IntrospectionException e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance(mthd, e.getMessage());
            agLog.error(mthd, lMsgRef, e);
        }
        if (!isDisclose) return this.selectedAgTreeNode;
        return this.disclosedAgTreeNode;
    }

    private void traverseMilestoneNodes(TreeModel treeModel) {
        String method = "traverseMilestoneNodes";
        if (agLog.isTrace()) {
            agLog.trace(method);
        }
        Map milestoneData = null;
        if (!treeModel.isRowAvailable()) {
            return;
        }
        milestoneData = (Map)treeModel.getRowData();
        String status = (String)milestoneData.get("status");
        if (null == status || status.equals("Not Started")) {
            return;
        }
        boolean traversable = false;
        int rowIndex = -1;
        do {
            if (status.equals("Completed") || status.equals("Expired") || status.equals("Completed With Warning")) {
                traversable = true;
            } else {
                List children = (List)milestoneData.get("agList");
                if (children == null || children.isEmpty()) {
                    traversable = true;
                } else {
                    this.disclosedAgTreeNode.setContained(true);
                    treeModel.enterContainer();
                    treeModel.setRowIndex(0);
                    Map rowData = null;
                    if (!treeModel.isRowAvailable()) {
                        return;
                    }
                    rowData = (Map)treeModel.getRowData();
                    String nodeType = (String)rowData.get(IAGUIConstants.NODETYPE_PROPERTY);
                    if ("task".equals(nodeType)) {
                        boolean result = this.traverseTaskNodes(treeModel);
                        if (result) {
                            traversable = true;
                            treeModel.exitContainer();
                        } else {
                            traversable = false;
                        }
                    }
                }
            }
            if (!traversable) continue;
            rowIndex = treeModel.getRowIndex();
            if (treeModel.isRowAvailable(++rowIndex)) {
                milestoneData = (Map)treeModel.getRowData(rowIndex);
                status = (String)milestoneData.get("status");
                if (status == null || status.equals("Not Started")) {
                    traversable = false;
                    continue;
                }
                treeModel.setRowIndex(rowIndex);
                continue;
            }
            traversable = false;
        } while (traversable);
    }

    private boolean traverseTaskNodes(TreeModel treeModel) {
        String method = "traverseTaskNodes";
        if (agLog.isTrace()) {
            agLog.trace(method);
        }
        boolean result = false;
        String nextTaskInstanceId = null;
        int rowIndex = -1;
        boolean traversable = true;
        Map taskData = null;
        if (!treeModel.isRowAvailable()) {
            return result;
        }
        taskData = (Map)treeModel.getRowData();
        String taskInstanceId = (String)taskData.get(IAGUIConstants.INSTANCEID_TASK_PROPERTY);
        String taskStatus = (String)taskData.get("status");
        if (taskStatus == null) {
            return result;
        }
        do {
            if (this.previousTaskId == null && taskStatus.equals("ASSIGNED")) {
                traversable = false;
                break;
            }
            if (this.previousTaskTraversed) {
                if (taskStatus.equals("ASSIGNED")) {
                    traversable = false;
                    break;
                }
                traversable = true;
            } else if (taskInstanceId.equals(this.previousTaskId)) {
                this.previousTaskTraversed = true;
                traversable = true;
            } else {
                traversable = true;
            }
            rowIndex = treeModel.getRowIndex();
            if (treeModel.isRowAvailable(++rowIndex)) {
                taskData = (Map)treeModel.getRowData(rowIndex);
                nextTaskInstanceId = (String)taskData.get(IAGUIConstants.INSTANCEID_TASK_PROPERTY);
                taskStatus = (String)taskData.get("status");
                if (taskStatus == null || taskStatus.equals("Not Started")) {
                    traversable = false;
                    continue;
                }
                treeModel.setRowIndex(rowIndex);
                taskInstanceId = nextTaskInstanceId;
                continue;
            }
            if (taskStatus.equals("ASSIGNED")) {
                Map data;
                String status;
                int index1 = treeModel.getRowIndex();
                treeModel.exitContainer();
                int index2 = treeModel.getRowIndex();
                result = treeModel.isRowAvailable(++index2) ? !"Not Started".equals(status = (String)(data = (Map)treeModel.getRowData(index2)).get("status")) : false;
                treeModel.enterContainer();
                treeModel.setRowIndex(index1);
            } else {
                result = true;
            }
            traversable = false;
        } while (traversable);
        return result;
    }

    public void setMainAreaNodeSwitcher(UIXSwitcher mainAreaNodeSwitcher) {
        this.mainAreaNodeSwitcher = mainAreaNodeSwitcher;
    }

    public UIXSwitcher getMainAreaNodeSwitcher() {
        return this.mainAreaNodeSwitcher;
    }

    private boolean isAllAreDummyTasks(List taskList) {
        for (int i = 0; i < taskList.size(); ++i) {
            HashMap taskMap = (HashMap)taskList.get(i);
            String taskId = (String)taskMap.get(IAGUIConstants.INSTANCEID_TASK_PROPERTY);
            if (taskId == null || taskId.startsWith("AGDM")) continue;
            return false;
        }
        return true;
    }

    public String getTaskState() {
        return _taskState;
    }

    public void refreshAGTreeRegion() {
        if (_agTreeModelList != null) {
            _agTreeModelList.clear();
        }
        this.agDetailsCache.clearAGDetailsCache();
        this.setAgTreeModelList(null);
        this.getAgTreeModelList();
        String agId = null;
        if (this.singleInstance.booleanValue()) {
            agId = this.singleAGInstanceId;
        } else {
            AGInstanceListBean agInstBean = (AGInstanceListBean)AGUtil.evaluateELExpression("#{agInstanceListBean}", AGInstanceListBean.class);
            agId = agInstBean.getAGInstanceID();
        }
        this.refreshAGPercentCompletion(agId);
        AGTasksPopup agTasksPopup = (AGTasksPopup)AGUtil.evaluateELExpression("#{agTasksPopup}", AGTasksPopup.class);
        try {
            agTasksPopup.setAGInstance(this.svcIfc.getAGInstanceById(agId));
            agTasksPopup.refreshCompletedTasks();
        }
        catch (Exception e) {
            ResourceRef lMsgRef = AGUIErrorMsg.ERR_IN_METHOD.instance("refreshAGTreeRegion", e.getMessage());
            agLog.error("refreshAGTreeRegion", lMsgRef, e);
        }
        this.handleTreeRowSelection();
        AGContextualEventRegionalHandler.handleAGRefreshTaskTreeEvent(null);
    }

    public void refreshAGDetailsRegion() {
        if (this.agTreeBinding != null) {
            UIXGroup group = (UIXGroup)this.agTreeBinding.getFacet("nodeStamp");
            List compList = group.getChildren();
            for (UIComponent component : compList) {
                if (!(component instanceof RichCommandLink)) continue;
                FacesContext context = FacesContext.getCurrentInstance();
                Object obj = context.getApplication().evaluateExpressionGet(context, "#{bindings.fireAGDetailsEvent}", OperationBinding.class);
                ((OperationBinding)obj).execute();
                break;
            }
        }
    }

    private void readParams() {
        this.singleAGInstanceId = (String)AGUtil.evaluateELExpression("#{pageFlowScope.AGInstanceID}", String.class);
        String string = this.singleAGInstanceId = this.singleAGInstanceId == null || this.singleAGInstanceId.isEmpty() ? null : this.singleAGInstanceId;
        if (this.singleAGInstanceId == null) {
            this.singleAGInstanceId = this.agProps.getProperty("AGInstanceID");
            this.singleAGInstanceId = this.singleAGInstanceId == null || this.singleAGInstanceId.isEmpty() ? null : this.singleAGInstanceId;
        }
        this.showGaugePercentLabel = (String)AGUtil.evaluateELExpression("#{pageFlowScope.ShowGaugePercentLabel}", String.class);
        if (this.showGaugePercentLabel == null || this.showGaugePercentLabel.isEmpty()) {
            this.showGaugePercentLabel = this.agProps.getProperty("ShowGaugePercentLabel");
            this.showGaugePercentLabel = this.showGaugePercentLabel == null || this.showGaugePercentLabel.isEmpty() ? "false" : this.showGaugePercentLabel;
        }
        this.bShowGaugePercentLabel = this.showGaugePercentLabel.equals("true");
        this.showGaugeTickMarks = (String)AGUtil.evaluateELExpression("#{pageFlowScope.ShowGaugeTickMarks}", String.class);
        if (this.showGaugeTickMarks == null || this.showGaugeTickMarks.isEmpty()) {
            this.showGaugeTickMarks = this.agProps.getProperty("ShowGaugeTickMarks");
            this.showGaugeTickMarks = this.showGaugeTickMarks == null || this.showGaugeTickMarks.isEmpty() ? "false" : this.showGaugeTickMarks;
        }
        this.bShowGaugeTickMarks = this.showGaugeTickMarks.equals("true");
        this.showRefreshButton = (String)AGUtil.evaluateELExpression("#{pageFlowScope.ShowRefreshButton}", String.class);
        if (this.showRefreshButton == null || this.showRefreshButton.isEmpty()) {
            this.showRefreshButton = this.agProps.getProperty("ShowRefreshButton");
            this.showRefreshButton = this.showRefreshButton == null || this.showRefreshButton.isEmpty() ? "false" : this.showRefreshButton;
        }
    }

    private void initializeAGTreeModelList() {
        this.getAgTreeModelList();
        if (_agTreeModelList != null) {
            _aGInstanceID = _agTreeModelList.containsKey(this.singleAGInstanceId) ? this.singleAGInstanceId : null;
            this.singleInstance = this.singleAGInstanceId != null && !this.singleAGInstanceId.isEmpty() && _agTreeModelList.containsKey(this.singleAGInstanceId);
        } else {
            this.singleInstance = false;
        }
        AGAppearanceParams agAppearanceParams = (AGAppearanceParams)AGUtil.evaluateELExpression("#{appearanceParams}", AGAppearanceParams.class);
        if (!this.singleInstance.booleanValue()) {
            agAppearanceParams.setAgInstanceDropDownRendered(true);
        } else {
            agAppearanceParams.setAgFilterDropDownVisible(true);
            agAppearanceParams.setAgTreeRendered(true);
        }
        this.bEmptyTreeModel = _agTreeModelList == null || _agTreeModelList.isEmpty();
    }

    public void setAgDetailsLayout(RichPanelStretchLayout agDetailsLayout) {
        this.agDetailsLayout = agDetailsLayout;
    }

    public RichPanelStretchLayout getAgDetailsLayout() {
        return this.agDetailsLayout;
    }

    public void onFilterValueChanged(ValueChangeEvent valueChangeEvent) {
        if (agLog.isDebug()) {
            agLog.debug("New task filter selected :" + valueChangeEvent.getNewValue().toString());
        }
        this.previousTaskId = null;
        if (_agTreeModelList != null) {
            _agTreeModelList.clear();
        }
        this.agDetailsCache.clearAGDetailsCache();
        this.setAgTreeModelList(null);
        this.getAgTreeModelList();
        this.handleTreeRowSelection();
        AGContextualEventRegionalHandler.handleAGRefreshTaskTreeEvent(null);
        this.refreshAGDetailsRegion();
    }

    public void handleNextActivity(ActionEvent event) {
        if (!this.isCurrentTaskFuture) {
            this.previousTaskId = this.currentTaskId;
        }
        this.refreshAGTreeRegion();
        this.refreshAGDetailsRegion();
    }

    public void setShowRefreshButton(String showRefreshButton) {
        this.showRefreshButton = showRefreshButton;
    }

    public String getShowRefreshButton() {
        return this.showRefreshButton;
    }

    public void setAgTreePanelGroup(RichPanelGroupLayout agTreePanelGroup) {
        this.agTreePanelGroup = agTreePanelGroup;
    }

    public RichPanelGroupLayout getAgTreePanelGroup() {
        return this.agTreePanelGroup;
    }

    protected String verifyImageURL(String imageURL) {
        String result;
        block6: {
            result = null;
            try {
                if (imageURL == null) {
                    return null;
                }
                String firstPart = imageURL.substring(0, imageURL.lastIndexOf(47) + 1);
                String filename = imageURL.substring(imageURL.lastIndexOf(47) + 1, imageURL.length());
                String newImageURL = firstPart + URLEncoder.encode(filename, "UTF-8");
                URL url = new URL(newImageURL);
                if (ImageIO.read(url) != null) {
                    result = newImageURL;
                } else if (agLog.isDebug()) {
                    agLog.debug("Invalid image URL:" + imageURL);
                }
            }
            catch (Exception ex) {
                if (!agLog.isDebug()) break block6;
                agLog.debug("Exception caught while processing image URL:" + imageURL);
            }
        }
        return result;
    }

    private void setTaskBlockedIcon(List taskList) {
        for (int i = 0; i < taskList.size(); ++i) {
            Map taskMap = (Map)taskList.get(i);
            if (taskMap == null) continue;
            String agInstanceId = (String)taskMap.get(IAGUIConstants.INSTANCEID_AG_PROPERTY);
            String milestoneName = (String)taskMap.get(IAGUIConstants.MILESTONE_NAME_TASK_PROPERTY);
            String taskInstanceId = (String)taskMap.get(IAGUIConstants.INSTANCEID_AG_PROPERTY);
            String taskStatus = (String)taskMap.get(IAGUIConstants.INSTANCEID_AG_PROPERTY);
            try {
                String statusIcon;
                String nextTaskId;
                String nextTaskStatus;
                Map nextTaskMap;
                boolean bDisplayBlocked = this.svcIfc.isDisplayBlockedIcon(agInstanceId, milestoneName, taskInstanceId);
                if (!bDisplayBlocked || i + 1 >= taskList.size() || (nextTaskMap = (Map)taskList.get(i + 1)) == null || (nextTaskStatus = this.svcIfc.getTaskStatus(agInstanceId, milestoneName, nextTaskId = (String)nextTaskMap.get(IAGUIConstants.INSTANCEID_AG_PROPERTY))) == null || !nextTaskStatus.equals("ASSIGNED")) continue;
                boolean useCustomIcon = this.svcIfc.getUseCustomBlockedIcon();
                if (useCustomIcon) {
                    statusIcon = this.svcIfc.getTaskBlockedIconLocation(agInstanceId);
                    taskMap.remove(IAGUIConstants.STATUS_ICON_TASK_PROPERTY);
                    taskMap.put(IAGUIConstants.STATUS_ICON_TASK_PROPERTY, statusIcon);
                    if (!agLog.isDebug()) continue;
                    agLog.debug("Using custom blocked icon for task id" + nextTaskId);
                    continue;
                }
                statusIcon = "/ag_images/taskblocked_qualifier.png";
                taskMap.remove(IAGUIConstants.STATUS_ICON_TASK_PROPERTY);
                taskMap.put(IAGUIConstants.STATUS_ICON_TASK_PROPERTY, statusIcon);
                if (!agLog.isDebug()) continue;
                agLog.debug("Using default blocked icon for task id" + nextTaskId);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setPreviousTaskId(String previousTaskId) {
        this.previousTaskId = previousTaskId;
    }

    static {
        _inlineStyleActive = "color:blue";
        _inlineStyleInactive = "color:Gray";
        statusToIconMap = new HashMap();
        treeNodeType = null;
        statusToIconMap.put("ASSIGNED", "/ag_images/taskuntouched_qualifier.png");
        statusToIconMap.put("COMPLETED", "/ag_images/checkmark_status.png");
        statusToIconMap.put("SUSPENDED", "/ag_images/tasksuspended_qualifier.png");
        statusToIconMap.put("WITHDRAWN", "/ag_images/taskwithdrawn_qualifier.png");
        statusToIconMap.put("EXPIRED", "/ag_images/taskexpired_qualifier.png");
        statusToIconMap.put("ERRORED", "/ag_images/taskerrored_qualifier.png");
        statusToIconMap.put("ALERTED", "/ag_images/taskalerted_qualifier.png");
        statusToIconMap.put("STALE", "/ag_images/taskstaled_qualifier.png");
        statusToIconMap.put("DELETED", "/ag_images/tasktrash_qualifier.png");
        statusToIconMap.put("INFO_REQUESTED", "/ag_images/taskrequestinfo_qualifier.png");
    }
}

