/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.faces.component.UIComponent;
import oracle.adf.controller.TaskFlowId;
import oracle.adf.share.ADFContext;
import oracle.adf.share.security.SecurityContext;
import oracle.adf.view.rich.component.rich.input.RichInputText;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.model.AGException;
import oracle.bpel.activityguide.ui.beans.model.AGInstance;
import oracle.bpel.activityguide.ui.beans.model.AGTreeModelBean;
import oracle.bpel.activityguide.ui.beans.model.AGUtil;
import oracle.bpel.activityguide.ui.beans.model.IAGServiceInterface;
import oracle.bpel.activityguide.ui.beans.model.IAGTasksPopup;
import oracle.bpel.activityguide.ui.beans.resources.AGUIErrorMsg;
import oracle.bpel.activityguide.ui.beans.resources.AGUIInfoMsg;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.activityguide.query.IAGQueryService;
import oracle.bpel.services.workflow.activityguide.query.model.AGDisplayInfo;
import oracle.bpel.services.workflow.activityguide.query.model.MilestoneDisplayInfoType;
import oracle.bpel.services.workflow.activityguide.query.model.TaskDisplayInfoType;
import oracle.bpel.services.workflow.activityguide.query.model.TaskDisplayInfoTypeImpl;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.task.model.Task;
import oracle.bpel.services.workflow.verification.IWorkflowContext;
import org.apache.myfaces.trinidad.component.UIXSwitcher;
import org.apache.myfaces.trinidad.context.RequestContext;

public class AGTasksPopup
implements IAGTasksPopup {
    private AGLog agLog = AGLogFactory.getLog(AGTasksPopup.class);
    protected IWorkflowServiceClient wfSvcClient;
    protected String serverConnectionMode;
    AGTreeModelBean agTreeBean;
    private RichInputText completedTasksOutputText;
    private UIXSwitcher tasksSummraySwitch;
    private String agTasksPopupTaskFlowID = null;
    private Boolean showCompletedTasks = true;
    private String facetName = "outputText";
    protected String serverAuthenticationMethod;
    protected String realm;
    protected String selectionFilter;
    protected String loginUserId;
    protected String loginUserPassword;
    protected int clientType;
    protected String queryMode;
    AGInstance m_AgInstance = null;

    public AGTasksPopup() {
        this.serverConnectionMode = AGUtil.getAgProps().getProperty("ServerConnectionMode");
        this.agTreeBean = (AGTreeModelBean)AGUtil.evaluateELExpression("#{agTreeModelBean}", AGTreeModelBean.class);
        this.agTasksPopupTaskFlowID = AGUtil.getAgProps().getProperty("AGTasksPopupTaskflowID");
        if (this.agTasksPopupTaskFlowID != null) {
            this.facetName = "region";
            this.showCompletedTasks = false;
        }
        this.selectionFilter = AGUtil.getAgProps().getProperty("SelectionFilter");
        this.serverAuthenticationMethod = AGUtil.getAgProps().getProperty("ServerAuthenticationMethod");
        this.realm = AGUtil.agProps.getProperty("Realm");
        this.queryMode = AGUtil.agProps.getProperty("AG_QUERY_MODE");
        SecurityContext securityCtx = ADFContext.getCurrent().getSecurityContext();
        this.loginUserId = securityCtx.getUserName();
    }

    public AGTasksPopup(int clientType) {
        String method = "AGTasksPopup";
        this.clientType = clientType;
        switch (this.clientType) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                this.agLog.error(method, AGUIErrorMsg.ERR_POPUP_TASK_TYPE_INVALID.instance(clientType));
            }
        }
    }

    @Override
    public List<Task> getTasks(String AGInstanceID2, int taskType) throws WorkflowException, AGException {
        String method = "getTasks";
        if (this.agLog.isTrace()) {
            this.agLog.trace(method);
        }
        ArrayList<Task> tasks = null;
        ArrayList<Boolean> taskOptionalAttributeValues = null;
        if (AGInstanceID2 == null) {
            if (this.agLog.isWarn()) {
                this.agLog.warn(method, AGUIErrorMsg.WARN_AG_NO_INSTANCES.instance(method));
            }
            throw new AGException(38012);
        }
        IWorkflowContext workflowContext = this.getWorkflowContext();
        IAGQueryService agQuerySvc = this.wfSvcClient.getAGQueryService();
        List<String> taskDisplayColumnsList = Arrays.asList(IAGServiceInterface.TASK_DISPLAY_COLUMNS);
        AGDisplayInfo agDisplayInfo = agQuerySvc.getAGDisplayInfoDetailsById(this.queryMode, workflowContext, Long.parseLong(AGInstanceID2), taskDisplayColumnsList, this.selectionFilter);
        tasks = new ArrayList<Task>();
        List msDisplayInfo = agDisplayInfo.getMilestoneDisplayInfo();
        for (Object msObj : msDisplayInfo) {
            int i;
            MilestoneDisplayInfoType ms = (MilestoneDisplayInfoType)msObj;
            ArrayList<Task> taskList = null;
            String mode = agDisplayInfo.getProcessMode();
            if (mode.equalsIgnoreCase("AGBPM")) {
                taskOptionalAttributeValues = new ArrayList<Boolean>();
                List taskDispInfoList = ms.getTaskDisplayInfo();
                taskList = new ArrayList<Task>();
                if (taskDispInfoList != null) {
                    for (i = 0; i < taskDispInfoList.size(); ++i) {
                        TaskDisplayInfoTypeImpl td = (TaskDisplayInfoTypeImpl)taskDispInfoList.get(i);
                        if (td == null) continue;
                        Task newTask = AGUtil.createTask((TaskDisplayInfoType)td);
                        taskOptionalAttributeValues.add(td.isOptional());
                        taskList.add(newTask);
                    }
                }
            } else {
                taskOptionalAttributeValues = null;
                taskList = ms.getTask();
            }
            block10: for (i = 0; i < taskList.size(); ++i) {
                Object taskObj = taskList.get(i);
                Task task = (Task)taskObj;
                String taskState = task.getSystemAttributes().getState();
                switch (taskType) {
                    case 0: {
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_TOTAL_TASKS.instance(AGInstanceID2));
                        }
                        this.addToTasks(tasks, task);
                        continue block10;
                    }
                    case 1: {
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_COMPLETED_TASKS.instance(AGInstanceID2));
                        }
                        if (taskState == null || !taskState.equals("COMPLETED")) continue block10;
                        this.addToTasks(tasks, task);
                        continue block10;
                    }
                    case 2: {
                        String taskId;
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_COMPLETED_TASKS.instance(AGInstanceID2));
                        }
                        if (!(taskId = task.getSystemAttributes().getTaskId()).startsWith("AGDM")) continue block10;
                        this.addToTasks(tasks, task);
                        continue block10;
                    }
                    case 3: {
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_ERRORED_TASKS.instance(AGInstanceID2));
                        }
                        if (taskState == null || !taskState.equals("ERRORED")) continue block10;
                        this.addToTasks(tasks, task);
                        continue block10;
                    }
                    case 4: {
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_REQUIRED_TASKS.instance(AGInstanceID2));
                        }
                        if (!this.isTaskRequired(task, mode, taskOptionalAttributeValues == null ? null : (Boolean)taskOptionalAttributeValues.get(i))) continue block10;
                        this.addToTasks(tasks, task);
                        continue block10;
                    }
                    case 5: {
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_OPTIONAL_TASKS.instance(AGInstanceID2));
                        }
                        if (!this.isTaskOptional(task, mode, taskOptionalAttributeValues == null ? null : (Boolean)taskOptionalAttributeValues.get(i))) continue block10;
                        this.addToTasks(tasks, task);
                        continue block10;
                    }
                    default: {
                        if (this.agLog.isError()) {
                            this.agLog.error(method, AGUIErrorMsg.ERR_POPUP_TASK_TYPE_INVALID.instance(taskType));
                        }
                        throw new AGException(38017);
                    }
                }
            }
        }
        return tasks;
    }

    protected List<Task> addToTasks(List<Task> tasks, Task task) {
        String taskTitle = task.getTitle();
        if (taskTitle != null && !taskTitle.startsWith("switch")) {
            tasks.add(task);
        }
        return tasks;
    }

    protected boolean isTaskRequired(Task task, String mode, Boolean taskOptionalAttribute) {
        String taskId = task.getSystemAttributes().getTaskId();
        if (taskId != null && taskId.startsWith("AGDM")) {
            return false;
        }
        if ("AGBPM".equals(mode)) {
            return taskOptionalAttribute == false;
        }
        String required = task.getSystemMessageAttributes().getTextAttribute1();
        return required != null ? required.equalsIgnoreCase("YES") : false;
    }

    protected boolean isTaskOptional(Task task, String mode, Boolean taskOptionalAttribute) {
        return !this.isTaskRequired(task, mode, taskOptionalAttribute);
    }

    public int getCompletedTasks() throws WorkflowException, AGException {
        String method = "getCompletedTasks";
        String agInstanceId = this.agTreeBean.getAGInstanceID();
        if (this.agLog.isInfo()) {
            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_COMPUTE_COMPLETED_TASKS.instance(agInstanceId));
        }
        if (agInstanceId == null) {
            return 0;
        }
        this.m_AgInstance = this.agTreeBean.getAGInstance();
        List tasks = this.getTasksByType(1);
        if (tasks != null) {
            return tasks.size();
        }
        return 0;
    }

    public int getTotalTasks() throws WorkflowException, AGException {
        String method = "getTotalTasks";
        String agInstanceId = this.agTreeBean.getAGInstanceID();
        if (this.agLog.isInfo()) {
            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_COMPUTE_TOTAL_TASKS.instance(agInstanceId));
        }
        if (agInstanceId == null) {
            return 0;
        }
        this.m_AgInstance = this.agTreeBean.getAGInstance();
        List tasks = this.getTasksByType(0);
        if (tasks != null) {
            return tasks.size();
        }
        return 0;
    }

    protected IWorkflowContext getWorkflowContext() throws WorkflowException, AGException {
        String method = "getWorkflowContext";
        this.wfSvcClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)this.serverConnectionMode);
        ITaskQueryService taskQueryService = this.wfSvcClient.getTaskQueryService();
        IWorkflowContext wfCtx = null;
        if (this.serverAuthenticationMethod.equals("IDENTITY_PROPAGATION")) {
            wfCtx = this.clientType == 1 ? taskQueryService.authenticate(this.loginUserId, this.loginUserPassword.toCharArray(), this.realm) : taskQueryService.authenticate(null, null, this.realm);
        } else {
            if (this.agLog.isError()) {
                this.agLog.error(method, AGUIErrorMsg.ERR_AG_SERVER_AUTHMODE_INVALID.instance(method));
            }
            throw new AGException(38010);
        }
        return wfCtx;
    }

    public void setCompletedTasksOutputText(RichInputText completedTasksOutputText) {
        this.completedTasksOutputText = completedTasksOutputText;
    }

    public RichInputText getCompletedTasksOutputText() {
        return this.completedTasksOutputText;
    }

    public void refreshCompletedTasks() {
        if (this.showCompletedTasks.booleanValue()) {
            RequestContext reqContext = RequestContext.getCurrentInstance();
            reqContext.addPartialTarget((UIComponent)this.completedTasksOutputText);
        }
    }

    public void setTasksSummraySwitch(UIXSwitcher tasksSummraySwitch) {
        this.tasksSummraySwitch = tasksSummraySwitch;
    }

    public UIXSwitcher getTasksSummraySwitch() {
        return this.tasksSummraySwitch;
    }

    public Boolean getShowCompletedTasks() {
        return this.showCompletedTasks;
    }

    @Override
    public void setServerParams(String queryMode, String serverConnectionMode, String serverAuthenticationMethod, String realm, String selectionFilter, String loginUserId, String loginUserPassword) {
        if (this.clientType == 1) {
            this.queryMode = queryMode;
            this.serverConnectionMode = serverConnectionMode;
            this.serverAuthenticationMethod = serverAuthenticationMethod;
            this.realm = realm;
            this.selectionFilter = selectionFilter;
            this.loginUserId = loginUserId;
            this.loginUserPassword = loginUserPassword;
        }
    }

    public String getFacetName() {
        return this.facetName;
    }

    public TaskFlowId getDynamicTaskFlowId() {
        if (this.agTasksPopupTaskFlowID == null) {
            return TaskFlowId.parse((String)"/WEB-INF/oracle/bpel/activityguide/ui/taskflows/ag-dummy-popup-task-flow.xml#ag-dummy-popup-task-flow");
        }
        return TaskFlowId.parse((String)this.agTasksPopupTaskFlowID);
    }

    public List getTasksByType(int taskType) throws WorkflowException, AGException {
        String method = "getTotalTasksByType";
        ArrayList<Task> tasks = new ArrayList<Task>();
        tasks = new ArrayList();
        ArrayList<Boolean> taskOptionalAttributeValues = null;
        if (this.m_AgInstance == null) {
            return null;
        }
        AGDisplayInfo agDisplayInfo = this.m_AgInstance.getAGDisplayInfo();
        if (agDisplayInfo == null) {
            return null;
        }
        List msDisplayInfo = agDisplayInfo.getMilestoneDisplayInfo();
        for (Object msObj : msDisplayInfo) {
            int i;
            MilestoneDisplayInfoType ms = (MilestoneDisplayInfoType)msObj;
            ArrayList<Task> taskList = null;
            String mode = agDisplayInfo.getProcessMode();
            if (mode.equalsIgnoreCase("AGBPM")) {
                taskOptionalAttributeValues = new ArrayList<Boolean>();
                List taskDispInfoList = ms.getTaskDisplayInfo();
                taskList = new ArrayList<Task>();
                if (taskDispInfoList != null) {
                    for (i = 0; i < taskDispInfoList.size(); ++i) {
                        TaskDisplayInfoTypeImpl td = (TaskDisplayInfoTypeImpl)taskDispInfoList.get(i);
                        if (td == null) continue;
                        Task newTask = AGUtil.createTask((TaskDisplayInfoType)td);
                        taskList.add(newTask);
                        taskOptionalAttributeValues.add(td.isOptional());
                    }
                }
            } else {
                taskList = ms.getTask();
            }
            block10: for (i = 0; i < taskList.size(); ++i) {
                Object taskObj = taskList.get(i);
                Task task = (Task)taskObj;
                String taskState = task.getSystemAttributes().getState();
                switch (taskType) {
                    case 0: {
                        String taskTitle;
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_TOTAL_TASKS.instance(agDisplayInfo.getInstanceId()));
                        }
                        if ((taskTitle = task.getTitle()) == null || taskTitle.startsWith("switch")) continue block10;
                        tasks.add(task);
                        continue block10;
                    }
                    case 1: {
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_COMPLETED_TASKS.instance(agDisplayInfo.getInstanceId()));
                        }
                        if (taskState == null || !taskState.equals("COMPLETED")) continue block10;
                        tasks.add(task);
                        continue block10;
                    }
                    case 2: {
                        String taskId;
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_NOT_STARTED_TASKS.instance(agDisplayInfo.getInstanceId()));
                        }
                        if (!(taskId = task.getSystemAttributes().getTaskId()).startsWith("AGDM")) continue block10;
                        tasks.add(task);
                        continue block10;
                    }
                    case 3: {
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_ERRORED_TASKS.instance(agDisplayInfo.getInstanceId()));
                        }
                        if (taskState == null || !taskState.equals("ERRORED")) continue block10;
                        tasks.add(task);
                        continue block10;
                    }
                    case 4: {
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_REQUIRED_TASKS.instance(agDisplayInfo.getInstanceId()));
                        }
                        if (!this.isTaskRequired(task, mode, (Boolean)taskOptionalAttributeValues.get(i))) continue block10;
                        tasks.add(task);
                        continue block10;
                    }
                    case 5: {
                        if (this.agLog.isInfo()) {
                            this.agLog.info(method, AGUIInfoMsg.MSG_TASK_POPUP_OPTIONAL_TASKS.instance(agDisplayInfo.getInstanceId()));
                        }
                        if (!this.isTaskOptional(task, mode, (Boolean)taskOptionalAttributeValues.get(i))) continue block10;
                        tasks.add(task);
                        continue block10;
                    }
                    default: {
                        if (this.agLog.isError()) {
                            this.agLog.error(method, AGUIErrorMsg.ERR_POPUP_TASK_TYPE_INVALID.instance(taskType));
                        }
                        throw new AGException(38017);
                    }
                }
            }
        }
        return tasks;
    }

    public AGInstance getAGInstance() {
        return this.m_AgInstance;
    }

    public void setAGInstance(AGInstance agInstance) {
        this.m_AgInstance = agInstance;
    }
}

