/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.FacesContext;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.model.AGException;
import oracle.bpel.activityguide.ui.beans.model.AGInstance;
import oracle.bpel.activityguide.ui.beans.model.AGUtil;
import oracle.bpel.activityguide.ui.beans.model.IAGServiceInterface;
import oracle.bpel.activityguide.ui.beans.resources.AGUIErrorMsg;
import oracle.bpel.activityguide.ui.beans.resources.AGUIInfoMsg;
import oracle.bpel.activityguide.ui.i18n.I18NUtil;
import oracle.bpel.services.workflow.WorkflowException;
import oracle.bpel.services.workflow.activityguide.query.IAGQueryService;
import oracle.bpel.services.workflow.activityguide.query.model.AGDisplayInfo;
import oracle.bpel.services.workflow.client.IWorkflowServiceClient;
import oracle.bpel.services.workflow.client.WorkflowServiceClientFactory;
import oracle.bpel.services.workflow.query.ITaskQueryService;
import oracle.bpel.services.workflow.repos.Ordering;
import oracle.bpel.services.workflow.repos.Predicate;
import oracle.bpel.services.workflow.verification.IWorkflowContext;

public class AGServiceInterfaceImpl
implements IAGServiceInterface {
    private static AGLog agLog = AGLogFactory.getLog(AGServiceInterfaceImpl.class);
    private static final List agDisplayColumnList = Arrays.asList(AG_DISPLAY_COLUMNS);
    private static final List taskDisplayColumnList = Arrays.asList(TASK_DISPLAY_COLUMNS);
    private List childMSList = null;
    private IWorkflowContext wfCtx = null;
    private IWorkflowServiceClient wfSvcClient = null;
    private String authentionMode = null;
    private String loginUserId = null;
    private String connectionMode = null;
    private String authMethod = null;
    private String refreshScript = null;
    private String refreshMethod = null;
    private String worklistURL = null;
    private String realm = null;
    private boolean hasSwitchConnectionMode = true;
    private boolean hasSwitchAuthMethod = true;
    private boolean isSingleInstance = false;
    private Locale locale = null;
    private ITaskQueryService taskQuerySvc = null;
    private IAGQueryService agQuerySvc = null;
    private String selectionFilter = null;
    private String queryMode = "AGBPM";
    private boolean useCustomTaskBlockedImage = false;
    private Map<String, AGInstance> agInstanceMap = new HashMap<String, AGInstance>();

    public AGServiceInterfaceImpl() {
        this.locale = FacesContext.getCurrentInstance().getViewRoot().getLocale();
    }

    @Override
    public void setConnectionMode(String connectMode) {
        if (this.connectionMode == null || !this.connectionMode.equals(connectMode)) {
            this.connectionMode = connectMode;
            this.hasSwitchConnectionMode = true;
        } else {
            this.hasSwitchConnectionMode = false;
        }
    }

    @Override
    public void setAuthenticationMethod(String authMethod) {
        if (this.authMethod == null || !this.authMethod.equals(authMethod)) {
            this.authMethod = authMethod;
            this.hasSwitchAuthMethod = true;
        } else {
            this.hasSwitchAuthMethod = false;
        }
    }

    @Override
    public void setLoginUserId(String userId) {
        if (this.loginUserId == null || !this.loginUserId.equals(userId)) {
            this.loginUserId = userId;
        }
    }

    @Override
    public void setJSRefreshCallback(String script, String method) {
        this.refreshScript = script;
        this.refreshMethod = method;
    }

    @Override
    public void setWorklistURL(String url) {
        this.worklistURL = url;
    }

    @Override
    public void setRealm(String secRealm) {
        this.realm = secRealm;
    }

    String getWorklistURL() {
        return this.worklistURL;
    }

    @Override
    public String getQueryMode() {
        return this.queryMode;
    }

    @Override
    public void setQueryMode(String queryMode) {
        if (queryMode != null && !queryMode.equalsIgnoreCase("AGBPM")) {
            this.queryMode = queryMode;
            AGUtil.setQueryMode(queryMode);
        }
    }

    @Override
    public boolean getUseCustomBlockedIcon() {
        return this.useCustomTaskBlockedImage;
    }

    @Override
    public void setUseCustomBlockedIcon(String useCustomIcon) {
        this.useCustomTaskBlockedImage = useCustomIcon != null && useCustomIcon.equalsIgnoreCase("TRUE");
    }

    @Override
    public List<String> getAGInstances(Map<String, String> queryPropMap) throws Exception {
        this.selectionFilter = queryPropMap.get("SelectionFilter");
        String qryDefinitionFilter = queryPropMap.get("AGDefinitionFilter");
        String qryInstanceId = queryPropMap.get("AGInstanceID");
        String qryPredicate1 = queryPropMap.get("CustomPredicate1");
        String qryPredicate2 = queryPropMap.get("CustomPredicate2");
        String qryOrder = queryPropMap.get("AGInstanceOrdering");
        String mthd = "getAGInstances";
        if (!this.authMethod.equals("IDENTITY_PROPAGATION")) {
            if (agLog.isError()) {
                agLog.error(mthd, AGUIErrorMsg.ERR_AG_SERVER_AUTHMODE_INVALID.instance(mthd));
            }
            throw new AGException(38010);
        }
        this.wfCtx = null;
        if (this.connectionMode == null) {
            this.connectionMode = "REMOTE";
        } else if (!this.connectionMode.equals("REMOTE") && !this.connectionMode.equals("SOAP")) {
            if (agLog.isError()) {
                agLog.error(mthd, AGUIErrorMsg.ERR_AG_SERVER_CONNECTION_INVALID.instance(mthd));
            }
            throw new AGException(38011);
        }
        if (this.wfSvcClient == null) {
            this.setSvcClient();
        }
        this.setClientContext();
        this.wfCtx.setLocale(this.locale);
        I18NUtil.setGsLocale(this.locale);
        AGUtil.setTimezone(this.wfCtx.getTimeZone());
        if (this.selectionFilter != null) {
            this.selectionFilter = this.selectionFilter.trim();
        }
        if (qryDefinitionFilter != null) {
            qryDefinitionFilter = qryDefinitionFilter.trim();
        }
        if (qryInstanceId != null) {
            qryInstanceId = qryInstanceId.trim();
        }
        if (qryPredicate1 != null) {
            qryPredicate1 = qryPredicate1.trim();
        }
        if (qryPredicate2 != null) {
            qryPredicate2 = qryPredicate2.trim();
        }
        if (qryOrder != null) {
            qryOrder = qryOrder.trim();
        }
        Predicate combinedPredicate = null;
        Ordering order = null;
        this.resetInstanceCache();
        if (qryInstanceId != null) {
            if (agLog.isInfo()) {
                agLog.info(mthd, AGUIInfoMsg.MSG_PREDS_IGNORED.instance(mthd));
            }
            this.isSingleInstance = true;
        } else {
            if (this.selectionFilter == null) {
                if (agLog.isError()) {
                    agLog.error(mthd, AGUIErrorMsg.ERR_AG_SELECTION_FILTER_MISSING.instance(mthd));
                }
                throw new AGException(38008);
            }
            Predicate defnPredicate = null;
            Predicate qryPredicate = null;
            if (qryDefinitionFilter != null) {
                defnPredicate = AGUtil.processDefinitionFilter(qryDefinitionFilter);
            }
            if (qryPredicate1 != null || qryPredicate2 != null) {
                qryPredicate = AGUtil.processPredicateProp(qryPredicate1, qryPredicate2);
            }
            combinedPredicate = defnPredicate != null && qryPredicate != null ? new Predicate(defnPredicate, 7, qryPredicate) : (defnPredicate != null ? defnPredicate : qryPredicate);
            if (qryOrder != null) {
                order = AGUtil.processOrderingProp(qryOrder);
            }
        }
        System.out.println("************************************************************");
        System.out.println("Selection Filter:" + this.selectionFilter);
        System.out.println("Predicate:");
        if (combinedPredicate != null) {
            System.out.println(combinedPredicate.toString());
        }
        System.out.println("Ordering:");
        if (order != null) {
            System.out.println(order.toString());
        }
        System.out.println("************************************************************");
        if (agLog.isDebug()) {
            agLog.debug("Selection filter:" + this.selectionFilter);
            agLog.debug("Predicate:" + combinedPredicate != null ? combinedPredicate.toString() : null);
            agLog.debug("Ordering:" + order != null ? order.toString() : null);
            agLog.debug("Server connection mode:" + this.connectionMode);
            agLog.debug("Query mode:" + this.queryMode);
        }
        if (this.agQuerySvc == null) {
            this.agQuerySvc = this.wfSvcClient.getAGQueryService();
        }
        if (this.isSingleInstance) {
            AGDisplayInfo agDisplayInfo = null;
            agDisplayInfo = this.queryMode.equals("AGBPM") ? this.agQuerySvc.getAGDisplayInfoDetailsById(this.wfCtx, Long.parseLong(qryInstanceId), taskDisplayColumnList, this.selectionFilter) : this.agQuerySvc.getAGDisplayInfoDetailsById(this.queryMode, this.wfCtx, Long.parseLong(qryInstanceId), taskDisplayColumnList, this.selectionFilter);
            if (agLog.isDebug()) {
                agLog.debug("Cache AG Instance: " + qryInstanceId);
            }
            if (agDisplayInfo == null) {
                if (agLog.isWarn()) {
                    agLog.warn(mthd, AGUIErrorMsg.WARN_AG_NO_INSTANCES.instance(mthd));
                }
                throw new AGException(38012);
            }
            this.agInstanceMap.put(qryInstanceId, new AGInstance(agDisplayInfo, this));
            ArrayList<String> sglInstList = new ArrayList<String>();
            if (agDisplayInfo.getProcessMode().equalsIgnoreCase("AGBPM")) {
                sglInstList.add((String)((Object)new AGInstanceDetails(agDisplayInfo.getInstanceId(), agDisplayInfo.getTitle(), agDisplayInfo.getName(), I18NUtil.getI18NiizedAGStatus(agDisplayInfo.getStatus()))));
            } else {
                sglInstList.add((String)((Object)new AGInstanceDetails(Long.toString(agDisplayInfo.getAGInstanceInfo().getCiKey()), agDisplayInfo.getTitle(), agDisplayInfo.getAGInstanceInfo().getIdentificationKey(), I18NUtil.getI18NiizedAGStatus(agDisplayInfo.getAGInstanceInfo().getStatus()))));
            }
            return sglInstList;
        }
        List agDisplayInfoList = null;
        agDisplayInfoList = this.queryMode.equals("AGBPM") ? this.agQuerySvc.queryAGDisplayInfos(this.wfCtx, agDisplayColumnList, IAGQueryService.AGAssignmentFilter.valueOf((String)this.selectionFilter), combinedPredicate, order, 0, 0) : this.agQuerySvc.queryAGDisplayInfos(this.queryMode, this.wfCtx, agDisplayColumnList, IAGQueryService.AGAssignmentFilter.valueOf((String)this.selectionFilter), combinedPredicate, order, 0, 0);
        Iterator agListIter = agDisplayInfoList.iterator();
        ArrayList<String> instList = new ArrayList<String>();
        while (agListIter.hasNext()) {
            AGDisplayInfo agDisplayInfo = (AGDisplayInfo)agListIter.next();
            if (agDisplayInfo.getProcessMode().equalsIgnoreCase("AGBPEL")) {
                instList.add((String)((Object)new AGInstanceDetails(Long.toString(agDisplayInfo.getAGInstanceInfo().getCiKey()), agDisplayInfo.getTitle(), agDisplayInfo.getAGInstanceInfo().getIdentificationKey(), I18NUtil.getI18NiizedAGStatus(agDisplayInfo.getAGInstanceInfo().getStatus()))));
            } else {
                instList.add((String)((Object)new AGInstanceDetails(agDisplayInfo.getInstanceId(), agDisplayInfo.getTitle(), agDisplayInfo.getName(), I18NUtil.getI18NiizedAGStatus(agDisplayInfo.getStatus()))));
            }
            if (!agLog.isInfo()) continue;
            agLog.info(mthd, AGUIInfoMsg.MSG_AG_INSTANCE.instance(Long.toString(agDisplayInfo.getAGInstanceInfo().getCiKey())));
        }
        return instList;
    }

    @Override
    public AGInstance getAGInstanceById(String agInstanceId) throws AGException, WorkflowException {
        String mthd = "getAGInstanceById";
        AGInstance cachedInstance = null;
        cachedInstance = this.agInstanceMap.get(agInstanceId);
        if (cachedInstance != null) {
            return cachedInstance;
        }
        if (this.agQuerySvc == null) {
            this.agQuerySvc = this.wfSvcClient.getAGQueryService();
        }
        AGDisplayInfo agDisplayInfo = null;
        agDisplayInfo = this.queryMode.equalsIgnoreCase("AGBPM") ? this.agQuerySvc.getAGDisplayInfoDetailsById(this.wfCtx, Long.parseLong(agInstanceId), taskDisplayColumnList, this.selectionFilter) : this.agQuerySvc.getAGDisplayInfoDetailsById(this.queryMode, this.wfCtx, Long.parseLong(agInstanceId), taskDisplayColumnList, this.selectionFilter);
        if (agDisplayInfo == null) {
            if (agLog.isWarn()) {
                agLog.warn(mthd, AGUIErrorMsg.WARN_AG_NO_INSTANCES.instance(mthd));
            }
            throw new AGException(38012);
        }
        if (agLog.isDebug()) {
            agLog.debug("Cache AG Instance: " + agInstanceId);
        }
        this.agInstanceMap.put(agInstanceId, new AGInstance(agDisplayInfo, this));
        return this.agInstanceMap.get(agInstanceId);
    }

    @Override
    public String getAGDisplayTitle(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getDisplayTitle();
    }

    @Override
    public String getAGName(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getName();
    }

    @Override
    public String getAGDescription(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getDescription();
    }

    @Override
    public Calendar getAGCreated(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getCreated();
    }

    @Override
    public String getAGStatus(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getStatus();
    }

    @Override
    public int getAGPercentCompletion(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getPercentCompletion();
    }

    @Override
    public String getAGErrorMessage(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getErrorMessage();
    }

    @Override
    public String getTaskBlockedIconLocation(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getTaskBlockedIconLocation();
    }

    @Override
    public String getAGIconLocation(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getIconLocation();
    }

    @Override
    public List<String> getAGMilestones(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getChildMilestoneNames();
    }

    @Override
    public String getMSDisplayTitle(String agInstanceId, String milestoneName) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getDisplayTitle();
    }

    @Override
    public String getMSIconLocation(String agInstanceId, String milestoneName) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getIconLocation();
    }

    @Override
    public String getMSDescription(String agInstanceId, String milestoneName) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getDescription();
    }

    @Override
    public String getMSStatus(String agInstanceId, String milestoneName) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getStatus();
    }

    @Override
    public String getMSErrorMessage(String agInstanceId, String milestoneName) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getErrorMessage();
    }

    @Override
    public boolean isFutureMilestone(String agInstanceId, String milestoneName) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).isFutureMilestone();
    }

    @Override
    public boolean isMilestoneBranch(String agInstanceId, String milestoneName) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).isMilestoneBranch();
    }

    @Override
    public List<String> getMSChildren(String agInstanceId, String milestoneName) throws AGException, WorkflowException {
        Iterator<String> iter = this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getChildTasks().iterator();
        this.childMSList = new ArrayList();
        while (iter.hasNext()) {
            String taskId = "Task:" + iter.next();
            this.childMSList.add(taskId);
        }
        iter = this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getChildMilestones().iterator();
        while (iter.hasNext()) {
            String msName = "Milestone:" + iter.next();
            this.childMSList.add(msName);
        }
        return this.childMSList;
    }

    @Override
    public String getTaskTitle(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).getTitle();
    }

    @Override
    public String getTaskStatus(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).getTaskState();
    }

    @Override
    public String getTaskURL(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).getTaskURL();
    }

    @Override
    public Calendar getTaskDueDate(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).getDueDate();
    }

    public List getTaskErrors(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).getErrors();
    }

    @Override
    public String getGlobalTaskAccessMode(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getGlobalTaskAccessMode();
    }

    @Override
    public boolean isDisplayBlockedIcon(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).isDisplayBlockedIcon();
    }

    public String getBlockedExplanation(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).getBlockedExplanation();
    }

    public boolean isLastMilestoneTask(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).isLastMilestoneTask();
    }

    @Override
    public String getProcessMode(String agInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getProcessMode();
    }

    @Override
    public boolean isTaskRequired(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).isTaskRequired();
    }

    @Override
    public boolean isSwitchTask(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).isSwitchTask();
    }

    @Override
    public boolean isFutureTask(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).isFutureTask();
    }

    @Override
    public String getTaskBlockedIconDescription(String agInstanceId, String milestoneName, String taskInstanceId) throws AGException, WorkflowException {
        return this.getAGInstanceById(agInstanceId).getMilestoneByName(milestoneName).getTaskInstanceById(taskInstanceId).getBlockedExplanation();
    }

    IWorkflowServiceClient getWfSvcClient() throws Exception {
        if (this.wfSvcClient != null) {
            return this.wfSvcClient;
        }
        throw new Exception();
    }

    IWorkflowContext getWfCtx() throws AGException {
        String mthd = "getWFCtx";
        if (this.wfSvcClient != null) {
            return this.wfCtx;
        }
        if (agLog.isError()) {
            agLog.error(mthd, AGUIErrorMsg.ERR_AG_WORKFLOW_CTX_NULL.instance(mthd));
        }
        throw new AGException(38014);
    }

    @Override
    public void resetInstanceCache() {
        this.release();
        this.childMSList = null;
        this.isSingleInstance = false;
        if (this.hasSwitchConnectionMode) {
            this.wfSvcClient = null;
            this.wfCtx = null;
        }
        if (this.hasSwitchAuthMethod) {
            this.wfCtx = null;
        }
    }

    void release() {
        Collection<AGInstance> c = this.agInstanceMap.values();
        Iterator<AGInstance> i = c.iterator();
        while (i.hasNext()) {
            AGInstance agInstance = i.next();
            agInstance.release();
            i.remove();
        }
    }

    private void setSvcClient() {
        this.wfSvcClient = WorkflowServiceClientFactory.getWorkflowServiceClient((String)this.connectionMode);
    }

    private void setClientContext() throws AGException, WorkflowException {
        String mthd = "setClientContext";
        if (this.wfCtx == null) {
            if (this.realm == null) {
                this.realm = "jazn.com";
                if (agLog.isDebug()) {
                    agLog.debug("Realm is not configured.  Defaulting it to jazn.com");
                }
            }
            if (this.taskQuerySvc == null) {
                this.taskQuerySvc = this.wfSvcClient.getTaskQueryService();
            }
            if (this.authMethod.equals("IDENTITY_PROPAGATION")) {
                this.wfCtx = this.taskQuerySvc.authenticate(null, null, this.realm);
            } else {
                if (agLog.isError()) {
                    agLog.error(mthd, AGUIErrorMsg.ERR_AG_SERVER_AUTHMODE_INVALID.instance(mthd));
                }
                throw new AGException(38010);
            }
        }
    }

    public static class AGInstanceDetails {
        String CiKey;
        String Title;
        String Idkey;
        String Status;

        public AGInstanceDetails(String CiKey, String Title, String IdKey, String Status) {
            this.CiKey = CiKey;
            this.Title = Title;
            this.Idkey = IdKey;
            this.Status = Status;
        }

        public String toString() {
            return this.CiKey + " " + this.Title + " " + this.Idkey + " " + this.Status;
        }

        public String getCiKey() {
            return this.CiKey;
        }

        public String getTitle() {
            return this.Title;
        }

        public String getIdkey() {
            return this.Idkey;
        }

        public String getStatus() {
            return this.Status;
        }
    }
}

