/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.model.AGPasswordEncrypt;
import oracle.bpel.activityguide.ui.beans.resources.AGUIErrorMsg;
import oracle.bpel.activityguide.ui.beans.resources.AGUIInfoMsg;

public class AGProperties {
    private static AGLog agLog = AGLogFactory.getLog(AGProperties.class);
    protected static final String AG_SYSTEM_PROPERTY = "agui.property.file";
    private String absAgPropsFileName = null;
    private Properties agProps = null;

    public void load() {
        block5: {
            String mthd = "load";
            if (this.agProps == null) {
                try {
                    FileInputStream input = new FileInputStream(this.absAgPropsFileName);
                    this.agProps = new Properties();
                    this.agProps.load(input);
                    input.close();
                }
                catch (FileNotFoundException e) {
                    if (agLog.isError()) {
                        agLog.error(mthd, AGUIErrorMsg.ERR_PROP_FILE_NOT_FOUND.instance(this.absAgPropsFileName, e.getMessage()));
                    }
                }
                catch (IOException e) {
                    if (!agLog.isError()) break block5;
                    agLog.error(mthd, AGUIErrorMsg.ERR_PROP_FILE_IO.instance(this.absAgPropsFileName, e.getMessage()));
                }
            }
        }
    }

    public void reLoad() {
        this.agProps = null;
        this.load();
    }

    public String getProperty(String key) {
        String propValue;
        String method = "getProperty";
        if (this.agProps == null) {
            this.load();
        }
        try {
            propValue = this.agProps.getProperty(key);
        }
        catch (Exception e) {
            if (agLog.isWarn()) {
                agLog.warn(method, AGUIErrorMsg.WARN_AG_PROPS_NULL.instance(key, e.getMessage()));
            }
            return null;
        }
        if (propValue != null && propValue.isEmpty()) {
            return null;
        }
        return propValue;
    }

    public String getWorkflowAdminDecryptedPassword() {
        String value = this.getProperty("WorkflowAdminPasswordEncrypted");
        if (value == null) {
            return null;
        }
        AGPasswordEncrypt e = new AGPasswordEncrypt();
        String password = e.decrpyt(value);
        return password;
    }

    public void setAbsAgPropsFileName(String absAgPropsFileName) {
        String method = "setAbsAgPropsFileName";
        if (agLog.isInfo()) {
            agLog.info(method, AGUIInfoMsg.MSG_AG_PROPS_FILE.instance(absAgPropsFileName));
        }
        this.absAgPropsFileName = absAgPropsFileName;
    }

    public String getAbsAgPropsFileName() {
        return this.absAgPropsFileName;
    }
}

