/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import oracle.adf.view.rich.component.UIXInputPopup;
import oracle.adf.view.rich.event.LaunchPopupEvent;
import oracle.adf.view.rich.event.ReturnPopupEvent;
import oracle.adf.view.rich.model.AttributeDescriptor;
import oracle.adf.view.rich.model.ColumnDescriptor;
import oracle.adf.view.rich.model.ListOfValuesModel;
import oracle.adf.view.rich.model.QueryDescriptor;
import oracle.adf.view.rich.model.QueryModel;
import oracle.adf.view.rich.model.TableModel;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.model.AGAppearanceParams;
import oracle.bpel.activityguide.ui.beans.model.AGServiceInterfaceImpl;
import oracle.bpel.activityguide.ui.beans.model.AGTasksPopup;
import oracle.bpel.activityguide.ui.beans.model.AGTreeModelBean;
import oracle.bpel.activityguide.ui.beans.model.AGUtil;
import oracle.bpel.activityguide.ui.beans.model.FilterBean;
import oracle.bpel.activityguide.ui.beans.resources.AGUIInfoMsg;
import oracle.bpel.activityguide.ui.i18n.I18NUtil;
import org.apache.myfaces.trinidad.context.RequestContext;
import org.apache.myfaces.trinidad.model.CollectionModel;
import org.apache.myfaces.trinidad.model.RowKeySet;

public class AGInstanceListBean {
    private AGLog agLog = AGLogFactory.getLog(AGInstanceListBean.class);
    private String _agInstanceId;
    List _values = new ArrayList();
    List _recentValues = new ArrayList();
    List _filteredList = new ArrayList();
    AGTreeModelBean _agTreeBean = null;
    FilterBean _filterBean = null;
    private CollectionModel listModel = new ListLovCollection();
    private CollectionModel baseModel = new BaseLovCollection();
    private List<String> _attributes = new ArrayList<String>();

    public AGInstanceListBean() {
        this._attributes.add("AGInstanceID");
        this._attributes.add("agTitle");
        this._attributes.add("agIdentificationKey");
        this._attributes.add("agStatus");
        this._agTreeBean = (AGTreeModelBean)AGUtil.evaluateELExpression("#{agTreeModelBean}", AGTreeModelBean.class);
        this._filterBean = (FilterBean)AGUtil.evaluateELExpression("#{filterBean}", FilterBean.class);
        List agInstanceIList = this._agTreeBean.getAgInstanceIdList();
        if (agInstanceIList != null) {
            for (int i = 0; i < agInstanceIList.size(); ++i) {
                AGServiceInterfaceImpl.AGInstanceDetails agInstanceInfo = (AGServiceInterfaceImpl.AGInstanceDetails)agInstanceIList.get(i);
                String agInstanceId = agInstanceInfo.getCiKey();
                if (this.agLog.isTrace()) {
                    this.agLog.trace(AGUIInfoMsg.MSG_AG_INST_LIST_BEAN_ID_LIST.instance(agInstanceId));
                }
                String agTitle = agInstanceInfo.getTitle();
                String agIdKey = agInstanceInfo.getIdkey();
                String agStatus = agInstanceInfo.getStatus();
                String agRowid = new Integer(i).toString();
                AGInstanceID _curRow = new AGInstanceID(i, agInstanceId, agTitle, agIdKey, agStatus, agRowid);
                this._values.add(_curRow);
            }
        }
    }

    public void setAGInstanceID(String agInstanceId) {
        this._agInstanceId = agInstanceId;
        this._agTreeBean.setAGInstanceID(agInstanceId);
    }

    public String getAGInstanceID() {
        return this._agInstanceId;
    }

    public void processReturn(ReturnPopupEvent event) {
        UIComponent src = (UIComponent)event.getSource();
        Object value = event.getReturnValue();
        if (src instanceof UIXInputPopup) {
            Object rowData;
            String agId = null;
            if (value instanceof List) {
                List listvalue = (List)value;
                for (int i = 0; i < listvalue.size(); ++i) {
                    rowData = listvalue.get(i);
                    if (!(rowData instanceof AGInstanceID)) continue;
                    agId = ((AGInstanceID)rowData).getAGInstanceID();
                    if (this.agLog.isTrace()) {
                        this.agLog.trace(AGUIInfoMsg.MSG_AG_INST_LIST_BEAN_SELECTED_AG_ID.instance(agId));
                    }
                    this.setAGInstanceID(agId);
                }
            } else if (value instanceof RowKeySet) {
                for (Object rowKey : (RowKeySet)value) {
                    this.baseModel.setRowKey(rowKey);
                    rowData = (AGInstanceID)this.baseModel.getRowData();
                    agId = ((AGInstanceID)rowData).getAGInstanceID();
                    this.setAGInstanceID(agId);
                }
            }
            this._agTreeBean.setPreviousTaskId(null);
            RequestContext reqContext = RequestContext.getCurrentInstance();
            AGAppearanceParams agAppearanceParams = (AGAppearanceParams)AGUtil.evaluateELExpression("#{appearanceParams}", AGAppearanceParams.class);
            agAppearanceParams.setAgFilterDropDownVisible(true);
            agAppearanceParams.setAgTreeRendered(true);
            reqContext.addPartialTarget((UIComponent)this._filterBean.getTaskFilterDropDown());
            reqContext.addPartialTarget((UIComponent)this._agTreeBean.getAgTreePanelGroup());
            this._agTreeBean.handleTreeRowSelection();
            this._agTreeBean.refreshAGPercentCompletion(agId);
            AGTasksPopup agTasksPopup = (AGTasksPopup)AGUtil.evaluateELExpression("#{agTasksPopup}", AGTasksPopup.class);
            agTasksPopup.refreshCompletedTasks();
            this._agTreeBean.refreshAGDetailsRegion();
        }
    }

    public void processLaunch(LaunchPopupEvent event) {
        UIComponent src;
        String method = "processLaunch";
        if (this.agLog.isTrace()) {
            this.agLog.trace(AGUIInfoMsg.MSG_AG_INST_LIST_BEAN_PROC_LAUNCH.instance(method));
        }
        if ((src = (UIComponent)event.getSource()) instanceof UIXInputPopup) {
            this.filterList((String)event.getSubmittedValue());
            if (this._filteredList.size() == 1) {
                this.setAGInstanceID(((AGInstanceID)this._filteredList.get(0)).getAGInstanceID());
                event.setLaunchPopup(false);
            } else {
                event.setLaunchPopup(true);
            }
        }
    }

    public List getValues() {
        return this._filteredList;
    }

    public List getRecentValues() {
        ArrayList recentValues = new ArrayList();
        return recentValues;
    }

    public CollectionModel getListModel() {
        return this.listModel;
    }

    public ListOfValuesModel getListOfValuesModel() {
        return new ListOfValuesModelImpl(this);
    }

    private void filterList(String agInstanceId) {
        this._filteredList.clear();
        if (this._filteredList.size() == 0) {
            this._filteredList.addAll(this._values);
        }
    }

    public class ListOfValuesModelImpl
    extends ListOfValuesModel {
        private AGInstanceListBean _bean;

        public ListOfValuesModelImpl(AGInstanceListBean bean) {
            this._bean = bean;
        }

        public List<? extends Object> getItems() {
            return this._bean.getValues();
        }

        public QueryModel getQueryModel() {
            return null;
        }

        public List<? extends Object> getRecentItems() {
            return this._bean.getRecentValues();
        }

        public TableModel getTableModel() {
            return new TableModelImpl(this._bean.getListModel());
        }

        public boolean isAutoCompleteEnabled() {
            return false;
        }

        public void performQuery(QueryDescriptor qd) {
        }

        public List<Object> autoCompleteValue(Object value) {
            this._bean.filterList((String)value);
            ArrayList<Object> returnList = new ArrayList<Object>();
            for (int i = 0; i < this._bean._filteredList.size(); ++i) {
                returnList.add(((AGInstanceID)this._bean._filteredList.get(i)).getAGInstanceID());
            }
            return returnList;
        }

        public void valueSelected(Object value) {
            block3: {
                block2: {
                    if (value == null || !(value instanceof List)) break block2;
                    List listvalue = (List)value;
                    for (int i = 0; i < listvalue.size(); ++i) {
                        Object rowData = listvalue.get(i);
                        if (!(rowData instanceof AGInstanceID)) continue;
                        this._bean.setAGInstanceID(((AGInstanceID)rowData).getAGInstanceID());
                    }
                    break block3;
                }
                if (value == null || !(value instanceof RowKeySet)) break block3;
                for (Object rowKey : (RowKeySet)value) {
                    this._bean.baseModel.setRowKey(rowKey);
                    AGInstanceID rowData = (AGInstanceID)this._bean.baseModel.getRowData();
                    this._bean.setAGInstanceID(rowData.getAGInstanceID());
                }
            }
        }

        public QueryDescriptor getQueryDescriptor() {
            return null;
        }

        public class TableModelImpl
        extends TableModel {
            private CollectionModel _collectionModel;
            private List<ColumnDescriptor> _descriptors;

            public TableModelImpl(CollectionModel collectionModel) {
                assert (collectionModel != null);
                this._collectionModel = collectionModel;
            }

            public CollectionModel getCollectionModel() {
                return this._collectionModel;
            }

            public List<ColumnDescriptor> getColumnDescriptors() {
                if (this._descriptors == null) {
                    this._descriptors = new ArrayList<ColumnDescriptor>(AGInstanceListBean.this._attributes.size());
                    for (String attr : AGInstanceListBean.this._attributes) {
                        this._descriptors.add(new ColumnDescriptorImpl(attr));
                    }
                }
                return this._descriptors;
            }

            public class ColumnDescriptorImpl
            extends ColumnDescriptor {
                private String _name;

                public ColumnDescriptorImpl(String name) {
                    this._name = name;
                }

                public String getFormat() {
                    return null;
                }

                public String getLabel() {
                    I18NUtil.setGsLocale(FacesContext.getCurrentInstance().getViewRoot().getLocale());
                    return I18NUtil.getI18NiizedString("AG_INPUT_COMBOBOX_COLUMN_" + this._name.toUpperCase());
                }

                public String getName() {
                    return this._name;
                }

                public Class getType() {
                    return String.class;
                }

                public String getAlign() {
                    return null;
                }

                public AttributeDescriptor.ComponentType getComponentType() {
                    return AttributeDescriptor.ComponentType.inputText;
                }

                public String getDescription() {
                    return null;
                }

                public Set<AttributeDescriptor.Operator> getSupportedOperators() {
                    return Collections.emptySet();
                }

                public int getLength() {
                    return 0;
                }

                public int getMaximumLength() {
                    return 0;
                }

                public Object getModel() {
                    return null;
                }

                public int getWidth() {
                    return 0;
                }

                public boolean isReadOnly() {
                    return true;
                }

                public boolean isRequired() {
                    return false;
                }
            }
        }
    }

    class ListLovCollection
    extends CollectionModel {
        AGInstanceID _row = null;
        int _rowIndex = -1;

        ListLovCollection() {
        }

        public Object getRowKey() {
            if (this._row != null) {
                return this._row.getRowID();
            }
            return null;
        }

        public void setRowKey(Object rowKey) {
            if (rowKey == null) {
                this._row = null;
                return;
            }
            int index = -1;
            for (int i = 0; i < AGInstanceListBean.this._filteredList.size(); ++i) {
                String rowId = ((AGInstanceID)AGInstanceListBean.this._filteredList.get(i)).getRowID();
                if (!rowId.equals(rowKey)) continue;
                index = i;
                break;
            }
            this.setRowIndex(index);
        }

        public void setRowIndex(int rowIndex) {
            int size = AGInstanceListBean.this._filteredList.size();
            if (rowIndex < 0 || rowIndex > size || size == 0) {
                this._row = null;
                this._rowIndex = -1;
            } else {
                this._row = (AGInstanceID)AGInstanceListBean.this._filteredList.get(rowIndex);
                this._rowIndex = rowIndex;
            }
        }

        public int getRowIndex() {
            return this._rowIndex;
        }

        public Object getRowData() {
            return this._row;
        }

        public int getRowCount() {
            return AGInstanceListBean.this._filteredList.size();
        }

        public boolean isRowAvailable() {
            return this._row != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getRowData(int rowIndex) {
            int oldIndex = this.getRowIndex();
            try {
                this.setRowIndex(rowIndex);
                Object object = this.getRowData();
                return object;
            }
            finally {
                this.setRowIndex(oldIndex);
            }
        }

        public boolean isSortable(String property) {
            return false;
        }

        public List getSortCriteria() {
            return Collections.EMPTY_LIST;
        }

        public Object getWrappedData() {
            return this;
        }

        public void setWrappedData(Object data) {
            throw new UnsupportedOperationException();
        }
    }

    class BaseLovCollection
    extends CollectionModel {
        AGInstanceID _row = null;
        int _rowIndex = -1;

        public Object getRowKey() {
            if (this._row != null) {
                return this._row.getRowID();
            }
            return null;
        }

        public void setRowKey(Object rowKey) {
            if (rowKey == null) {
                this._row = null;
                return;
            }
            int index = -1;
            for (int i = 0; i < AGInstanceListBean.this._filteredList.size(); ++i) {
                String rowId = ((AGInstanceID)AGInstanceListBean.this._filteredList.get(i)).getRowID();
                if (!rowId.equals(rowKey)) continue;
                index = i;
                break;
            }
            this.setRowIndex(index);
        }

        public void setRowIndex(int rowIndex) {
            int size = AGInstanceListBean.this._filteredList.size();
            if (rowIndex < 0 || rowIndex > size || size == 0) {
                this._row = null;
                this._rowIndex = -1;
            } else {
                this._row = (AGInstanceID)AGInstanceListBean.this._filteredList.get(rowIndex);
                this._rowIndex = rowIndex;
            }
        }

        public int getRowIndex() {
            return this._rowIndex;
        }

        public Object getRowData() {
            return this._row;
        }

        public int getRowCount() {
            return AGInstanceListBean.this._filteredList.size();
        }

        public boolean isRowAvailable() {
            return this._row != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object getRowData(int rowIndex) {
            int oldIndex = this.getRowIndex();
            try {
                this.setRowIndex(rowIndex);
                Object object = this.getRowData();
                return object;
            }
            finally {
                this.setRowIndex(oldIndex);
            }
        }

        public boolean isSortable(String property) {
            return false;
        }

        public List getSortCriteria() {
            return Collections.EMPTY_LIST;
        }

        public Object getWrappedData() {
            return this;
        }

        public void setWrappedData(Object data) {
            throw new UnsupportedOperationException();
        }
    }

    public class AGInstanceID {
        private int instanceNum;
        private String agInstanceId;
        private String agTitle;
        private String agIdentificationKey;
        private String agStatus;
        private String rowId;

        AGInstanceID(int instanceNum, String agInstanceId, String agTitle, String agIdentificationKey, String agStatus, String rowId) {
            this.instanceNum = instanceNum;
            this.agInstanceId = agInstanceId;
            this.agTitle = agTitle;
            this.agIdentificationKey = agIdentificationKey;
            this.agStatus = agStatus;
            this.rowId = rowId;
        }

        public String getAGInstanceID() {
            return this.agInstanceId;
        }

        public String getRowID() {
            return this.rowId;
        }

        public String getAgTitle() {
            return this.agTitle;
        }

        public String getAgIdentificationKey() {
            return this.agIdentificationKey;
        }

        public String getAgStatus() {
            return this.agStatus;
        }
    }
}

