/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.model.MilestoneInstance;
import oracle.bpel.services.workflow.activityguide.query.model.AGDisplayInfo;
import oracle.bpel.services.workflow.activityguide.query.model.MilestoneDisplayInfoType;

class AGInstance {
    private static AGLog agLog = AGLogFactory.getLog(AGInstance.class);
    private Map<String, MilestoneInstance> msInstanceMap = new HashMap<String, MilestoneInstance>();
    private AGDisplayInfo agDisplayInfo = null;
    private Iterator msListIter = null;
    private Object parent = null;
    private String processMode = null;
    private boolean useCustomBlockIcon = false;
    private List<String> msSequence = null;

    AGInstance(AGDisplayInfo displayInfo, Object parent) {
        this.agDisplayInfo = displayInfo;
        this.parent = parent;
        this.msSequence = new ArrayList<String>();
        this.processMode = displayInfo.getProcessMode();
        if (agLog.isDebug()) {
            agLog.debug("Cached AG Id: " + this.agDisplayInfo.getAGInstanceInfo().getCiKey() + " AG Name: " + this.agDisplayInfo.getName());
        }
        for (MilestoneDisplayInfoType msDisplayInfo : this.agDisplayInfo.getMilestoneDisplayInfo()) {
            if (this.processMode.equalsIgnoreCase("AGBPM")) {
                this.msSequence.add(msDisplayInfo.getName());
                this.msInstanceMap.put(msDisplayInfo.getName(), new MilestoneInstance(msDisplayInfo, this));
                continue;
            }
            this.msSequence.add(msDisplayInfo.getMilestoneInstance().getName());
            this.msInstanceMap.put(msDisplayInfo.getMilestoneInstance().getName(), new MilestoneInstance(msDisplayInfo, this));
        }
    }

    Object getParent() {
        return this.parent;
    }

    public AGDisplayInfo getAGDisplayInfo() {
        return this.agDisplayInfo;
    }

    List getChildMilestoneNames() {
        return this.msSequence;
    }

    MilestoneInstance getMilestoneByName(String key) {
        return this.msInstanceMap.get(key);
    }

    String getDisplayTitle() {
        return this.agDisplayInfo.getTitle();
    }

    String getName() {
        return this.agDisplayInfo.getName();
    }

    String getDescription() {
        return this.agDisplayInfo.getDescription();
    }

    Calendar getCreated() {
        if (this.processMode.equalsIgnoreCase("AGBPM")) {
            return Calendar.getInstance();
        }
        return this.agDisplayInfo.getAGInstanceInfo().getCreationDate();
    }

    String getStatus() {
        if (this.processMode.equalsIgnoreCase("AGBPM")) {
            return this.agDisplayInfo.getStatus();
        }
        return this.agDisplayInfo.getAGInstanceInfo().getStatus();
    }

    int getPercentCompletion() {
        if (this.processMode.equalsIgnoreCase("AGBPM")) {
            return this.agDisplayInfo.getPercentageComplete().intValue();
        }
        return this.agDisplayInfo.getAGInstanceInfo().getCompletionPercentage().intValue();
    }

    String getErrorMessage() {
        if (this.processMode.equalsIgnoreCase("AGBPM")) {
            return this.agDisplayInfo.getDescription();
        }
        return this.agDisplayInfo.getAGInstanceInfo().getErrorMessage();
    }

    void release() {
        Collection<MilestoneInstance> c = this.msInstanceMap.values();
        Iterator<MilestoneInstance> i = c.iterator();
        while (i.hasNext()) {
            MilestoneInstance msInstance = i.next();
            msInstance.release();
            i.remove();
        }
    }

    String getGlobalTaskAccessMode() {
        return this.agDisplayInfo.getGlobalTaskAccessMode();
    }

    public String getProcessMode() {
        return this.processMode;
    }

    public String getTaskBlockedIconLocation() {
        return this.agDisplayInfo.getTaskBlockedIconLocation();
    }

    public String getIconLocation() {
        return this.agDisplayInfo.getIconLocation();
    }
}

