/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import oracle.bpel.activityguide.ui.i18n.I18NUtil;

public class AGException
extends Exception {
    private static String gsListBundleName = null;
    private static ResourceBundle gsResourceBundle = null;
    private int errorCode;
    private Object[] errParams = null;
    private String mPrefix = null;
    private String mSeverity = null;
    private String mType = null;
    private String mName = null;
    private String mDescription = null;
    private String mFix = null;

    public AGException(int errorCode) {
        this.errorCode = errorCode;
        this.init();
    }

    public AGException(int errorCode, Object[] params) {
        this.errorCode = errorCode;
        this.errParams = params;
        this.init();
    }

    @Override
    public String getMessage() {
        StringBuffer buf = new StringBuffer();
        if (this.mName != null) {
            buf.append(this.mName);
            if (!this.mName.endsWith(".")) {
                buf.append('.');
            }
            buf.append('\n');
        }
        if (this.mDescription != null) {
            buf.append(this.mDescription);
            if (!this.mDescription.endsWith(".")) {
                buf.append('.');
            }
            buf.append('\n');
        }
        if (this.mFix != null) {
            buf.append(this.mFix);
            if (!this.mFix.endsWith(".")) {
                buf.append('.');
            }
            buf.append('\n');
        }
        if (this.mType != null) {
            buf.append(this.mType);
            if (!this.mType.endsWith(".")) {
                buf.append('.');
            }
            buf.append('\n');
        }
        if (this.mSeverity != null) {
            buf.append(this.mSeverity);
            if (!this.mSeverity.endsWith(".")) {
                buf.append('.');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        return buf.append("ORABPEL-").append(this.errorCode).append("\n\n").append(this.getMessage()).toString();
    }

    protected String getResourceString(String key) throws MissingResourceException {
        return gsResourceBundle.getString(key);
    }

    private void init() {
        String mesg;
        this.mPrefix = "exception." + this.errorCode;
        try {
            this.mSeverity = this.getResourceString(this.mPrefix + ".severity");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            this.mType = this.getResourceString(this.mPrefix + ".type");
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            mesg = this.getResourceString(this.mPrefix + ".name");
            this.mName = MessageFormat.format(mesg, this.errParams);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            mesg = this.getResourceString(this.mPrefix + ".description");
            this.mDescription = MessageFormat.format(mesg, this.errParams);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        try {
            mesg = this.getResourceString(this.mPrefix + ".fix");
            this.mFix = MessageFormat.format(mesg, this.errParams);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    static {
        gsResourceBundle = I18NUtil.getGsAGUIExceptionsList();
    }
}

