/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.model;

import java.util.Locale;
import java.util.TimeZone;
import javax.faces.context.FacesContext;
import oracle.adf.view.rich.context.AdfFacesContext;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.model.AGException;
import oracle.bpel.activityguide.ui.beans.model.AGUtil;
import oracle.bpel.activityguide.ui.beans.resources.AGUIErrorMsg;
import oracle.bpel.activityguide.ui.beans.resources.AGUIInfoMsg;

public class AGAppearanceParams {
    private AGLog agLog = AGLogFactory.getLog(AGAppearanceParams.class);
    private String ShowProperties = "true";
    private Boolean agInstanceDropDownRendered = false;
    private Boolean agFilterDropDownVisible = false;
    private Boolean agTreeRendered = false;
    private String agDoneButtonLabel = "AG_NEXT_ACTIVITY";

    public AGAppearanceParams() {
        String method = "AGAppearanceParams";
        String value = AGUtil.getAgProps().getProperty("ShowAllAGTreeNodesProperties");
        if (this.agLog.isInfo()) {
            this.agLog.info(method, AGUIInfoMsg.MSG_SHOW_NODE_PROPS.instance(value));
        }
        if (value != null) {
            this.ShowProperties = value;
        }
        this.readAGDoneButtonLabel();
    }

    public String getShowProperties() {
        return this.ShowProperties;
    }

    public void setAgInstanceDropDownRendered(Boolean agInstanceDropDownRendered) {
        this.agInstanceDropDownRendered = agInstanceDropDownRendered;
    }

    public Boolean getAgInstanceDropDownRendered() {
        return this.agInstanceDropDownRendered;
    }

    public void setAgTreeRendered(Boolean agTreeRendered) {
        this.agTreeRendered = agTreeRendered;
    }

    public Boolean getAgTreeRendered() {
        return this.agTreeRendered;
    }

    public void setAgFilterDropDownVisible(Boolean agFilterDropDownVisible) {
        this.agFilterDropDownVisible = agFilterDropDownVisible;
    }

    public Boolean getAgFilterDropDownVisible() {
        return this.agFilterDropDownVisible;
    }

    public String getAgDoneButtonLabel() {
        return this.agDoneButtonLabel;
    }

    protected void readAGDoneButtonLabel() {
        String method = "readAGDoneButtonLabel";
        String value = AGUtil.getAgProps().getProperty("AGDoneButtonLabel");
        if (this.agLog.isInfo()) {
            this.agLog.info(method, AGUIInfoMsg.MSG_DONE_BUTTON_LABEL.instance(value));
        }
        if (value == null) {
            return;
        }
        if (value.equals("AG_DONE") || value.equals("AG_NEXT_ACTIVITY") || value.equals("AG_NEXT_TASK")) {
            this.agDoneButtonLabel = value;
        } else {
            try {
                throw new AGException(38018);
            }
            catch (AGException e) {
                this.agLog.error(method, AGUIErrorMsg.ERR_DONE_BUTTON_LABEL_INVALID.instance(method, e.getMessage()));
            }
        }
    }

    public Locale getLocale() {
        FacesContext ctx = FacesContext.getCurrentInstance();
        if (ctx != null) {
            return ctx.getViewRoot().getLocale();
        }
        return null;
    }

    public TimeZone getTimeZone() {
        AdfFacesContext adfFacesContext = AdfFacesContext.getCurrentInstance();
        if (adfFacesContext != null) {
            return adfFacesContext.getTimeZone();
        }
        return null;
    }
}

