/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.logger.forkchild;

import java.util.Locale;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bpel.activityguide.ui.beans.logger.AGException;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.ResourceRef;

public class AGLogImplJava
implements AGLog {
    private static final String s_cname = AGLogImplJava.class.getName();
    private static final String ENTER = "ENTER ";
    private static final String EXIT = "EXIT ";
    private static final String THROWN = "TROWN ";
    private static final String DELIM_DOT = ".";
    private static final int NUM_SEGMENTS_IN_LOGGER_NAME = 5;
    private final String mLogName;
    private final Logger mLog;
    private final String mSourceClassName;
    private String mCallerClassName;
    private String mCallerMethodName;

    AGLogImplJava(Class<?> sourceClass) {
        this.mLogName = this.makeLogName(sourceClass.getName());
        this.mLog = Logger.getLogger(this.mLogName);
        this.mSourceClassName = sourceClass.getName();
    }

    public Logger getLogger() {
        return this.mLog;
    }

    @Override
    public String getSourceClassName() {
        return this.mSourceClassName;
    }

    @Override
    public boolean isTrace() {
        return this.getLogger().isLoggable(Level.FINER);
    }

    @Override
    public boolean isFinest() {
        return this.getLogger().isLoggable(Level.FINEST);
    }

    @Override
    public boolean isFiner() {
        return this.getLogger().isLoggable(Level.FINER);
    }

    @Override
    public boolean isDebug() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    @Override
    public boolean isFine() {
        return this.getLogger().isLoggable(Level.FINE);
    }

    @Override
    public boolean isConfig() {
        return this.getLogger().isLoggable(Level.CONFIG);
    }

    @Override
    public boolean isInfo() {
        return this.getLogger().isLoggable(Level.INFO);
    }

    @Override
    public boolean isWarn() {
        return this.getLogger().isLoggable(Level.WARNING);
    }

    @Override
    public boolean isError() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isFatal() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    @Override
    public boolean isSevere() {
        return this.getLogger().isLoggable(Level.SEVERE);
    }

    @Override
    public void trace(String message) {
        if (this.isTrace()) {
            this.inferCaller();
            this.getLogger().logp(Level.FINER, this.mCallerClassName, this.mCallerMethodName, message);
        }
    }

    @Override
    public void trace(ResourceRef message) {
        if (this.isTrace()) {
            this.inferCaller();
            this.getLogger().logrb(Level.FINER, this.mSourceClassName, this.mCallerMethodName, message.getResourceBundleName(), message.getKey(), message.getArgs());
        }
    }

    @Override
    public void finest(String message) {
        if (this.isFinest()) {
            this.inferCaller();
            this.getLogger().logp(Level.FINEST, this.mCallerClassName, this.mCallerMethodName, message);
        }
    }

    @Override
    public void finest(ResourceRef message) {
        if (this.isFinest()) {
            this.inferCaller();
            this.getLogger().logrb(Level.FINEST, this.mSourceClassName, this.mCallerMethodName, message.getResourceBundleName(), message.getKey(), message.getArgs());
        }
    }

    @Override
    public void finer(String message) {
        if (this.isFiner()) {
            this.inferCaller();
            this.getLogger().logp(Level.FINER, this.mCallerClassName, this.mCallerMethodName, message);
        }
    }

    @Override
    public void finer(ResourceRef message) {
        if (this.isFiner()) {
            this.inferCaller();
            this.getLogger().logrb(Level.FINER, this.mSourceClassName, this.mCallerMethodName, message.getResourceBundleName(), message.getKey(), message.getArgs());
        }
    }

    @Override
    public void debug(String message) {
        if (this.isDebug()) {
            this.inferCaller();
            this.getLogger().logp(Level.FINE, this.mCallerClassName, this.mCallerMethodName, message);
        }
    }

    @Override
    public void debug(ResourceRef message) {
        if (this.isDebug()) {
            this.inferCaller();
            this.getLogger().logrb(Level.FINE, this.mSourceClassName, this.mCallerMethodName, message.getResourceBundleName(), message.getKey(), message.getArgs());
        }
    }

    @Override
    public void fine(String message) {
        if (this.isFine()) {
            this.inferCaller();
            this.getLogger().logp(Level.FINE, this.mCallerClassName, this.mCallerMethodName, message);
        }
    }

    @Override
    public void fine(ResourceRef message) {
        if (this.isFine()) {
            this.inferCaller();
            this.getLogger().logrb(Level.FINE, this.mSourceClassName, this.mCallerMethodName, message.getResourceBundleName(), message.getKey(), message.getArgs());
        }
    }

    @Override
    public void config(String sourceMethodName, ResourceRef message) {
        this.getLogger().logrb(Level.CONFIG, this.mSourceClassName, sourceMethodName, message.getResourceBundleName(), message.getKey(), message.getArgs());
    }

    @Override
    public void info(String sourceMethodName, ResourceRef message) {
        this.getLogger().logrb(Level.INFO, this.mSourceClassName, sourceMethodName, message.getResourceBundleName(), message.getKey(), message.getArgs());
    }

    @Override
    public void warn(String sourceMethodName, ResourceRef message) {
        this.getLogger().logrb(Level.WARNING, this.mSourceClassName, sourceMethodName, message.getResourceBundleName(), message.getKey(), message.getArgs());
    }

    @Override
    public void warn(String sourceMethodName, Throwable cause) {
        this.log_internal(Level.WARNING, this.mSourceClassName, sourceMethodName, null, cause);
    }

    @Override
    public void warn(String sourceMethodName, ResourceRef message, Throwable cause) {
        this.log_internal(Level.WARNING, this.mSourceClassName, sourceMethodName, message, cause);
    }

    @Override
    public void error(String sourceMethodName, ResourceRef message) {
        this.getLogger().logrb(Level.SEVERE, this.mSourceClassName, sourceMethodName, message.getResourceBundleName(), message.getKey(), message.getArgs());
    }

    @Override
    public void error(String sourceMethodName, Throwable cause) {
        this.log_internal(Level.SEVERE, this.mSourceClassName, sourceMethodName, null, cause);
    }

    @Override
    public void error(String sourceMethodName, ResourceRef message, Throwable cause) {
        this.log_internal(Level.SEVERE, this.mSourceClassName, sourceMethodName, message, cause);
    }

    @Override
    public void fatal(String sourceMethodName, ResourceRef message) {
        this.getLogger().logrb(Level.SEVERE, this.mSourceClassName, sourceMethodName, message.getResourceBundleName(), message.getKey(), message.getArgs());
    }

    @Override
    public void fatal(String sourceMethodName, Throwable cause) {
        this.log_internal(Level.SEVERE, this.mSourceClassName, sourceMethodName, null, cause);
    }

    @Override
    public void fatal(String sourceMethodName, ResourceRef message, Throwable cause) {
        this.log_internal(Level.SEVERE, this.mSourceClassName, sourceMethodName, message, cause);
    }

    @Override
    public void severe(String sourceMethodName, ResourceRef message) {
        this.getLogger().logrb(Level.SEVERE, this.mSourceClassName, sourceMethodName, message.getResourceBundleName(), message.getKey(), message.getArgs());
    }

    @Override
    public void severe(String sourceMethodName, Throwable cause) {
        this.log_internal(Level.SEVERE, this.mSourceClassName, sourceMethodName, null, cause);
    }

    @Override
    public void severe(String sourceMethodName, ResourceRef message, Throwable cause) {
        this.log_internal(Level.SEVERE, this.mSourceClassName, sourceMethodName, message, cause);
    }

    @Override
    public void enter(String sourceMethodName) {
        if (this.isFine()) {
            StringBuffer sb = new StringBuffer(ENTER);
            if (this.mSourceClassName != null) {
                sb.append(this.mSourceClassName);
                sb.append(DELIM_DOT);
            }
            sb.append(sourceMethodName);
            this.fine(sb.toString());
        }
    }

    @Override
    public void enter(String sourceMethodName, Object param1) {
        if (this.isFine()) {
            StringBuffer sb = new StringBuffer(ENTER);
            if (this.mSourceClassName != null) {
                sb.append(this.mSourceClassName);
                sb.append(DELIM_DOT);
            }
            sb.append(sourceMethodName);
            sb.append("(");
            if (param1 != null) {
                sb.append(param1.toString());
            } else {
                sb.append("null");
            }
            sb.append(")");
            this.fine(sb.toString());
        }
    }

    @Override
    public void enter(String sourceMethodName, Object param1, Object param2) {
        if (this.isFine()) {
            StringBuffer sb = new StringBuffer(ENTER);
            if (this.mSourceClassName != null) {
                sb.append(this.mSourceClassName);
                sb.append(DELIM_DOT);
            }
            sb.append(sourceMethodName);
            sb.append("(");
            if (param1 != null) {
                sb.append(param1.toString());
            } else {
                sb.append("null");
            }
            sb.append(", ");
            if (param2 != null) {
                sb.append(param2.toString());
            } else {
                sb.append("null");
            }
            sb.append(")");
            this.fine(sb.toString());
        }
    }

    @Override
    public void enter(String sourceMethodName, Object[] params) {
        if (this.isFine()) {
            StringBuffer sb = new StringBuffer(ENTER);
            if (this.mSourceClassName != null) {
                sb.append(this.mSourceClassName);
                sb.append(DELIM_DOT);
            }
            sb.append(sourceMethodName);
            sb.append("(");
            if (params != null) {
                int lastArg = params.length - 1;
                for (int i = 0; i < params.length; ++i) {
                    if (params[i] != null) {
                        sb.append(params[i].toString());
                    } else {
                        sb.append("null");
                    }
                    if (i >= lastArg) continue;
                    sb.append(", ");
                }
            }
            sb.append(")");
            this.fine(sb.toString());
        }
    }

    @Override
    public void exit(String sourceMethodName) {
        if (this.isFine()) {
            StringBuffer sb = new StringBuffer(EXIT);
            if (this.mSourceClassName != null) {
                sb.append(this.mSourceClassName);
                sb.append(DELIM_DOT);
            }
            sb.append(sourceMethodName);
            this.fine(sb.toString());
        }
    }

    @Override
    public void exit(String sourceMethodName, Object returnValue) {
        if (this.isFine()) {
            StringBuffer sb = new StringBuffer(EXIT);
            if (this.mSourceClassName != null) {
                sb.append(this.mSourceClassName);
                sb.append(DELIM_DOT);
            }
            sb.append(sourceMethodName);
            sb.append(" => ");
            if (returnValue != null) {
                sb.append(returnValue.toString());
            }
            this.fine(sb.toString());
        }
    }

    @Override
    public void throwing(String sourceMethodName, Throwable thrown) {
        if (this.isFine()) {
            StringBuffer sb = new StringBuffer(THROWN);
            if (this.mSourceClassName != null) {
                sb.append(this.mSourceClassName);
                sb.append(DELIM_DOT);
            }
            sb.append(sourceMethodName);
            sb.append(" => ");
            sb.append(thrown.getMessage());
            this.fine(sb.toString());
        }
    }

    private void inferCaller() {
        StackTraceElement frame;
        String cname;
        int ix;
        StackTraceElement[] stack = new Throwable().getStackTrace();
        for (ix = 0; ix < stack.length && !(cname = (frame = stack[ix]).getClassName()).equals(s_cname); ++ix) {
        }
        while (ix < stack.length) {
            frame = stack[ix];
            cname = frame.getClassName();
            if (!cname.equals(s_cname)) {
                this.setCallerClassName(cname);
                this.setCallerMethodName(frame.getMethodName());
                return;
            }
            ++ix;
        }
    }

    private void setCallerClassName(String pCallerClassName) {
        this.mCallerClassName = pCallerClassName;
    }

    private void setCallerMethodName(String pCallerMethodName) {
        this.mCallerMethodName = pCallerMethodName;
    }

    private String makeLogName(String pClassName) {
        StringTokenizer lSt = new StringTokenizer(pClassName, DELIM_DOT);
        if (lSt.countTokens() > 5) {
            int lCount = 0;
            StringBuffer lLogNameBuffer = new StringBuffer();
            while (lSt.hasMoreTokens()) {
                if (lCount > 0) {
                    lLogNameBuffer.append(DELIM_DOT);
                }
                lLogNameBuffer.append(lSt.nextToken());
                if (++lCount != 5) continue;
                return lLogNameBuffer.toString();
            }
        }
        return pClassName;
    }

    private void log_internal(Level level, String sourceClassName, String sourceMethodName, ResourceRef message, Throwable cause) {
        if (message == null && cause == null) {
            return;
        }
        LogRecord lr = new LogRecord(level, "");
        lr.setSourceClassName(sourceClassName);
        lr.setSourceMethodName(sourceMethodName);
        lr.setLoggerName(this.mLogName);
        ResourceRef lMsg = message;
        if (lMsg == null && cause != null && cause instanceof AGException) {
            AGException exp = (AGException)cause;
            lMsg = exp.getMessageRef();
        }
        if (lMsg != null) {
            lr.setResourceBundle(lMsg.getResourceBundle(Locale.getDefault()));
            lr.setResourceBundleName(lMsg.getResourceBundleName());
            lr.setParameters(lMsg.getArgs());
            lr.setMessage(lMsg.getKey());
        }
        if (cause != null) {
            lr.setThrown(cause);
            if (lMsg == null) {
                lr.setMessage(cause.getMessage());
            }
        }
        this.getLogger().log(lr);
    }
}

