/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.logger;

import java.util.Locale;
import java.util.ResourceBundle;
import oracle.bpel.activityguide.ui.beans.logger.MessageLocalizer;

public abstract class ResourceRef {
    private static final String ID_DELIM = "#";
    private final String mKey;
    private final Object[] mArgs;
    private String mId = null;

    protected ResourceRef() {
        this.mKey = null;
        this.mArgs = null;
    }

    protected ResourceRef(String key, Object arg) {
        this(key, new Object[]{arg});
    }

    protected ResourceRef(String key, Object arg1, Object arg2) {
        this(key, new Object[]{arg1, arg2});
    }

    protected ResourceRef(String key, Object[] args) {
        this.mKey = key;
        this.mArgs = args;
    }

    protected ResourceRef(String key) {
        this.mKey = key;
        this.mArgs = null;
    }

    protected abstract MessageLocalizer getMessageLocalizer();

    public String getKey() {
        return this.mKey;
    }

    public Object[] getArgs() {
        return this.mArgs;
    }

    public String getId() {
        if (this.mId == null) {
            this.mId = ResourceRef.makeId(this.getResourceBundleName(), this.mKey);
        }
        return this.mId;
    }

    public final String toString() {
        return this.getString();
    }

    public final boolean equals(Object other) {
        if (null == other) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResourceRef)) {
            return false;
        }
        ResourceRef that = (ResourceRef)other;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public final String getString() {
        return this.getMessageLocalizer().localize(this.getKey(), this.getArgs());
    }

    public final String getString(Locale locale) {
        return this.getMessageLocalizer().localize(locale, this.getKey(), this.getArgs());
    }

    public final String getString(Object arg) {
        Object[] args = new Object[]{arg};
        return this.getMessageLocalizer().localize(this.getKey(), args);
    }

    public final String getString(Object[] args) {
        return this.getMessageLocalizer().localize(this.getKey(), args);
    }

    public final String getString(Locale locale, Object[] args) {
        return this.getMessageLocalizer().localize(locale, this.getKey(), args);
    }

    public final String getEnglishString() {
        return this.getMessageLocalizer().localize(Locale.US, this.getKey(), this.getArgs());
    }

    public final String getEnglishString(Object arg) {
        Object[] args = new Object[]{arg};
        return this.getMessageLocalizer().localize(Locale.US, this.getKey(), args);
    }

    public final String getEnglishString(Object[] args) {
        return this.getMessageLocalizer().localize(Locale.US, this.getKey(), args);
    }

    public final String getResourceBundleName() {
        return this.getMessageLocalizer().getResourceBundleName();
    }

    public final ResourceBundle getResourceBundle(Locale locale) {
        return this.getMessageLocalizer().getResourceBundle(locale);
    }

    protected ClassLoader getResourceClassLoader() {
        return this.getClass().getClassLoader();
    }

    static final String makeId(String resourceBundleName, String key) {
        return resourceBundleName + ID_DELIM + key;
    }

    public static ResourceRef createTemp(String resourceBundleName, String key) {
        return new TempResourceRef(resourceBundleName, key);
    }

    public static ResourceRef createTemp(ClassLoader classLoader, String resourceBundleName, String key) {
        return new TempResourceRef(classLoader, resourceBundleName, key);
    }

    public static ResourceRef createTemp(String resourceBundleName, String key, Object arg) {
        return new TempResourceRef(resourceBundleName, key, arg);
    }

    public static ResourceRef createTemp(String resourceBundleName, String key, Object arg1, Object arg2) {
        return new TempResourceRef(resourceBundleName, key, arg1, arg2);
    }

    public static ResourceRef createTemp(String resourceBundleName, String key, Object[] args) {
        return new TempResourceRef(resourceBundleName, key, args);
    }

    public static ResourceRef createTemp(ClassLoader classLoader, String resourceBundleName, String key, Object[] args) {
        return new TempResourceRef(classLoader, resourceBundleName, key, args);
    }

    public ResourceRef instance(Object arg) {
        return new InstancedResourceRef(this, arg);
    }

    public ResourceRef instance(Object arg1, Object arg2) {
        return new InstancedResourceRef(this, new Object[]{arg1, arg2});
    }

    public ResourceRef instance(Object arg1, Object arg2, Object arg3) {
        return new InstancedResourceRef(this, new Object[]{arg1, arg2, arg3});
    }

    public ResourceRef instance(Object[] args) {
        return new InstancedResourceRef(this, args);
    }

    private class InstancedResourceRef
    extends ResourceRef {
        private final ResourceRef baseRef;
        private final Object[] instanceArgs;

        InstancedResourceRef(ResourceRef ref) {
            this.baseRef = ref;
            this.instanceArgs = null;
        }

        InstancedResourceRef(ResourceRef ref, Object arg) {
            this.baseRef = ref;
            this.instanceArgs = new Object[]{arg};
        }

        InstancedResourceRef(ResourceRef ref, Object[] args) {
            this.baseRef = ref;
            this.instanceArgs = args;
        }

        @Override
        public String getKey() {
            return this.baseRef.getKey();
        }

        @Override
        public String getId() {
            return this.baseRef.getId();
        }

        @Override
        public Object[] getArgs() {
            return this.instanceArgs;
        }

        @Override
        protected MessageLocalizer getMessageLocalizer() {
            return this.baseRef.getMessageLocalizer();
        }
    }

    private static class TempResourceRef
    extends ResourceRef {
        private MessageLocalizer mLocalizer;

        TempResourceRef(ClassLoader classLoader, String resourceBundleName, String msgKey) {
            super(msgKey);
            this.mLocalizer = MessageLocalizer.createMessageLocalizer(resourceBundleName, null == classLoader ? this.getClass().getClassLoader() : classLoader);
        }

        TempResourceRef(ClassLoader classLoader, String resourceBundleName, String msgKey, Object[] args) {
            super(msgKey, args);
            this.mLocalizer = MessageLocalizer.createMessageLocalizer(resourceBundleName, null == classLoader ? this.getClass().getClassLoader() : classLoader);
        }

        TempResourceRef(String resourceBundleName, String msgKey) {
            this((ClassLoader)null, resourceBundleName, msgKey, null);
        }

        TempResourceRef(String resourceBundleName, String msgKey, Object arg) {
            this((ClassLoader)null, resourceBundleName, msgKey, new Object[]{arg});
        }

        TempResourceRef(String resourceBundleName, String msgKey, Object arg1, Object arg2) {
            this((ClassLoader)null, resourceBundleName, msgKey, new Object[]{arg1, arg2});
        }

        TempResourceRef(String resourceBundleName, String msgKey, Object[] args) {
            this((ClassLoader)null, resourceBundleName, msgKey, args);
        }

        @Override
        protected MessageLocalizer getMessageLocalizer() {
            return this.mLocalizer;
        }
    }
}

