/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.logger;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import oracle.bpel.activityguide.ui.beans.logger.AGLog;
import oracle.bpel.activityguide.ui.beans.logger.AGLogFactory;
import oracle.bpel.activityguide.ui.beans.logger.CommonMsg;
import oracle.bpel.activityguide.ui.beans.logger.ResourceRef;
import oracle.bpel.activityguide.ui.beans.logger.forkparent.ForkMessageLocalizer;

public class MessageLocalizer {
    private static final Locale DEFAULT_LOCALE = ForkMessageLocalizer.DEFAULT_LOCALE != null ? ForkMessageLocalizer.DEFAULT_LOCALE : Locale.US;
    private static final AGLog agLog = AGLogFactory.getLog(MessageLocalizer.class);
    private final Map<Locale, ResourceBundle> mBundleMap;
    private final MessageLocalizer mParentLocalizer;
    private final ClassLoader mClassLoader;
    private final String mBundleName;
    private Set<String> mKeySet;

    public static final MessageLocalizer createMessageLocalizer(String resourceBundle, ClassLoader classLoader) {
        return MessageLocalizer.createMessageLocalizer(null, resourceBundle, classLoader);
    }

    public static final MessageLocalizer createMessageLocalizer(ResourceBundle resourceBundle) {
        if (resourceBundle == null) {
            throw new NullPointerException("resourceBundle");
        }
        return new MessageLocalizer(null, resourceBundle.getClass().getName(), resourceBundle.getClass().getClassLoader(), resourceBundle);
    }

    public static final MessageLocalizer createMessageLocalizer(MessageLocalizer parent, String resourceBundle, ClassLoader classLoader) {
        return new MessageLocalizer(parent, resourceBundle, classLoader, null);
    }

    private MessageLocalizer(MessageLocalizer parent, String bundleName, ClassLoader classLoader, ResourceBundle initialBundle) {
        this.mParentLocalizer = parent;
        this.mBundleMap = new HashMap<Locale, ResourceBundle>();
        this.mClassLoader = classLoader;
        this.mBundleName = bundleName;
        if (initialBundle != null) {
            this.mBundleMap.put(initialBundle.getLocale(), initialBundle);
        }
    }

    public final ResourceBundle getResourceBundle() {
        return this.getResourceBundle(DEFAULT_LOCALE);
    }

    public final synchronized ResourceBundle getResourceBundle(Locale locale) {
        String l_f = "getResourceBundle";
        ResourceBundle bundle = this.mBundleMap.get(locale);
        if (null == bundle) {
            try {
                bundle = ResourceBundle.getBundle(this.mBundleName, locale, this.mClassLoader);
            }
            catch (MissingResourceException err) {
                try {
                    if (agLog.isError()) {
                        agLog.error("getResourceBundle", CommonMsg.ERR_CANNOT_LOAD_RB.instance(this.mBundleName, locale), err);
                    }
                }
                catch (Throwable t) {
                    agLog.throwing("getResourceBundle", t);
                }
            }
            if (null == bundle) {
                if (agLog.isError()) {
                    agLog.error("getResourceBundle", CommonMsg.ERR_CANNOT_LOAD_RB.instance(this.mBundleName, locale));
                }
            } else {
                this.mBundleMap.put(locale, bundle);
            }
        }
        return bundle;
    }

    public final String getResourceBundleName() {
        return this.mBundleName;
    }

    public final boolean containsKey(String key) {
        return this.getKeys().contains(key) || null != this.mParentLocalizer && this.mParentLocalizer.containsKey(key);
    }

    public String localize(String key) {
        return this.localize(DEFAULT_LOCALE, key, null);
    }

    public String localize(Locale locale, String key) {
        return this.localize(locale, key, null);
    }

    public String localize(String key, Object[] args) {
        return this.localize(DEFAULT_LOCALE, key, args);
    }

    public String localize(Locale locale, String key, Object[] args) {
        String l_f = "localize";
        Locale validLocale = null == locale ? DEFAULT_LOCALE : locale;
        String msgKey = null == key ? "null" : key;
        ResourceBundle bundle = this.getResourceBundle(validLocale);
        if (null == bundle) {
            return MessageLocalizer.makeNonlocalizedMsg(msgKey, args);
        }
        try {
            String msg = null;
            try {
                msg = bundle.getString(msgKey);
            }
            catch (Exception err) {
                if (null == this.mParentLocalizer) {
                    if (agLog.isWarn()) {
                        agLog.warn("localize", CommonMsg.ERR_KEY_NOT_IN_RB.instance(msgKey, this.mBundleName), err);
                    }
                    return MessageLocalizer.makeNonlocalizedMsg(msgKey, args);
                }
                return this.mParentLocalizer.localize(locale, msgKey, args);
            }
            if (null == msg) {
                return MessageLocalizer.makeNonlocalizedMsg(msgKey, args);
            }
            if (null != args && args.length > 0) {
                msg = MessageFormat.format(msg, MessageLocalizer.localizeArgs(locale, args));
            }
            return msg;
        }
        catch (Exception err) {
            try {
                if (agLog.isError()) {
                    agLog.error("localize", CommonMsg.ERR_LOCALIZING_RB_MSG.instance(bundle.getClass().getName(), msgKey, err.getMessage()), err);
                }
            }
            catch (Throwable t) {
                agLog.throwing("localize", t);
            }
            return MessageLocalizer.makeNonlocalizedMsg(msgKey, args);
        }
    }

    private synchronized Set<String> getKeys() {
        if (null == this.mKeySet) {
            this.mKeySet = new HashSet<String>();
            ResourceBundle bundle = this.getResourceBundle();
            Enumeration<String> enumeration = bundle.getKeys();
            while (enumeration.hasMoreElements()) {
                this.mKeySet.add(enumeration.nextElement());
            }
        }
        return this.mKeySet;
    }

    private static String makeNonlocalizedMsg(String key, Object[] args) {
        StringBuffer msg = new StringBuffer();
        if (null != key) {
            msg.append(key);
        }
        for (int i = 0; null != args && i < args.length; ++i) {
            msg.append(", ");
            msg.append(args[i]);
        }
        return msg.toString();
    }

    private static final Object[] localizeArgs(Locale locale, Object[] args) {
        if (null == args) {
            return null;
        }
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            result[i] = args[i] instanceof ResourceRef ? ((ResourceRef)args[i]).getString(locale) : ForkMessageLocalizer.localizeArg(locale, args[i]);
        }
        return result;
    }
}

