/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.ui.beans.logger;

import java.util.Locale;
import oracle.bpel.activityguide.ui.beans.logger.AGDetailedException;
import oracle.bpel.activityguide.ui.beans.logger.ResourceRef;
import oracle.bpel.activityguide.ui.beans.logger.forkparent.ForkAGException;

public class AGException
extends ForkAGException
implements AGDetailedException {
    private Locale mLocale = null;
    private ResourceRef mConciseRef;
    private ResourceRef mDetailRef;

    public AGException(ResourceRef reason) {
        this(null, reason, null, null);
    }

    public AGException(Throwable cause) {
        this(null, null, null, cause);
    }

    public AGException(ResourceRef reason, Throwable cause) {
        this(null, reason, null, cause);
    }

    public AGException(ResourceRef reason, ResourceRef details) {
        this(null, reason, details, null);
    }

    public AGException(ResourceRef reason, ResourceRef details, Throwable cause) {
        this(null, reason, details, cause);
    }

    public AGException(Locale locale, ResourceRef reason) {
        this(locale, reason, null, null);
    }

    public AGException(Locale locale, Throwable cause) {
        this(locale, null, null, cause);
    }

    public AGException(Locale locale, ResourceRef reason, ResourceRef details) {
        this(locale, reason, details, null);
    }

    public AGException(Locale locale, ResourceRef reason, Throwable cause) {
        this(locale, reason, null, cause);
    }

    public AGException(Locale locale, ResourceRef reason, ResourceRef details, Throwable cause) {
        this.mLocale = locale;
        this.mConciseRef = reason;
        this.mDetailRef = details;
        this.initCause(cause);
    }

    @Override
    public Locale getLocale() {
        return this.mLocale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.mLocale = locale;
    }

    @Override
    public ResourceRef getMessageRef() {
        return this.mConciseRef;
    }

    @Override
    public ResourceRef getConciseMessageRef() {
        return this.getMessageRef();
    }

    @Override
    public ResourceRef getDetailMessageRef() {
        return this.mDetailRef;
    }

    @Override
    public String getDetailMessage(Locale l) {
        return this.getDetailMessageRef().getString(l);
    }

    @Override
    public void setDetailMessageRef(ResourceRef details) {
        this.mDetailRef = details;
        this.isDetailInternallyGenerated = false;
    }

    @Override
    public String getMessage() {
        if (this.getConciseMessageRef() != null) {
            return this.getConciseMessageRef().getEnglishString();
        }
        return super.getMessage();
    }

    @Override
    public String getLocalizedMessage() {
        if (this.getConciseMessageRef() != null) {
            return this.getConciseMessageRef().getString(this.getLocale());
        }
        return this.getMessage();
    }

    @Override
    public String toString() {
        String concise;
        String s = this.getClass().getName();
        String string = concise = this.getConciseMessageRef() != null ? this.getConciseMessageRef().getString(this.getLocale()) : null;
        if (concise != null) {
            String detail;
            String string2 = detail = this.getDetailMessageRef() != null ? this.getDetailMessageRef().getString(this.getLocale()) : null;
            if (detail != null) {
                return s + ": " + concise + "(" + detail + ")";
            }
            return s + ": " + concise;
        }
        return s;
    }
}

