/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.cli;

import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ResourceBundle;
import oracle.bpel.activityguide.cli.AGPropertyCLISettings;
import oracle.bpel.activityguide.cli.AGPropertyEncrypt;
import oracle.bpel.activityguide.cli.CLIi18nUtil;

public class AGSaveProps {
    private static AGPropertyCLISettings props = new AGPropertyCLISettings();
    private static final boolean useConsole = false;
    private static ResourceBundle cli_rb;

    private String myReadLine(String msg) {
        System.out.println(msg);
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        try {
            msg = br.readLine();
        }
        catch (IOException ioe) {
            System.out.println(cli_rb.getString("IO_READ_ERROR"));
            System.exit(1);
        }
        return msg;
    }

    private boolean getCLIFilename() {
        String filename = this.myReadLine(cli_rb.getString("READ_PROP_FILE_NAME"));
        boolean b = props.testPropertyFilename(filename);
        if (!b) {
            System.out.println(cli_rb.getString("FILE_READ_ERROR") + filename);
            return false;
        }
        File f = new File(filename);
        if (f.exists()) {
            String s = this.myReadLine(cli_rb.getString("CONFIRM_OVERWRITE"));
            if ((s = s.trim()).equals("0")) {
                System.exit(0);
            }
        }
        props.setAGFilename(filename);
        props.setPropFileName(filename);
        return true;
    }

    private void getCLIAuthenticationMethod() {
        while (true) {
            String s;
            if ((s = this.myReadLine(cli_rb.getString("READ_AUTH_MODE"))).isEmpty()) {
                System.out.println(cli_rb.getString("INVALID_INPUT"));
                continue;
            }
            if (s.startsWith("1", 0)) {
                props.setAuthenticationMethod("WORKFLOW_ADMIN_AUTHENTICATION");
                return;
            }
            if (s.startsWith("2", 0)) {
                props.setAuthenticationMethod("IDENTITY_PROPAGATION");
                return;
            }
            System.out.println(cli_rb.getString("INVALID_INPUT"));
        }
    }

    private void getCLIConnectionMode() {
        while (true) {
            String s;
            if ((s = this.myReadLine(cli_rb.getString("READ_CONN_MODE"))).isEmpty()) {
                System.out.println(cli_rb.getString("INVALID_INPUT"));
                continue;
            }
            if (s.startsWith("1", 0)) {
                props.setConnectionMode("SOAP");
                return;
            }
            if (s.startsWith("2", 0)) {
                props.setConnectionMode("REMOTE");
                return;
            }
            System.out.println(cli_rb.getString("INVALID_INPUT"));
        }
    }

    private void getCLIWorkflowAdminUserId() {
        String s;
        while ((s = this.myReadLine(cli_rb.getString("READ_ADMIN_ID"))).isEmpty()) {
            System.out.println(cli_rb.getString("INVALID_INPUT"));
        }
        props.setWorkflowAdminUserId(s);
    }

    private void getCLIWorkflowAdminPassword() {
        String s;
        while ((s = this.readPassword(cli_rb.getString("READ_ADMIN_PWD")).toString()).isEmpty()) {
            System.out.println(cli_rb.getString("INVALID_INPUT"));
        }
        AGPropertyEncrypt e = new AGPropertyEncrypt();
        String ePassword = e.encrpyt(s);
        props.setWorkflowAdminPassword(ePassword);
    }

    private void getCLIWorklistURL() {
        String s = this.myReadLine(cli_rb.getString("READ_WORKLIST_URL"));
        props.setWorklistURL(s);
    }

    private void getCLIRealm() {
        String s = this.myReadLine(cli_rb.getString("READ_REALM"));
        if (s.isEmpty()) {
            s = "jazn.com";
        }
        props.setRealm(s);
    }

    private void getCLIAGSelectionFilter() {
        String s = this.myReadLine(cli_rb.getString("READ_DEFINITION_FILTER"));
        props.setAGDefinitionFilter(s);
    }

    private void getCLISelectionFilter() {
        String s = this.myReadLine(cli_rb.getString("READ_SELECTION_FILTER"));
        props.setSelectionFilter(s);
    }

    private void getCLICustPred1() {
        String s = this.myReadLine(cli_rb.getString("READ_PREDICATE1"));
        props.setCustPred1(s);
    }

    private void getCLICustPred2() {
        String s = this.myReadLine(cli_rb.getString("READ_PREDICATE2"));
        props.setCustPred2(s);
    }

    private void getCLIInstanceID() {
        String s = this.myReadLine(cli_rb.getString("READ_AG_ID"));
        props.setInstanceID(s);
    }

    private void getCLIInstanceOrder() {
        String s = this.myReadLine(cli_rb.getString("READ_ORDERING"));
        props.setInstanceOrder(s);
    }

    public static void main(String[] args) {
        AGSaveProps agSaveProps = new AGSaveProps();
        String[] locale = new String[]{"en", "", ""};
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                locale[i] = args[i];
            }
        }
        cli_rb = CLIi18nUtil.getGsAGCLIResourceBundle(locale);
        String resp = agSaveProps.myReadLine(cli_rb.getString("CONFIRM_SAVE"));
        if ((resp = resp.trim()).equals("1")) {
            if (!agSaveProps.getCLIFilename()) {
                System.out.println(cli_rb.getString("EXIT"));
                System.exit(1);
            }
            agSaveProps.getCLIAuthenticationMethod();
            agSaveProps.getCLIConnectionMode();
            if (props.getAuthenticationMethod().equalsIgnoreCase("WORKFLOW_ADMIN_AUTHENTICATION")) {
                agSaveProps.getCLIWorkflowAdminUserId();
                agSaveProps.getCLIWorkflowAdminPassword();
            }
            String respOpt = agSaveProps.myReadLine(cli_rb.getString("CONFIRM_SAVE_OPTIONAL_PROP"));
            respOpt = resp.trim();
            if (respOpt.equals("1")) {
                agSaveProps.getCLIInstanceID();
                agSaveProps.getCLIAGSelectionFilter();
                agSaveProps.getCLISelectionFilter();
                agSaveProps.getCLICustPred1();
                agSaveProps.getCLICustPred2();
                agSaveProps.getCLIInstanceOrder();
            }
            String saveFile = props.saveProps();
            System.out.println(cli_rb.getString("FILE_WRITTEN") + saveFile);
        }
    }

    private char[] readPassword(String msg) {
        char[] passwd = new char[]{};
        Console cons = System.console();
        if (cons != null && (passwd = cons.readPassword("[%s]", msg)) != null) {
            return passwd;
        }
        System.out.println(cli_rb.getString("EMPTY_PWD"));
        return passwd;
    }
}

