/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpel.activityguide.cli;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import oracle.bpel.activityguide.cli.AGPropertyEncrypt;

public class AGPropertyCLISettings {
    private static final String AG_SYS_PROPERTY_SERVER_AUTHENTICATION_METHOD = "ServerAuthenticationMethod";
    private static final String AG_SYS_PROPERTY_SERVER_CONNECTION_MOE = "ServerConnectionMode";
    private static final String AG_SYS_PROPERTY_WORKLIST_HTTP_URL = "WorklistHttpURL";
    private static final String AG_SYS_PROPERTY_WORKFLOW_ADMIN_USER_ID = "WorkflowAdminUserId";
    private static final String AG_SYS_PROPERTY_WORKFLOW_ADMIN_EPASSWORD = "WorkflowAdminPasswordEncrypted";
    private static final String AG_SYS_PROPERTY_SELECTION_FILTER = "SelectionFilter";
    private static final String AG_SYS_PROPERTY_REALM = "Realm";
    private static final String AG_SYS_PROPERTY_AG_DEFINITION_FILTER = "AGDefinitionFilter";
    private static final String AG_SYS_PROPERTY_AG_INSTANCE_ID = "AGInstanceID";
    private static final String AG_SYS_PROPERTY_AG_INSTANCE_ORDERING = "AGInstanceOrdering";
    private static final String AG_SYS_PROPERTY_CUSTOM_PREDICATE1 = "CustomPredicate1";
    private static final String AG_SYS_PROPERTY_CUSTOM_PREDICATE2 = "CustomPredicate2";
    private static final String AG_SYS_PROPERTY_SHOW_ALL_AG_TREE_NODES_PROPERTIES = "ShowAllAGTreeNodesProperties";
    String AG_AUTH_IDENT_PROPAGATION = "IDENTITY_PROPAGATION";
    String AG_AUTH_WORKFLOW_ADMIN = "WORKFLOW_ADMIN_AUTHENTICATION";
    String AG_INSTANCE = "AG_INSTANCE";
    private static final String AGSYSPROP_DIR = "agui.property.file";
    private static final String propBaseFileName = "activityguide.properties";
    private static final String propDebugPath = "/scratch/cshare/cshare_eventpoc/";
    String _AGPropertyFilename = "";
    private String propFileName = null;
    private Properties agProps = null;

    public void setAGFilename(String filename) {
        this._AGPropertyFilename = filename;
    }

    public String getAGFilename() {
        return this._AGPropertyFilename;
    }

    public boolean testPropertyFilename(String name) {
        try {
            FileOutputStream output = new FileOutputStream(name);
            output.close();
        }
        catch (FileNotFoundException e) {
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private String findPropFilename() {
        this.propFileName = this._AGPropertyFilename;
        if (this.propFileName.equals("")) {
            this.propFileName = System.getProperty(AGSYSPROP_DIR);
        }
        if (this.propFileName == null) {
            this.propFileName = "/scratch/cshare/cshare_eventpoc/activityguide.properties";
        }
        return this.propFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load() {
        if (this.agProps == null) {
            try {
                this.propFileName = this.findPropFilename();
                FileInputStream input = new FileInputStream(this.propFileName);
                this.agProps = new Properties();
                this.agProps.load(input);
                input.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public void reLoad() {
        this.agProps = null;
        this.load();
    }

    public void initSave() {
        if (this.agProps == null) {
            this.agProps = new Properties();
        } else {
            this.agProps.clear();
        }
    }

    public boolean save() {
        FileOutputStream output = null;
        try {
            this.propFileName = this.findPropFilename();
            output = new FileOutputStream(this.propFileName);
            this.agProps.store(output, "ActivityGuide Properties");
            output.close();
        }
        catch (FileNotFoundException e) {
            try {
                output.close();
            }
            catch (IOException f) {
                f.printStackTrace();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String saveProps() {
        this.save();
        return this.propFileName;
    }

    public String getProperty(String key) {
        String propValue;
        if (this.agProps == null) {
            boolean b = this.load();
        }
        try {
            propValue = this.agProps.getProperty(key);
        }
        catch (Exception e) {
            return "";
        }
        return propValue;
    }

    public boolean setProperty(String key, String value) {
        boolean b;
        if (this.agProps == null && !(b = this.load())) {
            return false;
        }
        try {
            this.agProps.setProperty(key, value);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String getpropFileName() {
        return this.propFileName;
    }

    public void setPropFileName(String filename) {
        this._AGPropertyFilename = filename;
    }

    public String getAuthenticationMethod() {
        String value = this.getProperty(AG_SYS_PROPERTY_SERVER_AUTHENTICATION_METHOD);
        return value;
    }

    public void setAuthenticationMethod(String value) {
        this.setProperty(AG_SYS_PROPERTY_SERVER_AUTHENTICATION_METHOD, value);
    }

    public String getConnectionMode() {
        String value = this.getProperty(AG_SYS_PROPERTY_SERVER_CONNECTION_MOE);
        return value;
    }

    public void setConnectionMode(String value) {
        this.setProperty(AG_SYS_PROPERTY_SERVER_CONNECTION_MOE, value);
    }

    public String getWorkflowAdminUserId() {
        String value = this.getProperty(AG_SYS_PROPERTY_WORKFLOW_ADMIN_USER_ID);
        return value;
    }

    public void setWorkflowAdminUserId(String value) {
        this.setProperty(AG_SYS_PROPERTY_WORKFLOW_ADMIN_USER_ID, value);
    }

    public String getWorkflowAdminPassword() {
        String value = this.getProperty(AG_SYS_PROPERTY_WORKFLOW_ADMIN_EPASSWORD);
        return value;
    }

    public void setWorkflowAdminPassword(String value) {
        AGPropertyEncrypt e = new AGPropertyEncrypt();
        String eValue = e.encrpyt(value);
        this.setProperty(AG_SYS_PROPERTY_WORKFLOW_ADMIN_EPASSWORD, eValue);
    }

    public String getRealm() {
        String value = this.getProperty(AG_SYS_PROPERTY_REALM);
        return value;
    }

    public void setRealm(String value) {
        this.setProperty(AG_SYS_PROPERTY_REALM, value);
    }

    public String getInstanceID() {
        String value = this.getProperty(AG_SYS_PROPERTY_AG_INSTANCE_ID);
        return value;
    }

    public void setInstanceID(String value) {
        if (value != null && !value.equals("")) {
            this.setProperty(AG_SYS_PROPERTY_AG_INSTANCE_ID, value);
        }
    }

    public String getWorklistURL() {
        String value = this.getProperty(AG_SYS_PROPERTY_WORKLIST_HTTP_URL);
        return value;
    }

    public void setWorklistURL(String value) {
        this.setProperty(AG_SYS_PROPERTY_WORKLIST_HTTP_URL, value);
    }

    public String getAGDefinitionFilter() {
        String value = this.getProperty(AG_SYS_PROPERTY_AG_DEFINITION_FILTER);
        return value;
    }

    public void setAGDefinitionFilter(String value) {
        if (value != null && !value.equals("")) {
            this.setProperty(AG_SYS_PROPERTY_AG_DEFINITION_FILTER, value);
        }
    }

    public String getSelectionFilter() {
        String value = this.getProperty(AG_SYS_PROPERTY_SELECTION_FILTER);
        return value;
    }

    public void setSelectionFilter(String value) {
        this.setProperty(AG_SYS_PROPERTY_SELECTION_FILTER, value);
    }

    public String getInstanceOrder() {
        String value = this.getProperty(AG_SYS_PROPERTY_AG_INSTANCE_ORDERING);
        return value;
    }

    public void setInstanceOrder(String value) {
        if (value != null && !value.equals("")) {
            this.setProperty(AG_SYS_PROPERTY_AG_INSTANCE_ORDERING, value);
        }
    }

    public String getCustPred1() {
        String value = this.getProperty(AG_SYS_PROPERTY_CUSTOM_PREDICATE1);
        return value;
    }

    public void setCustPred1(String value) {
        if (value != null && !value.equals("")) {
            this.setProperty(AG_SYS_PROPERTY_CUSTOM_PREDICATE1, value);
        }
    }

    public String getCustPred2() {
        String value = this.getProperty(AG_SYS_PROPERTY_CUSTOM_PREDICATE2);
        return value;
    }

    public void setCustPred2(String value) {
        if (value != null && !value.equals("")) {
            this.setProperty(AG_SYS_PROPERTY_CUSTOM_PREDICATE2, value);
        }
    }
}

