/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import oracle.bpm.io.fs.VEventType;
import oracle.bpm.io.fs.VFile;
import oracle.bpm.io.fs.VFileEvent;
import oracle.bpm.io.fs.VFileEventListener;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.protocol.VFileURLConnection;
import oracle.bpm.io.fs.protocol.vfile.Handler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VFileSystem {
    private int delayDispatchCount;
    private final Object delayedDispatchLock = new Object();
    @NotNull
    private Collection<VFileEvent> delayedEvents = Collections.emptyList();
    private final Map<VFileEventListener, Object> listeners = new LinkedHashMap<VFileEventListener, Object>();
    private static final Object DUMMY = new Object();

    public abstract void flush() throws IOException;

    public abstract List<String> getURIParts(@NotNull VFile var1);

    public abstract VFile[] list(@NotNull VFile var1, @Nullable VFileFilter var2) throws IOException;

    public VFile getRoot() {
        return this.createFile("/");
    }

    public VFile createFile(@NotNull String location) {
        if (location == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.createFile must not be null");
        }
        return new VFile(this, location.replace(File.separatorChar, '/'));
    }

    public VFile createFile(@NotNull VFile parent, @NotNull String child) {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.createFile must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.createFile must not be null");
        }
        return new VFile(this, parent, child.replace(File.separatorChar, '/'));
    }

    public final void addListener(@NotNull VFileEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.addListener must not be null");
        }
        this.listeners.put(listener, DUMMY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(@NotNull VFileEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.removeListener must not be null");
        }
        Map<VFileEventListener, Object> map = this.listeners;
        synchronized (map) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearListeners() {
        Map<VFileEventListener, Object> map = this.listeners;
        synchronized (map) {
            this.listeners.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithEventsDelayed(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.runWithEventsDelayed must not be null");
        }
        try {
            this.pauseEventDispatch();
            runnable.run();
        }
        finally {
            this.resumeEventDispatch();
        }
    }

    public void closeOutputStream(@NotNull VFile vFile) throws IOException {
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.closeOutputStream must not be null");
        }
        VEventType eventType = vFile.isCreated() ? VEventType.ADD : VEventType.CHANGE;
        this.fireEvent(new VFileEvent(eventType, vFile));
    }

    protected abstract long lastModified(@NotNull VFile var1) throws IOException;

    protected abstract boolean isZeroLength(@NotNull VFile var1) throws IOException;

    protected abstract boolean delete(@NotNull VFile var1) throws IOException;

    protected abstract boolean mkdirs(@NotNull VFile var1) throws IOException;

    protected abstract boolean exists(@NotNull VFile var1) throws IOException;

    protected abstract boolean isDirectory(@NotNull VFile var1) throws IOException;

    protected abstract boolean canWrite(@NotNull VFile var1) throws IOException;

    protected abstract InputStream openInputStream(@NotNull VFile var1) throws IOException;

    protected abstract OutputStream openOutputStream(@NotNull VFile var1) throws IOException;

    protected abstract boolean isHidden(@NotNull VFile var1) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    protected URL createUrl(@NotNull VFile vFile) throws IOException {
        URL uRL;
        if (vFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.createUrl must not be null");
        }
        StringBuilder sb = new StringBuilder();
        try {
            byte[] bytes;
            MessageDigest md = MessageDigest.getInstance("MD5");
            List<String> strings = this.getURIParts(vFile);
            for (String part : strings) {
                md.update(part.getBytes());
            }
            for (byte aByte : bytes = md.digest()) {
                sb.append(Integer.toHexString(0xFF & aByte));
            }
            String path = vFile.getCanonicalPath().replaceAll(" ", "%20");
            String urlString = "vfile://" + sb.toString() + ":" + path;
            URL url = new URL(null, urlString, Handler.getInstance());
            VFileURLConnection.register(url, vFile);
            uRL = url;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (uRL == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/VFileSystem.createUrl must not return null");
        }
        return uRL;
    }

    protected final void fireEvent(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.fireEvent must not be null");
        }
        if (this.fireEventInternal(event)) {
            this.dispatchEvent(event);
        }
    }

    protected boolean fireEventInternal(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.fireEventInternal must not be null");
        }
        return true;
    }

    protected final void dispatchEvent(@NotNull VFileEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFileSystem.dispatchEvent must not be null");
        }
        if (this.isDispatchDelayed()) {
            this.delayedEvents.add(event);
        } else {
            this.dispatchEvent0(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumeEventDispatch() {
        Collection<Object> delayedEvents;
        Object object = this.delayedDispatchLock;
        synchronized (object) {
            assert (this.delayDispatchCount > 0);
            if (--this.delayDispatchCount == 0) {
                delayedEvents = this.delayedEvents;
                this.delayedEvents = Collections.emptyList();
            } else {
                delayedEvents = Collections.emptyList();
            }
        }
        for (VFileEvent vFileEvent : delayedEvents) {
            this.dispatchEvent0(vFileEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pauseEventDispatch() {
        Object object = this.delayedDispatchLock;
        synchronized (object) {
            if (++this.delayDispatchCount == 1) {
                this.delayedEvents = new ConcurrentLinkedQueue<VFileEvent>();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDispatchDelayed() {
        Object object = this.delayedDispatchLock;
        synchronized (object) {
            return this.delayDispatchCount > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvent0(VFileEvent event) {
        ArrayList<VFileEventListener> safeCopy;
        Map<VFileEventListener, Object> map = this.listeners;
        synchronized (map) {
            safeCopy = new ArrayList<VFileEventListener>(this.listeners.keySet());
        }
        for (VFileEventListener listener : safeCopy) {
            listener.onFileEvent(event);
        }
    }
}

