/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.io.fs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.LinkedList;
import oracle.bpm.io.fs.VFileFilter;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.VFileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VFile
implements Serializable,
Comparable<VFile> {
    @Nullable
    private transient String canonicalPathCache;
    private transient VFileSystem fileSystem;
    private boolean isCreated;
    @NotNull
    private final String location;
    private transient VFile parentVFile;
    private transient String vFileName;
    public static final char separatorChar = '/';
    public static final String separator = "/";
    private static final long serialVersionUID = 0L;

    VFile(@NotNull VFileSystem fileSystem, @NotNull String location) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFile.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFile.<init> must not be null");
        }
        this.fileSystem = fileSystem;
        this.location = location;
    }

    VFile(@NotNull VFileSystem fileSystem, @NotNull VFile parent, @NotNull String child) {
        if (fileSystem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/io/fs/VFile.<init> must not be null");
        }
        if (parent == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/io/fs/VFile.<init> must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/io/fs/VFile.<init> must not be null");
        }
        this.fileSystem = fileSystem;
        String path = parent.getCanonicalPath();
        StringBuilder builder = new StringBuilder().append(path);
        String sep = separator;
        if (!separator.equals(path)) {
            builder.append(separator);
        }
        this.location = builder.append(child).toString();
    }

    public void setCreated(boolean isCreated) {
        this.isCreated = isCreated;
    }

    public VFile getParentFile() {
        if (this.parentVFile == null) {
            LinkedList<String> path = VFileUtils.canonicalDecomposition(this.location);
            if (path.size() > 1) {
                path.removeLast();
                String pathName = VFileUtils.makePathName(path);
                if (this != this.getFileSystem().getRoot() && pathName.endsWith(separator)) {
                    pathName = pathName.substring(0, pathName.length() - separator.length());
                }
                this.parentVFile = new VFile(this.getFileSystem(), pathName);
            } else {
                this.parentVFile = null;
            }
        }
        return this.parentVFile;
    }

    public boolean delete() throws IOException {
        return this.getFileSystem().delete(this);
    }

    public String getName() {
        if (this.vFileName == null) {
            LinkedList<String> path = VFileUtils.canonicalDecomposition(this.location);
            this.vFileName = path.getLast();
            if (this.vFileName.endsWith(separator)) {
                this.vFileName = this.vFileName.substring(0, this.vFileName.length() - 1);
            }
        }
        return this.vFileName;
    }

    public boolean mkdirs() throws IOException {
        return this.getFileSystem().mkdirs(this);
    }

    public VFile getCanonicalFile() throws IOException {
        return new VFile(this.fileSystem, this.getCanonicalPath());
    }

    public boolean exists() throws IOException {
        return this.getFileSystem().exists(this);
    }

    public boolean isDirectory() throws IOException {
        return this.fileSystem == null ? this.location.endsWith(separator) : this.getFileSystem().isDirectory(this);
    }

    public VFile[] listFiles(@Nullable VFileFilter filter) throws IOException {
        return this.getFileSystem().list(this, filter);
    }

    public String getCanonicalPath() {
        if (this.canonicalPathCache == null) {
            if (this.location.isEmpty()) {
                return separator;
            }
            LinkedList<String> parts = VFileUtils.canonicalDecomposition(this.location);
            this.canonicalPathCache = VFileUtils.makePathName(parts);
        }
        return this.canonicalPathCache;
    }

    public boolean canWrite() throws IOException {
        return this.getFileSystem().canWrite(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public VFileSystem getFileSystem() {
        if (this.fileSystem == null) {
            throw new IllegalStateException(this + " is not bound to a filesystem");
        }
        VFileSystem vFileSystem = this.fileSystem;
        if (vFileSystem == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/VFile.getFileSystem must not return null");
        }
        return vFileSystem;
    }

    public String toString() {
        return this.location;
    }

    @Override
    public int compareTo(VFile o) {
        return this.getCanonicalPath().compareTo(o.getCanonicalPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFile vFile = (VFile)o;
        return this.compareTo(vFile) == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public URL toURL() throws IOException {
        URL uRL = this.fileSystem.createUrl(this);
        if (uRL == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/io/fs/VFile.toURL must not return null");
        }
        return uRL;
    }

    public long lastModified() throws IOException {
        return this.fileSystem.lastModified(this);
    }

    public boolean isZeroLength() throws IOException {
        return this.fileSystem.isZeroLength(this);
    }

    public boolean isHidden() throws IOException {
        return this.fileSystem.isHidden(this);
    }

    public int hashCode() {
        return this.getCanonicalPath().hashCode();
    }

    public InputStream openInputStream() throws IOException {
        return this.getFileSystem().openInputStream(this);
    }

    public OutputStream openOuputStream() throws IOException {
        return this.getFileSystem().openOutputStream(this);
    }

    public boolean isCreated() {
        return this.isCreated;
    }

    void closeOutputStream() throws IOException {
        this.getFileSystem().closeOutputStream(this);
    }
}

