/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.bpm.lang.DynamicObject;
import oracle.bpm.util.Base64;
import oracle.bpm.xml.DeserializationException;
import oracle.bpm.xml.Deserializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLDeserializer
implements Deserializer,
ErrorHandler {
    public static <T> T deserializeObjectFromString(String serializedObject, Class<T> aClass) throws DeserializationException {
        XMLDeserializer xmlDeserializer = new XMLDeserializer();
        DynamicObject dynamicObject = xmlDeserializer.parse(new StringReader(serializedObject));
        return dynamicObject.convertTo(aClass);
    }

    @Override
    public void error(SAXParseException saxparseexception) {
        System.err.println("[Error] " + this.getLocationString(saxparseexception) + ": " + saxparseexception.getMessage());
    }

    @Override
    public void fatalError(SAXParseException saxparseexception) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(saxparseexception) + ": " + saxparseexception.getMessage());
        throw saxparseexception;
    }

    @Override
    public DynamicObject parse(InputStream istream) throws DeserializationException {
        try {
            Document document = this.parse(new InputSource(istream));
            return DynamicObject.valueOf(this.buildObject(document.getDocumentElement()));
        }
        catch (IOException e) {
            throw (DeserializationException)new DeserializationException().initCause(e);
        }
        catch (SAXException e) {
            throw (DeserializationException)new DeserializationException().initCause(e);
        }
    }

    public DynamicObject parse(Reader reader) throws DeserializationException {
        try {
            Document document = this.parse(new InputSource(reader));
            return DynamicObject.valueOf(this.buildObject(document.getDocumentElement()));
        }
        catch (IOException e) {
            throw (DeserializationException)new DeserializationException().initCause(e);
        }
        catch (SAXException e) {
            throw (DeserializationException)new DeserializationException().initCause(e);
        }
    }

    @Override
    public void warning(SAXParseException saxparseexception) {
        System.err.println("[Warning] " + this.getLocationString(saxparseexception) + ": " + saxparseexception.getMessage());
    }

    protected Object buildComposite(NodeList nodelist, String className, Map<String, DynamicObject> references, String id) {
        DynamicObject dobj = DynamicObject.create();
        dobj.setJavaClassName(className);
        if (id != null) {
            references.put(id, dobj);
        }
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            if (node.getNodeType() != 1) continue;
            String nodeName = node.getNodeName();
            if ("__outerInstance".equals(nodeName)) {
                nodeName = "this$0";
                System.out.println("nodeName = " + nodeName);
            }
            dobj.setField(nodeName, this.buildObject(node, references));
        }
        return dobj;
    }

    protected Object buildObject(Node parentNode) {
        return this.buildObject(parentNode, new HashMap<String, DynamicObject>());
    }

    protected Document parse(InputSource inputSource) throws SAXException, IOException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            docBuilder.setErrorHandler(this);
            return docBuilder.parse(inputSource);
        }
        catch (FactoryConfigurationError factoryConfigError) {
            throw new SAXException(factoryConfigError.getMessage());
        }
        catch (ParserConfigurationException parserConfigException) {
            throw new SAXException(parserConfigException.getMessage());
        }
    }

    protected Document parse(String stringURI) throws SAXException, IOException {
        return this.parse(new InputSource(stringURI));
    }

    private String getLocationString(SAXParseException saxparseexception) {
        StringBuffer stringbuffer = new StringBuffer();
        String stringSystemId = saxparseexception.getSystemId();
        if (stringSystemId != null) {
            int n = stringSystemId.lastIndexOf(47);
            if (n > -1) {
                stringSystemId = stringSystemId.substring(n + 1);
            }
            stringbuffer.append(stringSystemId);
        }
        stringbuffer.append(':');
        stringbuffer.append(saxparseexception.getLineNumber());
        stringbuffer.append(':');
        stringbuffer.append(saxparseexception.getColumnNumber());
        return stringbuffer.toString();
    }

    private Object buildArray(NodeList nodelist, Map<String, DynamicObject> references) {
        DynamicObject list = DynamicObject.createList();
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            if (node.getNodeType() != 1) continue;
            list.addElement(this.buildObject(node, references));
        }
        return list;
    }

    private Object buildBinary(NodeList nodelist) {
        return Base64.decode(this.buildString(nodelist));
    }

    private Boolean buildBoolean(NodeList nodelist) {
        return Boolean.valueOf(this.buildString(nodelist));
    }

    private Double buildDouble(NodeList nodelist) {
        return Double.valueOf(this.buildString(nodelist));
    }

    private Long buildLong(NodeList nodelist) {
        return Long.valueOf(this.buildString(nodelist));
    }

    private Object buildMap(NodeList nodelist, Map<String, DynamicObject> references) {
        DynamicObject map = DynamicObject.createMap();
        Node keyNode = null;
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node node = nodelist.item(i);
            if (node.getNodeType() != 1) continue;
            if (keyNode == null) {
                keyNode = node;
                continue;
            }
            map.setElement(this.buildObject(keyNode, references), this.buildObject(node, references));
            keyNode = null;
        }
        return map;
    }

    private Object buildObject(Node parentNode, Map<String, DynamicObject> references) {
        String isItNull;
        NodeList nodelist = parentNode.getChildNodes();
        Node nullNode = parentNode.getAttributes().getNamedItem("xsi:null");
        if (nullNode != null && (isItNull = nullNode.getNodeValue()).equals("1")) {
            return DynamicObject.NULL;
        }
        Node typeNode = parentNode.getAttributes().getNamedItem("xsi:type");
        Node refNode = parentNode.getAttributes().getNamedItem("ref");
        Node idNode = parentNode.getAttributes().getNamedItem("id");
        if (refNode != null) {
            return references.get(refNode.getNodeValue());
        }
        if (typeNode != null) {
            String type = typeNode.getNodeValue();
            if (type.equals("SOAP-ENC:base64")) {
                return this.buildBinary(parentNode.getChildNodes());
            }
            if (type.equals("array")) {
                return this.buildArray(parentNode.getChildNodes(), references);
            }
            if (type.equals("map")) {
                return this.buildMap(parentNode.getChildNodes(), references);
            }
            if (type.equals("long")) {
                return this.buildLong(parentNode.getChildNodes());
            }
            if (type.equals("double")) {
                return this.buildDouble(parentNode.getChildNodes());
            }
            if (type.equals("boolean")) {
                return this.buildBoolean(parentNode.getChildNodes());
            }
            return this.buildComposite(parentNode.getChildNodes(), type, references, idNode != null ? idNode.getNodeValue() : null);
        }
        int elementNodes = 0;
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node n = nodelist.item(i);
            if (n.getNodeType() != 1) continue;
            ++elementNodes;
        }
        if (elementNodes == 0) {
            return this.buildString(nodelist);
        }
        return this.buildComposite(parentNode.getChildNodes(), null, references, idNode != null ? idNode.getNodeValue() : null);
    }

    private String buildString(NodeList nodelist) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < nodelist.getLength(); ++i) {
            Node n = nodelist.item(i);
            if (n.getNodeType() != 3) continue;
            result.append(n.getNodeValue());
        }
        return result.toString();
    }
}

