/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.data;

import java.net.InetAddress;
import java.net.UnknownHostException;
import oracle.bpm.lang.Str;

public class ServerLocation {
    public String homeDir;
    public String host;
    public String logDir;
    public String webconsoleURL;
    public static final String LOCALHOST = "$LOCALHOST$";
    public static final String DEFAULT_WEBCONSOLE_URL = "http://$LOCALHOST$:9595/webconsole";

    public ServerLocation() {
    }

    public ServerLocation(String host) {
        this(host, ServerLocation.getDefaultWebconsoleURL(host));
    }

    public ServerLocation(String host, String webconsoleURL) {
        this(host, webconsoleURL, null, null);
    }

    public ServerLocation(String host, String webconsoleURL, String logDir, String homeDir) {
        try {
            if (host != null && host.equals(LOCALHOST)) {
                host = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        this.host = host;
        this.webconsoleURL = webconsoleURL;
        this.logDir = logDir;
        this.homeDir = homeDir;
    }

    public String getHomeDir() {
        return Str.replace(this.homeDir, "$HOME$", System.getProperty("user.home"));
    }

    public String getHost() {
        try {
            if (this.host != null && this.host.equals(LOCALHOST)) {
                this.host = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return this.host;
    }

    public String getLogDir() {
        return Str.replace(this.logDir, "$HOME$", System.getProperty("user.home"));
    }

    public String getWebconsoleURL() {
        return this.webconsoleURL;
    }

    public boolean equals(ServerLocation sl) {
        try {
            InetAddress[] hostIPs = InetAddress.getAllByName(this.getHost());
            InetAddress[] targetHostIPs = InetAddress.getAllByName(sl.getHost());
            for (int i = 0; i < hostIPs.length; ++i) {
                InetAddress hostIP = hostIPs[i];
                for (int j = 0; j < targetHostIPs.length; ++j) {
                    InetAddress targetHost = targetHostIPs[j];
                    if (!hostIP.equals(targetHost)) continue;
                    return true;
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public String toString() {
        return "ServerLocation[host=" + this.getHost() + ", webconsoleURL=" + this.webconsoleURL + ", logDir=" + this.getLogDir() + ", homeDir= " + this.getHomeDir() + "]";
    }

    private static String getDefaultWebconsoleURL(String host) {
        return "http://" + host + ":9595/webconsole";
    }
}

