/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.storage;

import fuego.prefs.CustomStoragePreference;
import fuego.prefs.StringPreference;
import fuego.prefs.engine.storage.BackingStoreListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.prefs.BackingStoreException;
import oracle.bpm.lang.exception.ProgramException;

public class FileSystemStore
implements BackingStoreListener {
    private StringPreference outPutDirPreference;
    private CustomStoragePreference preference;
    private static final String PROPERTIES_FILE_NAME = "engine.properties";

    public FileSystemStore(CustomStoragePreference preference, StringPreference outPutDirPreference) {
        this.preference = preference;
        this.outPutDirPreference = outPutDirPreference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws BackingStoreException {
        File propertiesFile = this.getPropertiesFile();
        if (propertiesFile.exists()) {
            Properties properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(propertiesFile);
                try {
                    properties.load(fileInputStream);
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
                this.preference.setStoredValue((String)properties.get(this.preference.getKey()));
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store() throws BackingStoreException {
        File propertiesFile = this.getPropertiesFile();
        Properties properties = new Properties();
        try {
            try {
                FileInputStream fileInputStream = new FileInputStream(propertiesFile);
                try {
                    properties.load(fileInputStream);
                }
                finally {
                    ((InputStream)fileInputStream).close();
                }
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            if (!propertiesFile.getParentFile().exists() && !propertiesFile.getParentFile().mkdirs()) {
                throw new ProgramException(propertiesFile.getParent() + "dirs could not be created.");
            }
            properties.put(this.preference.getKey(), this.preference.getValueToStore());
            FileOutputStream fileOutputStream = new FileOutputStream(propertiesFile);
            try {
                properties.store(fileOutputStream, null);
            }
            finally {
                ((OutputStream)fileOutputStream).close();
            }
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
    }

    private File getPropertiesFile() {
        return new File(this.outPutDirPreference.getValue().concat(File.separator).concat(PROPERTIES_FILE_NAME));
    }
}

