/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.storage;

import fuego.directory.DirEngine;
import fuego.directory.DirEngineConfiguration;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.prefs.engine.EngineType;
import fuego.prefs.engine.storage.BackingStoreListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Id;
import oracle.bpm.lang.Literals;
import oracle.bpm.log.Log;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EnginePreferencesNode
extends AbstractPreferences {
    private List<BackingStoreListener> backingStoreListeners;
    private StringList childs;
    private String configuration;
    private boolean export;
    private Map<String, String> prefs;
    private static final String PREFERENCES_DTD = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!-- DTD for preferences --><!ELEMENT preferences (root) ><!ATTLIST preferences EXTERNAL_XML_VERSION CDATA \"0.0\"  ><!ELEMENT root (map, node*) ><!ATTLIST root          type (system|user) #REQUIRED ><!ELEMENT node (map, node*) ><!ATTLIST node          name CDATA #REQUIRED ><!ELEMENT map (entry*) ><!ATTLIST map  MAP_XML_VERSION CDATA \"0.0\"  ><!ELEMENT entry EMPTY ><!ATTLIST entry          key CDATA #REQUIRED          value CDATA #REQUIRED >";
    private static final String PREFERENCES_DTD_URI = "http://java.sun.com/dtd/preferences.dtd";
    private static final String XML_VERSION = "1.0";
    public static final String ENGINE_ENCODING = Literals.DEFAULT_ENCODING;
    private static final String ROOT_NAME = "";

    public EnginePreferencesNode(String configuration) {
        this(null, ROOT_NAME, configuration);
    }

    private EnginePreferencesNode(EnginePreferencesNode parent, String name) {
        this(parent, name, parent.configuration);
    }

    private EnginePreferencesNode(EnginePreferencesNode parent, String name, String configuration) {
        super(parent, name);
        this.configuration = configuration;
        this.prefs = new TreeMap<String, String>();
        this.childs = StringList.create();
        this.backingStoreListeners = new ArrayList<BackingStoreListener>();
    }

    public static DirEngineConfiguration fetchEngineConfiguration(String serverId, String configuration, DirectorySession directorySession) throws DirectoryException {
        return DirEngineConfiguration.fetch(directorySession, configuration, serverId);
    }

    public String getConfiguration() {
        return this.configuration;
    }

    public void export(OutputStream outputStream) throws BackingStoreException, IOException {
        this.export(outputStream, "UTF-8");
    }

    public void export(OutputStream outputStream, String encoding) throws BackingStoreException, IOException {
        DocumentBuilder builder;
        if (this.isRemoved()) {
            throw new IllegalStateException("Node has been removed");
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.toString());
        }
        Document doc = builder.newDocument();
        doc.appendChild(doc.createProcessingInstruction("fuego", Id.getFuegoProcessingInstructionData()));
        Element preferences = (Element)doc.appendChild(doc.createElement("preferences"));
        preferences.setAttribute("EXTERNAL_XML_VERSION", XML_VERSION);
        Element xmlRoot = (Element)preferences.appendChild(doc.createElement("root"));
        xmlRoot.setAttribute("type", this.isUserNode() ? "user" : "system");
        ArrayList<EnginePreferencesNode> ancestors = new ArrayList<EnginePreferencesNode>();
        Preferences child = this;
        Preferences parent = child.parent();
        while (parent != null) {
            ancestors.add((EnginePreferencesNode)child);
            child = parent;
            parent = child.parent();
        }
        Element e = xmlRoot;
        for (int i = ancestors.size() - 1; i >= 0; --i) {
            e.appendChild(doc.createElement("map"));
            e = (Element)e.appendChild(doc.createElement("node"));
            e.setAttribute("name", ((Preferences)ancestors.get(i)).name());
        }
        EnginePreferencesNode.putPreferencesInXml(e, doc, this, true);
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("doctype-system", PREFERENCES_DTD_URI);
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", encoding);
            DOMSource source = new DOMSource(doc);
            StreamResult result = new StreamResult(outputStream);
            transformer.transform(source, result);
            outputStream.flush();
        }
        catch (TransformerConfigurationException tce) {
            throw new IOException(tce.toString());
        }
        catch (TransformerException te) {
            throw new IOException(te.toString());
        }
    }

    @Override
    public void flush() {
        assert (false) : "Use flush(DirectorySession) instead of this";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush(String serverId, OutputStream os, String encoding) throws BackingStoreException {
        this.notifyStoreToListeners();
        Object object = this.lock;
        synchronized (object) {
            try {
                this.export(os, encoding);
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
    }

    public void flush(String serverId, DirectorySession dirSession) throws BackingStoreException {
        if (!this.export) {
            Log.logTrace("This is going to fail in FDI since no modifications were done to this preferences. flush should not have been called");
            assert (this.dumpStack()) : "Previous stack trace should help debugging unmodified properties object trying to be stored";
            return;
        }
        try {
            DirEngine engine = DirEngine.fetch(dirSession, serverId);
            if (engine == null) {
                DirEngine.create(dirSession, serverId);
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this.flush(serverId, os, "UTF-8");
            DirEngineConfiguration engineConf = EnginePreferencesNode.fetchEngineConfiguration(serverId, this.configuration, dirSession);
            if (engineConf == null) {
                DirEngineConfiguration.create(dirSession, this.configuration, serverId, os.toString("UTF-8"));
            } else {
                engineConf.setProperties(os.toString("UTF-8"));
                engineConf.update();
            }
        }
        catch (DirectoryException e) {
            throw new BackingStoreException(e);
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
        this.export = false;
    }

    public String get(String key) {
        return this.getSpi(key);
    }

    public boolean getExport() {
        return this.export;
    }

    public EngineType getType() throws BackingStoreException {
        if (this.parent() != null) {
            return ((EnginePreferencesNode)this.parent()).getType();
        }
        String[] childs = this.childrenNames();
        assert (childs.length > 0) : "Root node must contain at least one child";
        return EngineType.valueOf(childs[0]) == null ? EngineType.ENTERPRISE : EngineType.valueOf(childs[0]);
    }

    @Override
    public boolean isUserNode() {
        return true;
    }

    public void merge(EnginePreferencesNode root) throws BackingStoreException, IOException, InvalidPreferencesFormatException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        root.exportSubtree(outputStream);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        this.sync(inputStream);
        outputStream.close();
        inputStream.close();
    }

    public void notifyLoadToListeners() {
        try {
            for (BackingStoreListener backingStoreListener : this.backingStoreListeners) {
                backingStoreListener.load();
            }
        }
        catch (BackingStoreException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerBackingStoreListener(BackingStoreListener backingStoreListener) {
        this.backingStoreListeners.add(backingStoreListener);
    }

    public void setExport(boolean export) {
        this.export = export;
    }

    @Override
    public void sync() {
        assert (false) : "Use sync(DirectorySession) instead of this";
    }

    public void sync(InputStream istr) throws IOException, InvalidPreferencesFormatException {
        try {
            Document doc = EnginePreferencesNode.load(istr);
            String xmlVersion = doc.getDocumentElement().getAttribute("EXTERNAL_XML_VERSION");
            if (xmlVersion.compareTo(XML_VERSION) > 0) {
                throw new InvalidPreferencesFormatException("Exported preferences file format version " + xmlVersion + " is not supported. This java installation can read" + " versions " + XML_VERSION + " or older. You may need" + " to install a newer version of JDK.");
            }
            Element xmlRoot = (Element)doc.getDocumentElement().getChildNodes().item(0);
            EnginePreferencesNode.ImportSubtree(this, xmlRoot);
        }
        catch (SAXException e) {
            throw new InvalidPreferencesFormatException(e);
        }
    }

    public void sync(String serverId, DirectorySession directorySession) throws BackingStoreException, InvalidPreferencesFormatException {
        this.notifyLoadToListeners();
        try {
            DirEngineConfiguration engineConf = EnginePreferencesNode.fetchEngineConfiguration(serverId, this.configuration, directorySession);
            if (engineConf == null) {
                return;
            }
            String p = engineConf.getProperties();
            ByteArrayInputStream istr = new ByteArrayInputStream(p.getBytes(ENGINE_ENCODING));
            this.sync(istr);
        }
        catch (DirectoryException e) {
            throw new BackingStoreException(e);
        }
        catch (IOException e) {
            throw new BackingStoreException(e);
        }
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return this.childs.toArray();
    }

    @Override
    protected AbstractPreferences childSpi(String name) {
        EnginePreferencesNode child = this.parent() == null && EngineType.valueOf(name) == null ? new EnginePreferencesNode(this, EngineType.ENTERPRISE.toString()) : new EnginePreferencesNode(this, name);
        this.childs.add(name);
        return child;
    }

    @Override
    protected void flushSpi() throws BackingStoreException {
    }

    @Override
    protected String getSpi(String key) {
        return this.prefs.get(key);
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        Set<String> keys = this.prefs.keySet();
        return keys.toArray(new String[keys.size()]);
    }

    @Override
    protected void putSpi(String key, String value) {
        this.prefs.put(key, value);
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        EnginePreferencesNode parent = (EnginePreferencesNode)this.parent();
        if (parent != null) {
            parent.removeChild(this.name());
        }
    }

    @Override
    protected void removeSpi(String key) {
        this.prefs.remove(key);
    }

    @Override
    protected void syncSpi() throws BackingStoreException {
    }

    private static void ImportPrefs(Preferences prefsNode, Element map) {
        NodeList entries = map.getChildNodes();
        int numEntries = entries.getLength();
        for (int i = 0; i < numEntries; ++i) {
            Element entry = (Element)entries.item(i);
            prefsNode.put(entry.getAttribute("key"), entry.getAttribute("value"));
        }
    }

    private static void ImportSubtree(Preferences prefsNode, Element xmlNode) {
        int i;
        NodeList xmlChildren = xmlNode.getChildNodes();
        int numXmlChildren = xmlChildren.getLength();
        if (((EnginePreferencesNode)prefsNode).isRemoved()) {
            return;
        }
        Element firstXmlChild = (Element)xmlChildren.item(0);
        EnginePreferencesNode.ImportPrefs(prefsNode, firstXmlChild);
        Preferences[] prefsChildren = new Preferences[numXmlChildren - 1];
        for (i = 1; i < numXmlChildren; ++i) {
            Element xmlKid = (Element)xmlChildren.item(i);
            prefsChildren[i - 1] = prefsNode.node(xmlKid.getAttribute("name"));
        }
        for (i = 1; i < numXmlChildren; ++i) {
            EnginePreferencesNode.ImportSubtree(prefsChildren[i - 1], (Element)xmlChildren.item(i));
        }
    }

    private static Document load(InputStream inputStream) throws SAXException, IOException {
        DocumentBuilderFactory dbf = EnginePreferencesNode.createDocumentBuilderFactory();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(new EH());
            db.setEntityResolver(new Resolver());
            InputSource source = new InputSource(inputStream);
            return db.parse(source);
        }
        catch (ParserConfigurationException exception) {
            throw new Error(exception);
        }
    }

    private static DocumentBuilderFactory createDocumentBuilderFactory() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setValidating(true);
        dbf.setCoalescing(true);
        dbf.setIgnoringComments(true);
        return dbf;
    }

    private static void putPreferencesInXml(Element elt, Document doc, Preferences prefs, boolean subTree) throws BackingStoreException {
        int i;
        if (((EnginePreferencesNode)prefs).isRemoved()) {
            elt.getParentNode().removeChild(elt);
            return;
        }
        Preferences[] childrenCopy = null;
        String[] childrenNames = null;
        String[] keys = prefs.keys();
        Element map = (Element)elt.appendChild(doc.createElement("map"));
        EnginePreferencesNode.setAttributes(doc, prefs, keys, map);
        if (subTree) {
            childrenNames = prefs.childrenNames();
            childrenCopy = new Preferences[childrenNames.length];
            for (i = 0; i < childrenNames.length; ++i) {
                childrenCopy[i] = prefs.node(childrenNames[i]);
            }
        }
        if (subTree) {
            for (i = 0; i < childrenNames.length; ++i) {
                Element xmlChild = (Element)elt.appendChild(doc.createElement("node"));
                xmlChild.setAttribute("name", childrenNames[i]);
                EnginePreferencesNode.putPreferencesInXml(xmlChild, doc, childrenCopy[i], subTree);
            }
        }
    }

    private static void setAttributes(Document doc, Preferences prefs, String[] keys, Element map) {
        for (int i = 0; i < keys.length; ++i) {
            Element entry = (Element)map.appendChild(doc.createElement("entry"));
            entry.setAttribute("key", keys[i]);
            entry.setAttribute("value", prefs.get(keys[i], null));
        }
    }

    private boolean dumpStack() {
        Thread.dumpStack();
        return false;
    }

    private void notifyStoreToListeners() throws BackingStoreException {
        for (BackingStoreListener backingStoreListener : this.backingStoreListeners) {
            backingStoreListener.store();
        }
    }

    private void removeChild(String childName) {
        this.childs.remove(childName);
    }

    private static class Resolver
    implements EntityResolver {
        private Resolver() {
        }

        @Override
        public InputSource resolveEntity(String pid, String sid) throws SAXException {
            if (sid.equals(EnginePreferencesNode.PREFERENCES_DTD_URI)) {
                InputSource is = new InputSource(new StringReader(EnginePreferencesNode.PREFERENCES_DTD));
                is.setSystemId(EnginePreferencesNode.PREFERENCES_DTD_URI);
                return is;
            }
            throw new SAXException("Invalid system identifier: " + sid);
        }
    }

    private static class EH
    implements ErrorHandler {
        private EH() {
        }

        @Override
        public void error(SAXParseException x) throws SAXException {
            throw x;
        }

        @Override
        public void fatalError(SAXParseException x) throws SAXException {
            throw x;
        }

        @Override
        public void warning(SAXParseException x) throws SAXException {
            throw x;
        }
    }
}

