/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.standalone.studio;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.BooleanPreference;
import fuego.prefs.CategoryPreference;
import fuego.prefs.LocalhostUserPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.engine.standalone.StandaloneNetworkingPreferences;
import fuego.prefs.validator.PrefValidatorFactory;
import fuego.prefs.validator.StringPrefValidator;
import oracle.bpm.resources.Msg;

public class StudioNetworkingPreferences
extends StandaloneNetworkingPreferences {
    protected StringPreference papiWsUrl;
    protected BooleanPreference startPapiWs;
    private static String PROTOCOL_SEP = "://";
    private static String HOST_SEP = ":";

    public StudioNetworkingPreferences(CategoryPreference parent) {
        super(parent);
        this.portalUrl = new LocalhostFixURLPreference("portalUrl", (CategoryPreference)this, DirectoryMsg.WEB_WORK_PORTAL, null, null, PrefValidatorFactory.createUrlPrefValidator(), "http://$LOCALHOST$:8585/workspace");
        ((LocalhostFixURLPreference)this.portalUrl).fixValue();
        this.webServicesUrl = new LocalhostFixURLPreference("webServicesUrl", (CategoryPreference)this, DirectoryMsg.WEB_SERVICES_URL, null, null, PrefValidatorFactory.createUrlPrefValidator(), "http://$LOCALHOST$:8585/fws/servlet/Deploy");
        ((LocalhostFixURLPreference)this.webServicesUrl).fixValue();
        this.papiWsUrl = new LocalhostFixURLPreference("portalUrl", (CategoryPreference)this, DirectoryMsg.PAPIWS, null, null, PrefValidatorFactory.createUrlPrefValidator(), "http://$LOCALHOST$:8585/papiws");
        ((LocalhostFixURLPreference)this.papiWsUrl).fixValue();
        this.startPapiWs = new BooleanPreference("startPapiWs", this, DirectoryMsg.START_PAPIWS, null, null, false);
    }

    public StringPreference getPapiWsUrl() {
        return this.papiWsUrl;
    }

    public BooleanPreference getStartPapiWs() {
        return this.startPapiWs;
    }

    public static class LocalhostFixURLPreference
    extends LocalhostUserPreference {
        public LocalhostFixURLPreference(String id, CategoryPreference parent, Msg label, Msg help, Msg hint, StringPrefValidator value, String defaultValue) {
            super(id, parent, label, help, hint, value, defaultValue);
        }

        public void fixValue() {
            String value = super.getStringValue();
            if (value.indexOf("$LOCALHOST$") > 0) {
                return;
            }
            int beginIndex = value.indexOf(PROTOCOL_SEP);
            int endIndex = value.lastIndexOf(HOST_SEP);
            if (beginIndex > 0) {
                String protocol = value.substring(0, beginIndex);
                String rest = "";
                if (endIndex > 0) {
                    rest = value.substring(endIndex);
                }
                value = protocol + PROTOCOL_SEP + "$LOCALHOST$" + rest;
                super.setValue(value);
            }
        }

        @Override
        protected String updateContext(String value, String storedValue) {
            if (!value.equals(this.getDefaultValue())) {
                value = storedValue.substring(0, storedValue.lastIndexOf("/")) + value.substring(value.lastIndexOf("/"), value.length());
            }
            return value;
        }
    }
}

