/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.standalone;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.CategoryPreference;
import fuego.prefs.IntegerPreference;
import fuego.prefs.engine.base.BaseMemoryPreferences;
import fuego.prefs.validator.ErrorMsg;
import oracle.bpm.resources.Msg;

public class StandaloneMemoryPreferences
extends BaseMemoryPreferences {
    protected IntegerPreference instancesCacheSize;
    protected IntegerPreference maxJvmHeapSize = new IntegerPreference("maxJvmHeapSize", this, DirectoryMsg.JVM_HEAP_MAX, null, DirectoryMsg.MBYTES, 256, 256, 4096, 32);
    public static final int MAX_JVM_HEAP_SIZE_DEF = 256;
    public static final int INSTANCE_CACHE_SIZE_DEF = 5000;

    public StandaloneMemoryPreferences(CategoryPreference parent) {
        this("memory", parent, null, null, null);
    }

    public StandaloneMemoryPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.maxJvmHeapSize.setModifiableInRuntime(false);
        this.instancesCacheSize = new IntegerPreference("instancesCacheSize", this, DirectoryMsg.CACHE_SIZE, null, null, 5000, 10, 1000000, 100);
        this.instancesCacheSize.setModifiableInRuntime(false);
    }

    public IntegerPreference getInstancesCacheSize() {
        return this.instancesCacheSize;
    }

    public IntegerPreference getMaxJvmHeapSize() {
        return this.maxJvmHeapSize;
    }

    @Override
    public ErrorMsg validate() {
        int jvmMemoryInKB;
        ErrorMsg msg = super.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.instancesCacheSize.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.maxJvmHeapSize.validate();
        if (msg != null) {
            return msg;
        }
        int memoryUsedByInstancesInKB = this.maxInstanceSize.getValue() * this.instancesCacheSize.getValue();
        if ((double)memoryUsedByInstancesInKB > (double)(jvmMemoryInKB = this.maxJvmHeapSize.getValue() * 1024) * 0.8) {
            return new ErrorMsg(DirectoryMsg.INSTANCEMAX_SIZE_MUST_BE_LTJVM, 1);
        }
        if (memoryUsedByInstancesInKB * 2 > jvmMemoryInKB) {
            return new ErrorMsg(DirectoryMsg.INSTANCE_MAX_SIZE_WARNING, 1);
        }
        return null;
    }
}

