/*
 * Decompiled with CFR 0.152.
 */
package fuego.prefs.engine.base;

import fuego.directory.msg.DirectoryMsg;
import fuego.prefs.CategoryPreference;
import fuego.prefs.LocalhostPreference;
import fuego.prefs.StringPreference;
import fuego.prefs.validator.ErrorMsg;
import fuego.prefs.validator.PrefValidatorFactory;
import oracle.bpm.resources.Msg;

public abstract class BaseNetworkingPreferences
extends CategoryPreference {
    protected StringPreference administratorMail;
    protected StringPreference mailServerName = new StringPreference("mailServerName", this, DirectoryMsg.MAIL_SERVER_NAME, null, null, "smtp");
    protected StringPreference portalServlet;
    protected StringPreference portalUrl;
    protected StringPreference webServicesUrl;
    public static final String MAIL_SERVER_NAME_DEF = "smtp";
    public static final String ADMINISTRATOR_MAIL_DEF = "admin@example.com";

    public BaseNetworkingPreferences(CategoryPreference parent) {
        this("networking", parent, null, null, null);
    }

    public BaseNetworkingPreferences(String id, CategoryPreference parent, Msg label, Msg help, Msg hint) {
        super(id, parent, label, help, hint);
        this.administratorMail = new StringPreference("administratorMail", (CategoryPreference)this, DirectoryMsg.ADMINISTRATOR_MAIL, null, null, PrefValidatorFactory.createMailPrefValidator(), ADMINISTRATOR_MAIL_DEF);
        String localhost = LocalhostPreference.getLocalhost();
        this.portalUrl = new StringPreference("portalUrl", (CategoryPreference)this, DirectoryMsg.WEB_WORK_PORTAL, null, null, PrefValidatorFactory.createUrlPrefValidator(), "http://" + localhost + ":8686/workspace");
        this.portalServlet = new StringPreference("portalServlet", this, DirectoryMsg.WORK_PORTAL_END_URL, null, null, "/faces");
        this.webServicesUrl = new StringPreference("webServicesUrl", (CategoryPreference)this, DirectoryMsg.WEB_SERVICES_URL, null, null, PrefValidatorFactory.createUrlPrefValidator(), "http://" + localhost + ":8585/fws/servlet/Deploy");
    }

    public StringPreference getAdministratorMail() {
        return this.administratorMail;
    }

    public StringPreference getMailServerName() {
        return this.mailServerName;
    }

    public StringPreference getPortalUrl() {
        return this.portalUrl;
    }

    public StringPreference getPortalServlet() {
        return this.portalServlet;
    }

    public String getFullPortalUrl() {
        return this.getPortalUrl().getValue() + this.getPortalServlet().getValue();
    }

    public String getPortalUrlContext() {
        String portalUrl = this.getPortalUrl().getValue();
        return portalUrl.substring(portalUrl.lastIndexOf("/") + 1);
    }

    public StringPreference getWebServicesUrl() {
        return this.webServicesUrl;
    }

    public void updatePortalPort(int port) {
        String portalUrl = this.getPortalUrl().getValue();
        String url = portalUrl.substring(0, portalUrl.lastIndexOf(":"));
        this.getPortalUrl().setValue(url + ":" + port + portalUrl.substring(portalUrl.lastIndexOf("/")));
    }

    public void updatePortalUrlContext(String context) {
        String portalUrl = this.getPortalUrl().getValue();
        String url = portalUrl.substring(0, portalUrl.lastIndexOf("/"));
        this.getPortalUrl().setValue(url + "/" + context);
    }

    @Override
    public ErrorMsg validate() {
        ErrorMsg msg = this.administratorMail.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.mailServerName.validate();
        if (msg != null) {
            return msg;
        }
        msg = this.portalUrl.validate();
        if (msg != null) {
            return msg;
        }
        return this.webServicesUrl.validate();
    }
}

