/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.util;

import fuego.directory.msg.DirectoryMsg;
import fuego.directory.util.DirectoryImportException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import oracle.bpm.lang.DefaultException;
import oracle.bpm.lang.DefaultRuntimeException;
import oracle.bpm.resources.Msg;

public class CouldNotImportObjectsException
extends DirectoryImportException {
    HashMap sourceExceptions;
    static final long serialVersionUID = 3235503323984740350L;
    static final long serialCheck = -2799880449356664300L;

    protected CouldNotImportObjectsException(Msg msg, String id, String fileName) {
        super(msg, id, fileName);
    }

    public static CouldNotImportObjectsException groupImportExceptions(String id, String fileName, HashMap sourceExceptions) {
        CouldNotImportObjectsException result = new CouldNotImportObjectsException(DirectoryMsg.DII_00039(fileName, id), id, fileName);
        result.sourceExceptions = sourceExceptions;
        return result;
    }

    public HashMap getSourceExceptions() {
        return this.sourceExceptions;
    }

    @Override
    public String getDetail(Locale locale) {
        return super.getDetail(locale) + this.getErrorsString(locale);
    }

    protected String getErrorsString(Locale locale) {
        String errors = null;
        if (this.sourceExceptions != null) {
            Iterator itNotAvailableObjects = this.sourceExceptions.entrySet().iterator();
            errors = "\n";
            while (itNotAvailableObjects.hasNext()) {
                Map.Entry entry = itNotAvailableObjects.next();
                Object object = entry.getValue();
                String nestedMessage = object.toString();
                if (object instanceof DefaultException) {
                    nestedMessage = ((DefaultException)object).getMessage(locale);
                } else if (object instanceof DefaultRuntimeException) {
                    nestedMessage = ((DefaultRuntimeException)object).getMessage(locale);
                } else if (object instanceof Throwable) {
                    nestedMessage = object.getClass().getName() + ":" + ((Throwable)object).getMessage();
                }
                errors = errors + entry.getKey() + ": " + nestedMessage + "\n";
            }
            errors = errors.substring(0, errors.length() - 1);
        }
        return errors;
    }
}

