/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.provider.notifiers;

import fuego.directory.DirObject;
import fuego.directory.DirectoryException;
import fuego.directory.provider.DirectorySessionImpl;
import fuego.directory.provider.notifiers.DirObjectType;
import fuego.directory.provider.notifiers.DirectoryEventGeneratorImpl;
import fuego.directory.provider.notifiers.DirectoryNotificationEvent;
import java.util.ArrayList;
import java.util.List;
import oracle.bpm.log.Log;

public abstract class BaseEventGenerator
extends DirectoryEventGeneratorImpl {
    protected List<DirectoryNotificationEvent> events;

    protected BaseEventGenerator(DirObjectType objectType, DirectorySessionImpl session) {
        super(objectType, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(DirectoryNotificationEvent newEvent) {
        BaseEventGenerator baseEventGenerator = this;
        synchronized (baseEventGenerator) {
            newEvent.getObjectType().addEvent(this.events, newEvent);
        }
    }

    public void addEvent(EventInfo eventInfo) {
        DirectoryNotificationEvent event;
        if (eventInfo != null && this.getSession().isConnected()) {
            int eventType = eventInfo.eventType;
            String eventId = eventInfo.eventId;
            String objectId = eventInfo.objectId;
            if (eventType == 1) {
                event = DirectoryNotificationEvent.newDeleteEvent(objectId, this.getObjectType(), eventId);
            } else {
                assert (eventType == 2 || eventType == 4) : "Wrong event Type " + eventType;
                DirObject dirObject = this.getDirObject(objectId);
                if (dirObject == null) {
                    String eventString;
                    String string = eventString = eventType == 2 ? "CREATE" : "CHANGE";
                    if (Log.isDebugging()) {
                        Log.logDebug("A " + eventString + " event for " + (Object)((Object)this.getObjectType()) + " : " + objectId + " could not find the object. Event skipped");
                    }
                    event = null;
                } else {
                    event = eventType == 2 ? DirectoryNotificationEvent.newAddEvent(dirObject, this.getObjectType(), eventId) : DirectoryNotificationEvent.newUpdateEvent(dirObject, this.getObjectType(), eventId);
                }
            }
        } else {
            event = null;
        }
        if (event != null) {
            this.addEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<DirectoryNotificationEvent> generateEvents() throws DirectoryException {
        List<DirectoryNotificationEvent> currentList;
        this.buildEvents();
        BaseEventGenerator baseEventGenerator = this;
        synchronized (baseEventGenerator) {
            currentList = this.events;
            this.events = new ArrayList<DirectoryNotificationEvent>();
        }
        this.updateTimeStamp();
        return currentList;
    }

    @Override
    public boolean isSynchronized() {
        return this.events != null;
    }

    @Override
    public void synchronize() throws DirectoryException {
        this.events = new ArrayList<DirectoryNotificationEvent>();
    }

    protected void buildEvents() {
    }

    protected DirObject getDirObject(String objectId) {
        try {
            return this.getObjectType().fetchDirObjectFor(this.getSession(), objectId);
        }
        catch (DirectoryException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static class EventInfo {
        public final String eventId;
        public final int eventType;
        public final String objectId;

        public EventInfo(int eventType, String eventId, String objectId) {
            this.eventType = eventType;
            this.eventId = eventId;
            this.objectId = objectId;
        }
    }
}

