/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory.auth;

import fuego.directory.DirectoryException;
import fuego.directory.auth.AuthenticationType;
import fuego.directory.auth.SecurityConstants;

public class SecurityEnvironment
implements SecurityConstants {
    private boolean classNameInvalid;
    private boolean isTokenValidationEnabled;
    private int securityLevel;
    private String tokenValidationClassName;

    private SecurityEnvironment(int securityLevel, boolean tokenValidationEnabled, String tokenValidationClassName) {
        this.securityLevel = securityLevel;
        this.isTokenValidationEnabled = tokenValidationEnabled;
        this.tokenValidationClassName = tokenValidationClassName;
        this.classNameInvalid = false;
    }

    public static SecurityEnvironment create(String className) throws DirectoryException {
        boolean tokenValidationEnabled = SecurityEnvironment.checkTokenValidationEnabled(className);
        int minimumSecurityLevel = SecurityEnvironment.checkSecurityLevel(tokenValidationEnabled);
        return new SecurityEnvironment(minimumSecurityLevel, tokenValidationEnabled, className);
    }

    public boolean isClassNameInvalid() {
        return this.classNameInvalid;
    }

    public void setClassNameInvalid(boolean classNameInvalid) {
        this.classNameInvalid = classNameInvalid;
    }

    public int getSecurityLevel() {
        return this.securityLevel;
    }

    public boolean isTokenValidationEnabled() {
        return this.isTokenValidationEnabled;
    }

    public String getTokenValidationClassName() {
        return this.tokenValidationClassName;
    }

    public void setTokenValidationClassName(String tokenValidationClassName) {
        if (this.isTokenValidationEnabled() && (tokenValidationClassName == null || tokenValidationClassName.length() == 0)) {
            throw new IllegalArgumentException("Cannot set an empty token validation class name while token validation is enabled.");
        }
        this.isTokenValidationEnabled = SecurityEnvironment.checkTokenValidationEnabled(tokenValidationClassName);
        this.securityLevel = SecurityEnvironment.checkSecurityLevel(this.isTokenValidationEnabled);
        this.tokenValidationClassName = tokenValidationClassName;
        this.classNameInvalid = false;
    }

    private static int checkSecurityLevel(boolean tokenValidationEnabled) {
        return tokenValidationEnabled ? AuthenticationType.SIMPLE.getSecurityLevel() : AuthenticationType.TRUSTED.getSecurityLevel();
    }

    private static boolean checkTokenValidationEnabled(String className) {
        return className != null && className.length() > 0;
    }
}

