/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirHumanParticipant;
import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectoryFeatures;
import fuego.directory.DirectoryPassport;
import fuego.directory.auth.AuthenticatorFactory;
import fuego.directory.exception.InvalidAttributeValueException;
import fuego.directory.exception.InvalidDirectorySessionException;
import fuego.directory.exception.ProtocolNotSupportedException;
import fuego.directory.listener.DirectoryNotifierInterface;
import fuego.directory.provider.AttributeValidator;
import fuego.directory.provider.AuthenticationAccessor;
import fuego.directory.provider.EngineAccessor;
import fuego.directory.provider.Factory;
import fuego.directory.provider.GroupAccessor;
import fuego.directory.provider.ObjectClassInstanceAccessor;
import fuego.directory.provider.ObjectPropertiesAccessor;
import fuego.directory.provider.OrganizationAccessor;
import fuego.directory.provider.ParticipantAccessor;
import fuego.directory.provider.ProcessAccessor;
import fuego.directory.provider.ProcessManagerAccessor;
import fuego.directory.provider.ProjectAccessor;
import fuego.directory.provider.ValidationAccessor;
import java.util.Map;
import oracle.bpm.log.Log;
import oracle.bpm.util.Properties;

public abstract class DirectorySession<T> {
    protected Properties sessionProperties;
    private final String directoryId;
    private final Factory<T> factory;
    private final String participant;
    private final String preset;

    protected DirectorySession(DirectoryPassport passport, Factory<T> factory) {
        this.factory = factory;
        this.directoryId = passport.getId();
        this.preset = passport.getPreset();
        this.participant = passport.getParticipant();
        this.sessionProperties = (Properties)passport.getProperties().clone();
    }

    public abstract boolean isAdministrator();

    public abstract AttributeValidator getAttributeValidator();

    public abstract boolean isConnected();

    public abstract String getOrganizationName();

    public abstract String getSchemaId();

    public abstract boolean hasSchemaInfo();

    public abstract String getSchemaVersion();

    public abstract boolean isTransactionStarted();

    public abstract void disconnect() throws DirectoryException;

    public abstract DirectoryNotifierInterface getDirectoryNotifier();

    public abstract void commitTransaction();

    public abstract void rollbackTransaction();

    public abstract void startTransaction();

    public abstract DirectoryFeatures supports();

    public static boolean isASCII(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '\u0014' && c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static boolean isExtendedASCII(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\n' || c == '\r' || c == '\t' || c >= '\u0014' && c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static boolean isValid7BitValue(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    public static void checkAttributeValue(String name, String value) {
        if (value != null && !DirectorySession.isValidValue(value, DirectorySession.invalidCharacters())) {
            throw InvalidAttributeValueException.invalidValue(name, value);
        }
    }

    public static void checkAttributeValues(String name, String[] value) {
        for (String aValue : value) {
            DirectorySession.checkAttributeValue(name, aValue);
        }
    }

    public static void checkKeyAttributeValue(String name, String value) {
        if (value != null && !DirectorySession.isValidValue(value, DirectorySession.invalidKeyCharacters())) {
            throw InvalidAttributeValueException.invalidValue(name, value);
        }
    }

    public static void checkPasswordAttributeValue(String name, String value) {
        if (value != null && !DirectorySession.isValid7BitValue(value)) {
            throw InvalidAttributeValueException.invalidValue(name, value);
        }
    }

    public static boolean isValidValue(String value, char[] invalid) {
        char[] valueArray = value.toCharArray();
        for (char anInvalid : invalid) {
            for (char aValueArray : valueArray) {
                if (anInvalid != aValueArray) continue;
                return false;
            }
        }
        return true;
    }

    public static void validateValue(String attributeName, String value, char[] invalidChars) {
        DirectorySession.validateValue(attributeName, value, invalidChars, false);
    }

    public static void validateValue(String attributeName, String value, char[] invalidChars, boolean emptyAllowed) {
        if (!(emptyAllowed || value != null && value.length() != 0)) {
            throw InvalidAttributeValueException.invalidValue(attributeName, value);
        }
        char[] valueArray = value.toCharArray();
        for (char invalidChar : invalidChars) {
            for (char aValueArray : valueArray) {
                if (invalidChar != aValueArray) continue;
                throw InvalidAttributeValueException.invalidValue(attributeName, value, aValueArray);
            }
        }
    }

    public static final char[] invalidCharacters() {
        return new char[]{';', ',', '+', '\"', '<', '>', '\\', '/'};
    }

    public static final char[] invalidIDCharacters() {
        return new char[]{';', ',', '+', '\"', '<', '>', '\\', '/', '@', ':'};
    }

    public static final char[] invalidKeyCharacters() {
        return new char[]{'\u0000', ';', ',', '+', '\"', '<', '>', '\\', '?', '#'};
    }

    public boolean isAdministratorOf(String ou) {
        return this.isAdministrator() || this.getSessionParticipant().isOUAdministeredBy(ou);
    }

    public boolean isAnonymous() {
        return this.getParticipant() == null;
    }

    public Map<String, AuthenticatorFactory> getAuthMethods() {
        try {
            Factory f = Factory.getDirectoryFactory(this.getDirectoryId());
            return f.getAuthMethods(this.getDirectoryId());
        }
        catch (ProtocolNotSupportedException protocolNotSupportedException) {
            return null;
        }
    }

    public String getDirectoryId() {
        return this.directoryId;
    }

    public Factory<T> getFactory() {
        return this.factory;
    }

    public String getParticipant() {
        return this.participant;
    }

    public boolean isServiceAvailable() {
        try {
            return Directory.isAvailable(this.getDirectoryId());
        }
        catch (Exception ex) {
            Log.logSevere(ex);
            return false;
        }
    }

    @Deprecated
    public String getUrl() {
        return this.getOrganizationName();
    }

    public void checkIDAttributeValue(String name, String value) {
        if (!this.isValidIdValue(value)) {
            throw InvalidAttributeValueException.invalidValue(name, value);
        }
    }

    public final boolean isValidDescriptionValue(String value) {
        return this.getValidationAccessor().isValidDescriptionValue(value);
    }

    public final boolean isValidFullIdValue(String value) {
        return this.getValidationAccessor().isValidFullIdValue(value);
    }

    public final boolean isValidIdValue(String value) {
        return this.getValidationAccessor().isValidIdValue(value);
    }

    public final boolean isValidPropertyKeyValue(String value) {
        return this.getValidationAccessor().isValidPropertyKeyValue(value);
    }

    public void checkDescriptionAttributeValue(String name, String value) {
        if (!this.isValidDescriptionValue(value)) {
            throw InvalidAttributeValueException.invalidValue(name, value);
        }
    }

    public void checkFullIDAttributeValue(String name, String value) {
        if (!this.isValidFullIdValue(value)) {
            throw InvalidAttributeValueException.invalidValue(name, value);
        }
    }

    public void checkPropertyKeyAttributeValue(String name, String value) {
        if (!this.isValidPropertyKeyValue(value)) {
            throw InvalidAttributeValueException.invalidValue(name, value);
        }
    }

    public boolean doNotUpdateUsers() {
        return false;
    }

    public void initializeObject(DirObject dirObject) {
        if (dirObject == null) {
            throw new NullPointerException();
        }
        if (dirObject.session == null) {
            assert (dirObject.schemaId.equals(this.getSchemaId())) : "The schema Ids of the sessions differ current [" + dirObject.schemaId + "] vs new [" + this.getSchemaId() + "]";
            if (!dirObject.schemaId.equals(this.getSchemaId())) {
                throw InvalidDirectorySessionException.invalidSchemaId(this.getSchemaId(), dirObject.schemaId);
            }
            dirObject.session = this;
        } else {
            assert (dirObject.session == this) : "The session assigned to the object is different from me";
            if (dirObject.session != this) {
                throw new IllegalStateException();
            }
        }
    }

    public Object getProperty(String key) {
        return this.sessionProperties.get(key);
    }

    public Object putProperty(String key, Object value) {
        return this.sessionProperties.put(key, value);
    }

    protected abstract AuthenticationAccessor getAuthenticationAccessor();

    protected abstract EngineAccessor getEngineAccessor();

    protected abstract GroupAccessor getGroupAccessor();

    protected abstract ProcessManagerAccessor getProcessManagerAccessor();

    protected abstract ObjectPropertiesAccessor getObjectPropertiesAccessor();

    protected abstract OrganizationAccessor getOrganizationAccessor();

    protected abstract ObjectClassInstanceAccessor getObjectClassInstanceAccessor();

    protected abstract ParticipantAccessor getParticipantAccessor();

    protected abstract ProcessAccessor getProcessAccessor();

    protected abstract ProjectAccessor getProjectAccessor();

    protected abstract DirHumanParticipant getSessionParticipant();

    protected abstract ValidationAccessor getValidationAccessor();

    protected abstract void fillAuditInfo(DirObject var1) throws DirectoryException;

    protected String lookupProperty(String key) {
        String result = this.sessionProperties.getProperty(key);
        if (result == null) {
            result = Directory.getPropertyManager(this.getDirectoryId()).lookupProperty(key, this.preset, this.getParticipant(), this.getDirectoryId());
        }
        return result;
    }
}

