/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.FilterFields;
import fuego.directory.msg.DirectoryMsg;
import java.io.IOException;
import oracle.bpm.xml.XmlWriter;

public class DirOrganizationalUnit
extends DirObject {
    protected String description_d;
    protected String fullName_d;
    protected String name_d;
    public static final String ELEM_OU = "DirOrganizationalUnit";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_DESCRIPTION = "description";
    public static final String ATTR_PARENT_ID = "parentId";
    static final long serialVersionUID = 2192960769943601516L;
    static final long serialCheck = 2524467535141140049L;

    public DirOrganizationalUnit(DirectorySession session, int in, String name, String fullName, String description, String internalId) {
        super(session, in, internalId);
        this.name_d = name;
        this.getDirectorySession().getAttributeValidator().validateOUName(name, fullName);
        this.setDescription(description);
        this.fullName_d = fullName;
    }

    public static boolean isContainedBy(String ou1, String ou2) {
        DirOrganizationalUnit.check(ou1 != null, DirectoryMsg.DIR_00102);
        DirOrganizationalUnit.check(ou2 != null, DirectoryMsg.DIR_00102);
        String ou1NS = ou1 + (DirOrganizationalUnit.isRootId(ou1) ? "" : "/");
        String ou2NS = ou2 + (DirOrganizationalUnit.isRootId(ou2) ? "" : "/");
        return ou1NS.startsWith(ou2NS);
    }

    public static String getParentId(String id) {
        return DirOrganizationalUnit.removeLastPart(id);
    }

    public static String getRootId() {
        return "";
    }

    public static boolean isRootId(String id) {
        return "".equals(id);
    }

    public static boolean areVisible(String ou1, String ou2) {
        DirOrganizationalUnit.check(ou1 != null, DirectoryMsg.DIR_00102);
        DirOrganizationalUnit.check(ou2 != null, DirectoryMsg.DIR_00102);
        String ou1NS = ou1 + (DirOrganizationalUnit.isRootId(ou1) ? "" : "/");
        String ou2NS = ou2 + (DirOrganizationalUnit.isRootId(ou2) ? "" : "/");
        ou1NS = ou1NS.toLowerCase();
        ou2NS = ou2NS.toLowerCase();
        return ou1NS.startsWith(ou2NS) || ou2NS.startsWith(ou1NS);
    }

    public static DirOrganizationalUnit fetch(DirectorySession session, String id) throws DirectoryException {
        DirOrganizationalUnit.check(id != null, DirectoryMsg.DIR_00108);
        if (DirOrganizationalUnit.isRootId(id)) {
            return DirOrganizationalUnit.fetchRoot(session);
        }
        if (!session.getAttributeValidator().isValidOUFullName(id)) {
            return null;
        }
        return session.getOrganizationAccessor().fetchOU(id);
    }

    public static DirOrganizationalUnit[] fetchAll(DirectorySession dir) throws DirectoryException {
        Directory.checkSession(dir);
        return dir.getOrganizationAccessor().fetchAllOUs();
    }

    public static DirOrganizationalUnit[] fetchAllByFilter(DirectorySession session, FilterFields filterFields, String filter, int max) throws DirectoryException {
        Directory.checkSession(session);
        if (filterFields != FilterFields.NONE && (filter == null || filter.trim().length() == 0)) {
            throw new IllegalArgumentException("Filters must not be empty");
        }
        return session.getOrganizationAccessor().fetchAllByFilter(filterFields, filter, max);
    }

    public static DirOrganizationalUnit fetchRoot(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().fetchRootOU();
    }

    public String getFullName() {
        return this.fullName_d;
    }

    public String getName() {
        return this.name_d;
    }

    public String getParentId() {
        return DirOrganizationalUnit.removeLastPart(this.fullName_d);
    }

    public boolean isContainedBy(String ou2) {
        return DirOrganizationalUnit.isContainedBy(this.getId(), ou2);
    }

    public boolean isContainedBy(DirOrganizationalUnit ou2) {
        return DirOrganizationalUnit.isContainedBy(this.getId(), ou2.getId());
    }

    public void setDescription(String description) {
        this.description_d = this.getDirectorySession().getAttributeValidator().validateDescription(description);
    }

    public String getDescription() {
        return this.description_d;
    }

    public DirOrganizationalUnit[] fetchChildren() throws DirectoryException {
        return this.getDirectorySession().getOrganizationAccessor().fetchOUChildren(this);
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getId() {
        return this.fullName_d;
    }

    public boolean isRoot() {
        return this.name_d.equalsIgnoreCase("");
    }

    public DirOrganizationalUnit create(String name, String description) throws DirectoryException {
        DirectorySession directorySession = this.getDirectoryAdministratorSession();
        directorySession.getAttributeValidator().validateNewOUName(name, this.getId());
        description = directorySession.getAttributeValidator().validateDescription(description);
        return this.getDirectoryAdministratorSession().getOrganizationAccessor().createOU(this, name, description, "");
    }

    @Override
    public void delete() throws DirectoryException {
        this.delete(false);
    }

    public void delete(boolean force) throws DirectoryException {
        DirOrganizationalUnit.checkSupports(!this.isRoot(), DirectoryMsg.DIR_00118);
        this.getDirectoryAdministratorSession().getOrganizationAccessor().deleteOU(this, force);
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectoryAdministratorSession().getOrganizationAccessor().refreshOU(this);
    }

    @Override
    public String toString() {
        return "name:" + this.name_d + " fullName:" + this.fullName_d + " description:" + this.description_d + "|" + super.toString();
    }

    @Override
    public void update() throws DirectoryException {
        DirOrganizationalUnit.checkSupports(!this.isRoot(), DirectoryMsg.DIR_00121);
        this.getDirectoryAdministratorSession().getOrganizationAccessor().updateOU(this);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement(ELEM_OU);
        xmlWriter.printValuedElement(ATTR_NAME, this.getName());
        xmlWriter.printValuedElement(ATTR_DESCRIPTION, this.getDescription());
        xmlWriter.printValuedElement(ATTR_PARENT_ID, this.getParentId());
        xmlWriter.endElement();
    }
}

