/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;

public class DirObjectClassInstance
extends DirObject {
    private String[] assignedParticipants;
    private String[] assignedRoles;
    private String instanceXml;
    private String name;
    private String objectClass;
    private static final long serialVersionUID = 3900126531429544960L;
    public static String LAYOUT_OBJECT_CLASS_TYPE = "bea.albpm.workspace.layout";

    public DirObjectClassInstance(DirectorySession session, int in, String internalId, String name, String objectClass, String[] assignedRoles, String[] assignedParticipants, String instanceXml) {
        super(session, in, internalId);
        this.setName(name);
        this.setObjectClass(objectClass);
        this.setAssignedRoles(assignedRoles);
        this.setAssignedParticipants(assignedParticipants);
        this.setInstanceXml(instanceXml);
    }

    public static DirObjectClassInstance create(DirectorySession session, String name, String objectClass, String[] assignedRoles, String[] assignedParticipants, String instanceXml) throws DirectoryException {
        Directory.checkAdministratorSession(session);
        session.getAttributeValidator().validateObjectClassInstanceName(name);
        return session.getObjectClassInstanceAccessor().create(name, objectClass, assignedRoles, assignedParticipants, instanceXml);
    }

    public static DirObjectClassInstance fetchByName(DirectorySession session, String objectClass, String name) throws DirectoryException {
        Directory.checkSession(session);
        return session.getObjectClassInstanceAccessor().fetchByName(objectClass, name);
    }

    public static DirObjectClassInstance[] fetchByRolesAndParticipants(DirectorySession session, String objectClass, String[] roles, String[] participants) throws DirectoryException {
        Directory.checkSession(session);
        return session.getObjectClassInstanceAccessor().fetchByRolesAndParticipants(objectClass, roles, participants);
    }

    public static DirObjectClassInstance[] fetchByRoles(DirectorySession session, String objectClass, String[] roles) throws DirectoryException {
        Directory.checkSession(session);
        return session.getObjectClassInstanceAccessor().fetchByRoles(objectClass, roles);
    }

    public static DirObjectClassInstance[] fetchByParticipants(DirectorySession session, String objectClass, String[] participants) throws DirectoryException {
        Directory.checkSession(session);
        return session.getObjectClassInstanceAccessor().fetchByParticipants(objectClass, participants);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DirObjectClassInstance that = (DirObjectClassInstance)o;
        return this.name.equals(that.name) && this.objectClass.equals(that.objectClass);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.name.hashCode();
        result = 31 * result + this.objectClass.hashCode();
        return result;
    }

    public String getName() {
        return this.name;
    }

    public String getObjectClass() {
        return this.objectClass;
    }

    public String[] getAssignedRoles() {
        return this.assignedRoles;
    }

    public void setAssignedRoles(String[] assignedRoles) {
        this.assignedRoles = assignedRoles;
    }

    public String[] getAssignedParticipants() {
        return this.assignedParticipants;
    }

    public void setAssignedParticipants(String[] assignedParticipants) {
        this.assignedParticipants = assignedParticipants;
    }

    public String getInstanceXml() {
        return this.instanceXml;
    }

    public void setInstanceXml(String instanceXml) {
        this.instanceXml = instanceXml;
    }

    @Override
    public String getDisplayName() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectoryAdministratorSession().getObjectClassInstanceAccessor().delete(this);
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectoryAdministratorSession().getObjectClassInstanceAccessor().refresh(this);
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectoryAdministratorSession().getObjectClassInstanceAccessor().update(this);
    }

    private void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    private void setName(String name) {
        this.name = name;
    }
}

