/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.DirOrganizationalGroup;
import fuego.directory.DirOrganizationalUnit;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectoryRuntimeException;
import fuego.directory.DirectorySession;
import fuego.directory.FilterFields;
import fuego.directory.exception.InvalidAttributeValueException;
import fuego.directory.exception.NoPermissionException;
import fuego.directory.exception.OperationNotSupportedException;
import fuego.directory.msg.DirectoryMsg;
import fuego.directory.provider.ParticipantAccessor;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import oracle.bpm.collections.lists.StringList;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.Time;
import oracle.bpm.log.Log;
import oracle.bpm.msg.CoreMsg;
import oracle.bpm.resources.Msg;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.xml.XmlWriter;

public class DirHumanParticipant
extends DirObject {
    protected Absence[] absencePeriods;
    protected String[] administeredOUs;
    protected String displayName;
    protected String employeeId = "";
    protected String fax;
    protected String firstName = "";
    protected String id;
    protected String lastName = "";
    protected Locale locale;
    protected String mail = "";
    protected String manager = "";
    protected String ou;
    protected int permissions;
    protected Boolean receivesMail;
    protected RoleAssignment[] rolesAssignment;
    protected StatusSupport statusSupport;
    protected String telephone;
    protected TimeZone timezone;
    public static final char ROOT_ENABLED = 'R';
    public static final char ADMINISTRATOR_ENABLED = 'S';
    public static final char PARTICIPANT_ENABLED = 'A';
    public static final char ADMINISTRATOR_DISABLED = 'E';
    public static final char PARTICIPANT_DISABLED = 'D';
    public static final String ELEM_PART = "DirHumanParticipant";
    private static final String PERMISSIONS = "XRSADGEP";
    public static final int MAX_PERSONS_FETCH_SIZE = 1000;
    public static final int MAX_PARTICIPANTS_FETCH_SIZE = 10000;
    public static final int PERMISSION_USER_ADMINISTRATOR = 1;
    public static final String PREFERENCES = "prefs";
    public static final String RECEIVES_MAIL = "mail";
    static final long serialVersionUID = -4589250245947172934L;
    static final long serialCheck = 121520205709660919L;

    public DirHumanParticipant(DirectorySession session, int in, String id, String status, RoleAssignment[] rolesAssignment, Absence[] absencePeriods, String internalId) {
        this(session, in, id, status, rolesAssignment, absencePeriods, 0, internalId);
    }

    public DirHumanParticipant(DirectorySession session, int in, String id, String status, RoleAssignment[] rolesAssignment, Absence[] absencePeriods, int permissions, String internalId) {
        super(session, in, internalId);
        assert (rolesAssignment != null) : "Roles Assignment cannot be null";
        assert (status != null) : "Status cannot be null";
        this.getDirectorySession().getAttributeValidator().validateParticipantId(id);
        this.id = id;
        this.statusSupport = new StatusSupport(status);
        this.rolesAssignment = DirHumanParticipant.checkRolesAssignment(session, id, rolesAssignment);
        this.absencePeriods = absencePeriods;
        this.ou = DirOrganizationalUnit.getRootId();
        this.permissions = permissions;
    }

    public DirHumanParticipant(DirectorySession session, int in, String id, String firstName, String lastName, String displayName, String mail, String telephone, String fax, String status, RoleAssignment[] roles, Absence[] absencePeriods, String ou, String internalId) {
        this(session, in, id, firstName, lastName, displayName, mail, telephone, fax, status, roles, absencePeriods, ou, 0, internalId);
    }

    public DirHumanParticipant(DirectorySession session, int in, String id, String firstName, String lastName, String displayName, String mail, String telephone, String fax, String status, RoleAssignment[] roles, Absence[] absencePeriods, String ou, int permissions, String internalId) {
        this(session, in, id, status, roles, absencePeriods, internalId);
        this.displayName = displayName;
        this.firstName = firstName;
        this.lastName = lastName;
        this.mail = mail;
        this.telephone = telephone;
        this.fax = fax;
        DirHumanParticipant.check(ou != null, DirectoryMsg.DIR_00102);
        this.ou = ou;
        this.permissions = permissions;
    }

    public static int castPermissionFrom(String permission) {
        if (permission == null) {
            return -1;
        }
        int temp = 0;
        for (int i = 0; i < permission.length(); ++i) {
            int value = DirHumanParticipant.getPermissionValue(permission.substring(i, i + 1));
            if (value == -1) {
                return -1;
            }
            temp += value;
        }
        return temp;
    }

    public static String castPermissionToString(int permission) {
        String permissions = PERMISSIONS;
        int mask = (1 << PERMISSIONS.length()) - 1;
        if (permission <= 0 || permission > mask) {
            return "";
        }
        if (permission == mask) {
            return PERMISSIONS;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (permission != 0) {
            if ((permission & 1) != 0) {
                result.append(PERMISSIONS.charAt(i));
            }
            permission >>= 1;
            ++i;
        }
        return result.toString();
    }

    public static DirHumanParticipant create(DirectorySession session, String id, String firstName, String lastName, String displayName, String mail, String telephone, String fax, String password, DirOrganizationalUnit ou, RoleAssignment[] rolesAssignment) throws DirectoryException {
        return DirHumanParticipant.create(session, id, firstName, lastName, displayName, mail, telephone, fax, password, ou, rolesAssignment, true);
    }

    public static DirHumanParticipant create(DirectorySession session, String id, String firstName, String lastName, String displayName, String mail, String telephone, String fax, String password, DirOrganizationalUnit ou, RoleAssignment[] rolesAssignment, int permissions) throws DirectoryException {
        return DirHumanParticipant.create(session, id, firstName, lastName, displayName, mail, telephone, fax, password, ou, rolesAssignment, permissions, true);
    }

    public static DirHumanParticipant create(DirectorySession session, String id, String firstName, String lastName, String displayName, String mail, String telephone, String fax, String password, DirOrganizationalUnit ou, RoleAssignment[] rolesAssignment, boolean enabled) throws DirectoryException {
        return DirHumanParticipant.create(session, id, firstName, lastName, displayName, mail, telephone, fax, password, ou, rolesAssignment, 0, enabled);
    }

    public static DirHumanParticipant create(DirectorySession session, String id, String firstName, String lastName, String displayName, String mail, String telephone, String fax, String password, DirOrganizationalUnit ou, RoleAssignment[] rolesAssignment, int permissions, boolean enabled) throws DirectoryException {
        if (ou == null) {
            throw new IllegalArgumentException(DirectoryMsg.DIR_00102.toString());
        }
        Directory.checkAdministratorSession(session, session.getSessionParticipant(), 1, ou.getId());
        if (!session.supports().createParticipants()) {
            throw new OperationNotSupportedException("create participant", id);
        }
        session.getAttributeValidator().validateParticipantId(id);
        DirHumanParticipant.check(lastName != null && lastName.length() > 0, DirectoryMsg.DIR_00135);
        DirHumanParticipant.check(displayName != null && displayName.length() > 0, DirectoryMsg.DIR_00134);
        DirHumanParticipant.check(password != null && password.trim().length() > 0, DirectoryMsg.DIR_00100);
        session.getAuthenticationAccessor().checkPasswordAttributeValue(id, password);
        rolesAssignment = DirHumanParticipant.checkRolesAssignment(session, id, rolesAssignment);
        return session.getParticipantAccessor().createHumanParticipant(id, firstName, lastName, displayName, telephone, fax, password, mail, ou, rolesAssignment, enabled, permissions);
    }

    public static DirHumanParticipant fetch(DirectorySession session, String id) throws DirectoryException {
        Directory.checkSession(session);
        try {
            session.getAttributeValidator().validateParticipantId(id);
        }
        catch (InvalidAttributeValueException e) {
            return null;
        }
        return session.getParticipantAccessor().fetchHumanParticipant(id);
    }

    public static DirHumanParticipant fetch(DirectorySession session, int in) throws DirectoryException {
        Directory.checkSession(session);
        if (in < 1) {
            return null;
        }
        return session.getParticipantAccessor().fetchHumanParticipant(in);
    }

    public static DirHumanParticipant[] fetchAll(DirectorySession session) throws DirectoryException {
        return DirHumanParticipant.fetchAll(session, true);
    }

    public static DirHumanParticipant[] fetchAll(DirectorySession session, boolean enabledOnly) throws DirectoryException {
        return DirHumanParticipant.fetchAll(session, enabledOnly ? 10000 : 1000, enabledOnly);
    }

    public static DirHumanParticipant[] fetchAll(DirectorySession session, int max) throws DirectoryException {
        return DirHumanParticipant.fetchAll(session, max, true);
    }

    public static DirHumanParticipant[] fetchAll(DirectorySession session, int max, boolean enabledOnly) throws DirectoryException {
        Directory.checkSession(session);
        return session.getParticipantAccessor().fetchAllHumanParticipants(enabledOnly, max);
    }

    public static DirHumanParticipant[] fetchAllReplacedHumanParticipants(DirectorySession session, Time time, int max) throws DirectoryException {
        return DirHumanParticipant.fetchAllReplacedHumanParticipants(session, true, time, max);
    }

    public static DirHumanParticipant[] fetchAllReplacedHumanParticipants(DirectorySession session, Time time) throws DirectoryException {
        return DirHumanParticipant.fetchAllReplacedHumanParticipants(session, true, time);
    }

    public static DirHumanParticipant[] fetchAllReplacedHumanParticipants(DirectorySession session, boolean enabledOnly, Time time) throws DirectoryException {
        return DirHumanParticipant.fetchAllReplacedHumanParticipants(session, enabledOnly, time, enabledOnly ? 10000 : 1000);
    }

    public static DirHumanParticipant[] fetchAllReplacedHumanParticipants(DirectorySession session, boolean enabledOnly, Time time, int max) throws DirectoryException {
        Directory.checkSession(session);
        return session.getParticipantAccessor().fetchAllReplacedHumanParticipants(enabledOnly, time, max);
    }

    public static DirHumanParticipant[] fetchAllMinimal(DirectorySession session, int max, boolean enabledOnly) throws DirectoryException {
        Directory.checkSession(session);
        return session.getParticipantAccessor().fetchAllHumanParticipantsMinimal(enabledOnly, max);
    }

    public static DirHumanParticipant[] fetchAllDisabled(DirectorySession session) throws DirectoryException {
        return DirHumanParticipant.fetchAllDisabled(session, 0);
    }

    public static DirHumanParticipant[] fetchAllDisabled(DirectorySession session, int max) throws DirectoryException {
        Directory.checkSession(session);
        return session.getParticipantAccessor().fetchAllDisabledHumanParticipants(max);
    }

    public static Map fetchAllPropertyValues(DirectorySession session, String category, String key) throws DirectoryException {
        Directory.checkAdministratorSession(session);
        return session.getObjectPropertiesAccessor().fetchAllPropertyValuesForParticipants(category, key);
    }

    public static DirHumanParticipant fetchCurrent(DirectorySession session) {
        Directory.checkSession(session);
        if (session.isAnonymous()) {
            return null;
        }
        DirHumanParticipant sessionParticipant = session.getSessionParticipant();
        assert (sessionParticipant != null) : "Participant session cannot be null in a non-anonymous session";
        return sessionParticipant;
    }

    public static DirHumanParticipant[] fetchMatchingName(DirectorySession session, String partialName, int max) throws DirectoryException {
        Directory.checkSession(session);
        return session.getParticipantAccessor().fetchHumanParticipantMatchingName(partialName, max);
    }

    public static DirHumanParticipant[] fetchAllByFilter(DirectorySession session, FilterFields filterFields, String filter, int max) throws DirectoryException {
        Directory.checkSession(session);
        if (filterFields != FilterFields.NONE && (filter == null || filter.trim().length() == 0)) {
            throw new IllegalArgumentException("Filters must not be empty");
        }
        return session.getParticipantAccessor().fetchAllByFilter(filterFields, filter, max);
    }

    public static DirHumanParticipant[] fetchParticipantsForOU(DirectorySession session, DirOrganizationalUnit ou) throws DirectoryException {
        return session.getParticipantAccessor().fetchParticipantsForOU(ou);
    }

    public static Msg getPermissionMsg(String permission) {
        if (permission == null) {
            return null;
        }
        if ("X".equals(permission)) {
            return DirectoryMsg.PERMISION_X;
        }
        if ("R".equals(permission)) {
            return DirectoryMsg.PERMISION_R;
        }
        if ("S".equals(permission)) {
            return DirectoryMsg.PERMISION_S;
        }
        if ("A".equals(permission)) {
            return CoreMsg.A;
        }
        if ("D".equals(permission)) {
            return DirectoryMsg.PERMISION_D;
        }
        if ("G".equals(permission)) {
            return DirectoryMsg.PERMISION_G;
        }
        if ("E".equals(permission)) {
            return DirectoryMsg.PERMISION_E;
        }
        if ("P".equals(permission)) {
            return DirectoryMsg.PERMISION_P;
        }
        return null;
    }

    public static int getPermissionValue(String permission) {
        int p = permission.length() != 1 ? -1 : PERMISSIONS.indexOf(Character.toUpperCase(permission.charAt(0)));
        return p == -1 ? -1 : 1 << p;
    }

    public static String[] getPossiblePermissions() {
        return Str.chars(PERMISSIONS);
    }

    public static void setGlobalTrustPrincipal(DirectorySession session, String principal) throws DirectoryException {
        DirHumanParticipant.setGlobalTrustPrincipal(session, principal, false);
    }

    public static void setGlobalTrustPrincipal(DirectorySession session, String principal, boolean skipAuth) throws DirectoryException {
        Directory.checkAdministratorSession(session);
        session.getAuthenticationAccessor().setParticipantTrust(null, principal, skipAuth);
    }

    public static void unsetGlobalTrustPrincipal(DirectorySession session, String principal) throws DirectoryException {
        Directory.checkAdministratorSession(session);
        session.getAuthenticationAccessor().unsetParticipantTrust(null, principal);
    }

    public void becomeHumanParticipant(int newIn, String newId) {
        this.in_d = newIn;
        this.internalProviderId_d = newId;
    }

    public boolean canBeDisabled() {
        return !this.isRoot();
    }

    public boolean canBeModified() {
        return !this.isRoot();
    }

    public boolean canBeReplacementOf(DirHumanParticipant otherParticipant) {
        if (DirOrganizationalUnit.isContainedBy(otherParticipant.getOU(), this.getOU())) {
            for (RoleAssignment roleAssignment : this.rolesAssignment) {
                for (RoleAssignment otherRoleAssignment : otherParticipant.rolesAssignment) {
                    if (!DirHumanParticipant.equivalent(roleAssignment, otherRoleAssignment)) continue;
                    return true;
                }
            }
            try {
                List<RoleAssignment> otherRoles = this.fetchRoles(otherParticipant);
                for (RoleAssignment roleAssignment : this.fetchRoles(this)) {
                    for (RoleAssignment otherRoleAssignment : otherRoles) {
                        if (!DirHumanParticipant.equivalent(roleAssignment, otherRoleAssignment)) continue;
                        return true;
                    }
                }
            }
            catch (DirectoryException directoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public void changePassword(String oldPassword, String newPassword) throws DirectoryException {
        DirectorySession s = this.getDirectoryUserSession();
        if (!s.supports().changeParticipantPassword()) {
            throw new OperationNotSupportedException("change participant password", this.getId());
        }
        DirHumanParticipant.check(newPassword != null && newPassword.trim().length() > 0, DirectoryMsg.DIR_00100);
        s.getAuthenticationAccessor().checkPasswordAttributeValue(this.getId(), newPassword);
        if (!s.isAdministratorOf(this.getOU())) {
            DirHumanParticipant.check(this.getId().equalsIgnoreCase(s.getParticipant()), DirectoryMsg.DIR_00105);
            DirHumanParticipant.check(oldPassword != null && oldPassword.length() > 0, DirectoryMsg.DIR_00101);
        } else {
            oldPassword = null;
        }
        s.getAuthenticationAccessor().changeParticipantPassword(this, oldPassword, newPassword);
    }

    public void changePhoto(byte[] photo) throws DirectoryException {
        this.getDirectorySession().getParticipantAccessor().changeParticipantPhoto(this, photo);
    }

    @Override
    public void delete() throws DirectoryException {
        if (!this.getDirectorySession().supports().deleteParticipants()) {
            throw new OperationNotSupportedException("delete participant", this.getId());
        }
        DirHumanParticipant.check(!this.isRoot(), DirectoryMsg.DIR_00117);
        this.getDirectoryAdministratorSession(this.getDirectorySession().getSessionParticipant(), 1, this.getOU()).getParticipantAccessor().deleteHumanParticipant(this);
    }

    public String[] fetchAssignedGroups() throws DirectoryException {
        return this.getDirectorySession().getGroupAccessor().fetchGroupsForParticipant(this);
    }

    public DirHumanParticipant[] fetchParticipantsReplaced() throws DirectoryException {
        return this.getDirectorySession().getParticipantAccessor().fetchParticipantsReplaced(this);
    }

    public byte[] fetchPhoto() throws DirectoryException {
        return this.getDirectorySession().getParticipantAccessor().fetchParticipantPhoto(this);
    }

    public TimeZone fetchTimezone() throws DirectoryException {
        if (this.timezone == null) {
            this.timezone = this.getDirectorySession().getParticipantAccessor().fetchTimezone(this);
            if (this.timezone == null) {
                this.timezone = TimeZone.getDefault();
            }
        }
        return this.timezone;
    }

    public void changeTimezone(TimeZone tz) throws DirectoryException {
        DirectorySession s = this.getDirectoryUserSession();
        if (!s.getParticipant().equalsIgnoreCase(this.getId()) && !s.isAdministratorOf(this.getOU())) {
            throw new NoPermissionException(DirectoryMsg.DIR_00205);
        }
        s.getParticipantAccessor().changeTimezone(this, tz != null ? tz : TimeZone.getDefault());
        this.timezone = tz;
    }

    public Locale fetchLocale() throws DirectoryException {
        if (this.locale == null) {
            this.locale = this.getDirectorySession().getParticipantAccessor().fetchLocale(this);
            if (this.locale == null) {
                this.locale = Locale.getDefault();
            }
        }
        return this.locale;
    }

    public void changeLocale(Locale l) throws DirectoryException {
        DirectorySession s = this.getDirectoryUserSession();
        if (!s.getParticipant().equalsIgnoreCase(this.getId()) && !s.isAdministratorOf(this.getOU())) {
            throw new NoPermissionException(DirectoryMsg.DIR_00205);
        }
        s.getParticipantAccessor().changeLocale(this, l != null ? l : Locale.getDefault());
        this.locale = l;
    }

    public Absence getAbsenceFor(Time time) {
        if (time == null) {
            return null;
        }
        for (Absence abs : this.absencePeriods) {
            if (!time.between(abs.from, abs.to)) continue;
            return abs;
        }
        return null;
    }

    public Absence[] getAbsencePeriods() {
        assert (this.absencePeriods != null) : "Absence Periods can not be null";
        return this.absencePeriods;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public String getEmployeeId() {
        return this.employeeId;
    }

    public String getFax() {
        return this.fax;
    }

    public String getFirstName() {
        return this.firstName;
    }

    @Deprecated
    public String getGlobalDN() {
        return "uid=" + this.getId() + ",o=" + this.getOrganization();
    }

    @Override
    public String getGlobalId() {
        return this.getId() + '@' + this.getOrganization();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getMail() {
        return this.mail;
    }

    public String getManager() {
        return this.manager;
    }

    public String getOU() {
        return this.ou;
    }

    public RoleAssignment[] getRolesAssignment() {
        assert (this.rolesAssignment != null);
        return this.rolesAssignment;
    }

    public String getStatus() {
        return this.statusSupport.getStatus();
    }

    public String getTelephone() {
        return this.telephone;
    }

    public boolean hasGroupAssigned(String group) throws DirectoryException {
        return this.getDirectorySession().getGroupAccessor().hasGroupAssigned(this, group);
    }

    public boolean hasRoleAssigned(String role) {
        for (RoleAssignment aRolesAssignment : this.rolesAssignment) {
            if (!aRolesAssignment.role.equalsIgnoreCase(role)) continue;
            return true;
        }
        return false;
    }

    public boolean hasRoleAssigned(String role, String parametricValue) {
        assert (parametricValue != null);
        for (RoleAssignment aRolesAssignment : this.rolesAssignment) {
            if (!aRolesAssignment.role.equalsIgnoreCase(role) || !parametricValue.equals(aRolesAssignment.parametricValue)) continue;
            return true;
        }
        return false;
    }

    public boolean isAdministrator() {
        return this.statusSupport.isAdministrator();
    }

    public void setAdministrator(boolean isAdministrator) {
        DirHumanParticipant.check(!this.isRoot(), DirectoryMsg.DIR_00109);
        this.statusSupport.setAdministrator(isAdministrator);
    }

    public boolean isEnabled() {
        return this.statusSupport.isEnabled();
    }

    public boolean isRoot() {
        return this.statusSupport.isRoot();
    }

    public boolean receivesMail() {
        if (this.receivesMail == null) {
            Object value = null;
            try {
                value = this.retrieveProperty(PREFERENCES, RECEIVES_MAIL);
            }
            catch (DirectoryException ex) {
                Log.logSevere(ex);
            }
            this.receivesMail = value != null ? Boolean.valueOf((String)value) : Boolean.FALSE;
        }
        return this.receivesMail;
    }

    public void receivesMail(boolean r) {
        try {
            this.storePropertyInternal(PREFERENCES, RECEIVES_MAIL, (Serializable)((Object)String.valueOf(r)));
            this.receivesMail = r;
        }
        catch (DirectoryException e) {
            Log.logSevere(e);
        }
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectorySession().getParticipantAccessor().refreshHumanParticipant(this);
    }

    public Map retrieveAllFuegoProperties() throws DirectoryException {
        return this.getDirectoryUserSession().getObjectPropertiesAccessor().fetchAllFuegoProperties(this);
    }

    @Override
    public Map<String, Object> retrieveAllProperties(String category) throws DirectoryException {
        return this.retrieveAllPropertiesImpl(category);
    }

    public String retrieveEncryptedProperty(String category, String key) throws DirectoryException {
        return this.getDirectoryUserSession().getObjectPropertiesAccessor().fetchEncrypted(this, category, key);
    }

    @Override
    public String retrieveEncryptedProperty(String category, String key, String encryptionKey) throws DirectoryException {
        return this.retrieveEncryptedPropertyImpl(category, key, encryptionKey);
    }

    @Override
    public Object retrieveProperty(String category, String key) throws DirectoryException {
        return this.retrievePropertyImpl(category, key);
    }

    @Override
    public String retrieveStringProperty(String category, String key) throws DirectoryException {
        return this.retrieveStringPropertyImpl(category, key);
    }

    public void setAbsencePeriods(Absence[] absencePeriods) {
        DirHumanParticipant.check(!this.isRoot(), DirectoryMsg.DIR_00110);
        DirHumanParticipant.check(absencePeriods != null, DirectoryMsg.DIR_00111);
        this.absencePeriods = ArrayUtils.trim(absencePeriods);
    }

    public void setDisplayName(String name) {
        DirHumanParticipant.check(name != null && name.length() > 0, DirectoryMsg.DIR_00050);
        this.displayName = name;
    }

    public void setEmployeeId(String id) {
        this.employeeId = id != null ? id : "";
    }

    public void setEnabled(boolean enabled) {
        DirHumanParticipant.check(!this.isRoot(), DirectoryMsg.DIR_00109);
        this.statusSupport.setEnabled(enabled);
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public void setFirstName(String name) {
        this.firstName = name != null ? name : "";
    }

    public void setLastName(String name) {
        this.lastName = name != null ? name : "";
    }

    public void setMail(String mail) {
        this.mail = mail != null ? mail : "";
    }

    public void setManager(String manager) {
        this.manager = manager != null ? manager : "";
    }

    public void setOU(String ou) {
        DirHumanParticipant.check(ou != null, DirectoryMsg.DIR_00102);
        this.ou = ou;
    }

    public void setOU(DirOrganizationalUnit ou) {
        DirHumanParticipant.check(ou != null, DirectoryMsg.DIR_00102);
        assert (ou != null);
        this.ou = ou.getId();
    }

    public int getPermissions() {
        return this.permissions;
    }

    public void setPermissions(int permissions) {
        this.permissions = permissions;
    }

    public void addPermission(int permission) {
        this.setPermissions(this.getPermissions() | permission);
    }

    public void removePermission(int permission) {
        this.setPermissions(this.getPermissions() & ~permission);
    }

    public boolean hasPermission(int permission) {
        return (this.getPermissions() & permission) != 0;
    }

    public String[] fetchAdministeredOUs() throws DirectoryException {
        if (this.administeredOUs == null) {
            this.administeredOUs = this.getDirectorySession().getParticipantAccessor().fetchAdministeredOUs(this);
        }
        return this.administeredOUs;
    }

    public void changeAdministeredOUs(String[] ous) throws DirectoryException {
        this.getDirectoryAdministratorSession().getParticipantAccessor().changeAdministeredOUs(this, ous);
        this.administeredOUs = ous;
    }

    public boolean isOUAdministeredBy(String orgUnit) {
        boolean result = false;
        try {
            String[] ous = this.fetchAdministeredOUs();
            for (int i = 0; i < ous.length && !result; ++i) {
                if (!DirOrganizationalUnit.isContainedBy(orgUnit, ous[i])) continue;
                result = true;
            }
        }
        catch (DirectoryException e) {
            throw DirectoryRuntimeException.wrapException(e);
        }
        return result;
    }

    public void setRolesAssignment(RoleAssignment[] rolesAssignment) {
        DirHumanParticipant.check(!this.isRoot(), DirectoryMsg.DIR_00110);
        this.rolesAssignment = DirHumanParticipant.checkRolesAssignment(this.getDirectorySession(), this.getId(), rolesAssignment);
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public void setTrustPrincipal(String principal) throws DirectoryException {
        this.setTrustPrincipal(principal, false);
    }

    public void setTrustPrincipal(String principal, boolean skipAuth) throws DirectoryException {
        DirectorySession s = this.getDirectoryAdministratorSession();
        s.getAuthenticationAccessor().setParticipantTrust(this, principal, skipAuth);
    }

    public void storeEncryptedProperty(String category, String key, String value) throws DirectoryException {
        this.getDirectoryUserSession().getObjectPropertiesAccessor().createEncrypted(this, category, key, value);
    }

    @Override
    public void storeEncryptedProperty(String category, String key, String value, String encryptionKey) throws DirectoryException {
        this.storeEncryptedPropertyImpl(category, key, value, encryptionKey);
    }

    @Override
    public void storeProperty(String category, String key, Serializable value) throws DirectoryException {
        if (PREFERENCES.equals(category) && RECEIVES_MAIL.equals(key)) {
            this.receivesMail(Boolean.valueOf((String)((Object)value)));
        } else {
            this.storePropertyInternal(category, key, value);
        }
    }

    @Override
    public String toString() {
        return "firstName:" + this.getFirstName() + ",lastName:" + this.getLastName() + ",mail:" + this.getMail() + ",status:" + this.statusSupport.getStatus() + ",tel:" + this.getTelephone() + ",fax:" + this.getFax() + ",permissions:" + this.getPermissions() + '|' + super.toString();
    }

    public void unsetTrustPrincipal(String principal) throws DirectoryException {
        DirectorySession s = this.getDirectoryAdministratorSession();
        s.getAuthenticationAccessor().unsetParticipantTrust(this, principal);
    }

    @Override
    public void update() throws DirectoryException {
        DirHumanParticipant.check(this.lastName != null && this.lastName.length() > 0, DirectoryMsg.DIR_00135);
        DirHumanParticipant.check(this.displayName != null && this.displayName.length() > 0, DirectoryMsg.DIR_00134);
        this.getDirectoryAdministratorSession(this.getDirectorySession().getSessionParticipant(), 1, this.getOU()).getParticipantAccessor().updateHumanParticipant(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void writeXML(XmlWriter xmlWriter, StringList categories) throws IOException {
        xmlWriter.startElement(ELEM_PART);
        xmlWriter.printValuedElement("id", this.getId());
        xmlWriter.printValuedElement("firstName", this.getFirstName());
        xmlWriter.printValuedElement("lastName", this.getLastName());
        xmlWriter.printValuedElement("displayName", this.getDisplayName());
        xmlWriter.printValuedElement(RECEIVES_MAIL, this.getMail());
        xmlWriter.printValuedElement("receivesMail", String.valueOf(this.receivesMail()));
        xmlWriter.printValuedElement("ou", this.getOU());
        xmlWriter.printValuedElement("status", this.getStatus());
        xmlWriter.printValuedElement("telephone", this.getTelephone());
        xmlWriter.printValuedElement("fax", this.getFax());
        xmlWriter.printValuedElement("employeeId", this.getEmployeeId());
        xmlWriter.printValuedElement("manager", this.getManager());
        xmlWriter.printValuedElement("perm", String.valueOf(this.getPermissions()));
        if (this.rolesAssignment != null && this.rolesAssignment.length > 0) {
            xmlWriter.startElement("rolesAssignment");
            for (Serializable serializable : this.rolesAssignment) {
                ((RoleAssignment)serializable).writeXML(xmlWriter);
            }
            xmlWriter.endElement();
        }
        if (this.getDirectorySession().supports().userAdministration()) {
            String[] ous;
            try {
                ous = this.fetchAdministeredOUs();
            }
            catch (DirectoryException e) {
                throw DirectoryRuntimeException.wrapException(e);
            }
            if (ous != null && ous.length > 0) {
                void var6_13;
                xmlWriter.startElement("administeredOUs");
                String[] arr$ = ous;
                int len$ = arr$.length;
                boolean bl = false;
                while (var6_13 < len$) {
                    String administeredOU = arr$[var6_13];
                    xmlWriter.startElement("administeredOU");
                    if ("".equals(administeredOU)) {
                        administeredOU = "/";
                    }
                    xmlWriter.printValuedElement("administeredOUName", administeredOU);
                    xmlWriter.endElement();
                    ++var6_13;
                }
                xmlWriter.endElement();
            }
        }
        if (this.absencePeriods != null && this.absencePeriods.length > 0) {
            xmlWriter.startElement("absences");
            for (Serializable serializable : this.absencePeriods) {
                xmlWriter.startElement("absence");
                xmlWriter.printValuedElement("from", ((Absence)serializable).from.toString());
                xmlWriter.printValuedElement("to", ((Absence)serializable).to.toString());
                for (String replacement : ((Absence)serializable).replacements) {
                    xmlWriter.printValuedElement("replacement", replacement);
                }
                xmlWriter.endElement();
            }
            xmlWriter.endElement();
        }
        if (categories != null && !categories.isEmpty()) {
            xmlWriter.startElement("participantProperties");
            for (String category : categories) {
                try {
                    Map<String, Object> properties = this.retrieveAllProperties(category);
                    properties.putAll(this.retrieveAllProperties(null));
                    for (Map.Entry<String, Object> entry : properties.entrySet()) {
                        this.printProperty(xmlWriter, "participantProperty", category, entry.getKey(), entry.getValue() == null ? null : entry.getValue().toString());
                    }
                }
                catch (DirectoryException e) {
                    e.printStackTrace();
                }
            }
            xmlWriter.endElement();
        }
        xmlWriter.endElement();
    }

    public void assignToGroup(String groupId) throws DirectoryException {
        this.getDirectorySession().getGroupAccessor().assignParticipant(this, groupId);
    }

    public boolean unassignFromGroup(String groupId) throws DirectoryException {
        return this.getDirectorySession().getGroupAccessor().unassignParticipant(this, groupId);
    }

    public boolean isHumanParticipant() {
        return this.getIn() > 0;
    }

    protected final ParticipantAccessor getParticipantAccessor() {
        return this.getDirectorySession().getParticipantAccessor();
    }

    static RoleAssignment[] checkRolesAssignment(DirectorySession session, String object, RoleAssignment[] roleAssignments) {
        if (roleAssignments == null) {
            return new RoleAssignment[0];
        }
        for (int i = 0; i < roleAssignments.length; ++i) {
            RoleAssignment roleAssignment = roleAssignments[i];
            if (roleAssignment == null) continue;
            session.getAttributeValidator().validateRoleAssignment(roleAssignment);
            for (int j = i + 1; j < roleAssignments.length; ++j) {
                if (roleAssignment.equals(roleAssignments[j])) {
                    roleAssignments[j] = null;
                    continue;
                }
                if (!roleAssignment.equalsWithoutPermissionsAndCategory(roleAssignments[j])) continue;
                throw InvalidAttributeValueException.duplicateRoleAssignment(object, roleAssignment, roleAssignments[j]);
            }
        }
        return ArrayUtils.trim(roleAssignments);
    }

    private static boolean equivalent(RoleAssignment roleAssignment, RoleAssignment otherRoleAssignment) {
        return roleAssignment.equalsWithoutPermissionsAndCategory(otherRoleAssignment) && (roleAssignment.permissions & otherRoleAssignment.permissions) == otherRoleAssignment.permissions;
    }

    private List<RoleAssignment> fetchRoles(DirHumanParticipant participant) throws DirectoryException {
        ArrayList<RoleAssignment> otherRoles = new ArrayList<RoleAssignment>();
        for (String idGroup : participant.fetchAssignedGroups()) {
            otherRoles.addAll(Arrays.asList(DirOrganizationalGroup.fetch(this.getDirectorySession(), idGroup).getRolesAssignment()));
        }
        return otherRoles;
    }

    private void storePropertyInternal(String category, String key, Serializable value) throws DirectoryException {
        DirectorySession s = this.getDirectoryUserSession();
        if (!s.getParticipant().equalsIgnoreCase(this.getId()) && !s.isAdministratorOf(this.getOU())) {
            throw new NoPermissionException(DirectoryMsg.DIR_00205);
        }
        this.storePropertyImpl(category, key, value);
    }

    public static class StatusSupport
    implements Serializable {
        private char status;
        private static final long serialVersionUID = -6565351592334391615L;

        public StatusSupport(String status) {
            this.status = Character.toUpperCase(status.charAt(0));
        }

        public boolean isRoot() {
            return this.status == 'R';
        }

        public boolean isAdministrator() {
            return this.isRoot() || this.status == 'S' || this.status == 'E';
        }

        public boolean isEnabled() {
            return this.status == 'R' || this.status == 'S' || this.status == 'A';
        }

        public void setEnabled(boolean enabled) {
            if (enabled) {
                switch (this.status) {
                    case 'E': {
                        this.status = (char)83;
                        break;
                    }
                    case 'D': {
                        this.status = (char)65;
                    }
                }
            } else {
                switch (this.status) {
                    case 'S': {
                        this.status = (char)69;
                        break;
                    }
                    case 'A': {
                        this.status = (char)68;
                    }
                }
            }
        }

        public void setAdministrator(boolean administrator) {
            if (administrator) {
                switch (this.status) {
                    case 'A': {
                        this.status = (char)83;
                        break;
                    }
                    case 'D': {
                        this.status = (char)69;
                    }
                }
            } else {
                switch (this.status) {
                    case 'S': {
                        this.status = (char)65;
                        break;
                    }
                    case 'E': {
                        this.status = (char)68;
                    }
                }
            }
        }

        public String getStatus() {
            return new String(new char[]{this.status});
        }
    }

    public static class RoleAssignment
    implements Serializable {
        public final int category;
        public final String parametricValue;
        public final int permissions;
        public final String role;
        public final int roleIn;
        public static final int DEFAULT_CATEGORY = 5;
        static final long serialVersionUID = -4589250245947172934L;
        static final long serialCheck = 121520205709660919L;

        public RoleAssignment(String role, int permissions, int roleIn) {
            this(role, null, permissions, roleIn, 5);
        }

        public RoleAssignment(String role, int permissions, int roleIn, int category) {
            this(role, null, permissions, roleIn, category);
        }

        public RoleAssignment(String role, String parametricValue, int permissions, int roleIn) {
            this(role, parametricValue, permissions, roleIn, 5);
        }

        public RoleAssignment(String role, String parametricValue, int permissions, int roleIn, int category) {
            assert (role != null) : "The role must not be null!";
            this.role = role;
            this.parametricValue = parametricValue != null && parametricValue.trim().length() == 0 ? null : parametricValue;
            this.permissions = permissions;
            this.roleIn = roleIn;
            this.category = category;
        }

        public void writeXML(XmlWriter xmlWriter) throws IOException {
            xmlWriter.startElement("roleAssignment");
            xmlWriter.printValuedElement("roleId", this.role);
            xmlWriter.printValuedElement("parametricValue", this.parametricValue);
            xmlWriter.printValuedElement("permissions", String.valueOf(this.permissions));
            xmlWriter.printValuedElement("category", String.valueOf(this.category));
            xmlWriter.endElement();
        }

        @Deprecated
        public String asStoreString() {
            return this.role + ':' + this.permissions + ':' + (this.parametricValue == null ? "" : this.parametricValue) + ':' + this.roleIn + ':' + this.category;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RoleAssignment)) {
                return false;
            }
            RoleAssignment other = (RoleAssignment)obj;
            if (!this.role.equals(other.role) || this.permissions != other.permissions || this.category != other.category) {
                return false;
            }
            if (this.parametricValue == null) {
                return other.parametricValue == null;
            }
            return this.parametricValue.equals(other.parametricValue);
        }

        public boolean equalsWithoutPermissions(RoleAssignment other) {
            if (other == null) {
                return false;
            }
            if (!this.role.equals(other.role) || this.category != other.category) {
                return false;
            }
            if (this.parametricValue == null) {
                return other.parametricValue == null;
            }
            return this.parametricValue.equals(other.parametricValue);
        }

        public boolean equalsWithoutPermissionsAndCategory(RoleAssignment other) {
            if (other == null) {
                return false;
            }
            if (!this.role.equals(other.role)) {
                return false;
            }
            if (this.parametricValue == null) {
                return other.parametricValue == null;
            }
            return this.parametricValue.equals(other.parametricValue);
        }

        public int hashCode() {
            return this.roleIn;
        }

        public String toString() {
            return this.role + ':' + this.permissions + ':' + (this.parametricValue == null ? "" : this.parametricValue) + ':' + this.roleIn + ':' + this.category;
        }
    }

    public static class Absence
    implements Serializable {
        public final Time from;
        public final String[] replacements;
        public final Time to;
        public static final String replacement = null;
        static final long serialVersionUID = -4589250245947172934L;
        static final long serialCheck = 121520205709660919L;

        public Absence(Time from, Time to) {
            this(from, to, new String[0]);
        }

        public Absence(Time from, Time to, String replacement) {
            this(from, to, new String[]{replacement});
        }

        public Absence(Time from, Time to, String[] replacements) {
            this.from = from;
            this.to = to;
            this.replacements = replacements;
        }

        public String toString() {
            StringList listReplacements = StringList.create(this.replacements).sort();
            return this.from.format() + ':' + this.to.format() + ':' + listReplacements.toString();
        }
    }
}

