/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.exception.OperationNotSupportedException;
import fuego.directory.msg.DirectoryMsg;
import java.io.Serializable;
import java.util.Map;
import oracle.bpm.util.ArrayUtils;

public class DirEngine
extends DirObject {
    protected String id_d;
    protected String[] locations_d;
    static final long serialVersionUID = -3551978232465137837L;
    static final long serialCheck = 5045131733003647120L;

    public DirEngine(DirectorySession session, String id, String internalId) {
        this(session, -1, id, internalId);
    }

    public DirEngine(DirectorySession session, int in, String id, String internalId) {
        super(session, in, internalId);
        this.id_d = id;
        this.locations_d = new String[0];
    }

    public static DirEngine create(DirectorySession session, String id) throws DirectoryException {
        Directory.checkAdministratorSession(session);
        DirEngine.check(id != null && id.length() > 0, DirectoryMsg.DIR_00126);
        session.getAttributeValidator().validateEngineId(id);
        return session.getEngineAccessor().createEngine(id);
    }

    public static DirEngine fetch(DirectorySession session, String id) throws DirectoryException {
        Directory.checkSession(session);
        DirEngine.check(id != null && id.length() > 0, DirectoryMsg.DIR_00126);
        return session.getEngineAccessor().fetchEngine(id);
    }

    public static DirEngine[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getEngineAccessor().fetchAllEngines();
    }

    @Override
    public String getDisplayName() {
        return this.getId();
    }

    @Override
    public String getId() {
        return this.id_d;
    }

    public void setLocations(String[] locations) {
        DirEngine.check(locations != null, DirectoryMsg.DIR_00107);
        this.locations_d = ArrayUtils.trim(locations);
    }

    public String[] getLocations() {
        return this.locations_d;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectoryAdministratorSession().getEngineAccessor().deleteEngine(this);
    }

    @Override
    public void refresh() throws DirectoryException {
        throw new OperationNotSupportedException("refresh", this.toString());
    }

    @Override
    public Map<String, Object> retrieveAllProperties(String category) throws DirectoryException, OperationNotSupportedException {
        return this.retrieveAllPropertiesImpl(category);
    }

    @Override
    public String retrieveEncryptedProperty(String category, String key, String encryptionKey) throws DirectoryException, OperationNotSupportedException {
        return this.retrieveEncryptedPropertyImpl(category, key, encryptionKey);
    }

    @Override
    public Object retrieveProperty(String category, String key) throws DirectoryException, OperationNotSupportedException {
        return this.retrievePropertyImpl(category, key);
    }

    @Override
    public void storeEncryptedProperty(String category, String key, String value, String encryptionKey) throws DirectoryException, OperationNotSupportedException {
        this.storeEncryptedPropertyImpl(category, key, value, encryptionKey);
    }

    @Override
    public void storeProperty(String category, String key, Serializable value) throws DirectoryException, OperationNotSupportedException {
        this.storePropertyImpl(category, key, value);
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectoryAdministratorSession().getEngineAccessor().updateEngine(this);
    }
}

