/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.BusinessParameterMapping;
import fuego.directory.DirEngine;
import fuego.directory.DirHumanParticipant;
import fuego.directory.DirObject;
import fuego.directory.DirOrganizationalUnit;
import fuego.directory.DirProcessDefinition;
import fuego.directory.DirProjectRevision;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.RoleMapping;
import fuego.directory.exception.InvalidAttributeValueException;
import fuego.directory.exception.OperationNotSupportedException;
import fuego.directory.msg.DirectoryMsg;
import java.io.Serializable;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.bpm.log.Log;

public class DirDeployedProcess
extends DirObject {
    protected String engine_d;
    protected String name_d;
    protected String ou_d;
    protected String processDefinitionId;
    protected int processesByProjectIn;
    protected int projectRevisionIn = -1;
    protected String status_d;
    protected String version_d;
    public static final String GENERIC_SEPARATOR = "/";
    public static final String VERSION_SEPARATOR = "#";
    public static final String ORGANIZATION_SEPARATOR = "@";
    public static final String ACTIVE = "A";
    public static final String DEPRECATED = "D";
    public static final String UNDEPLOYED = "U";
    static final long serialVersionUID = 2445662457878447174L;
    static final long serialCheck = -4010031843231397406L;

    public DirDeployedProcess(DirectorySession session, int in, String name, String version, String engine, String ou, String processDefinitionId, int processDefinitionIn, String status, String internalID) {
        this(session, in, name, version, engine, ou, processDefinitionId, processDefinitionIn, status, -1, internalID);
    }

    public DirDeployedProcess(DirectorySession session, int in, String name, String version, String engine, String ou, String processDefinitionId, int processDefinitionIn, String status, int projectRevisionIn, String internalID) {
        super(session, in, internalID);
        this.name_d = name;
        this.version_d = version;
        this.engine_d = engine;
        this.ou_d = ou;
        this.processDefinitionId = processDefinitionId;
        this.processesByProjectIn = processDefinitionIn;
        this.status_d = status;
        this.projectRevisionIn = projectRevisionIn;
    }

    public static boolean isConsolidatedId(String processId) {
        return processId.lastIndexOf(VERSION_SEPARATOR) == -1;
    }

    public static String getDeployedVersion(int major, int minor) {
        return major + "." + minor;
    }

    public static final int getProcessMinorFromID(String processId) {
        String processVersion = DirDeployedProcess.getProcessVersionFromID(processId);
        int indexOf = processVersion.lastIndexOf("-");
        if (indexOf == -1) {
            return -1;
        }
        try {
            String version = processVersion.substring(indexOf + 1);
            indexOf = version.lastIndexOf(".") + 1;
            if (indexOf == 0) {
                return -1;
            }
            return Integer.parseInt(version.substring(indexOf));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static String getProcessNameFromID(String processID) {
        int init = processID.lastIndexOf(GENERIC_SEPARATOR) + 1;
        int end = processID.lastIndexOf(VERSION_SEPARATOR);
        if (init <= 0) {
            throw InvalidAttributeValueException.invalidValue("Process identification", processID);
        }
        return end == -1 ? processID.substring(init) : processID.substring(init, end);
    }

    public static String getProcessVersionFromID(String processID) {
        int init = processID.lastIndexOf(VERSION_SEPARATOR) + 1;
        if (init == 0) {
            return "";
        }
        int end = processID.indexOf(ORGANIZATION_SEPARATOR);
        end = end == -1 ? processID.length() : end;
        return processID.substring(init, end);
    }

    @Deprecated
    public static DirDeployedProcess create(DirectorySession session, DirProcessDefinition processDefinition, DirProjectRevision projectRevision, DirEngine engine, DirOrganizationalUnit ou) throws DirectoryException {
        return DirDeployedProcess.create(session, processDefinition, projectRevision, "", engine, ou);
    }

    public static DirDeployedProcess create(DirectorySession session, DirProcessDefinition processDefinition, DirProjectRevision projectRevision, String processProperties, DirEngine engine, DirOrganizationalUnit ou) throws DirectoryException {
        Directory.checkSession(session);
        DirDeployedProcess.check(processProperties != null, DirectoryMsg.DIR_00124);
        DirDeployedProcess.check(processDefinition != null, DirectoryMsg.DIR_00124);
        DirDeployedProcess.check(engine != null, DirectoryMsg.DIR_00125);
        DirDeployedProcess.check(ou != null, DirectoryMsg.DIR_00102);
        return session.getProcessAccessor().createDeployedProcess(processDefinition, projectRevision, processProperties, engine, ou);
    }

    public static DirDeployedProcess fetch(DirectorySession session, int in) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchDeployedProcess(in);
    }

    public static DirDeployedProcess fetch(DirectorySession session, String id) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchDeployedProcess(id);
    }

    public static DirDeployedProcess[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchAllDeployedProcesses();
    }

    public static DirDeployedProcess[] fetchAllByIdAndStatus(DirectorySession session, String id, String status) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchAllDeployedProcessesByIdAndStatus(id, status);
    }

    public static DirDeployedProcess[] fetchAllByIdAndStatus(DirectorySession session, String name, String ou, String status) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchAllDeployedProcessesByIdAndStatus(name, ou, status);
    }

    public static DirDeployedProcess[] fetchAllByName(DirectorySession session, String name) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchAllDeployedProcessesByName(name);
    }

    public static DirDeployedProcess[] fetchConsolidatedProcesses(DirectorySession session, String name, DirOrganizationalUnit ou) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchAllConsolidatedDeployedProcesses(name, ou);
    }

    public static DirDeployedProcess[] fetchDeployedProcessesByRoles(DirectorySession session, DirHumanParticipant.RoleAssignment[] roles, String ou) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchDeployedProcessesByRoles(roles, ou);
    }

    public static DirDeployedProcess[] fetchForEngine(DirectorySession session, DirEngine engine) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchDeployedProcessesForEngine(engine);
    }

    public static DirDeployedProcess[] fetchForParticipant(DirectorySession session, DirHumanParticipant participant) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProcessAccessor().fetchDeployedProcessesForParticipant(participant);
    }

    public static String getOUFromID(String processID) {
        assert (processID != null) : "The processID can not be null";
        int indexOf = processID.lastIndexOf(GENERIC_SEPARATOR);
        if (indexOf < 0) {
            throw InvalidAttributeValueException.invalidValue("Process identification", processID);
        }
        if (indexOf == 0) {
            return DirOrganizationalUnit.getRootId();
        }
        return processID.substring(1, indexOf);
    }

    public static final int getProcessMayorFromID(String processId) {
        String processVersion = DirDeployedProcess.getProcessVersionFromID(processId);
        int indexOf = processVersion.lastIndexOf("-");
        if (indexOf == -1) {
            return -1;
        }
        try {
            String version = processVersion.substring(indexOf + 1);
            indexOf = version.lastIndexOf(".");
            if (indexOf == -1) {
                return Integer.parseInt(version);
            }
            return Integer.parseInt(version.substring(0, indexOf));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    public static final boolean isValidId(String processId) {
        if (processId == null) {
            return false;
        }
        if (!processId.substring(0, 1).equals(GENERIC_SEPARATOR)) {
            return false;
        }
        int indexOf = processId.lastIndexOf(VERSION_SEPARATOR);
        if (indexOf == -1) {
            return false;
        }
        if (DirDeployedProcess.getProcessMayorFromID(processId) == -1) {
            return false;
        }
        return DirDeployedProcess.getProcessMinorFromID(processId) != -1;
    }

    public static String buildId(String organizationalUnit, String processName, String processVersion) {
        organizationalUnit = DirOrganizationalUnit.isRootId(organizationalUnit) ? "" : GENERIC_SEPARATOR + organizationalUnit;
        return organizationalUnit + GENERIC_SEPARATOR + processName + VERSION_SEPARATOR + processVersion;
    }

    public static final String convertToNewDeployedProcessId(String processId) {
        if (processId == null || processId.equals("")) {
            return GENERIC_SEPARATOR;
        }
        if (!processId.substring(0, 1).equals(GENERIC_SEPARATOR)) {
            String processOrgUnit;
            String processName;
            String auxiliar = processId;
            int indexOf = auxiliar.lastIndexOf(GENERIC_SEPARATOR);
            if (indexOf == -1) {
                return GENERIC_SEPARATOR + processId;
            }
            String processVersion = auxiliar.substring(indexOf + 1);
            int subIndexOf = processVersion.lastIndexOf("_");
            if (processVersion.lastIndexOf("-") != -1 && subIndexOf != -1) {
                processVersion = processVersion.substring(0, subIndexOf) + "." + processVersion.substring(subIndexOf + 1);
                auxiliar = auxiliar.substring(0, indexOf);
            } else {
                processVersion = null;
            }
            indexOf = auxiliar.lastIndexOf(GENERIC_SEPARATOR);
            if (indexOf != -1) {
                processName = auxiliar.substring(indexOf + 1);
                processOrgUnit = auxiliar.substring(0, indexOf);
            } else {
                processName = auxiliar;
                processOrgUnit = null;
            }
            processId = "";
            if (processOrgUnit != null) {
                processId = processId + GENERIC_SEPARATOR + processOrgUnit;
            }
            processId = processVersion == null ? processId + GENERIC_SEPARATOR + processName : processId + GENERIC_SEPARATOR + processName + VERSION_SEPARATOR + processVersion;
        }
        return processId;
    }

    public static final String convertToOldDeployedProcessId(String processId) {
        if (processId == null || processId.equals("")) {
            return "";
        }
        if (processId.substring(0, 1).equals(GENERIC_SEPARATOR)) {
            String processName = DirDeployedProcess.getProcessNameFromID(processId);
            String processVersion = DirDeployedProcess.getProcessVersionFromID(processId);
            String processOrgUnit = DirDeployedProcess.getOUFromID(processId);
            if (processVersion.equals("")) {
                processVersion = null;
            } else {
                int indexOf = processVersion.lastIndexOf(".");
                processVersion = processVersion.substring(0, indexOf) + "_" + processVersion.substring(indexOf + 1);
            }
            processId = "";
            if (!DirOrganizationalUnit.isRootId(processOrgUnit)) {
                processId = processOrgUnit + GENERIC_SEPARATOR;
            }
            processId = processVersion == null ? processId + processName : processId + processName + GENERIC_SEPARATOR + processVersion;
        }
        return processId;
    }

    public static String getConsolidatedId(String processId) {
        StringBuilder builder = new StringBuilder();
        Matcher matcher = Pattern.compile("\\S.+#").matcher(processId);
        if (matcher.find()) {
            String name = matcher.group();
            builder.append(name.substring(0, name.length() - 1));
            Matcher orgMatcher = Pattern.compile("\\b@.+").matcher(processId);
            if (orgMatcher.find()) {
                builder.append(orgMatcher.group());
            }
        }
        return builder.length() == 0 ? processId : builder.toString();
    }

    @Override
    public String getDisplayName() {
        return this.getName() + "_v." + this.getVersion();
    }

    public String getEngine() {
        return this.engine_d;
    }

    @Override
    public String getId() {
        return DirDeployedProcess.buildId(this.ou_d, this.name_d, this.version_d);
    }

    public String getName() {
        return this.name_d;
    }

    public String getOU() {
        return this.ou_d;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public int getProcessesByProjectIn() {
        return this.processesByProjectIn;
    }

    public void setStatus(String status) {
        boolean pending = this.isPending();
        this.status_d = status;
        this.setPending(pending);
        if (UNDEPLOYED.equals(this.status_d) && this.isPending()) {
            Log.logTrace("No deberia llegar a un UNDEPLOYED PENDING status.");
        }
    }

    public String getStatus() {
        return this.status_d.toUpperCase();
    }

    public String getStatusAndPending() {
        return this.status_d;
    }

    public String getVersion() {
        return this.version_d;
    }

    public boolean isVisibleTo(String ou) {
        return DirOrganizationalUnit.areVisible(this.getOU(), ou);
    }

    public String getConsolidatedId() {
        String ouStr = DirOrganizationalUnit.isRootId(this.ou_d) ? "" : this.ou_d;
        return ouStr + GENERIC_SEPARATOR + this.name_d;
    }

    public void changeProcessDefinition(DirProjectRevision projectRevision, DirProcessDefinition processDefinition) throws DirectoryException {
        this.processDefinitionId = processDefinition.getId();
        this.processesByProjectIn = this.getDirectoryAdministratorSession().getProcessAccessor().changeDeployedProcess(this, projectRevision, processDefinition);
    }

    public void changeProcessProperties(String xmlProperties) throws DirectoryException {
        this.getDirectorySession().getProcessAccessor().changeDeploymentPropertiesFor(this, xmlProperties);
    }

    public int getProjectRevisionIn() {
        if (this.projectRevisionIn == -1) {
            try {
                this.projectRevisionIn = this.getDirectorySession().getProjectAccessor().fetchProjectRevisionInByProcessesByProjectIn(this.processesByProjectIn);
            }
            catch (DirectoryException e) {
                Log.logSevere(e);
            }
        }
        return this.projectRevisionIn;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectoryAdministratorSession().getProcessAccessor().deleteDeployedProcess(this);
    }

    public BusinessParameterMapping[] fetchBusinessParameterMapping() throws DirectoryException {
        return this.getDirectorySession().getProcessAccessor().fetchBusinessParameterMapping(this);
    }

    public DirProcessDefinition fetchProcessDefinition() throws DirectoryException {
        return this.getDirectorySession().getProcessAccessor().fetchProcessDefinition(this, this.processesByProjectIn);
    }

    public String fetchProcessProperties() throws DirectoryException {
        return this.getDirectorySession().getProcessAccessor().fetchDeploymentProperties(this);
    }

    public DirProjectRevision fetchProjectRevision() throws DirectoryException {
        return this.getDirectoryAdministratorSession().getProjectAccessor().fetchByProcessByProjectIn(this.processesByProjectIn, this.projectRevisionIn);
    }

    public RoleMapping[] fetchRoleMapping() throws DirectoryException {
        return this.getDirectorySession().getProcessAccessor().fetchRoleMapping(this);
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectoryAdministratorSession().getProcessAccessor().refreshDeployedProcess(this);
    }

    @Override
    public Map<String, Object> retrieveAllProperties(String category) throws DirectoryException {
        return this.retrieveAllPropertiesImpl(category);
    }

    @Override
    public String retrieveEncryptedProperty(String category, String key, String encryptionKey) throws DirectoryException, OperationNotSupportedException {
        return this.retrieveEncryptedPropertyImpl(category, key, encryptionKey);
    }

    @Override
    public Object retrieveProperty(String category, String key) throws DirectoryException {
        return this.retrievePropertyImpl(category, key);
    }

    @Override
    public void storeEncryptedProperty(String category, String key, String value, String encryptionKey) throws DirectoryException {
        this.storeEncryptedPropertyImpl(category, key, value, encryptionKey);
    }

    @Override
    public void storeProperty(String category, String key, Serializable value) throws DirectoryException {
        this.storePropertyImpl(category, key, value);
    }

    @Override
    public String toString() {
        return "Process definition '" + this.getProcessDefinitionId() + "' (" + this.getProcessesByProjectIn() + ") deployed " + "in the engine '" + this.engine_d + "' with identification '" + this.getId() + "' (" + this.in_d + ").\n" + "Description: " + super.toString();
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectoryAdministratorSession().getProcessAccessor().updateDeployedProcess(this);
    }

    public boolean isPending() {
        return this.status_d.toLowerCase().equals(this.status_d);
    }

    public void setPending(boolean pending) {
        this.status_d = pending ? this.status_d.toLowerCase() : this.status_d.toUpperCase();
    }
}

