/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.exception.OperationNotSupportedException;
import fuego.directory.msg.DirectoryMsg;

public class DirConfiguration
extends DirObject {
    protected String properties_d;
    static final long serialVersionUID = 2833754707483553141L;
    static final long serialCheck = -6638354402667074320L;

    public DirConfiguration(DirectorySession session, String properties, String internalId) {
        this(session, -1, properties, internalId);
    }

    public DirConfiguration(DirectorySession session, int in, String properties, String internalId) {
        super(session, in, internalId);
        DirConfiguration.check(properties != null, DirectoryMsg.DIR_00211);
        this.properties_d = properties;
    }

    public static DirConfiguration create(DirectorySession session, String properties) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().createConfiguration(properties);
    }

    public static DirConfiguration fetch(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().fetchConfiguration();
    }

    @Override
    public String getDisplayName() {
        return this.getId();
    }

    @Override
    public String getId() {
        return "Configurations";
    }

    public void setProperties(String properties) {
        DirConfiguration.check(properties != null, DirectoryMsg.DIR_00211);
        this.properties_d = properties;
    }

    public String getProperties() {
        return this.properties_d;
    }

    @Override
    public void delete() throws DirectoryException {
        throw new OperationNotSupportedException("delete", this.toString());
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectorySession().getOrganizationAccessor().refreshConfiguration(this);
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectorySession().getOrganizationAccessor().updateConfiguration(this);
    }
}

