/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.DirProjectRevision;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.exception.OperationNotSupportedException;
import java.util.ArrayList;

public class DirCatalogJar
extends DirObject {
    private byte[] bytes = null;
    private String fileName;
    private long hashCode;
    private boolean localJar = false;
    private boolean sharedJar = false;
    static final long serialVersionUID = 3460050370092972435L;
    static final long serialCheck = -7855985691695042544L;

    public DirCatalogJar(DirectorySession session, int in, String fileName, long hashCode, String internalId, boolean sharedJar) {
        super(session, in, internalId);
        this.fileName = fileName;
        this.hashCode = hashCode;
        this.sharedJar = sharedJar;
    }

    public static DirCatalogJar create(DirectorySession session, String fileName, long hashCode, byte[] bytes) throws DirectoryException {
        return DirCatalogJar.create(session, fileName, hashCode, bytes, false);
    }

    public static DirCatalogJar createInMemoryJar(DirectorySession session, String fileName, long hashCode, byte[] bytes) {
        return DirCatalogJar.createInMemoryJar(session, fileName, hashCode, bytes, false);
    }

    public static DirCatalogJar createLocalJar(DirectorySession session, String fileName, long hashCode, byte[] bytes) throws DirectoryException {
        return DirCatalogJar.createLocalJar(session, fileName, hashCode, bytes, false);
    }

    public static DirCatalogJar fetch(DirectorySession session, int in) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProjectAccessor().fetchCatalogJarByIn(in);
    }

    public static DirCatalogJar[] fetchAllByIns(DirectorySession session, int[] ins) throws DirectoryException {
        ArrayList<DirCatalogJar> ret = new ArrayList<DirCatalogJar>();
        for (int in : ins) {
            ret.add(DirCatalogJar.fetch(session, in));
        }
        return ret.toArray(new DirCatalogJar[ret.size()]);
    }

    public static DirCatalogJar fetchByFileNameAndHashCode(DirectorySession session, String fileName, long hashCode) throws DirectoryException {
        return DirCatalogJar.fetchByFileNameAndHashCode(session, fileName, hashCode, false);
    }

    @Override
    public String getDisplayName() {
        return this.getId();
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getHashCode() {
        return this.hashCode;
    }

    @Override
    public String getId() {
        return this.getFileName() + ":" + this.getIn();
    }

    public boolean isSharedJar() {
        return this.sharedJar;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectoryAdministratorSession().getProjectAccessor().deleteCatalogJar(this);
    }

    public void setJar(byte[] bytes) {
        if (this.bytes != null) {
            throw new UnsupportedOperationException("setJar");
        }
        this.bytes = bytes;
    }

    public byte[] getJar() {
        return this.bytes;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DirCatalogJar)) {
            return false;
        }
        DirCatalogJar catalogJar = (DirCatalogJar)obj;
        return catalogJar.getFileName().equals(this.getFileName()) && catalogJar.getJar().equals(this.getJar()) && catalogJar.getHashCode() == this.getHashCode();
    }

    public DirProjectRevision[] fetchCatalogs() throws DirectoryException {
        if (this.isSharedJar()) {
            return new DirProjectRevision[0];
        }
        DirectorySession directorySession = this.getDirectoryAdministratorSession();
        ArrayList<DirProjectRevision> ret = new ArrayList<DirProjectRevision>();
        for (int in : directorySession.getProjectAccessor().fetchCatalogsInForJar(this.in_d)) {
            ret.add(DirProjectRevision.fetch(directorySession, in));
        }
        return ret.toArray(new DirProjectRevision[ret.size()]);
    }

    public byte[] fetchJar() throws DirectoryException {
        byte[] jar = this.getJar();
        if (jar == null && !this.localJar) {
            jar = this.getDirectorySession().getProjectAccessor().fetchCatalogJar(this);
        }
        return jar;
    }

    @Override
    public int hashCode() {
        return (int)this.getHashCode();
    }

    @Override
    public void refresh() throws DirectoryException {
        throw new OperationNotSupportedException("refresh", this.getId());
    }

    @Override
    public void update() throws DirectoryException {
        throw new OperationNotSupportedException("update", this.getId());
    }

    public void updateJar(long hashCode, byte[] jar) throws DirectoryException {
        if (!this.isSharedJar()) {
            throw new OperationNotSupportedException("update non shared", this.getId());
        }
        this.getDirectoryAdministratorSession().getProjectAccessor().updateCatalogJarJar(this, hashCode, jar);
        this.hashCode = hashCode;
    }

    private static DirCatalogJar create(DirectorySession session, String fileName, long hashCode, byte[] bytes, boolean sharedJar) throws DirectoryException {
        Directory.checkSession(session);
        assert (bytes != null) : "bytes can not be null";
        return session.getProjectAccessor().createCatalogJar(fileName, hashCode, bytes, sharedJar);
    }

    private static DirCatalogJar createInMemoryJar(DirectorySession session, String fileName, long hashCode, byte[] bytes, boolean sharedJar) {
        assert (bytes != null) : "bytes can not be null";
        DirCatalogJar catalogJar = new DirCatalogJar(session, -1, fileName, hashCode, "", sharedJar);
        catalogJar.localJar = true;
        catalogJar.bytes = bytes;
        return catalogJar;
    }

    private static DirCatalogJar createLocalJar(DirectorySession session, String fileName, long hashCode, byte[] bytes, boolean sharedJar) throws DirectoryException {
        Directory.checkSession(session);
        assert (bytes != null) : "bytes can not be null";
        DirCatalogJar catalogJar = session.getProjectAccessor().createCatalogJar(fileName, hashCode, null, sharedJar);
        catalogJar.localJar = true;
        catalogJar.bytes = bytes;
        return catalogJar;
    }

    private static DirCatalogJar fetchByFileNameAndHashCode(DirectorySession session, String fileName, long hashCode, boolean sharedJar) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProjectAccessor().fetchCatalogJarByFileNameAndHashCode(fileName, hashCode, sharedJar);
    }
}

