/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.DirOrganizationalRole;
import fuego.directory.DirOrganizationalUnit;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import fuego.directory.msg.DirectoryMsg;
import java.io.IOException;
import oracle.bpm.util.ArrayUtils;
import oracle.bpm.xml.XmlWriter;

public class DirCalendarRule
extends DirObject {
    protected String name_d;
    protected String[] ous_d;
    protected String properties_d;
    public static final String ELEM_CAL_RULE = "DirCalendarRule";
    static final long serialVersionUID = -3147992951310001338L;
    static final long serialCheck = -5760700953353394169L;

    public DirCalendarRule(DirectorySession session, String name, String properties, String internalId) {
        this(session, -1, name, properties, internalId);
    }

    public DirCalendarRule(DirectorySession session, int in, String name, String properties, String internalId) {
        super(session, in, internalId);
        this.name_d = name;
        this.properties_d = properties;
        this.ous_d = new String[0];
    }

    public static DirCalendarRule create(DirectorySession session, String name, String properties) throws DirectoryException {
        Directory.checkSession(session);
        session.getAttributeValidator().validateNewCalendarName(name);
        return session.getOrganizationAccessor().createCalendarRule(name, properties);
    }

    public static DirCalendarRule fetch(DirectorySession session, String name) throws DirectoryException {
        Directory.checkSession(session);
        if (!session.getAttributeValidator().isValidCalendarName(name)) {
            return null;
        }
        return session.getOrganizationAccessor().fetchCalendarRule(name);
    }

    public static DirCalendarRule[] fetchAll(DirectorySession session) throws DirectoryException {
        Directory.checkSession(session);
        return session.getOrganizationAccessor().fetchAllCalendarRules();
    }

    public static DirCalendarRule fetchForRoleAndOU(DirOrganizationalRole role, DirOrganizationalUnit ou) throws DirectoryException {
        assert (role != null) : DirectoryMsg.DIR_00103;
        assert (ou != null) : DirectoryMsg.DIR_00102;
        for (int i = 0; i < role.getCalendarRulesAssignment().length; ++i) {
            DirOrganizationalRole.CalendarRuleAssignment calAss = role.getCalendarRulesAssignment()[i];
            if (!calAss.ou.equals(ou.getId())) continue;
            return DirCalendarRule.fetch(role.getDirectorySession(), calAss.calendarRule);
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getId() {
        return this.getName();
    }

    public String getName() {
        return this.name_d;
    }

    public void setOUs(String[] ous) {
        DirCalendarRule.check(ous != null, DirectoryMsg.DIR_00115);
        this.ous_d = ArrayUtils.trim(ous);
    }

    public String[] getOUs() {
        return this.ous_d;
    }

    public void setProperties(String properties) {
        this.properties_d = properties;
    }

    public String getProperties() {
        return this.properties_d;
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectorySession().getOrganizationAccessor().deleteCalendarRule(this);
    }

    @Override
    public void refresh() throws DirectoryException {
        this.getDirectorySession().getOrganizationAccessor().refreshCalendarRule(this);
    }

    @Override
    public void update() throws DirectoryException {
        this.getDirectorySession().getOrganizationAccessor().updateCalendarRule(this);
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement(ELEM_CAL_RULE);
        xmlWriter.printValuedElement("name", this.getName());
        xmlWriter.printCDATAElement("properties", this.getProperties(), true);
        xmlWriter.startElement("ous");
        for (int i = 0; i < this.getOUs().length; ++i) {
            String ou = this.getOUs()[i];
            if (ou.equals(DirOrganizationalUnit.getRootId())) {
                ou = "/";
            }
            xmlWriter.printValuedElement("value", ou);
        }
        xmlWriter.endElement();
        xmlWriter.endElement();
    }
}

