/*
 * Decompiled with CFR 0.152.
 */
package fuego.directory;

import fuego.directory.DirObject;
import fuego.directory.Directory;
import fuego.directory.DirectoryException;
import fuego.directory.DirectorySession;
import java.io.IOException;
import oracle.bpm.lang.Time;
import oracle.bpm.xml.XmlWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirBusinessRule
extends DirObject
implements Cloneable {
    protected String data;
    protected String projectName;
    protected String ruleName;
    public static final String ELEM_VAR = "DirBusinessRule";
    static final long serialVersionUID = 8000269267509807166L;
    static final long serialCheck = 1103731645740543508L;

    public DirBusinessRule(@NotNull DirectorySession session, int in, @NotNull String ruleName, @NotNull String projectName, @Nullable String creator, @Nullable String data, @NotNull String internalID) {
        this(session, in, ruleName, projectName, creator, data, Time.now(), internalID);
    }

    public DirBusinessRule(@NotNull DirectorySession session, int in, @NotNull String ruleName, @NotNull String projectName, @Nullable String creator, @Nullable String data, @Nullable Time createTime, @NotNull String internalID) {
        super(session, in, internalID);
        if (createTime == null) {
            createTime = Time.now();
        }
        this.ruleName = ruleName;
        this.projectName = projectName;
        this.data = data;
        this.creator_d = creator;
        this.createTimestamp_d = createTime;
    }

    public static DirBusinessRule create(DirectorySession session, String projectName, String ruleName, String creator, String data) throws DirectoryException {
        Directory.checkAdministratorSession(session);
        session.getAttributeValidator().validateBusinessRuleId(ruleName);
        String actualCreator = creator != null ? creator : session.getParticipant();
        return session.getProjectAccessor().createBusinessRule(ruleName, projectName, actualCreator, data);
    }

    public static DirBusinessRule create(DirectorySession session, String projectName, String ruleName, int version, String creator, String data) throws DirectoryException {
        Directory.checkAdministratorSession(session);
        session.getAttributeValidator().validateBusinessRuleId(ruleName);
        String actualCreator = creator != null ? creator : session.getParticipant();
        return session.getProjectAccessor().createBusinessRule(ruleName, projectName, version, actualCreator, data);
    }

    public static void deleteAllByProjectName(DirectorySession session, String projectName) throws DirectoryException {
        Directory.checkAdministratorSession(session);
        session.getProjectAccessor().deleteBusinessRulesByProjectName(projectName);
    }

    public static DirBusinessRule fetch(DirectorySession session, String projectName, String ruleName, int version) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProjectAccessor().fetchBusinessRule(projectName, ruleName, version);
    }

    public static DirBusinessRule[] fetchAllLastVersionBusinessRules(DirectorySession session, String projectName) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProjectAccessor().fetchAllLastVersionBusinessRules(projectName);
    }

    public static DirBusinessRule[] fetchBusinessRuleVersions(DirectorySession session, String projectName, String ruleNanme) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProjectAccessor().fetchAllBusinessRuleVersions(projectName, ruleNanme);
    }

    public static DirBusinessRule fetchLastVersion(DirectorySession session, String projectName, String ruleName) throws DirectoryException {
        Directory.checkSession(session);
        return session.getProjectAccessor().fetchLastVersionBusinessRule(projectName, ruleName);
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getData() {
        return this.data;
    }

    @Override
    public String getDisplayName() {
        return this.getRuleName();
    }

    @Override
    public String getId() {
        return this.getRuleName();
    }

    public int getVersion() {
        return this.getIn();
    }

    @Override
    public void refresh() throws DirectoryException {
    }

    @Override
    public void update() throws DirectoryException {
        throw new UnsupportedOperationException("cannot update a business rule");
    }

    @Override
    public void delete() throws DirectoryException {
        this.getDirectoryAdministratorSession().getProjectAccessor().deleteBusinessRule(this);
    }

    public DirBusinessRule[] findPreviousVersions(int max) throws DirectoryException {
        return this.getDirectorySession().getProjectAccessor().findPreviousBusinessRules(this, max);
    }

    @Override
    public String getCreator() {
        return this.creator_d;
    }

    @Override
    public void writeXML(XmlWriter xmlWriter) throws IOException {
        xmlWriter.startElement(ELEM_VAR);
        xmlWriter.printValuedElement("ruleName", this.getRuleName());
        xmlWriter.printValuedElement("projectName", this.getProjectName());
        xmlWriter.printValuedElement("version", String.valueOf(this.getVersion()));
        xmlWriter.printCDATAElement("data", this.getData(), true);
        xmlWriter.endElement();
    }

    @Override
    public String toString() {
        return "projectName:" + this.projectName + "|ruleName:" + this.ruleName + "|version:" + this.getVersion();
    }
}

