/*
 * Decompiled with CFR 0.152.
 */
package fuego.internal.test;

import fuego.internal.test.FuegoTestsConstants;
import java.sql.Timestamp;
import java.util.Properties;

public class FuegoSuiteInfo
implements FuegoTestsConstants {
    public int buildNumber = 0;
    public final String configuration;
    public final String date;
    public final String module;
    public int runId;
    public final String suite;
    public final String version;

    public FuegoSuiteInfo(String configuration, String date, String module, String suite, String version) {
        this.configuration = configuration;
        this.date = date;
        this.module = module;
        this.suite = suite;
        this.version = version;
    }

    private FuegoSuiteInfo(Properties properties, String suiteName) {
        String s;
        int pos = suiteName.lastIndexOf(46);
        String suite = pos == -1 ? suiteName : suiteName.substring(pos + 1);
        String testConfig = properties.getProperty("test.config");
        String testConfig2 = properties.getProperty("test.config2");
        String testMachine = properties.getProperty("test.machine");
        String testDirectoryConfig = properties.getProperty("test.directory.config");
        String testConnectorConfig = properties.getProperty("test.connector.config");
        this.date = properties.getProperty("test.timestamp", new Timestamp(System.currentTimeMillis()).toString());
        String version = properties.getProperty("fuego.version");
        if (version == null) {
            version = System.getProperty("fuego.version");
        }
        if ((s = properties.getProperty("fuego.build.number")) == null) {
            s = System.getProperty("fuego.build.number");
        }
        if (s != null && !"".equals(s)) {
            this.buildNumber = Integer.valueOf(s);
        }
        this.version = version;
        this.suite = suite;
        String module = properties.getProperty("test.module.name");
        if (module == null) {
            module = suiteName.substring(0, suiteName.lastIndexOf("."));
        }
        this.module = module;
        this.configuration = this.defineConfigStr(testMachine, testConfig, testConfig2, testDirectoryConfig, testConnectorConfig);
    }

    public static FuegoSuiteInfo create(String version, String module, String suite, String date, String configuration) {
        return new FuegoSuiteInfo(configuration, date, module, suite, version);
    }

    public static FuegoSuiteInfo create(Properties properties, String suite) {
        return new FuegoSuiteInfo(properties, suite);
    }

    public boolean isJunk() {
        return this.version.endsWith("JUNK");
    }

    public String toString() {
        return "SUITE :" + this.version + ":" + this.configuration + ":" + this.module + ":" + this.suite + ":" + this.date;
    }

    private String defineConfigStr(String machine, String configuration, String configuration2, String directoryConfiguration, String connectorConfiguration) {
        StringBuffer sb = new StringBuffer();
        sb.append(machine == null ? "UNKNOWN" : machine);
        sb.append("/");
        sb.append(configuration == null ? "" : configuration);
        sb.append(configuration2 == null ? "" : "-" + configuration2);
        sb.append("/");
        sb.append(directoryConfiguration != null && !directoryConfiguration.equals(configuration) ? directoryConfiguration : "");
        sb.append("/");
        sb.append(connectorConfiguration != null && !connectorConfiguration.equals(configuration) ? connectorConfiguration : "");
        return sb.toString();
    }
}

