/*
 * Decompiled with CFR 0.152.
 */
package fuego.internal.test;

import fuego.internal.test.FuegoSuiteInfo;
import fuego.internal.test.FuegoTestInfo;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import oracle.bpm.io.StreamUtils;
import oracle.bpm.io.fs.VFileSystem;
import oracle.bpm.io.fs.java.JavaFileSystem;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.project.catalog.bundles.CommonTypesComponentBundle;
import oracle.bpm.type.ComponentCatalog;
import oracle.bpm.type.MutableComponentCatalog;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.type.catalog.ComponentBundle;
import oracle.bpm.type.catalog.DirectoryComponentBundle;
import oracle.bpm.util.FileException;
import oracle.bpm.util.FileUtils;

public final class CoreTestUtils {
    private static Connection connection;
    protected static String resultsURL;

    private CoreTestUtils() {
    }

    public static MutableComponentCatalog createDefaultCatalog() {
        return CoreTestUtils.createCatalog(null, null, false);
    }

    public static MutableComponentCatalog createCatalog(File catalogFile, File buildDir, boolean force) {
        File fuegotestCatalog;
        System.setProperty("oracle.bpmn.test.compatibility", Boolean.TRUE.toString());
        MutableComponentCatalog defRep = TypeUtils.getDefaultCatalog();
        if (catalogFile == null) {
            return defRep;
        }
        String catalogFileName = catalogFile.getName();
        File catalogCache = new File(buildDir, catalogFileName + "-cache");
        if (catalogFile.isFile()) {
            File dataDir = new File(buildDir, "../data");
            File catalogDir = new File(buildDir, "catalogs");
            fuegotestCatalog = new File(catalogDir, catalogFileName.substring(0, catalogFileName.indexOf(".jar")));
            if (fuegotestCatalog.exists()) {
                FileUtils.deleteDirectory(fuegotestCatalog);
                if (catalogCache.exists()) {
                    try {
                        FileUtils.delete(catalogCache);
                    }
                    catch (FileException e) {
                        e.printStackTrace();
                    }
                }
            }
            fuegotestCatalog.mkdirs();
            try {
                StreamUtils.unzip(new File(dataDir, "catalogs/" + catalogFileName), catalogDir);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            File catalogDir = new File(buildDir, "catalogs");
            fuegotestCatalog = new File(catalogDir, catalogFileName);
            if (force || !fuegotestCatalog.exists()) {
                fuegotestCatalog.mkdirs();
                FileUtils.copyFileOrDirectory(catalogFile, fuegotestCatalog);
            }
        }
        MutableComponentCatalog catalog = TypeUtils.createComponentCatalog(defRep);
        catalogCache.mkdir();
        catalog.setDefaultStorageBundle(new DirectoryComponentBundle(catalogCache));
        String catalogPath = fuegotestCatalog.getPath();
        JavaFileSystem fileSystem = new JavaFileSystem(new File(catalogPath));
        catalog.addComponentBundle((ComponentBundle)new CommonTypesComponentBundle((ComponentCatalog)catalog, (VFileSystem)fileSystem));
        catalog.addComponentBundle(new DirectoryComponentBundle(fuegotestCatalog));
        catalog.sync();
        return catalog;
    }

    public static MutableComponentCatalog createProjectCatalog(VFileSystem fileSystem, File buildDir) {
        MutableComponentCatalog defRep = TypeUtils.getDefaultCatalog();
        File catalogCache = new File(buildDir, fileSystem.getRoot().toString() + "-cache");
        MutableComponentCatalog catalog = TypeUtils.createComponentCatalog(defRep);
        catalogCache.mkdir();
        catalog.addComponentBundle((ComponentBundle)new CommonTypesComponentBundle((ComponentCatalog)catalog, fileSystem));
        catalog.sync();
        return catalog;
    }

    public static void traverse(MutableComponentCatalog catalog, ObjectTypeDescription root) {
        int count = root.getInnerTypeCount();
        for (int i = 0; i < count; ++i) {
            try {
                ObjectTypeDescription innerType = root.getInnerType(i);
                if (innerType.isDefault()) continue;
                catalog.update(innerType);
                CoreTestUtils.traverse(catalog, innerType);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static Connection getConnection() {
        if (connection == null) {
            try {
                Class.forName("oracle.jdbc.driver.OracleDriver");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            try {
                connection = DriverManager.getConnection(resultsURL, "test", "test");
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startSuite(FuegoSuiteInfo suiteInfo) {
        if (suiteInfo.isJunk()) {
            return;
        }
        String stmtString = "{call setrundate (?,?,?,?)}";
        CallableStatement stmt = null;
        try {
            stmt = CoreTestUtils.getConnection().prepareCall(stmtString);
            stmt.registerOutParameter(1, 4);
            stmt.setString(2, suiteInfo.version);
            stmt.setString(3, suiteInfo.date);
            if (suiteInfo.buildNumber != 0) {
                stmt.setInt(4, suiteInfo.buildNumber);
            } else {
                stmt.setNull(4, 4);
            }
            stmt.executeUpdate();
            suiteInfo.runId = stmt.getInt(1);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeSuiteOutput(FuegoSuiteInfo suiteInfo, String output, Connection connection) throws SQLException, UnsupportedEncodingException {
        String stmtString = "insert into ntestoutput (runid, config, pkg, testclass, output, enginelog) values (?,?,?,?,?,?)";
        PreparedStatement stmt = null;
        try {
            stmt = connection.prepareStatement(stmtString);
            stmt.setInt(1, suiteInfo.runId);
            stmt.setString(2, suiteInfo.configuration);
            stmt.setString(3, suiteInfo.module);
            stmt.setString(4, suiteInfo.suite);
            if (output != null) {
                byte[] msg = output.getBytes("UTF-8");
                ByteArrayInputStream bais = new ByteArrayInputStream(msg);
                stmt.setBinaryStream(5, (InputStream)bais, msg.length);
            } else {
                stmt.setNull(5, -2);
            }
            String engineLog = System.getProperty("test.engine.log");
            System.setProperty("test.engine.log", "");
            stmt.setString(6, engineLog);
            stmt.executeUpdate();
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void storeTestResult(FuegoTestInfo testInfo, Connection connection) throws SQLException, UnsupportedEncodingException {
        String insertIntoTest = "insert into ntest (runId, config, pkg, testclass, name, duration, status) values (?,?,?,?,?,?,?)";
        String insertIntoTestResult = "insert into nTestResult (runId, config, pkg, testclass, name, result, jira_id) values (?,?,?,?,?,?,?)";
        PreparedStatement testStatement = null;
        Statement testResultStatement = null;
        try {
            testStatement = connection.prepareStatement("insert into ntest (runId, config, pkg, testclass, name, duration, status) values (?,?,?,?,?,?,?)");
            testStatement.setInt(1, testInfo.suiteInfo.runId);
            testStatement.setString(2, testInfo.suiteInfo.configuration);
            testStatement.setString(3, testInfo.suiteInfo.module);
            testStatement.setString(4, testInfo.suiteInfo.suite);
            testStatement.setString(5, testInfo.testName);
            testStatement.setDouble(6, testInfo.duration);
            testStatement.setInt(7, testInfo.status);
            if (!testInfo.isOk()) {
                testResultStatement = connection.prepareStatement("insert into nTestResult (runId, config, pkg, testclass, name, result, jira_id) values (?,?,?,?,?,?,?)");
                testResultStatement.setInt(1, testInfo.suiteInfo.runId);
                testResultStatement.setString(2, testInfo.suiteInfo.configuration);
                testResultStatement.setString(3, testInfo.suiteInfo.module);
                testResultStatement.setString(4, testInfo.suiteInfo.suite);
                testResultStatement.setString(5, testInfo.testName);
                byte[] msg = (testInfo.failureMsg == null ? "none" : testInfo.failureMsg).getBytes("UTF-8");
                ByteArrayInputStream bais = new ByteArrayInputStream(msg);
                testResultStatement.setBinaryStream(6, bais, msg.length);
                testResultStatement.setString(7, testInfo.jiraId);
                testResultStatement.executeUpdate();
            }
            testStatement.executeUpdate();
        }
        catch (SQLException sqle) {
            System.out.println(sqle.getErrorCode());
            System.out.println(testStatement.toString());
            sqle.printStackTrace();
            throw sqle;
        }
        finally {
            if (testStatement != null) {
                try {
                    testStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            if (testResultStatement != null) {
                try {
                    testResultStatement.close();
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean submitSuite(FuegoSuiteInfo suiteInfo, String output) {
        if (!suiteInfo.isJunk()) {
            try {
                CoreTestUtils.storeSuiteOutput(suiteInfo, output, CoreTestUtils.getConnection());
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    public static boolean submitTest(FuegoTestInfo testInfo) {
        if (!testInfo.suiteInfo.isJunk()) {
            try {
                try {
                    CoreTestUtils.storeTestResult(testInfo, CoreTestUtils.getConnection());
                }
                catch (SQLException sqle) {
                    if (sqle.getErrorCode() == 1) {
                        testInfo.testName = testInfo.testName + "_DUPLICATED_" + System.currentTimeMillis();
                        CoreTestUtils.storeTestResult(testInfo, CoreTestUtils.getConnection());
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    static {
        resultsURL = "jdbc:oracle:thin:@testsdb.ar.oracle.com:1521:ORCL";
    }
}

