/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject.design;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import oracle.bpm.bpmobject.design.ConstructionException;
import oracle.bpm.bpmobject.design.MethodUsagesRemover;
import oracle.bpm.bpmobject.msg.BpmObjectMsg;
import oracle.bpm.lang.AttributeTypeDescription;
import oracle.bpm.lang.MethodTypeDescription;
import oracle.bpm.lang.Modifier;
import oracle.bpm.lang.ObjectTypeDescription;
import oracle.bpm.lang.SchemaObject;
import oracle.bpm.lang.Str;
import oracle.bpm.lang.SuperType;
import oracle.bpm.lang.TypeDescription;
import oracle.bpm.lang.XObjectTypeDescription;
import oracle.bpm.lang.XmlTypeDescription;
import oracle.bpm.resources.Msg;
import oracle.bpm.type.Argument;
import oracle.bpm.type.SourceCode;
import oracle.bpm.type.TypeFinder;
import oracle.bpm.type.TypeRef;
import oracle.bpm.type.TypeUtils;
import oracle.bpm.util.Identifier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BpmObjectTypeDescriptionHelper {
    public static final String VVAL_POST_MTD = "ValidValues";
    public static final String VVAL_DESC_MTD_SIGN_PROP = "validValuesDescriptionMethodSignature";
    public static final String VVAL_DESC_MTD_NAME_PROP = "validValuesDescriptionMethodName";
    public static final String VVAL_DESC_LIST = "validValuesDescriptionList";

    public static boolean hasAttributesObject(@NotNull XObjectTypeDescription bpmObject) {
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.hasAttributesObject must not be null");
        }
        try {
            BpmObjectTypeDescriptionHelper.getAttributesObject(bpmObject);
            return true;
        }
        catch (CannotFindAttributesObjectException e) {
            return false;
        }
    }

    public static int getAttributeCount(XObjectTypeDescription bpmObject) {
        return BpmObjectTypeDescriptionHelper.getAttributes(bpmObject).size();
    }

    public static int getMemberCount(XObjectTypeDescription bpmObject) {
        try {
            return BpmObjectTypeDescriptionHelper.getAttributesObject(bpmObject).getMemberCount();
        }
        catch (CannotFindAttributesObjectException e) {
            return 0;
        }
    }

    public static boolean isFuegoObjectReservedName(String name) {
        return name != null && name.endsWith(VVAL_POST_MTD);
    }

    public static boolean isGroup(AttributeTypeDescription attr) {
        TypeDescription parent = attr.getParent();
        return parent != null && parent.isBpmObject() && XObjectTypeDescription.isGroupAttribute(attr);
    }

    public static MethodTypeDescription getMemberFor(String name, ObjectTypeDescription xtd) {
        int dot = name.indexOf(46);
        int brace = name.indexOf(91);
        if (dot < 0) {
            return xtd.findAttribute(name, TypeFinder.Scope.DELEGATED);
        }
        String attName = name.substring(0, brace > 0 && brace < dot ? brace : dot);
        String restName = name.substring(dot + 1);
        AttributeTypeDescription td = xtd.findAttribute(attName, TypeFinder.Scope.DELEGATED);
        if (td != null) {
            TypeDescription resultType = td.getResultType();
            if (resultType.isArray() && resultType.getElementType().isInnerType()) {
                return BpmObjectTypeDescriptionHelper.getMemberFor(restName, (ObjectTypeDescription)resultType.getElementType());
            }
            if (resultType instanceof ObjectTypeDescription) {
                return BpmObjectTypeDescriptionHelper.getMemberFor(restName, (ObjectTypeDescription)resultType);
            }
        }
        return null;
    }

    public static void setPublic(MethodTypeDescription mtd, boolean flag) {
        if (flag) {
            mtd.setModifiers(mtd.getModifiers() | 0x8000L);
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFFDFFFL);
        } else {
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFF7FFFL);
            mtd.setModifiers(mtd.getModifiers() | 0x2000L);
        }
    }

    public static void setResultType(MethodTypeDescription mtd, TypeRef resultType) {
        mtd.setResultType(resultType);
    }

    public static void setServerSide(MethodTypeDescription mtd, boolean flag) {
        if (flag) {
            mtd.setModifiers(mtd.getModifiers() | 0x10000L);
        } else {
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFEFFFFL);
        }
        BpmObjectTypeDescriptionHelper.setClientAvailable(mtd);
    }

    public static void setStatic(MethodTypeDescription mtd, boolean flag) {
        if (flag) {
            mtd.setModifiers(mtd.getModifiers() | 0x40L);
        } else {
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFFFFBFL);
        }
    }

    public static boolean isValidAttName(ObjectTypeDescription parent, String name) {
        try {
            return BpmObjectTypeDescriptionHelper.validateAttributeName(name) && BpmObjectTypeDescriptionHelper.validateMember(parent, name);
        }
        catch (ConstructionException ce) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static AttributeTypeDescription createAttribute(@NotNull String name, @NotNull TypeRef typeRef) throws ConstructionException {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.createAttribute must not be null");
        }
        if (typeRef == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.createAttribute must not be null");
        }
        BpmObjectTypeDescriptionHelper.validateAttributeName(name);
        AttributeTypeDescription attributeTypeDescription = new AttributeTypeDescription(name, typeRef);
        if (attributeTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.createAttribute must not return null");
        }
        return attributeTypeDescription;
    }

    public static void addAttribute(@NotNull XObjectTypeDescription parent, @NotNull AttributeTypeDescription atd) throws ConstructionException {
        if (parent == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.addAttribute must not be null");
        }
        if (atd == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.addAttribute must not be null");
        }
        BpmObjectTypeDescriptionHelper.validateMember(parent, atd.getName());
        try {
            BpmObjectTypeDescriptionHelper.getAttributesObject(parent).addMember(atd);
        }
        catch (CannotFindAttributesObjectException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public static AttributeTypeDescription addAttribute(XObjectTypeDescription parent, String name, TypeRef td, SourceCode calculateExpression) throws ConstructionException {
        BpmObjectTypeDescriptionHelper.validateAttributeName(name);
        BpmObjectTypeDescriptionHelper.validateMember(parent, name);
        AttributeTypeDescription member = BpmObjectTypeDescriptionHelper.createAttribute(name, td.get().setReferenceType(true), calculateExpression);
        try {
            BpmObjectTypeDescriptionHelper.getAttributesObject(parent).addMember(member);
        }
        catch (CannotFindAttributesObjectException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return member;
    }

    public static MethodTypeDescription addMethod(ObjectTypeDescription obj, String name, TypeDescription returnType, Argument[] inputArgs) throws ConstructionException {
        return BpmObjectTypeDescriptionHelper.addMethod(obj, name, (TypeRef)returnType, inputArgs, null, null);
    }

    public static MethodTypeDescription addMethod(ObjectTypeDescription obj, String name, TypeRef returnType, Argument[] inputArgs, String code, String codeLanguage) throws ConstructionException {
        BpmObjectTypeDescriptionHelper.validateMethodName(obj, name, false);
        MethodTypeDescription methodTD = BpmObjectTypeDescriptionHelper.createMethod(name, returnType, inputArgs, code, codeLanguage);
        return BpmObjectTypeDescriptionHelper.doAddMethod(obj, methodTD);
    }

    public static MethodTypeDescription addMethod(ObjectTypeDescription obj, String name, TypeDescription returnType, TypeDescription[] inputArgTypes) throws ConstructionException {
        return BpmObjectTypeDescriptionHelper.addMethod(obj, name, returnType, inputArgTypes, null, null);
    }

    public static MethodTypeDescription addMethod(ObjectTypeDescription obj, String name, TypeDescription returnType, TypeDescription[] inputArgTypes, String code, String codeLanguage) throws ConstructionException {
        Argument[] inputArgs = new Argument[inputArgTypes == null ? 0 : inputArgTypes.length];
        for (int i = 0; i < inputArgs.length; ++i) {
            inputArgs[i] = new Argument("arg" + i, inputArgTypes == null ? null : inputArgTypes[i], 1L);
        }
        return BpmObjectTypeDescriptionHelper.addMethod(obj, name, (TypeRef)returnType, inputArgs, code, codeLanguage);
    }

    public static MethodTypeDescription createMethod(String name, TypeRef returnType, Argument[] inputArgs, String code, String codeLanguage) {
        MethodTypeDescription methodTD = new MethodTypeDescription(name);
        return BpmObjectTypeDescriptionHelper.setMethod(methodTD, returnType, inputArgs, code, codeLanguage);
    }

    public static List<String> removeMember(ObjectTypeDescription parent, String name) throws ConstructionException {
        ArrayList<String> removedMemberList = new ArrayList<String>();
        MethodTypeDescription member = parent.findMember(name);
        if (member == null) {
            throw new ConstructionException(BpmObjectMsg.XOBJLIB_CONST_0001(name));
        }
        if (member.isMethod()) {
            MethodUsagesRemover mur = new MethodUsagesRemover(parent, member.getSignature());
            mur.startToGoOver();
            removedMemberList.addAll(mur.getReferencedAttributeNames());
            parent.removeMember(member);
        }
        if (member.isAttribute()) {
            AttributeTypeDescription attr = (AttributeTypeDescription)member;
            String vvMtdText = BpmObjectTypeDescriptionHelper.removeValidValuesDefinition(attr);
            if (vvMtdText != null) {
                removedMemberList.add(vvMtdText);
            }
            try {
                BpmObjectTypeDescriptionHelper.getAttributesObject(parent).removeMember(member);
            }
            catch (CannotFindAttributesObjectException e) {
                // empty catch block
            }
        }
        if (member.isAttribute() && XObjectTypeDescription.isGroupAttribute(member.asAttribute())) {
            TypeRef group = parent.findInnerType(Identifier.classname(name));
            parent.removeInnerType(group);
        }
        return removedMemberList.isEmpty() ? null : removedMemberList;
    }

    public static String removeValidValuesDefinition(AttributeTypeDescription attr) {
        String vvMtdText = null;
        ObjectTypeDescription parent = (ObjectTypeDescription)attr.getParent();
        MethodTypeDescription vvMtd = parent.findMethod(attr.getName() + VVAL_POST_MTD);
        if (vvMtd != null) {
            vvMtdText = vvMtd.getName();
            parent.removeMember(vvMtd);
        }
        attr.setValidValuesMethod(null);
        attr.setProperty(VVAL_DESC_MTD_NAME_PROP, null);
        attr.setProperty(VVAL_DESC_MTD_SIGN_PROP, null);
        attr.setValidValues(null);
        attr.setProperty(VVAL_DESC_LIST, null);
        return vvMtdText;
    }

    public static String toString(XObjectTypeDescription xotd) {
        StringBuilder buffer = new StringBuilder(xotd.toString());
        buffer.append("\n");
        buffer.append("--- METHODS ---\n");
        for (int i = 0; i < xotd.getMemberCount(); ++i) {
            MethodTypeDescription member = xotd.getMemberType(i);
            buffer.append(member.toString());
            buffer.append("\n");
        }
        buffer.append("--- ATTRIBUTES ---\n");
        try {
            XmlTypeDescription xmlotd = BpmObjectTypeDescriptionHelper.getAttributesObject(xotd);
            for (int i = 0; i < xmlotd.getMemberCount(); ++i) {
                MethodTypeDescription member = xmlotd.getMemberType(i);
                buffer.append(member.toString());
                buffer.append("\n");
            }
        }
        catch (CannotFindAttributesObjectException e) {
            buffer.append(e.getMessage()).append("\n");
        }
        buffer.append("--- INNERS ---\n");
        for (int j = 0; j < xotd.getInnerTypeCount(); ++j) {
            ObjectTypeDescription inner = xotd.getInnerType(j);
            buffer.append(inner.toString());
            buffer.append("\n");
            buffer.append("--- INNER MEMBERS ---\n");
            for (int k = 0; k < inner.getMemberCount(); ++k) {
                MethodTypeDescription member = inner.getMemberType(k);
                buffer.append(member.toString());
                buffer.append("\n");
            }
            buffer.append("\n");
        }
        return buffer.toString();
    }

    public static Msg validateFuegoObjectReservedName(String name) {
        if (name == null) {
            return null;
        }
        if (name.endsWith(VVAL_POST_MTD)) {
            return BpmObjectMsg.NAME_ENDS_WITH(VVAL_POST_MTD);
        }
        return null;
    }

    public static Msg validateMethodName(String name) {
        Msg msg = !Identifier.isValid(name) ? BpmObjectMsg.NOT_AN_IDENTIFIER(name) : (Character.isUpperCase(name.charAt(0)) ? BpmObjectMsg.UPPERCASE_METHOD_NAME : BpmObjectTypeDescriptionHelper.validateFuegoObjectReservedName(name));
        return msg;
    }

    @Nullable
    public static QName getMessageQName(@NotNull ObjectTypeDescription bpmObject) {
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.getMessageQName must not be null");
        }
        QName result = null;
        try {
            XmlTypeDescription xmlTd = BpmObjectTypeDescriptionHelper.getAttributesObject(bpmObject);
            String messageNamespace = xmlTd.getProperty("messageNamespace");
            String messageName = xmlTd.getProperty("message");
            if (messageName != null && messageNamespace != null) {
                result = new QName(messageNamespace, messageName);
            }
        }
        catch (CannotFindAttributesObjectException cannotFindAttributesObjectException) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Set<AttributeTypeDescription> getAttributesByPosition(@NotNull XObjectTypeDescription bpmObject) {
        Set<AttributeTypeDescription> result;
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.getAttributesByPosition must not be null");
        }
        try {
            XmlTypeDescription attributesObject = BpmObjectTypeDescriptionHelper.getAttributesObject(bpmObject);
            result = attributesObject.getAttributesByPosition();
        }
        catch (CannotFindAttributesObjectException e) {
            result = Collections.emptySet();
        }
        Set<AttributeTypeDescription> set = result;
        if (set == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.getAttributesByPosition must not return null");
        }
        return set;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static List<MethodTypeDescription> getAttributes(@NotNull ObjectTypeDescription bpmObject) {
        List<MethodTypeDescription> result;
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.getAttributes must not be null");
        }
        try {
            XmlTypeDescription attributesObject = BpmObjectTypeDescriptionHelper.getAttributesObject(bpmObject);
            MethodTypeDescription[] attributes = attributesObject.getMembers(18, 0L, 0L, TypeFinder.Scope.ALL, true);
            result = Arrays.asList(attributes);
        }
        catch (CannotFindAttributesObjectException e) {
            result = Collections.emptyList();
        }
        List<MethodTypeDescription> list = result;
        if (list == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.getAttributes must not return null");
        }
        return list;
    }

    private static AttributeTypeDescription createAttribute(String name, TypeRef td, SourceCode calculateExpression) {
        SchemaObject schemaObject;
        AttributeTypeDescription member = new AttributeTypeDescription(name, td.get());
        member.setModifiers(member.getModifiers() | 0x8000L | 4L | 8L);
        BpmObjectTypeDescriptionHelper.attributeDefaultModifiers(member);
        member.setCode(calculateExpression);
        member.setProperty("nativeName", name);
        TypeDescription typeDescription = td.get();
        String namespace = "";
        if (typeDescription.isXmlObject() && (schemaObject = typeDescription.asSchemaObject()).isElement()) {
            namespace = schemaObject.getNamespace();
        }
        member.setProperty("elementNamespace", namespace);
        member.setCalculated(calculateExpression != null);
        return member;
    }

    private static void setClientAvailable(MethodTypeDescription mtd) {
        if (Modifier.isServer(mtd.getModifiers())) {
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFFFFFFFFEFFL);
            mtd.setModifiers(mtd.getModifiers() | 0x4000000000L);
        } else {
            mtd.setModifiers(mtd.getModifiers() | 0x100L);
            mtd.setModifiers(mtd.getModifiers() & 0xFFFFFFBFFFFFFFFFL);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static XmlTypeDescription getAttributesObject(@NotNull ObjectTypeDescription bpmObject) throws CannotFindAttributesObjectException {
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.getAttributesObject must not be null");
        }
        String schemaId = bpmObject.getProperty("attributes.schema.id");
        boolean isService = TypeUtils.isService(bpmObject);
        assert (!Str.isEmpty(schemaId)) : "Missing schema id on " + bpmObject.getText();
        XmlTypeDescription xmlTypeDescription = BpmObjectTypeDescriptionHelper.findAttributesObject(bpmObject, !isService);
        if (xmlTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.getAttributesObject must not return null");
        }
        return xmlTypeDescription;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static XmlTypeDescription findAttributesObject(@NotNull ObjectTypeDescription bpmObject, boolean findType) throws CannotFindAttributesObjectException {
        if (bpmObject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.findAttributesObject must not be null");
        }
        XmlTypeDescription result = null;
        String schemaId = bpmObject.getProperty("attributes.schema.id");
        if (!Str.isEmpty(schemaId)) {
            for (SuperType superType : bpmObject.getSuperTypes()) {
                TypeDescription td = superType.getType();
                if (!schemaId.equals(td.getId())) continue;
                if (td.isUnknown()) break;
                assert (td instanceof XmlTypeDescription && superType.isDelegated()) : "Invalid super Type: " + td.getText();
                result = findType ? TypeUtils.findXmlType((XmlTypeDescription)td.asObject()) : (XmlTypeDescription)td;
                break;
            }
        }
        if (result == null) {
            throw new CannotFindAttributesObjectException("Missing xml schema for: " + bpmObject.getText());
        }
        XmlTypeDescription xmlTypeDescription = result;
        if (xmlTypeDescription == null) {
            throw new IllegalArgumentException("@NotNull method oracle/bpm/bpmobject/design/BpmObjectTypeDescriptionHelper.findAttributesObject must not return null");
        }
        return xmlTypeDescription;
    }

    private static MethodTypeDescription setMethod(MethodTypeDescription methodTD, TypeRef returnType, Argument[] inputArgs, String code, String codeLanguage) {
        BpmObjectTypeDescriptionHelper.methodDefaultModifiers(methodTD);
        methodTD.setResultType(returnType);
        methodTD.setArguments(inputArgs);
        methodTD.setSignature(methodTD.getJavaSignature());
        if (code != null) {
            methodTD.setCode(code, codeLanguage);
        }
        return methodTD;
    }

    private static void attributeDefaultModifiers(AttributeTypeDescription atd) {
        BpmObjectTypeDescriptionHelper.setPublic(atd, true);
        BpmObjectTypeDescriptionHelper.setStatic(atd, false);
    }

    private static MethodTypeDescription doAddMethod(ObjectTypeDescription obj, MethodTypeDescription mtd) {
        obj.addMember(mtd);
        return mtd;
    }

    private static void methodDefaultModifiers(MethodTypeDescription mtd) {
        BpmObjectTypeDescriptionHelper.setPublic(mtd, true);
        BpmObjectTypeDescriptionHelper.setStatic(mtd, false);
        BpmObjectTypeDescriptionHelper.setServerSide(mtd, false);
    }

    private static boolean validateAttributeName(String name) throws ConstructionException {
        if (name == null || "".equals(name.trim())) {
            throw new ConstructionException(BpmObjectMsg.XOBJLIB_CONST_0009);
        }
        int c = name.codePointAt(0);
        if (!Character.isLetter(c) || !Identifier.isValid(name)) {
            throw new ConstructionException(BpmObjectMsg.XOBJLIB_CONST_0007(name));
        }
        if (BpmObjectTypeDescriptionHelper.isFuegoObjectReservedName(name)) {
            throw new ConstructionException(BpmObjectMsg.XOBJLIB_CONST_0008(name));
        }
        return true;
    }

    private static boolean validateMember(ObjectTypeDescription parent, String name) throws ConstructionException {
        if (parent.findMember(name, TypeFinder.Scope.DELEGATED) != null) {
            throw new ConstructionException(BpmObjectMsg.XOBJLIB_CONST_0005(name));
        }
        return true;
    }

    private static boolean validateMethodName(ObjectTypeDescription parent, String name, boolean isReservedName) throws ConstructionException {
        if (name == null || "".equals(name.trim())) {
            throw new ConstructionException(BpmObjectMsg.XOBJLIB_CONST_0009);
        }
        char c = name.charAt(0);
        if (Character.isUpperCase(c) || !Identifier.isValid(name)) {
            throw new ConstructionException(BpmObjectMsg.XOBJLIB_CONST_0007(name));
        }
        if (!isReservedName && BpmObjectTypeDescriptionHelper.isFuegoObjectReservedName(name)) {
            throw new ConstructionException(BpmObjectMsg.XOBJLIB_CONST_0008(name));
        }
        if (parent.findMember(name, TypeFinder.Scope.CURRENT) != null) {
            throw new ConstructionException(BpmObjectMsg.XOBJLIB_CONST_0005(name));
        }
        return true;
    }

    private static class CannotFindAttributesObjectException
    extends Exception {
        private static final long serialVersionUID = -5099958561965827987L;

        CannotFindAttributesObjectException(String message) {
            super(message);
        }
    }
}

