/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.bpmobject;

import oracle.bpm.lang.AttributeTypeDescription;

public class XMLSignatureParser {
    private boolean elementIsQualified = false;
    private String elementNamespace = null;
    private int elemPosition = -1;
    private String elemType = null;
    private String name = null;
    private String namespace = null;
    private int signatureType;
    public static final int WITHOUT_POSITION = -1;

    private XMLSignatureParser() {
    }

    public static XMLSignatureParser buildSignature(AttributeTypeDescription objTypeDescription, String defaultNamespace) {
        String nativeName;
        String elementPosition;
        String namespace;
        XMLSignatureParser result = XMLSignatureParser.buildSignature(objTypeDescription.getWriteSignature(), defaultNamespace);
        String elementNamespace = objTypeDescription.getProperty("elementNamespace");
        if (elementNamespace != null) {
            result.elementNamespace = elementNamespace;
        }
        if ((namespace = objTypeDescription.getProperty("namespace")) != null) {
            result.namespace = namespace;
        }
        if ((elementPosition = objTypeDescription.getProperty("elementPosition")) != null) {
            result.elemPosition = Integer.parseInt(elementPosition);
        }
        if ((nativeName = objTypeDescription.getProperty("nativeName")) != null) {
            result.name = nativeName;
        }
        return result;
    }

    public static XMLSignatureParser buildSignature(String signature, String defaultNamespace) {
        return XMLSignatureParser.buildSignature(signature, defaultNamespace, false);
    }

    public static XMLSignatureParser buildSignature(String signature, String namespace, boolean elementIsQualified) {
        int lastInd;
        XMLSignatureParser result = new XMLSignatureParser();
        result.signatureType = signature.charAt(0);
        String elementNamespace = null;
        if (result.signatureType == 65) {
            int lastInd2 = signature.lastIndexOf(59);
            int firstInd = signature.indexOf(59);
            if (lastInd2 != -1 && firstInd != lastInd2) {
                elementNamespace = signature.substring(lastInd2 + 1);
                signature = signature.substring(0, lastInd2);
            }
        }
        int namespaceSeparatorPosition = result.signatureType == 64 ? 3 : 2;
        int elementNamespaceSeparatorPosition = namespaceSeparatorPosition + 1;
        int elementQualifiedPosition = elementNamespaceSeparatorPosition + 1;
        int nextIndex = signature.indexOf(59);
        boolean elemIsQualifiedFound = false;
        String originalSignature = null;
        if (nextIndex == -1) {
            originalSignature = signature;
        } else {
            boolean cont = true;
            int index = 0;
            int separatorCounter = 0;
            while (cont) {
                if (nextIndex == -1) {
                    nextIndex = signature.length();
                    cont = false;
                }
                if (separatorCounter == namespaceSeparatorPosition) {
                    result.namespace = signature.substring(index, nextIndex);
                } else if (separatorCounter == elementNamespaceSeparatorPosition) {
                    result.elementNamespace = signature.substring(index, nextIndex);
                } else if (separatorCounter == elementQualifiedPosition) {
                    result.elementIsQualified = "elementQualified".equals(signature.substring(index, nextIndex));
                    elemIsQualifiedFound = true;
                } else {
                    String currentToken = signature.substring(index, nextIndex);
                    originalSignature = originalSignature != null ? originalSignature + ';' + currentToken : currentToken;
                }
                if (!cont) continue;
                index = nextIndex + 1;
                nextIndex = signature.indexOf(59, index);
                ++separatorCounter;
            }
        }
        if (result.namespace == null) {
            result.namespace = namespace;
        }
        if (originalSignature == null) {
            originalSignature = signature;
        }
        if ((lastInd = originalSignature.lastIndexOf(59)) != -1) {
            result.name = originalSignature.substring(1, lastInd);
            result.elemType = originalSignature.substring(lastInd + 1);
        }
        if ((result.signatureType == 64 || result.signatureType == 35) && result.name != null) {
            lastInd = result.name.indexOf(59);
            result.elemPosition = Integer.parseInt(result.name.substring(0, lastInd));
            result.signatureType = result.name.charAt(lastInd + 1);
            result.name = result.name.substring(lastInd + 2);
        }
        if (result.signatureType == 65) {
            result.elementNamespace = elementNamespace;
        }
        if (!elemIsQualifiedFound) {
            result.elementIsQualified = elementIsQualified;
        }
        return result;
    }

    public static String replaceAttributeType(String signature, String newType) {
        XMLSignatureParser result = new XMLSignatureParser();
        result.signatureType = signature.charAt(0);
        int originalTypePosition = result.signatureType == 64 ? 2 : 1;
        int indexTypePosition = signature.indexOf(59, 0);
        if (originalTypePosition == 2) {
            indexTypePosition = signature.indexOf(59, indexTypePosition);
        }
        String firstPart = signature.substring(0, indexTypePosition);
        indexTypePosition = signature.indexOf(59, indexTypePosition + 1);
        String secondPart = signature.substring(indexTypePosition, signature.length());
        signature = firstPart + ';' + newType + secondPart;
        return signature;
    }

    public static String replaceAttributeElementNamespace(String signature, String elementNamespace) {
        int lastInd = signature.lastIndexOf(59);
        int firstInd = signature.indexOf(59);
        if (lastInd != -1 && firstInd != lastInd) {
            signature = signature.substring(0, lastInd);
        }
        return signature + ';' + elementNamespace;
    }

    public static String[] getConstructorParts(String constructor) {
        return constructor.split(";");
    }

    public int getElemPosition() {
        return this.elemPosition;
    }

    public String getName() {
        return this.name;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getElemType() {
        return this.elemType;
    }

    public int getSignatureType() {
        return this.signatureType;
    }

    public String getElementNamespace() {
        return this.elementNamespace;
    }

    public void setElementNamespace(String elementNamespace) {
        this.elementNamespace = elementNamespace;
    }

    public boolean getElementIsQualified() {
        return this.elementIsQualified;
    }
}

