/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import fuego.boot.ClassPath;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class EclipseClasspath {
    private File[] pluginDirs;
    private String rootBundle;
    private boolean verbose = false;
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String BUNDLE_CLASSPATH = "Bundle-ClassPath";
    private static final String REQUIRE_BUNDLE = "Require-Bundle";

    public EclipseClasspath(String rootBundle, File[] pluginDirs) {
        this.rootBundle = rootBundle;
        this.pluginDirs = pluginDirs;
    }

    public EclipseClasspath(String rootBundle, String searchPath, boolean verbose) {
        this.rootBundle = rootBundle;
        this.verbose = verbose;
        String[] paths = searchPath.split(File.pathSeparator);
        this.pluginDirs = new File[paths.length];
        for (int i = 0; i < paths.length; ++i) {
            this.pluginDirs[i] = new File(paths[i]);
        }
    }

    public static void main(String[] args) throws Throwable {
        File[] files;
        File[] directories = new File[args.length - 1];
        for (int i = 0; i < directories.length; ++i) {
            directories[i] = new File(args[i + 1]);
        }
        EclipseClasspath ecp = new EclipseClasspath(args[0], directories);
        for (File file : files = ecp.build()) {
            System.out.println(file);
        }
    }

    public File[] build() throws IOException {
        File[] resourcesJars;
        Map<String, File> searchPath = this.buildSearchPath(this.pluginDirs);
        ArrayList<String> pending = new ArrayList<String>();
        HashMap<String, File> classPath = new HashMap<String, File>();
        pending.add(this.rootBundle);
        Set<String> keys = searchPath.keySet();
        for (String jarName : keys) {
            File jar = new File(searchPath.get(jarName), jarName + ".jar");
            if (!jar.exists() || !jarName.startsWith("fuego.")) continue;
            pending.add(jarName);
        }
        this.loadDepenciesUsingJarManifest(pending, searchPath, classPath);
        File toolsJar = ClassPath.getToolsJar();
        if (toolsJar != null && toolsJar.exists()) {
            classPath.put(toolsJar.getName(), toolsJar.getCanonicalFile());
        }
        Collection files = classPath.values();
        for (File resourcesJar : resourcesJars = this.pluginDirs[0].listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("fuego.resources") && name.endsWith(".jar");
            }
        })) {
            classPath.put(resourcesJar.getName(), resourcesJar.getAbsoluteFile());
        }
        return files.toArray(new File[files.size()]);
    }

    private void loadDepenciesUsingJarManifest(List<String> pending, Map<String, File> searchPath, Map<String, File> classPath) throws IOException {
        HashSet<String> visited = new HashSet<String>();
        for (int i = 0; i < pending.size(); ++i) {
            String bundleName = pending.get(i);
            if (visited.contains(bundleName)) continue;
            visited.add(bundleName);
            File current = searchPath.get(bundleName);
            if (current != null) {
                if (current.exists()) {
                    String[] dependencies;
                    String requireBundle;
                    Map<String, String> manifest = this.readManifest(current);
                    String bundleClassPath = manifest.get(BUNDLE_CLASSPATH);
                    if (bundleClassPath != null) {
                        String[] bundlePath;
                        for (String file : bundlePath = bundleClassPath.split(",")) {
                            File jar = new File(current, file.trim());
                            if (!jar.exists()) continue;
                            classPath.put(jar.getName(), jar.getCanonicalFile());
                        }
                    }
                    if (current.isFile() && current.exists()) {
                        classPath.put(current.getName(), current.getCanonicalFile());
                    }
                    if ((requireBundle = manifest.get(REQUIRE_BUNDLE)) == null) continue;
                    for (String bundle : dependencies = requireBundle.split(",")) {
                        int semicolon = (bundle = bundle.trim()).indexOf(59);
                        if (semicolon != -1) {
                            bundle = bundle.substring(0, semicolon);
                        }
                        pending.add(bundle);
                    }
                    continue;
                }
                this.warn("File not found: " + current.getCanonicalFile());
                continue;
            }
            this.warn("Bundle not found: " + bundleName);
        }
    }

    private void warn(String message) {
        if (this.verbose) {
            System.err.println("WARNING: " + message);
        }
    }

    private Map<String, File> buildSearchPath(File[] directories) throws IOException {
        HashMap<String, File> searchPath = new HashMap<String, File>();
        for (File dir : directories) {
            File[] plugins = dir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    String name = pathname.getName();
                    if (name.endsWith(".jar")) {
                        return pathname.isFile() && name.matches(".*_\\d+(?:\\.\\d+)*\\.jar");
                    }
                    return pathname.isDirectory() && name.matches(".*_\\d+(?:\\.\\d+)*");
                }
            });
            System.out.println("------------------------------");
            if (plugins != null) {
                for (File plugin : plugins) {
                    int underscore;
                    String filename = plugin.getName();
                    String symbolicName = filename.substring(0, underscore = filename.lastIndexOf(95));
                    File candidate = (File)searchPath.get(symbolicName);
                    if (candidate == null) {
                        searchPath.put(symbolicName, plugin.getCanonicalFile());
                        continue;
                    }
                    this.warn("Duplicate versions of '" + symbolicName + "'\n" + "\tusing: " + candidate + "\tinstead of: " + plugin.getCanonicalFile());
                }
            }
            System.out.println("------------------------------");
        }
        return searchPath;
    }

    private Map<String, String> readManifest(File plugin) throws IOException {
        BufferedReader br;
        ZipFile zipFile = null;
        if (plugin.isDirectory()) {
            File manifest = new File(plugin, MANIFEST_PATH);
            br = new BufferedReader(new FileReader(manifest));
        } else {
            zipFile = new ZipFile(plugin);
            ZipEntry entry = zipFile.getEntry(MANIFEST_PATH);
            br = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
        }
        int state = 0;
        StringBuilder sb = new StringBuilder();
        String key = null;
        LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
        int c = br.read();
        while (c != -1) {
            switch (state) {
                case 0: {
                    if (c == 58) {
                        state = 1;
                        key = sb.toString();
                        sb.setLength(0);
                        break;
                    }
                    sb.append((char)c);
                    break;
                }
                case 1: {
                    if (c == 10) {
                        state = 2;
                        break;
                    }
                    sb.append((char)c);
                    break;
                }
                case 2: {
                    if (c == 32) {
                        state = 1;
                        break;
                    }
                    properties.put(key, sb.toString());
                    sb.setLength(0);
                    key = null;
                    state = 0;
                    sb.append((char)c);
                }
            }
            c = br.read();
        }
        if (key != null) {
            properties.put(key, sb.toString());
        }
        br.close();
        if (zipFile != null) {
            zipFile.close();
        }
        return properties;
    }
}

