/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import fuego.boot.ByteArrayPool;
import fuego.boot.CachedResource;
import fuego.boot.ClassCache;
import fuego.boot.ClassCacheWriteException;
import fuego.boot.Loader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.security.CodeSource;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

abstract class ClassHelper
implements Serializable {
    final File file;
    private CodeSource codeSource;
    private final long lastModified;
    private boolean loaded;
    static final long serialVersionUID = 8552405427758641697L;
    private static final String CLASS_EXT = ".class";
    static final long serialCheck = -6572367992623393362L;

    private ClassHelper(File file) {
        this.file = file;
        this.lastModified = file.lastModified();
    }

    public final String toString() {
        return this.getName();
    }

    abstract InputStream getResourceAsStream(String var1);

    abstract void addAll(ClassCache var1, FileChannel var2) throws ClassCacheWriteException;

    abstract boolean contains(String var1);

    abstract ByteArrayPool.Entry loadBytecode(String var1, ByteArrayPool var2);

    static String extractPackage(String name, boolean isClass) {
        int last;
        int n = last = isClass ? name.lastIndexOf(46) : name.lastIndexOf(47);
        if (last == -1) {
            name = "";
        } else {
            name = name.substring(0, last);
            if (!isClass) {
                name = name.replace('/', '.');
            }
        }
        return name;
    }

    static final ClassHelper create(File file) {
        ClassHelper result = file.isDirectory() ? new FileClassHelper(file) : new ZipClassHelper(file);
        return result;
    }

    final CodeSource getCodeSource() {
        if (this.codeSource == null) {
            try {
                this.codeSource = new CodeSource(this.file.toURI().toURL(), (Certificate[])null);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return this.codeSource;
    }

    final File getFile() {
        return this.file;
    }

    final String getName() {
        return this.file.getName();
    }

    final URL buildResourceURL(String name) {
        try {
            return CachedResource.urlForResource(this.file.toURI().toURL(), name);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    final boolean contains(String name, boolean isClass) {
        assert (name != null) : "name cannot be null";
        return this.contains(isClass ? name.replace('.', '/').concat(CLASS_EXT) : name.replace('\\', '/'));
    }

    final long lastModified() {
        return this.lastModified;
    }

    void close() {
    }

    final void setLoaded() {
        this.loaded = true;
        this.close();
    }

    final boolean isLoaded() {
        return this.loaded;
    }

    private static String pathFromClass(String className) {
        String result = className;
        if (result.endsWith(CLASS_EXT)) {
            result = result.substring(0, className.length() - CLASS_EXT.length());
        }
        result = result.replace('.', '/');
        result = result.concat(CLASS_EXT);
        return result;
    }

    private static final class ZipClassHelper
    extends ClassHelper {
        private Boolean fileExists;
        private transient ZipFile zipFile;
        static final long serialCheck = 3525471290102864232L;
        static final long serialVersionUID = 7552982713938127089L;

        ZipClassHelper(File file) {
            super(file);
        }

        @Override
        InputStream getResourceAsStream(String name) {
            try {
                ZipFile z = this.getZipFile();
                if (z == null) {
                    return null;
                }
                ZipEntry entry = z.getEntry(name);
                if (entry == null) {
                    return null;
                }
                return z.getInputStream(entry);
            }
            catch (IOException e) {
                this.printException(e);
                return null;
            }
        }

        @Override
        void addAll(ClassCache classCache, FileChannel channel) throws ClassCacheWriteException {
            ZipFile z;
            try {
                z = this.getZipFile();
            }
            catch (IOException e) {
                this.printException(e);
                z = null;
            }
            if (z != null) {
                int codeSourceIndex = -1;
                Enumeration<? extends ZipEntry> enumeration = z.entries();
                while (enumeration.hasMoreElements()) {
                    ByteArrayPool.Entry byteCode;
                    ZipEntry entry = enumeration.nextElement();
                    String name = entry.getName();
                    CachedResource resource = CachedResource.fromPath(name = name.replace('\\', '/'), classCache);
                    if (resource == null) continue;
                    CachedResource cachedResource = classCache.getCachedClass(resource);
                    if (cachedResource != null && !resource.canDup) {
                        String original = cachedResource.getCodeSource().getLocation().getFile();
                        int lastSlash = original.lastIndexOf(47);
                        if (lastSlash != -1) {
                            original = original.substring(lastSlash + 1);
                        }
                        this.debug("Warning className = " + resource + " duplicated in Jar: " + this.getFile() + ", first found in: " + cachedResource.getCodeSource().getLocation());
                        continue;
                    }
                    if (codeSourceIndex == -1) {
                        codeSourceIndex = classCache.addCodeSource(this.getCodeSource());
                    }
                    if ((byteCode = this.loadBytecode(entry, classCache.getByteArrayPool())) != null) {
                        resource.init(codeSourceIndex, byteCode, channel);
                        byteCode.release();
                    }
                    if (cachedResource == null) {
                        classCache.addCachedClass(resource);
                        continue;
                    }
                    cachedResource.add(resource);
                }
            } else {
                System.err.println("Warning: File not found: " + this.file);
            }
        }

        @Override
        void close() {
            try {
                if (this.zipFile != null) {
                    this.zipFile.close();
                    this.zipFile = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        @Override
        boolean contains(String name) {
            ZipFile z;
            try {
                z = this.getZipFile();
            }
            catch (IOException e) {
                this.printException(e);
                return false;
            }
            return z.getEntry(name) != null;
        }

        @Override
        ByteArrayPool.Entry loadBytecode(String className, ByteArrayPool byteArrayPool) {
            String path = ClassHelper.pathFromClass(className);
            ZipFile z = null;
            try {
                z = this.getZipFile();
            }
            catch (IOException e) {
                this.printException(e);
            }
            ZipEntry entry = z == null ? null : z.getEntry(path.replace('\\', '/'));
            ByteArrayPool.Entry result = null;
            if (entry != null) {
                result = this.loadBytecode(entry, byteArrayPool);
            }
            return result;
        }

        private ZipFile getZipFile() throws IOException {
            if (this.zipFile == null && this.fileExists()) {
                this.zipFile = new ZipFile(this.file);
            } else if (!this.fileExists()) {
                throw new FileNotFoundException(this.file.getAbsolutePath());
            }
            return this.zipFile;
        }

        private boolean fileExists() {
            if (this.fileExists == null) {
                this.fileExists = this.file.exists();
            }
            return this.fileExists;
        }

        private ByteArrayPool.Entry loadBytecode(ZipEntry entry, ByteArrayPool byteArrayPool) {
            ByteArrayPool.Entry result;
            block3: {
                result = null;
                try {
                    int n;
                    InputStream inputStream = this.getZipFile().getInputStream(entry);
                    result = byteArrayPool.findAvailableEntry((int)entry.getSize());
                    byte[] bytes = result.getBytes();
                    int offset = 0;
                    for (int total = result.getLength(); total > 0 && (n = inputStream.read(bytes, offset, total)) >= 0; total -= n) {
                        offset += n;
                    }
                }
                catch (IOException e) {
                    this.printException(e);
                    if (result == null) break block3;
                    result.release();
                    result = null;
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void printException(IOException e) {
            if (Loader.getRootLoader().doDebug()) {
                PrintStream printStream = System.err;
                synchronized (printStream) {
                    System.err.println(e.toString() + ": " + this.file);
                    e.printStackTrace();
                }
            }
        }

        private void debug(String message) {
            if (Loader.getRootLoader().doDebug()) {
                System.out.print(message);
            }
        }
    }

    private static final class FileClassHelper
    extends ClassHelper {
        static final long serialCheck = 6564279638894382681L;
        static final long serialVersionUID = 1498765458147213229L;

        FileClassHelper(File file) {
            super(file);
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("'" + file + "' is not a directory");
            }
        }

        @Override
        InputStream getResourceAsStream(String name) {
            File resource = new File(this.file, name.replace('/', File.separatorChar));
            try {
                return new FileInputStream(resource);
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }

        @Override
        void addAll(ClassCache classCache, FileChannel channel) throws ClassCacheWriteException {
            this.scan(classCache, channel, this.file, null);
        }

        @Override
        boolean contains(String name) {
            String path = name.replace('/', File.separatorChar);
            File resource = new File(this.file, path);
            return resource.exists();
        }

        @Override
        ByteArrayPool.Entry loadBytecode(String className, ByteArrayPool byteArrayPool) {
            String path = ClassHelper.pathFromClass(className);
            File classFile = new File(this.file, path);
            return this.loadBytecode(classFile, byteArrayPool);
        }

        private static boolean valid(String path) {
            return !path.endsWith("/") && path.indexOf(46) != -1 && !path.endsWith(".jar") && !path.endsWith(".zip");
        }

        private void scan(ClassCache classCache, FileChannel channel, File f, String currentPath) throws ClassCacheWriteException {
            File[] list = f.listFiles();
            int codeSourceIndex = -1;
            for (File path : list) {
                String fullPath = currentPath == null ? path.getName() : currentPath.concat("/").concat(path.getName());
                fullPath = fullPath.replace('\\', '/');
                if (path.isDirectory()) {
                    this.scan(classCache, channel, path, fullPath);
                    continue;
                }
                if (!FileClassHelper.valid(fullPath)) continue;
                if (codeSourceIndex == -1) {
                    codeSourceIndex = classCache.addCodeSource(this.getCodeSource());
                }
                CachedResource resource = CachedResource.fromPath(fullPath, classCache);
                ByteArrayPool.Entry byteBuffer = this.loadBytecode(path, classCache.getByteArrayPool());
                if (byteBuffer == null) continue;
                resource.init(codeSourceIndex, byteBuffer, channel);
                byteBuffer.release();
                classCache.addCachedClass(resource);
            }
        }

        private ByteArrayPool.Entry loadBytecode(File classFile, ByteArrayPool byteArrayPool) {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream(1024);
            try {
                int n;
                FileInputStream fis = new FileInputStream(classFile);
                byte[] buffer = new byte[1024];
                while ((n = fis.read(buffer)) >= 0) {
                    byteArray.write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                return null;
            }
            ByteArrayPool.Entry result = byteArrayPool.findAvailableEntry(byteArray.size());
            System.arraycopy(byteArray.toByteArray(), 0, result.getBytes(), 0, result.getLength());
            return result;
        }
    }
}

