/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

import fuego.boot.BootHashMap;
import fuego.boot.BuildCacheProgressMonitor;
import fuego.boot.ByteArrayPool;
import fuego.boot.CachedResource;
import fuego.boot.ClassCacheWriteException;
import fuego.boot.ClassHelper;
import fuego.boot.ClassSet;
import fuego.boot.LoadedResource;
import fuego.boot.Loader;
import fuego.boot.ResourceFromHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.security.BasicPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

final class ClassCache
implements Serializable {
    private final ByteArrayPool byteArrayPool;
    private FileChannel cacheChannel;
    private transient ClassSet cachedClasses;
    private transient MappedByteBuffer cacheFile;
    private transient FileInputStream cacheInputStream;
    private Exception closedStack;
    private List<CodeSource> codeSourceSet;
    private final List<ClassHelper> helpers;
    private final transient BootHashMap<String, ClassHelper> helpersByPackage;
    private final String id;
    private final Loader loader;
    private transient URLStreamHandler urlStreamHandler;
    private static final int BAD_CACHE_MAGIC = -1094792502;
    private static final int CACHE_MAGIC = -1094792450;
    private static final long serialVersionUID = 362498820763181265L;
    static final String[] NEVER = new String[]{"servlet-api.jar", "tools.jar"};
    private static final String CACHE = "cache";
    static final long serialCheck = -7584383211228736410L;
    private static final Map<String, WeakReference<ClassCache>> caches = new HashMap<String, WeakReference<ClassCache>>();
    private static final Object idLock = new Object();
    private static int nextId = 0;

    ClassCache(Loader loader, List<ClassHelper> helpers) {
        this.loader = loader;
        this.helpersByPackage = new BootHashMap();
        this.helpers = helpers;
        this.byteArrayPool = ByteArrayPool.create();
        this.id = this.selfRegister();
    }

    public static URLConnection openUrlConnection(URL url) {
        return new MyURLConnection(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ClassCache create(Loader loader, List<ClassHelper> helpers, File cacheIndexFile, byte[] digest, boolean useBuiltCache, boolean check) {
        ClassCache result = null;
        if (digest != null && cacheIndexFile.exists()) {
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(cacheIndexFile);
                FileChannel channel = inputStream.getChannel();
                MappedByteBuffer input = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
                File cacheFile = null;
                int magic = input.getInt();
                if (magic != -1094792450) {
                    System.err.println("Cache corrupted: " + Integer.toHexString(magic));
                } else {
                    cacheFile = loader.openClassCache();
                    if (cacheFile != null) {
                        int digestLength = input.getInt();
                        if (useBuiltCache) {
                            input.position(input.position() + digestLength);
                        } else if (digestLength != digest.length) {
                            cacheFile = null;
                        } else {
                            ClassCache.xOr(cacheFile.length(), digest, 0);
                            ClassCache.xOr(channel.size(), digest, 8);
                            for (int i = 0; i < digestLength; ++i) {
                                if (input.get() == digest[i]) continue;
                                cacheFile = null;
                                break;
                            }
                        }
                    }
                }
                if (cacheFile != null) {
                    Loader.printRunningTime("Loading cache", true);
                    result = new ClassCache(loader, helpers);
                    result.readCodeSourceSet(input);
                    result.cachedClasses = ClassSet.read(result, input);
                    result.openClassCache(cacheFile);
                    if (check) {
                        result.checkCache();
                    }
                    result.closeHelpers(NEVER);
                    Loader.printRunningTime("Loading cache");
                }
            }
            catch (IOException e) {
                result = null;
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    ByteArrayPool getByteArrayPool() {
        return this.byteArrayPool;
    }

    CachedResource getCachedClass(CachedResource resource) {
        return this.cachedClasses.get(resource);
    }

    CodeSource getCodeSource(int i) {
        return this.getCodeSourceSet().get(i);
    }

    boolean isEnabled() {
        return this.cachedClasses != null;
    }

    Loader getLoader() {
        return this.loader;
    }

    void addCachedClass(CachedResource resource) {
        this.cachedClasses.add(resource);
    }

    int addCodeSource(CodeSource codeSource) {
        List<CodeSource> cs = this.getCodeSourceSet();
        int index = cs.indexOf(codeSource);
        if (index == -1) {
            index = cs.size();
            cs.add(codeSource);
        }
        return index;
    }

    void addFileToHelpers(File file) {
        if (file.exists()) {
            for (ClassHelper helper : this.helpers) {
                if (!helper.getFile().equals(file)) continue;
                return;
            }
            if (this.loader.doDebug()) {
                System.out.println("Added to classpath: " + file);
            }
            this.helpers.add(ClassHelper.create(file));
        }
    }

    long buildCache(File file, Set<File> classSet, BuildCacheProgressMonitor monitor) throws IOException {
        long cacheFileSize;
        String msg = "Building Cache " + file;
        Loader.printRunningTime(msg, true);
        monitor.setProgress(0);
        FileOutputStream os = new FileOutputStream(file);
        FileChannel channel = os.getChannel();
        this.cachedClasses = new ClassSet();
        Arrays.sort(NEVER);
        try {
            this.loadIntoCache(channel, null, NEVER, monitor);
        }
        catch (ClassCacheWriteException e) {
            file.delete();
            throw e.getIOException();
        }
        try {
            channel.force(true);
            cacheFileSize = channel.size();
        }
        catch (IOException e) {
            e.printStackTrace();
            file.delete();
            throw e;
        }
        finally {
            os.flush();
            os.close();
            channel.close();
        }
        monitor.setProgress(100);
        Loader.printRunningTime(msg);
        return cacheFileSize;
    }

    void close() {
        this.closedStack = new Exception();
        if (this.cacheFile != null) {
            try {
                this.cacheChannel.close();
                this.cacheInputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.cacheFile = null;
        }
        this.closeHelpers(NEVER);
    }

    LoadedResource findClass(String className) {
        ClassHelper helper;
        LoadedResource result = null;
        if (this.cachedClasses != null) {
            CachedResource cr = this.cachedClasses.getFromClassName(className);
            assert (this.closedStack == null) : "Cannot use cache after close(). It was closed at: \n" + this.dumpStack(this.closedStack);
            if (this.cacheFile != null && cr != null) {
                cr.setInputFile(this.cacheFile);
                result = cr;
            }
        }
        if (result == null && this.helpers != null && this.helpers.size() > 0 && (helper = this.findHelper(className, true)) != null) {
            result = ResourceFromHelper.fromClass(this, className, helper);
        }
        return result;
    }

    URL findResource(String resourceName) {
        URL result = null;
        CachedResource resource = this.findResourceInCache(resourceName, 0);
        if (resource != null) {
            result = this.buildResourceURL(resource, resourceName, 0);
        } else {
            ClassHelper helper = this.findResourceHelper(resourceName);
            if (helper != null) {
                result = helper.buildResourceURL(resourceName);
            }
        }
        return result;
    }

    void findResources(String name, Vector<URL> v) {
        int i = 0;
        for (CachedResource resource = this.findResourceInCache(name, 0); resource != null; resource = resource.getNext()) {
            URL url;
            if ((url = this.buildResourceURL(resource, name, i++)) == null) continue;
            v.add(url);
        }
        for (ClassHelper classHelper : this.helpers) {
            URL url;
            if (!classHelper.contains(name, false) || (url = classHelper.buildResourceURL(name)) == null) continue;
            v.add(url);
        }
    }

    boolean openClassCache(File cache) {
        MappedByteBuffer result = null;
        if (cache.exists()) {
            try {
                this.cacheInputStream = new FileInputStream(cache);
                this.cacheChannel = this.cacheInputStream.getChannel();
                result = this.cacheChannel.map(FileChannel.MapMode.READ_ONLY, 0L, this.cacheChannel.size());
            }
            catch (IOException e) {
                try {
                    if (this.cacheInputStream != null) {
                        this.cacheInputStream.close();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                result = null;
            }
        }
        this.cacheFile = result;
        return result != null;
    }

    void writeClassCache(byte[] digest, long cacheFileSize, File cacheIndex) throws IOException, ClassCacheWriteException {
        RandomAccessFile out = new RandomAccessFile(cacheIndex, "rw");
        try {
            out.writeInt(-1094792502);
            out.writeInt(digest.length);
            out.write(digest);
            this.writeCodeSourceSet(out);
            this.getClassSet().write(out);
            out.getFD().sync();
            ClassCache.xOr(cacheFileSize, digest, 0);
            ClassCache.xOr(out.length(), digest, 8);
            out.seek(0L);
            out.writeInt(-1094792450);
            out.writeInt(digest.length);
            out.write(digest);
            out.getFD().sync();
            out.close();
        }
        catch (IOException e) {
            cacheIndex.delete();
            throw new ClassCacheWriteException(e);
        }
        Loader.printRunningTime("Writting Cache");
    }

    private static void xOr(long value, byte[] buffer, int offset) {
        buffer[offset++] = (byte)(value >>> 56);
        buffer[offset++] = (byte)(value >>> 48);
        buffer[offset++] = (byte)(value >>> 40);
        buffer[offset++] = (byte)(value >>> 32);
        buffer[offset++] = (byte)(value >>> 24);
        buffer[offset++] = (byte)(value >>> 16);
        buffer[offset++] = (byte)(value >>> 8);
        buffer[offset] = (byte)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClassCache findCache(String key) {
        ClassCache classCache;
        Map<String, WeakReference<ClassCache>> map = caches;
        synchronized (map) {
            classCache = (ClassCache)caches.get(key).get();
            if (classCache == null) {
                caches.remove(key);
            }
        }
        return classCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String selfRegister() {
        String id;
        Map<String, WeakReference<ClassCache>> map = idLock;
        synchronized (map) {
            id = String.valueOf(++nextId);
        }
        map = caches;
        synchronized (map) {
            caches.put(id, new WeakReference<ClassCache>(this));
        }
        return id;
    }

    private String dumpStack(Exception stack) {
        StringBuffer buffer = new StringBuffer();
        StackTraceElement[] elements = stack.getStackTrace();
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            buffer.append(element);
            buffer.append('\n');
        }
        return buffer.toString();
    }

    private ClassSet getClassSet() {
        return this.cachedClasses;
    }

    private List<CodeSource> getCodeSourceSet() {
        if (this.codeSourceSet == null) {
            this.codeSourceSet = new ArrayList<CodeSource>();
        }
        return this.codeSourceSet;
    }

    private URL buildResourceURL(CachedResource resource, String resourceName, int n) {
        URL result = null;
        try {
            if (!resource.isClass()) {
                if (n == 0) {
                    n = -1;
                }
                result = new URL(CACHE, this.id, n, "/" + resourceName);
            } else {
                URL url = resource.getCodeSource().getLocation();
                result = CachedResource.urlForResource(url, resourceName);
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private void checkCache() {
        int errors = 0;
        Iterator iterator = this.cachedClasses.iterator();
        while (iterator.hasNext()) {
            CachedResource c = (CachedResource)iterator.next();
            this.cacheFile.position(c.getBytecodeOffset());
            int magic = this.cacheFile.getInt();
            if (magic == -889275714 || !c.isClass()) continue;
            System.err.println("magic = " + Integer.toHexString(magic) + " " + c.getName());
            ++errors;
        }
        if (errors > 0) {
            System.exit(1);
        }
        System.err.println("Cache OK!");
    }

    private void closeHelpers(String[] exclude) {
        Iterator<ClassHelper> iterator = this.helpers.iterator();
        while (iterator.hasNext()) {
            ClassHelper helper = iterator.next();
            if (exclude != null && Arrays.binarySearch(exclude, helper.getName()) >= 0) continue;
            helper.close();
            iterator.remove();
        }
    }

    private ClassHelper findHelper(String name, boolean isClass) {
        String packageName = ClassHelper.extractPackage(name, isClass);
        ClassHelper helperInCache = this.helpersByPackage.get(packageName);
        if (helperInCache != null && helperInCache.contains(name, isClass)) {
            return helperInCache;
        }
        for (ClassHelper classHelper : this.helpers) {
            if (!classHelper.contains(name, isClass)) continue;
            this.helpersByPackage.put(packageName, classHelper);
            return classHelper;
        }
        return null;
    }

    private ClassHelper findResourceHelper(String resourceName) {
        ClassHelper helper = null;
        if (this.helpers != null && this.helpers.size() > 0) {
            helper = this.findHelper(resourceName, false);
        }
        return helper;
    }

    private CachedResource findResourceInCache(String resourceName, int port) {
        CachedResource result = null;
        if (this.cachedClasses != null) {
            for (result = this.cachedClasses.getFromPath(resourceName, this); port > 0 && result != null; result = result.getNext(), --port) {
            }
            if (this.cacheFile != null && result != null) {
                result.setInputFile(this.cacheFile);
            }
        }
        return result;
    }

    private void loadIntoCache(FileChannel channel, String[] include, String[] exclude, BuildCacheProgressMonitor monitor) throws ClassCacheWriteException {
        int size = this.helpers.size();
        int adv = 0;
        Iterator<ClassHelper> iterator = this.helpers.iterator();
        while (iterator.hasNext()) {
            boolean load;
            ClassHelper helper = iterator.next();
            boolean bl = load = !helper.isLoaded();
            if (load) {
                if (exclude != null) {
                    boolean bl2 = load = Arrays.binarySearch(exclude, helper.getName()) < 0;
                }
                if (load && include != null) {
                    load = Arrays.binarySearch(include, helper.getName()) >= 0;
                }
            }
            ++adv;
            if (load) {
                helper.addAll(this, channel);
                helper.setLoaded();
                helper.close();
                iterator.remove();
                if (adv % 5 == 0) {
                    System.gc();
                }
            }
            monitor.setProgress(adv * 80 / size);
        }
    }

    private void readCodeSourceSet(MappedByteBuffer input) throws MalformedURLException {
        int csSize = input.getInt();
        ArrayList<CodeSource> codeSourceSet = new ArrayList<CodeSource>(csSize);
        for (int i = 0; i < csSize; ++i) {
            int strLength = input.getInt();
            StringBuffer url = new StringBuffer(strLength);
            for (int j = 0; j < strLength; ++j) {
                url.append((char)(input.get() & 0xFF));
            }
            codeSourceSet.add(new CodeSource(new URL(url.toString()), (Certificate[])null));
        }
        this.codeSourceSet = codeSourceSet;
    }

    private void writeCodeSourceSet(RandomAccessFile out) throws IOException {
        int size = this.getCodeSourceSet().size();
        out.writeInt(size);
        for (int i = 0; i < size; ++i) {
            String cs = this.getCodeSource(i).getLocation().toExternalForm();
            out.writeInt(cs.length());
            out.writeBytes(cs);
        }
    }

    private static final class MyURLConnection
    extends URLConnection {
        private final CachedResource cachedResource;

        public MyURLConnection(URL url) {
            super(url);
            String key = url.getHost();
            ClassCache classCache = ClassCache.findCache(key);
            this.cachedResource = classCache != null ? classCache.findResourceInCache(url.getPath().substring(1), url.getPort()) : null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.cachedResource == null) {
                throw new IOException(this.getURL().getPath());
            }
            return this.cachedResource.getInputStream();
        }

        @Override
        public Permission getPermission() {
            return new CachePermission();
        }

        @Override
        public void connect() throws IOException {
            if (this.cachedResource == null) {
                throw new IOException(this.getURL().getPath());
            }
        }

        private static class CachePermission
        extends BasicPermission {
            static final long serialCheck = 8018145222100994936L;
            static final long serialVersionUID = -1203793436968896257L;

            public CachePermission() {
                super("cachePermission");
            }
        }
    }
}

