/*
 * Decompiled with CFR 0.152.
 */
package fuego.boot;

final class ByteArrayPool {
    private final Entry first;
    private int count;
    private final int minEntrySize;
    private static final int MIN_ENTRY_SIZE = 16384;

    private ByteArrayPool(int minEntrySize) {
        this.minEntrySize = minEntrySize;
        this.first = new Entry(minEntrySize, minEntrySize, this);
    }

    static ByteArrayPool create() {
        return new ByteArrayPool(16384);
    }

    Entry findAvailableEntry(int requestedSize) {
        Entry result = null;
        Entry last = null;
        Entry e = this.first;
        while (e != null) {
            if (!e.isLocked() && e.getCapacity() >= requestedSize) {
                result = e;
                break;
            }
            last = e;
            e = e.next;
        }
        if (result == null) {
            result = new Entry(requestedSize, this.minEntrySize, this);
            assert (last != null);
            last.next = result;
        }
        result.locked = true;
        result.length = requestedSize;
        return result;
    }

    static final class Entry {
        private Entry next;
        private final byte[] bytes;
        private boolean locked;
        private int length;

        private Entry(int slotSize, int minSize, ByteArrayPool pool) {
            int size = Math.max(slotSize, minSize) - 1;
            int i = 0;
            while (size > 0) {
                size >>= 1;
                ++i;
            }
            size = 1 << i;
            pool.count++;
            this.length = 0;
            this.bytes = new byte[size];
            this.locked = false;
            this.next = null;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public int getCapacity() {
            return this.bytes.length;
        }

        public int getLength() {
            return this.length;
        }

        public boolean isLocked() {
            return this.locked;
        }

        public void release() {
            this.locked = false;
        }
    }
}

