/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.mds.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Iterator;
import oracle.bpm.io.fs.VFileUtils;
import oracle.bpm.log.Log;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.msg.MetadataMsg;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.bpm.resources.Msg;
import oracle.mds.core.ConcurrentMOChangeException;
import oracle.mds.core.MDSObject;
import oracle.mds.core.MDSSession;
import oracle.mds.core.MOReference;
import oracle.mds.core.MetadataExistsException;
import oracle.mds.core.MetadataNotFoundException;
import oracle.mds.core.MetadataObject;
import oracle.mds.core.StreamedObject;
import oracle.mds.core.ValidationException;
import oracle.mds.exception.InvalidNamespaceException;
import oracle.mds.exception.UnsupportedUpdateException;
import oracle.mds.internal.util.ReaderInputStream;
import oracle.mds.naming.DocumentName;
import oracle.mds.naming.InvalidReferenceException;
import oracle.mds.naming.InvalidReferenceTypeException;
import oracle.mds.naming.PackageName;
import oracle.mds.naming.ReferenceException;
import oracle.mds.persistence.MDSIOException;
import oracle.mds.persistence.PContext;
import oracle.mds.persistence.PDocument;
import oracle.mds.persistence.PManager;
import oracle.mds.persistence.PPackage;
import oracle.mds.persistence.PResource;
import oracle.mds.persistence.PTransaction;
import oracle.mds.query.Query;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public final class MdsUtils {
    public static void closeQuery(@Nullable Query query) {
        if (query != null) {
            query.close();
        }
    }

    public static void flushSession(@Nullable MDSSession mdsSession) throws PersistenceException {
        if (mdsSession != null) {
            try {
                mdsSession.flushChanges();
            }
            catch (MDSIOException e) {
                throw PersistenceException.createMdsIOException(e);
            }
            catch (ConcurrentMOChangeException e) {
                throw PersistenceException.createMdsIOException(e);
            }
            catch (ValidationException e) {
                throw PersistenceException.createMdsIOException(e);
            }
        }
    }

    public static boolean existMDSObject(@NotNull MDSSession currentMDSSession, @NotNull String resourceLocation) {
        if (currentMDSSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.existMDSObject must not be null");
        }
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.existMDSObject must not be null");
        }
        boolean ret = false;
        try {
            String normalizedUrl = VFileUtils.getCannonicalPath((String)resourceLocation);
            ret = MdsUtils.getMutableMDSObject(currentMDSSession, normalizedUrl) != null;
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
        return ret;
    }

    public static boolean existsResource(@NotNull MDSSession currentMDSSession, @NotNull String location) {
        if (currentMDSSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.existsResource must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.existsResource must not be null");
        }
        boolean ret = MdsUtils.existsPackage(currentMDSSession, location);
        if (!ret) {
            ret = MdsUtils.existMDSObject(currentMDSSession, location);
        }
        return ret;
    }

    public static MetadataObject getMutableMetadataObject(@NotNull MDSSession mdsSession, @NotNull String documentLocation) throws PersistenceException {
        if (mdsSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.getMutableMetadataObject must not be null");
        }
        if (documentLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.getMutableMetadataObject must not be null");
        }
        MetadataObject metadataObject = null;
        String normalizedUrl = VFileUtils.getCannonicalPath((String)documentLocation);
        try {
            MOReference moReference = MOReference.create((String)normalizedUrl);
            metadataObject = mdsSession.getMutableMO(moReference);
        }
        catch (ReferenceException e) {
            throw PersistenceException.createInvalidPathException(normalizedUrl, e);
        }
        catch (UnsupportedUpdateException e) {
            throw PersistenceException.createMdsIOException(normalizedUrl, e);
        }
        catch (MetadataNotFoundException e) {
            // empty catch block
        }
        return metadataObject;
    }

    public static StreamedObject getStreamedObject(@NotNull MDSSession mdsSession, @NotNull String resourceLocation) throws PersistenceException {
        if (mdsSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.getStreamedObject must not be null");
        }
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.getStreamedObject must not be null");
        }
        StreamedObject streamedObject = null;
        String normalizedUrl = VFileUtils.getCannonicalPath((String)resourceLocation);
        try {
            streamedObject = StreamedObject.getStreamedObject((MDSSession)mdsSession, (String)normalizedUrl);
        }
        catch (ReferenceException e) {
            throw PersistenceException.createInvalidPathException(normalizedUrl, e);
        }
        catch (MetadataNotFoundException e) {
            // empty catch block
        }
        return streamedObject;
    }

    public static MetadataObject createDocument(@NotNull MDSSession mdsSession, @NotNull String documentLocation, @NotNull Document document) throws PersistenceException {
        if (mdsSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.createDocument must not be null");
        }
        if (documentLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.createDocument must not be null");
        }
        if (document == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.createDocument must not be null");
        }
        MetadataObject metadataObject = null;
        String normalizedUrl = VFileUtils.getCannonicalPath((String)documentLocation);
        try {
            metadataObject = mdsSession.createMetadataObject(normalizedUrl, document);
        }
        catch (MetadataExistsException e) {
            throw PersistenceException.createArtifactAlreadyExistsException(normalizedUrl, e);
        }
        catch (ReferenceException e) {
            Log.logWarning((Msg)MetadataMsg.INVALID_PATH(normalizedUrl), (Throwable)e);
        }
        catch (UnsupportedUpdateException e) {
            throw PersistenceException.createMdsIOException(normalizedUrl, e);
        }
        return metadataObject;
    }

    public static void createPackage(@NotNull MDSSession currentMDSSession, @NotNull String path) throws PersistenceException {
        if (currentMDSSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.createPackage must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.createPackage must not be null");
        }
        String normalizedUrl = VFileUtils.getCannonicalPath((String)path);
        try {
            PackageName packageName = PackageName.createPackageName((String)normalizedUrl);
            PTransaction transaction = currentMDSSession.getPTransaction();
            transaction.createPackage(packageName);
        }
        catch (InvalidReferenceException e) {
            Log.logWarning((Msg)MetadataMsg.INVALID_PATH(normalizedUrl), (Throwable)e);
        }
        catch (InvalidReferenceTypeException e) {
            Log.logWarning((Msg)MetadataMsg.INVALID_PATH(normalizedUrl), (Throwable)e);
        }
        catch (InvalidNamespaceException e) {
            Log.logWarning((Msg)MetadataMsg.INVALID_PATH(normalizedUrl), (Throwable)e);
        }
        catch (MDSIOException e) {
            throw PersistenceException.createMdsIOException(normalizedUrl, e);
        }
        catch (UnsupportedUpdateException e) {
            throw PersistenceException.createMdsIOException(normalizedUrl, e);
        }
    }

    public static boolean deletePackage(@NotNull MDSSession currentMDSSession, @NotNull String path, boolean recursive) throws PersistenceException {
        boolean ret;
        if (currentMDSSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.deletePackage must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.deletePackage must not be null");
        }
        PTransaction transaction = currentMDSSession.getPTransaction();
        String normalizedUrl = VFileUtils.getCannonicalPath((String)path);
        try {
            PackageName packageName = PackageName.createPackageName((String)normalizedUrl);
            PPackage aPackage = MdsUtils.getPackage(currentMDSSession, packageName);
            if (aPackage == null) {
                throw new MetadataException(MetadataMsg.FOLDER_NOT_EXISTS(normalizedUrl));
            }
            if (recursive) {
                MdsUtils.deletePackageRecur(currentMDSSession, packageName);
            } else {
                transaction.deletePackage(aPackage, false);
            }
            ret = true;
        }
        catch (Throwable e) {
            throw PersistenceException.createMdsIOException(normalizedUrl, e);
        }
        return ret;
    }

    public static boolean deleteDocument(@NotNull MDSSession currentMDSSession, @NotNull String documentName) throws PersistenceException {
        boolean ret;
        if (currentMDSSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.deleteDocument must not be null");
        }
        if (documentName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.deleteDocument must not be null");
        }
        String normalizedUrl = VFileUtils.getCannonicalPath((String)documentName);
        try {
            MOReference moReference = MOReference.create((String)normalizedUrl);
            try {
                currentMDSSession.deleteMetadataObject(moReference);
                ret = true;
            }
            catch (ClassCastException e) {
                StreamedObject.deleteStreamedObject((MDSSession)currentMDSSession, (MOReference)moReference);
                ret = true;
            }
        }
        catch (UnsupportedUpdateException e) {
            throw PersistenceException.createMdsIOException(normalizedUrl, e);
        }
        catch (InvalidReferenceTypeException e) {
            throw PersistenceException.createInvalidPathException(normalizedUrl, e);
        }
        catch (InvalidReferenceException e) {
            throw PersistenceException.createInvalidPathException(normalizedUrl, e);
        }
        return ret;
    }

    public static boolean existsPackage(@NotNull MDSSession currentMDSSession, @NotNull String canonicalPath) {
        if (currentMDSSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.existsPackage must not be null");
        }
        if (canonicalPath == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.existsPackage must not be null");
        }
        boolean ret = false;
        String normalizedUrl = VFileUtils.getCannonicalPath((String)canonicalPath);
        try {
            PackageName packageName = PackageName.createPackageName((String)normalizedUrl);
            ret = MdsUtils.getPackage(currentMDSSession, packageName) != null;
        }
        catch (InvalidNamespaceException e) {
            Log.logWarning((Msg)MetadataMsg.INVALID_PATH(normalizedUrl), (Throwable)e);
        }
        catch (InvalidReferenceTypeException e) {
            Log.logWarning((Msg)MetadataMsg.INVALID_PATH(normalizedUrl), (Throwable)e);
        }
        catch (InvalidReferenceException e) {
            Log.logWarning((Msg)MetadataMsg.INVALID_PATH(normalizedUrl), (Throwable)e);
        }
        return ret;
    }

    public static PPackage getPackage(@NotNull MDSSession currentMDSSession, @NotNull String resourceName) {
        if (currentMDSSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.getPackage must not be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.getPackage must not be null");
        }
        String normalizedUrl = VFileUtils.getCannonicalPath((String)resourceName);
        PPackage ret = null;
        try {
            PackageName packageName = PackageName.createPackageName((String)normalizedUrl);
            ret = MdsUtils.getPackage(currentMDSSession, packageName);
        }
        catch (InvalidReferenceException e) {
            Log.logWarning((Msg)MetadataMsg.INVALID_PATH(normalizedUrl), (Throwable)e);
        }
        catch (InvalidReferenceTypeException e) {
            Log.logWarning((Msg)MetadataMsg.INVALID_PATH(normalizedUrl), (Throwable)e);
        }
        catch (InvalidNamespaceException e) {
            Log.logWarning((Msg)MetadataMsg.INVALID_PATH(normalizedUrl), (Throwable)e);
        }
        return ret;
    }

    public static InputStream openInputStream(@NotNull MDSSession currentMDSSession, @NotNull String resourceLocation) throws PersistenceException {
        InputStream inputStream;
        if (currentMDSSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.openInputStream must not be null");
        }
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.openInputStream must not be null");
        }
        PManager pManager = currentMDSSession.getPersistenceManager();
        PContext pContext = currentMDSSession.getPContext();
        String normalizedUrl = VFileUtils.getCannonicalPath((String)resourceLocation);
        try {
            DocumentName documentName = DocumentName.create((String)normalizedUrl);
            PDocument pDocument = pManager.getDocument(pContext, documentName);
            if (pDocument == null) {
                throw new FileNotFoundException(resourceLocation);
            }
            if (pDocument.isXML()) {
                InputSource inputSource = pDocument.read();
                Reader reader = inputSource.getCharacterStream();
                inputStream = reader == null ? inputSource.getByteStream() : new ReaderInputStream(reader, "UTF-8");
            } else {
                StreamedObject streamedObject = StreamedObject.getStreamedObject((MDSSession)currentMDSSession, (String)resourceLocation);
                inputStream = streamedObject.getContents();
            }
        }
        catch (InvalidReferenceException e) {
            throw PersistenceException.createInvalidPathException(normalizedUrl, e);
        }
        catch (InvalidReferenceTypeException e) {
            throw PersistenceException.createInvalidPathException(normalizedUrl, e);
        }
        catch (MetadataNotFoundException e) {
            throw PersistenceException.createArtifactNotFoundException(normalizedUrl, e);
        }
        catch (ReferenceException e) {
            throw PersistenceException.createInvalidPathException(normalizedUrl, e);
        }
        catch (MDSIOException e) {
            throw PersistenceException.createMdsIOException(normalizedUrl, e);
        }
        catch (IOException e) {
            throw PersistenceException.createMdsIOException(normalizedUrl, e);
        }
        return inputStream;
    }

    public static MDSObject getMutableMDSObject(@NotNull MDSSession currentMDSSession, @NotNull String path) throws PersistenceException {
        if (currentMDSSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.getMutableMDSObject must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.getMutableMDSObject must not be null");
        }
        String normalizedUrl = VFileUtils.getCannonicalPath((String)path);
        MetadataObject mdsObject = MdsUtils.getMutableMetadataObject(currentMDSSession, normalizedUrl);
        if (mdsObject == null) {
            mdsObject = MdsUtils.getStreamedObject(currentMDSSession, normalizedUrl);
        }
        return mdsObject;
    }

    public static StreamedObject createStreamedObject(@NotNull MDSSession currentMDSSession, @NotNull String path, @NotNull InputStream inputStream) throws PersistenceException {
        StreamedObject streamedObject;
        if (currentMDSSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.createStreamedObject must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.createStreamedObject must not be null");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.createStreamedObject must not be null");
        }
        String normalizedUrl = VFileUtils.getCannonicalPath((String)path);
        try {
            streamedObject = StreamedObject.createStreamedObject((MDSSession)currentMDSSession, (String)normalizedUrl, (InputStream)inputStream);
        }
        catch (MetadataExistsException e) {
            throw PersistenceException.createArtifactAlreadyExistsException(normalizedUrl, e);
        }
        catch (ReferenceException e) {
            throw PersistenceException.createInvalidPathException(normalizedUrl, e);
        }
        catch (UnsupportedUpdateException e) {
            throw PersistenceException.createMdsIOException(normalizedUrl, e);
        }
        return streamedObject;
    }

    private static void deletePackageRecur(@NotNull MDSSession currentMdsSession, @NotNull PackageName pname) throws Exception {
        if (currentMdsSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.deletePackageRecur must not be null");
        }
        if (pname == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.deletePackageRecur must not be null");
        }
        PTransaction transaction = currentMdsSession.getPTransaction();
        PManager mgr = currentMdsSession.getPersistenceManager();
        PContext context = currentMdsSession.getPContext();
        Iterator it = mgr.getResources(context, pname);
        while (it.hasNext()) {
            PResource pres = (PResource)it.next();
            if (pres.isPackage()) {
                MdsUtils.deletePackageRecur(currentMdsSession, (PackageName)pres.getResourceName());
                continue;
            }
            PDocument pdoc = mgr.getDocument(context, (DocumentName)pres.getResourceName());
            transaction.deleteDocument(pdoc, true);
        }
        transaction.deletePackage(mgr.getPackage(context, pname), false);
    }

    private static PPackage getPackage(@NotNull MDSSession currentMDSSession, @NotNull PackageName packageName) throws InvalidNamespaceException {
        if (currentMDSSession == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.getPackage must not be null");
        }
        if (packageName == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/mds/utils/MdsUtils.getPackage must not be null");
        }
        PManager pManager = currentMDSSession.getPersistenceManager();
        return pManager.getPackage(currentMDSSession.getPContext(), packageName);
    }
}

