/*
 * Decompiled with CFR 0.152.
 */
package oracle.bpm.metadata.impl;

import oracle.bpm.metadata.artifact.jaxb.MetadataType;
import oracle.bpm.metadata.entity.ProjectFolder;
import oracle.bpm.metadata.entity.TemplateProject;
import oracle.bpm.metadata.exception.MetadataException;
import oracle.bpm.metadata.impl.MetadataArtifactHelper;
import oracle.bpm.metadata.persistence.MdPersistence;
import oracle.bpm.metadata.persistence.PersistenceException;
import oracle.mds.exception.InvalidNamespaceException;
import org.jetbrains.annotations.NotNull;

public class TemplateProjectExt
extends TemplateProject {
    public TemplateProjectExt(@NotNull MdPersistence persistence, @NotNull ProjectFolder projectFolder) {
        if (persistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/TemplateProjectExt.<init> must not be null");
        }
        if (projectFolder == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/TemplateProjectExt.<init> must not be null");
        }
        super(persistence, projectFolder.getLocation());
    }

    public TemplateProjectExt(@NotNull MdPersistence persistence, @NotNull MetadataType metadataType, @NotNull String location) {
        if (persistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/TemplateProjectExt.<init> must not be null");
        }
        if (metadataType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/TemplateProjectExt.<init> must not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of oracle/bpm/metadata/impl/TemplateProjectExt.<init> must not be null");
        }
        super(persistence, metadataType, location);
    }

    public static TemplateProject create(@NotNull MdPersistence persistence, @NotNull MetadataType metadataType) throws MetadataException {
        if (persistence == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/TemplateProjectExt.create must not be null");
        }
        if (metadataType == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/TemplateProjectExt.create must not be null");
        }
        try {
            String location = MetadataArtifactHelper.resolverRelativeFolder(metadataType);
            return new TemplateProjectExt(persistence, metadataType, location);
        }
        catch (InvalidNamespaceException e) {
            throw PersistenceException.createInvalidPathException(metadataType.getName(), e);
        }
    }

    public static TemplateProject create(@NotNull TemplateProject baseTemplateProject, @NotNull MdPersistence persistence) throws MetadataException {
        if (baseTemplateProject == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of oracle/bpm/metadata/impl/TemplateProjectExt.create must not be null");
        }
        if (persistence == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of oracle/bpm/metadata/impl/TemplateProjectExt.create must not be null");
        }
        ProjectFolder location = baseTemplateProject.getFolder().get();
        TemplateProjectExt newTemplateProject = new TemplateProjectExt(persistence, location);
        newTemplateProject.setMdPersistence(persistence);
        newTemplateProject.setDescription(baseTemplateProject.getDescription());
        newTemplateProject.setName(baseTemplateProject.getName());
        return newTemplateProject;
    }
}

